/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.LifeCycle;
import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import java.io.Closeable;
import java.util.Optional;

@Blocking
public interface BlockingHttpClient
extends Closeable,
LifeCycle<BlockingHttpClient> {
    public <I, O, E> HttpResponse<O> exchange(HttpRequest<I> var1, Argument<O> var2, Argument<E> var3);

    default public <I, O> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType) {
        return this.exchange(request, bodyType, HttpClient.DEFAULT_ERROR_TYPE);
    }

    default public <I, O> HttpResponse<O> exchange(HttpRequest<I> request) {
        return this.exchange(request, (Argument)null);
    }

    default public <I, O> HttpResponse<O> exchange(HttpRequest<I> request, Class<O> bodyType) {
        return this.exchange(request, Argument.of(bodyType));
    }

    default public <I, O> O retrieve(HttpRequest<I> request, Argument<O> bodyType) {
        return this.retrieve(request, bodyType, HttpClient.DEFAULT_ERROR_TYPE);
    }

    default public <I, O, E> O retrieve(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        HttpResponse response = this.exchange(request, bodyType, errorType);
        if (HttpStatus.class.isAssignableFrom(bodyType.getType())) {
            return (O)response.getStatus();
        }
        Optional body = response.getBody();
        if (!body.isPresent() && response.getBody(Argument.of(byte[].class)).isPresent()) {
            throw new HttpClientResponseException("Failed to decode the body for the given content type [%s]".formatted(response.getContentType().orElse(null)), response);
        }
        return (O)body.orElseThrow(() -> new HttpClientResponseException("Empty body", response));
    }

    default public <I, O> O retrieve(HttpRequest<I> request, Class<O> bodyType) {
        return this.retrieve(request, Argument.of(bodyType));
    }

    default public <I> String retrieve(HttpRequest<I> request) {
        return this.retrieve(request, String.class);
    }

    default public String retrieve(String uri) {
        return this.retrieve((HttpRequest)HttpRequest.GET((String)uri), (Class)String.class);
    }

    default public <O> O retrieve(String uri, Class<O> bodyType) {
        return this.retrieve((HttpRequest)HttpRequest.GET((String)uri), bodyType);
    }

    default public <O, E> O retrieve(String uri, Class<O> bodyType, Class<E> errorType) {
        return this.retrieve((HttpRequest)HttpRequest.GET((String)uri), (Argument<O>)Argument.of(bodyType), (Argument<E>)Argument.of(errorType));
    }

    default public <O> HttpResponse<O> exchange(String uri) {
        return this.exchange((HttpRequest)HttpRequest.GET((String)uri), (Argument<O>)((Argument)null));
    }

    default public <O> HttpResponse<O> exchange(String uri, Class<O> bodyType) {
        return this.exchange((HttpRequest)HttpRequest.GET((String)uri), (Argument<O>)Argument.of(bodyType));
    }

    default public <O, E> HttpResponse<O> exchange(String uri, Class<O> bodyType, Class<E> errorType) {
        return this.exchange((HttpRequest)HttpRequest.GET((String)uri), (Argument<O>)Argument.of(bodyType), (Argument<E>)Argument.of(errorType));
    }

    default public BlockingHttpClient refresh() {
        this.stop();
        return (BlockingHttpClient)this.start();
    }
}

