/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.discovery.StaticServiceInstanceList;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.client.HttpClientRegistry;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.ServiceHttpClientCondition;
import io.micronaut.http.client.ServiceHttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.scheduling.TaskScheduler;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import reactor.core.publisher.Flux;

@Factory
@Internal
public class ServiceHttpClientFactory {
    private final TaskScheduler taskScheduler;
    private final BeanProvider<HttpClientRegistry<?>> clientFactory;

    public ServiceHttpClientFactory(TaskScheduler taskScheduler, BeanProvider<HttpClientRegistry<?>> clientFactory) {
        this.taskScheduler = taskScheduler;
        this.clientFactory = clientFactory;
    }

    @EachBean(value=ServiceHttpClientConfiguration.class)
    @Requires(condition=ServiceHttpClientCondition.class)
    StaticServiceInstanceList serviceInstanceList(ServiceHttpClientConfiguration configuration) {
        List<URI> originalURLs = configuration.getUrls();
        ConcurrentLinkedQueue<URI> loadBalancedURIs = new ConcurrentLinkedQueue<URI>(originalURLs);
        return new StaticServiceInstanceList(configuration.getServiceId(), loadBalancedURIs, (String)configuration.getPath().orElse(null));
    }

    @EachBean(value=ServiceHttpClientConfiguration.class)
    @Requires(condition=ServiceHttpClientCondition.class)
    ApplicationEventListener<ServerStartupEvent> healthCheckStarter(@Parameter ServiceHttpClientConfiguration configuration, @Parameter StaticServiceInstanceList instanceList) {
        if (configuration.isHealthCheck()) {
            return event -> {
                List<URI> originalURLs = configuration.getUrls();
                Collection loadBalancedURIs = instanceList.getLoadBalancedURIs();
                Object httpClient = ((HttpClientRegistry)this.clientFactory.get()).getClient(HttpVersionSelection.forClientConfiguration(configuration), configuration.getServiceId(), (String)configuration.getPath().orElse(null));
                Duration initialDelay = configuration.getHealthCheckInterval();
                Duration delay = configuration.getHealthCheckInterval();
                this.taskScheduler.scheduleWithFixedDelay(initialDelay, delay, () -> Flux.fromIterable((Iterable)originalURLs).flatMap(originalURI -> {
                    URI healthCheckURI = originalURI.resolve(configuration.getHealthCheckUri());
                    return Flux.from(httpClient.exchange(HttpRequest.GET((URI)healthCheckURI))).onErrorResume(throwable -> {
                        if (throwable instanceof HttpClientResponseException) {
                            HttpClientResponseException responseException = (HttpClientResponseException)((Object)((Object)((Object)((Object)((Object)throwable)))));
                            return Flux.just(responseException.getResponse());
                        }
                        return Flux.just((Object)HttpResponse.serverError());
                    }).map(response -> Collections.singletonMap(originalURI, response.code()));
                }).subscribe(uriToStatusMap -> {
                    Map.Entry entry = uriToStatusMap.entrySet().iterator().next();
                    URI uri = (URI)entry.getKey();
                    int status = (Integer)entry.getValue();
                    if (status >= 300) {
                        loadBalancedURIs.remove(uri);
                    } else if (!loadBalancedURIs.contains(uri)) {
                        loadBalancedURIs.add(uri);
                    }
                }));
            };
        }
        throw new DisabledBeanException("HTTP Client Health Check not enabled");
    }
}

