/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientExceptionUtils;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.jdk.AbstractJdkHttpClient;
import io.micronaut.http.client.jdk.JdkClientSslBuilder;
import io.micronaut.http.client.jdk.cookie.CookieDecoder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.io.IOException;
import java.net.http.HttpResponse;
import org.slf4j.LoggerFactory;

@Internal
public class JdkBlockingHttpClient
extends AbstractJdkHttpClient
implements BlockingHttpClient {
    public JdkBlockingHttpClient(LoadBalancer loadBalancer, HttpVersionSelection httpVersion, HttpClientConfiguration configuration, String contextPath, MediaTypeCodecRegistry mediaTypeCodecRegistry, RequestBinderRegistry requestBinderRegistry, String clientId, ConversionService conversionService, JdkClientSslBuilder sslBuilder, CookieDecoder cookieDecoder) {
        super(configuration.getLoggerName().map(LoggerFactory::getLogger).orElseGet(() -> LoggerFactory.getLogger(JdkBlockingHttpClient.class)), loadBalancer, httpVersion, configuration, contextPath, mediaTypeCodecRegistry, requestBinderRegistry, clientId, conversionService, sslBuilder, cookieDecoder);
    }

    public <I, O, E> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        java.net.http.HttpRequest httpRequest = (java.net.http.HttpRequest)this.mapToHttpRequest(request, bodyType).block();
        try {
            java.net.http.HttpResponse<byte[]> httpResponse;
            boolean errorStatus;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Client {} Sending HTTP Request: {}", (Object)this.clientId, (Object)httpRequest);
            }
            boolean bl = errorStatus = (httpResponse = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofByteArray())).statusCode() >= 400;
            if (errorStatus && this.configuration.isExceptionOnErrorStatus()) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("Client {} Received HTTP Response: {} {}", new Object[]{this.clientId, httpResponse.statusCode(), httpResponse.uri()});
                }
                throw (HttpClientResponseException)HttpClientExceptionUtils.populateServiceId((HttpClientException)new HttpClientResponseException(HttpStatus.valueOf((int)httpResponse.statusCode()).getReason(), this.response(httpResponse, bodyType)), (String)this.clientId, (HttpClientConfiguration)this.configuration);
            }
            return this.response(httpResponse, bodyType);
        }
        catch (IOException e) {
            throw new HttpClientException("Error sending request: " + e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HttpClientException("Error sending request: " + e.getMessage(), (Throwable)e);
        }
    }

    public void close() throws IOException {
    }
}

