/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientExceptionUtils;
import io.micronaut.http.client.exceptions.NoHostException;
import io.micronaut.http.client.jdk.HttpRequestFactory;
import io.micronaut.http.client.jdk.HttpResponseAdapter;
import io.micronaut.http.client.jdk.JdkClientSslBuilder;
import io.micronaut.http.client.jdk.cookie.CookieDecoder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ContextPathUtils;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.ClientSslConfiguration;
import io.micronaut.http.ssl.SslConfiguration;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLParameters;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Internal
abstract class AbstractJdkHttpClient {
    public static final String H2C_ERROR_MESSAGE = "H2C is not supported by the JDK HTTP client";
    public static final String H3_ERROR_MESSAGE = "HTTP/3 is not supported by the JDK HTTP client";
    public static final String WEIRD_ALPN_ERROR_MESSAGE = "The only supported ALPN modes are [http/1.1] or [http/1.1,h2]";
    protected final LoadBalancer loadBalancer;
    protected final HttpVersionSelection httpVersion;
    protected final HttpClientConfiguration configuration;
    protected final String contextPath;
    protected final HttpClient client;
    protected final CookieManager cookieManager;
    protected final RequestBinderRegistry requestBinderRegistry;
    protected final String clientId;
    protected final ConversionService conversionService;
    protected final JdkClientSslBuilder sslBuilder;
    protected final Logger log;
    protected final CookieDecoder cookieDecoder;
    protected MediaTypeCodecRegistry mediaTypeCodecRegistry;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractJdkHttpClient(Logger log, LoadBalancer loadBalancer, HttpVersionSelection httpVersion, HttpClientConfiguration configuration, String contextPath, MediaTypeCodecRegistry mediaTypeCodecRegistry, RequestBinderRegistry requestBinderRegistry, String clientId, ConversionService conversionService, JdkClientSslBuilder sslBuilder, CookieDecoder cookieDecoder) {
        SslConfiguration sslConfiguration;
        this.cookieDecoder = cookieDecoder;
        this.log = configuration.getLoggerName().map(LoggerFactory::getLogger).orElse(log);
        this.loadBalancer = loadBalancer;
        this.httpVersion = httpVersion;
        this.configuration = configuration;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.requestBinderRegistry = requestBinderRegistry;
        this.clientId = clientId;
        this.conversionService = conversionService;
        this.cookieManager = new CookieManager();
        this.sslBuilder = sslBuilder;
        if (System.getProperty("jdk.internal.httpclient.disableHostnameVerification") != null && log.isWarnEnabled()) {
            log.warn("The jdk.internal.httpclient.disableHostnameVerification system property is set. This is not recommended for production use as it prevents proper certificate validation and may allow man-in-the-middle attacks.");
        }
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            if (((String)contextPath).charAt(0) != '/') {
                contextPath = "/" + (String)contextPath;
            }
            this.contextPath = contextPath;
        } else {
            this.contextPath = null;
        }
        HttpClient.Builder builder = HttpClient.newBuilder();
        configuration.getConnectTimeout().ifPresent(builder::connectTimeout);
        HttpVersionSelection httpVersionSelection = HttpVersionSelection.forClientConfiguration((HttpClientConfiguration)configuration);
        if (httpVersionSelection.getPlaintextMode() == HttpVersionSelection.PlaintextMode.H2C) {
            throw new ConfigurationException(H2C_ERROR_MESSAGE);
        }
        if (httpVersionSelection.isHttp3()) {
            throw new ConfigurationException(H3_ERROR_MESSAGE);
        }
        if (httpVersionSelection.isAlpn()) {
            List<String> supportedProtocols = Arrays.asList(httpVersionSelection.getAlpnSupportedProtocols());
            if (supportedProtocols.size() == 2 && supportedProtocols.contains("http/1.1") && supportedProtocols.contains("h2")) {
                builder.version(HttpClient.Version.HTTP_2);
            } else {
                if (supportedProtocols.size() != 1 || !supportedProtocols.get(0).equals("http/1.1")) throw new ConfigurationException(WEIRD_ALPN_ERROR_MESSAGE);
                builder.version(HttpClient.Version.HTTP_1_1);
            }
        } else {
            builder.version(HttpClient.Version.HTTP_1_1);
        }
        builder.followRedirects(configuration.isFollowRedirects() ? HttpClient.Redirect.NORMAL : HttpClient.Redirect.NEVER).cookieHandler(this.cookieManager);
        Optional proxyAddress = configuration.getProxyAddress();
        if (proxyAddress.isPresent()) {
            SocketAddress socketAddress = (SocketAddress)proxyAddress.get();
            builder = this.configureProxy(builder, socketAddress, configuration.getProxyUsername().orElse(null), configuration.getProxyPassword().orElse(null));
        }
        if ((sslConfiguration = configuration.getSslConfiguration()) instanceof ClientSslConfiguration) {
            ClientSslConfiguration clientSslConfiguration = (ClientSslConfiguration)sslConfiguration;
            this.configureSsl(builder, clientSslConfiguration);
        }
        this.client = builder.build();
    }

    private static HttpCookie toJdkCookie(@NonNull Cookie cookie, @NonNull HttpRequest<?> request, @NonNull String host) {
        HttpCookie newCookie = new HttpCookie(cookie.getName(), cookie.getValue());
        newCookie.setMaxAge(cookie.getMaxAge());
        newCookie.setDomain(host);
        newCookie.setHttpOnly(cookie.isHttpOnly());
        newCookie.setSecure(cookie.isSecure());
        newCookie.setPath(cookie.getPath() == null ? request.getPath() : cookie.getPath());
        return newCookie;
    }

    private HttpClient.Builder configureProxy(@NonNull HttpClient.Builder builder, @NonNull SocketAddress address, final @Nullable String username, final @Nullable String password) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Configuring proxy: {} with username: {}", (Object)address, (Object)username);
        }
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)address;
            builder = builder.proxy(ProxySelector.of(inetSocketAddress));
            if (username != null && password != null) {
                builder = builder.authenticator(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                });
            }
        } else {
            throw new IllegalArgumentException("Unsupported proxy address type: " + address.getClass().getName());
        }
        return builder;
    }

    private void configureSsl(HttpClient.Builder builder, ClientSslConfiguration clientSslConfiguration) {
        this.sslBuilder.build((SslConfiguration)clientSslConfiguration).ifPresent(builder::sslContext);
        SSLParameters sslParameters = new SSLParameters();
        clientSslConfiguration.getClientAuthentication().ifPresent(a -> {
            if (a == ClientAuthentication.WANT) {
                sslParameters.setWantClientAuth(true);
            } else if (a == ClientAuthentication.NEED) {
                sslParameters.setNeedClientAuth(true);
            }
        });
        clientSslConfiguration.getProtocols().ifPresent(sslParameters::setProtocols);
        clientSslConfiguration.getCiphers().ifPresent(sslParameters::setCipherSuites);
        builder.sslParameters(sslParameters);
    }

    public MediaTypeCodecRegistry getMediaTypeCodecRegistry() {
        return this.mediaTypeCodecRegistry;
    }

    public void setMediaTypeCodecRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
    }

    protected <I> Mono<java.net.http.HttpRequest> mapToHttpRequest(HttpRequest<I> request, Argument<?> bodyType) {
        return this.resolveRequestUri(request).map(uri -> {
            this.cookieDecoder.decode(request).ifPresent(cookies -> cookies.getAll().forEach(cookie -> {
                HttpCookie newCookie = AbstractJdkHttpClient.toJdkCookie(cookie, request, uri.getHost());
                this.cookieManager.getCookieStore().add((URI)uri, newCookie);
            }));
            return HttpRequestFactory.builder(uri, request, this.configuration, bodyType, this.mediaTypeCodecRegistry).build();
        });
    }

    private Mono<URI> resolveRequestUri(HttpRequest<?> request) {
        if (request.getUri().getScheme() != null) {
            return Mono.just((Object)request.getUri());
        }
        return this.resolveURI(request);
    }

    private <I> Mono<URI> resolveURI(HttpRequest<I> request) {
        URI requestURI = request.getUri();
        if (this.loadBalancer == null) {
            return Mono.error((Throwable)HttpClientExceptionUtils.populateServiceId((HttpClientException)new NoHostException("Request URI specifies no host to connect to"), (String)this.clientId, (HttpClientConfiguration)this.configuration));
        }
        return Mono.from((Publisher)this.loadBalancer.select(request)).map(server -> {
            Optional authInfo = server.getMetadata().get((CharSequence)"Authorization-Info", String.class);
            if (request instanceof MutableHttpRequest) {
                MutableHttpRequest mutableRequest = (MutableHttpRequest)request;
                if (authInfo.isPresent()) {
                    mutableRequest.getHeaders().auth((String)authInfo.get());
                }
            }
            try {
                return server.resolve(ContextPathUtils.prepend((URI)requestURI, (String)this.contextPath));
            }
            catch (URISyntaxException e) {
                throw HttpClientExceptionUtils.populateServiceId((HttpClientException)new HttpClientException("Failed to construct the request URI", (Throwable)e), (String)this.clientId, (HttpClientConfiguration)this.configuration);
            }
        });
    }

    @NonNull
    protected <O> HttpResponse<O> response(@NonNull java.net.http.HttpResponse<byte[]> netResponse, @NonNull Argument<O> bodyType) {
        return new HttpResponseAdapter<O>(netResponse, bodyType, this.conversionService, this.mediaTypeCodecRegistry);
    }
}

