/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientExceptionUtils;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.jdk.AbstractJdkHttpClient;
import io.micronaut.http.client.jdk.JdkBlockingHttpClient;
import io.micronaut.http.client.jdk.JdkClientSslBuilder;
import io.micronaut.http.client.jdk.JdkHttpClient;
import io.micronaut.http.client.jdk.cookie.CompositeCookieDecoder;
import io.micronaut.http.client.jdk.cookie.CookieDecoder;
import io.micronaut.http.client.jdk.cookie.DefaultCookieDecoder;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.json.codec.JsonStreamMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import java.net.URI;
import java.net.http.HttpResponse;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

@Internal
public class DefaultJdkHttpClient
extends AbstractJdkHttpClient
implements JdkHttpClient {
    public DefaultJdkHttpClient(@Nullable LoadBalancer loadBalancer, HttpVersionSelection httpVersion, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, MediaTypeCodecRegistry mediaTypeCodecRegistry, RequestBinderRegistry requestBinderRegistry, String clientId, ConversionService conversionService, JdkClientSslBuilder sslBuilder, CookieDecoder cookieDecoder) {
        super(configuration.getLoggerName().map(LoggerFactory::getLogger).orElseGet(() -> LoggerFactory.getLogger(DefaultJdkHttpClient.class)), loadBalancer, httpVersion, configuration, contextPath, mediaTypeCodecRegistry, requestBinderRegistry, clientId, conversionService, sslBuilder, cookieDecoder);
    }

    public DefaultJdkHttpClient(URI uri, ConversionService conversionService) {
        this(uri == null ? null : LoadBalancer.fixed((URI)uri), null, (HttpClientConfiguration)new DefaultHttpClientConfiguration(), null, DefaultJdkHttpClient.createDefaultMediaTypeRegistry(), (RequestBinderRegistry)new DefaultRequestBinderRegistry(conversionService, new RequestArgumentBinder[0]), null, conversionService, new JdkClientSslBuilder(new ResourceResolver()), new CompositeCookieDecoder(List.of(new DefaultCookieDecoder())));
    }

    public DefaultJdkHttpClient(URI uri, HttpClientConfiguration configuration, MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService) {
        this(uri == null ? null : LoadBalancer.fixed((URI)uri), null, configuration, null, mediaTypeCodecRegistry, (RequestBinderRegistry)new DefaultRequestBinderRegistry(conversionService, new RequestArgumentBinder[0]), null, conversionService, new JdkClientSslBuilder(new ResourceResolver()), new CompositeCookieDecoder(List.of(new DefaultCookieDecoder())));
    }

    private static MediaTypeCodecRegistry createDefaultMediaTypeRegistry() {
        JsonMapper mapper = JsonMapper.createDefault();
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        return MediaTypeCodecRegistry.of((MediaTypeCodec[])new MediaTypeCodec[]{new JsonMediaTypeCodec(mapper, configuration, null), new JsonStreamMediaTypeCodec(mapper, configuration, null)});
    }

    public BlockingHttpClient toBlocking() {
        return new JdkBlockingHttpClient(this.loadBalancer, this.httpVersion, this.configuration, this.contextPath, this.mediaTypeCodecRegistry, this.requestBinderRegistry, this.clientId, this.conversionService, this.sslBuilder, this.cookieDecoder);
    }

    public <I, O, E> Publisher<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return this.mapToHttpRequest(request, bodyType).map(httpRequest -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Client {} Sending HTTP Request: {}", (Object)this.clientId, httpRequest);
            }
            if (this.log.isTraceEnabled()) {
                httpRequest.headers().map().forEach((k, v) -> this.log.trace("Client {} Sending HTTP Request Header: {}={}", new Object[]{this.clientId, k, v}));
            }
            return this.client.sendAsync((java.net.http.HttpRequest)httpRequest, HttpResponse.BodyHandlers.ofByteArray());
        }).flatMap(Mono::fromCompletionStage).map(netResponse -> {
            boolean errorStatus;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Client {} Received HTTP Response: {} {}", new Object[]{this.clientId, netResponse.statusCode(), netResponse.uri()});
            }
            boolean bl = errorStatus = netResponse.statusCode() >= 400;
            if (errorStatus && this.configuration.isExceptionOnErrorStatus()) {
                throw (HttpClientResponseException)HttpClientExceptionUtils.populateServiceId((HttpClientException)new HttpClientResponseException(HttpStatus.valueOf((int)netResponse.statusCode()).getReason(), this.response((java.net.http.HttpResponse<byte[]>)netResponse, bodyType)), (String)this.clientId, (HttpClientConfiguration)this.configuration);
            }
            return this.response((java.net.http.HttpResponse<byte[]>)netResponse, bodyType);
        });
    }

    public boolean isRunning() {
        return false;
    }
}

