/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.Optional;

@Internal
public final class HttpRequestFactory {
    private HttpRequestFactory() {
    }

    @NonNull
    public static <I> HttpRequest.Builder builder(@NonNull URI uri, HttpRequest<I> request, @NonNull HttpClientConfiguration configuration, Argument<?> bodyType, MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder().uri(uri);
        configuration.getReadTimeout().ifPresent(builder::timeout);
        HttpRequest.BodyPublisher bodyPublisher = HttpRequestFactory.publisherForRequest(request, bodyType, mediaTypeCodecRegistry);
        builder.method(request.getMethod().toString(), bodyPublisher);
        request.getHeaders().forEach((name, values) -> values.forEach(value -> builder.header((String)name, (String)value)));
        if (request.getContentType().isEmpty()) {
            builder.header("Content-Type", "application/json");
        }
        configuration.getReadTimeout().ifPresent(builder::timeout);
        return builder;
    }

    private static <I> HttpRequest.BodyPublisher publisherForRequest(HttpRequest<I> request, Argument<?> bodyType, MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        if (HttpMethod.permitsRequestBody((HttpMethod)request.getMethod())) {
            Optional body = request.getBody();
            boolean hasBody = body.isPresent();
            MediaType requestContentType = request.getContentType().orElseGet(() -> MediaType.APPLICATION_JSON_TYPE);
            if (requestContentType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && hasBody) {
                Object bodyValue = body.get();
                if (bodyValue instanceof CharSequence) {
                    return HttpRequest.BodyPublishers.ofString(bodyValue.toString());
                }
                throw HttpRequestFactory.unsupportedBodyType(bodyValue.getClass(), requestContentType.toString());
            }
            if (requestContentType.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE) && hasBody) {
                Object bodyValue = body.get();
                throw HttpRequestFactory.unsupportedBodyType(bodyValue.getClass(), requestContentType.toString());
            }
            if (hasBody) {
                Object bodyValue = body.get();
                if (Publishers.isConvertibleToPublisher(bodyValue)) {
                    throw HttpRequestFactory.unsupportedBodyType(bodyValue.getClass(), requestContentType.toString());
                }
                if (bodyValue instanceof CharSequence) {
                    return HttpRequest.BodyPublishers.ofString(bodyValue.toString());
                }
                if (mediaTypeCodecRegistry != null) {
                    Optional registeredCodec = mediaTypeCodecRegistry.findCodec(requestContentType);
                    byte[] encoded = registeredCodec.map(codec -> {
                        if (bodyType != null && bodyType.isInstance(bodyValue)) {
                            return codec.encode(bodyType, bodyValue);
                        }
                        return codec.encode(bodyValue);
                    }).orElse(null);
                    if (encoded != null) {
                        return HttpRequest.BodyPublishers.ofByteArray(encoded);
                    }
                    return HttpRequest.BodyPublishers.noBody();
                }
            }
        }
        return HttpRequest.BodyPublishers.noBody();
    }

    private static UnsupportedOperationException unsupportedBodyType(Class<?> clazz, String contentType) {
        return new UnsupportedOperationException("Body of type [" + clazz + "] as " + contentType + " is not yet supported");
    }
}

