/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.client.jdk.AbstractJdkHttpClient;
import io.micronaut.http.client.jdk.JdkBlockingHttpClient;
import io.micronaut.http.client.jdk.JdkClientSslBuilder;
import io.micronaut.http.client.jdk.JdkHttpClient;
import io.micronaut.http.client.jdk.cookie.CompositeCookieDecoder;
import io.micronaut.http.client.jdk.cookie.CookieDecoder;
import io.micronaut.http.client.jdk.cookie.DefaultCookieDecoder;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.json.codec.JsonStreamMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import java.net.URI;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultJdkHttpClient
extends AbstractJdkHttpClient
implements JdkHttpClient {
    public DefaultJdkHttpClient(@Nullable LoadBalancer loadBalancer, HttpVersionSelection httpVersion, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @Nullable HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver, @Nullable List<HttpFilterResolver.FilterEntry> clientFilterEntries, MediaTypeCodecRegistry mediaTypeCodecRegistry, RequestBinderRegistry requestBinderRegistry, String clientId, ConversionService conversionService, JdkClientSslBuilder sslBuilder, CookieDecoder cookieDecoder) {
        super(configuration.getLoggerName().map(LoggerFactory::getLogger).orElseGet(() -> LoggerFactory.getLogger(DefaultJdkHttpClient.class)), loadBalancer, httpVersion, configuration, contextPath, filterResolver, clientFilterEntries, mediaTypeCodecRegistry, requestBinderRegistry, clientId, conversionService, sslBuilder, cookieDecoder);
    }

    public DefaultJdkHttpClient(URI uri, ConversionService conversionService) {
        this(uri == null ? null : LoadBalancer.fixed((URI)uri), null, (HttpClientConfiguration)new DefaultHttpClientConfiguration(), null, null, null, DefaultJdkHttpClient.createDefaultMediaTypeRegistry(), (RequestBinderRegistry)new DefaultRequestBinderRegistry(conversionService, new RequestArgumentBinder[0]), null, conversionService, new JdkClientSslBuilder(new ResourceResolver()), new CompositeCookieDecoder(List.of(new DefaultCookieDecoder())));
    }

    public DefaultJdkHttpClient(URI uri, HttpClientConfiguration configuration, MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService) {
        this(uri == null ? null : LoadBalancer.fixed((URI)uri), null, configuration, null, null, null, mediaTypeCodecRegistry, (RequestBinderRegistry)new DefaultRequestBinderRegistry(conversionService, new RequestArgumentBinder[0]), null, conversionService, new JdkClientSslBuilder(new ResourceResolver()), new CompositeCookieDecoder(List.of(new DefaultCookieDecoder())));
    }

    private static MediaTypeCodecRegistry createDefaultMediaTypeRegistry() {
        JsonMapper mapper = JsonMapper.createDefault();
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        return MediaTypeCodecRegistry.of((MediaTypeCodec[])new MediaTypeCodec[]{new JsonMediaTypeCodec(mapper, configuration, null), new JsonStreamMediaTypeCodec(mapper, configuration, null)});
    }

    public BlockingHttpClient toBlocking() {
        return new JdkBlockingHttpClient(this.loadBalancer, this.httpVersion, this.configuration, this.contextPath, (HttpClientFilterResolver<ClientFilterResolutionContext>)this.filterResolver, this.clientFilterEntries, this.mediaTypeCodecRegistry, this.requestBinderRegistry, this.clientId, this.conversionService, this.sslBuilder, this.cookieDecoder);
    }

    public <I, O, E> Publisher<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return this.exchangeImpl(request, bodyType);
    }

    public boolean isRunning() {
        return false;
    }
}

