/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.client.jdk.HttpHeadersAdapter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HttpResponseAdapter<O>
implements HttpResponse<O> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponseAdapter.class);
    private final java.net.http.HttpResponse<byte[]> httpResponse;
    @NonNull
    private final Argument<O> bodyType;
    private final ConversionService conversionService;
    private final MutableConvertibleValues<Object> attributes = new MutableConvertibleValuesMap();
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;

    public HttpResponseAdapter(java.net.http.HttpResponse<byte[]> httpResponse, @NonNull Argument<O> bodyType, ConversionService conversionService, MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        this.httpResponse = httpResponse;
        this.bodyType = bodyType;
        this.conversionService = conversionService;
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
    }

    public HttpStatus getStatus() {
        return HttpStatus.valueOf((int)this.httpResponse.statusCode());
    }

    public int code() {
        return this.httpResponse.statusCode();
    }

    public String reason() {
        return this.getStatus().getReason();
    }

    public HttpHeaders getHeaders() {
        return new HttpHeadersAdapter(this.httpResponse.headers(), this.conversionService);
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public Optional<O> getBody() {
        return this.convertBytes(this.getContentType().orElse(null), this.httpResponse.body(), this.bodyType);
    }

    public <T> Optional<T> getBody(Argument<T> type) {
        return this.convertBytes(this.getContentType().orElse(null), this.httpResponse.body(), type);
    }

    private <T> Optional convertBytes(@Nullable MediaType contentType, byte[] bytes, Argument<T> type) {
        Argument finalArgument;
        boolean isOptional;
        block8: {
            if (bytes.length == 0) {
                return Optional.empty();
            }
            isOptional = type.getType() == Optional.class;
            Argument argument = finalArgument = isOptional ? type.getFirstTypeVariable().orElse(type) : type;
            if (this.mediaTypeCodecRegistry != null && contentType != null) {
                if (CharSequence.class.isAssignableFrom(finalArgument.getType())) {
                    Charset charset = contentType.getCharset().orElse(StandardCharsets.UTF_8);
                    Optional<String> converted = Optional.of(new String(bytes, charset));
                    return isOptional ? Optional.of(converted) : converted;
                }
                if (finalArgument.getType() == byte[].class) {
                    Optional<byte[]> converted = Optional.of(bytes);
                    return isOptional ? Optional.of(converted) : converted;
                }
                Optional foundCodec = this.mediaTypeCodecRegistry.findCodec(contentType);
                if (foundCodec.isPresent()) {
                    try {
                        Optional<Object> converted = foundCodec.map(codec -> codec.decode(finalArgument, bytes));
                        return isOptional ? Optional.of(converted) : converted;
                    }
                    catch (CodecException e) {
                        if (!LOG.isDebugEnabled()) break block8;
                        String message = e.getMessage();
                        LOG.debug("Error decoding body for type [{}] from '{}'. Attempting fallback.", type, (Object)contentType);
                        LOG.debug("CodecException Message was: {}", (Object)(message == null ? "null" : message.replace("\n", "")));
                    }
                }
            }
        }
        Optional converted = this.conversionService.convert((Object)bytes, ConversionContext.of(finalArgument));
        if (isOptional) {
            return Optional.of(converted);
        }
        return converted;
    }
}

