/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Internal
public final class HttpRequestFactory {
    private HttpRequestFactory() {
    }

    @NonNull
    public static <I> HttpRequest.Builder builder(@NonNull URI uri, HttpRequest<I> request, @NonNull HttpClientConfiguration configuration, @Nullable Argument<?> bodyType, @Nullable MediaTypeCodecRegistry mediaTypeCodecRegistry, @NonNull MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        MutableHttpRequest mutableHttpRequest = request.toMutableRequest();
        HttpRequest.Builder builder = java.net.http.HttpRequest.newBuilder().uri(uri);
        configuration.getReadTimeout().ifPresent(builder::timeout);
        if (mutableHttpRequest.getMethod() == HttpMethod.GET) {
            builder.GET();
        } else {
            HttpRequest.BodyPublisher bodyPublisher = HttpRequestFactory.publisherForRequest(mutableHttpRequest, bodyType, mediaTypeCodecRegistry, messageBodyHandlerRegistry);
            builder.method(mutableHttpRequest.getMethod().toString(), bodyPublisher);
        }
        mutableHttpRequest.getHeaders().forEach((name, values) -> values.forEach(value -> builder.header((String)name, (String)value)));
        if (mutableHttpRequest.getContentType().isEmpty()) {
            builder.header("Content-Type", "application/json");
        }
        configuration.getReadTimeout().ifPresent(builder::timeout);
        return builder;
    }

    private static <I> HttpRequest.BodyPublisher publisherForRequest(@NonNull MutableHttpRequest<I> request, @Nullable Argument<?> bodyType, @Nullable MediaTypeCodecRegistry mediaTypeCodecRegistry, @NonNull MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        if (!HttpMethod.permitsRequestBody((HttpMethod)request.getMethod())) {
            return HttpRequest.BodyPublishers.noBody();
        }
        Optional body = request.getBody();
        if (body.isPresent()) {
            Optional registeredCodec;
            byte[] encoded;
            Object bodyValue = body.get();
            MediaType requestContentType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
            if (requestContentType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
                if (bodyValue instanceof CharSequence) {
                    return HttpRequest.BodyPublishers.ofString(bodyValue.toString());
                }
                if (bodyValue instanceof Map) {
                    Map mapBody = (Map)bodyValue;
                    return HttpRequest.BodyPublishers.ofString(HttpRequestFactory.encodeBody(mapBody, request.getCharacterEncoding()));
                }
            }
            if (Publishers.isConvertibleToPublisher(bodyValue)) {
                throw HttpRequestFactory.unsupportedBodyType(bodyValue.getClass(), requestContentType.toString());
            }
            if (bodyValue instanceof CharSequence) {
                return HttpRequest.BodyPublishers.ofString(bodyValue.toString());
            }
            if (mediaTypeCodecRegistry != null && (encoded = (byte[])(registeredCodec = mediaTypeCodecRegistry.findCodec(requestContentType)).map(codec -> {
                if (bodyType != null && bodyType.isInstance(bodyValue)) {
                    return codec.encode(bodyType, bodyValue);
                }
                return codec.encode(bodyValue);
            }).orElse(null)) != null) {
                return HttpRequest.BodyPublishers.ofByteArray(encoded);
            }
            Argument<?> bodyArgument = bodyType != null && bodyType.isInstance(bodyValue) ? bodyType : Argument.ofInstance(bodyValue);
            MessageBodyWriter messageBodyWriter = messageBodyHandlerRegistry.findWriter(bodyArgument, requestContentType).orElse(null);
            if (messageBodyWriter != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                messageBodyWriter.writeTo(bodyArgument, requestContentType, bodyValue, (MutableHeaders)request.getHeaders(), (OutputStream)byteArrayOutputStream);
                return HttpRequest.BodyPublishers.ofByteArray(byteArrayOutputStream.toByteArray());
            }
            throw HttpRequestFactory.unsupportedBodyType(bodyValue.getClass(), requestContentType.toString());
        }
        return HttpRequest.BodyPublishers.noBody();
    }

    private static String encodeBody(Map<?, ?> mapBody, Charset characterEncoding) {
        return mapBody.entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null).map(entry -> URLEncoder.encode(entry.getKey().toString(), characterEncoding) + "=" + URLEncoder.encode(entry.getValue().toString(), characterEncoding)).collect(Collectors.joining("&"));
    }

    private static UnsupportedOperationException unsupportedBodyType(Class<?> clazz, String contentType) {
        return new UnsupportedOperationException("Body of type [" + clazz + "] as " + contentType + " is not yet supported");
    }
}

