/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.jdk;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.ReactiveByteBufferByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;

@Internal
final class ByteBodySubscriber
implements HttpResponse.BodySubscriber<CloseableByteBody>,
BufferConsumer.Upstream {
    private final ReactiveByteBufferByteBody.SharedBuffer sharedBuffer;
    private final CloseableByteBody root;
    private final AtomicLong demand = new AtomicLong(0L);
    private Flow.Subscription subscription;
    private boolean cancelled;
    private volatile boolean disregardBackpressure;

    public ByteBodySubscriber(BodySizeLimits limits) {
        this.sharedBuffer = new ReactiveByteBufferByteBody.SharedBuffer(limits, (BufferConsumer.Upstream)this);
        this.root = new ReactiveByteBufferByteBody(this.sharedBuffer);
    }

    @Override
    public CompletionStage<CloseableByteBody> getBody() {
        return CompletableFuture.completedFuture(this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        boolean initialDemand;
        boolean cancelled;
        ByteBodySubscriber byteBodySubscriber = this;
        synchronized (byteBodySubscriber) {
            this.subscription = subscription;
            cancelled = this.cancelled;
            initialDemand = this.demand.get() > 0L;
        }
        if (cancelled) {
            subscription.cancel();
        } else if (initialDemand) {
            subscription.request(this.disregardBackpressure ? Long.MAX_VALUE : 1L);
        }
    }

    @Override
    public void onNext(List<ByteBuffer> item) {
        for (ByteBuffer buffer : item) {
            int n = buffer.remaining();
            this.demand.addAndGet(-n);
            this.sharedBuffer.add(buffer);
        }
        if (this.demand.get() > 0L) {
            this.subscription.request(1L);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.sharedBuffer.error(throwable);
    }

    @Override
    public void onComplete() {
        this.sharedBuffer.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Flow.Subscription initialDemand;
        ByteBodySubscriber byteBodySubscriber = this;
        synchronized (byteBodySubscriber) {
            initialDemand = this.subscription;
            this.demand.set(1L);
        }
        if (initialDemand != null) {
            initialDemand.request(1L);
        }
    }

    public void onBytesConsumed(long bytesConsumed) {
        long prev = this.demand.getAndAdd(bytesConsumed);
        if (prev <= 0L && prev + bytesConsumed > 0L) {
            this.subscription.request(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowDiscard() {
        Flow.Subscription subscription;
        ByteBodySubscriber byteBodySubscriber = this;
        synchronized (byteBodySubscriber) {
            this.cancelled = true;
            subscription = this.subscription;
        }
        if (subscription != null) {
            subscription.cancel();
        }
    }

    public void disregardBackpressure() {
        this.disregardBackpressure = true;
        if (this.subscription != null) {
            this.subscription.request(Long.MAX_VALUE);
        }
    }
}

