/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.BasicAuth;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class AuthTest {
    private static final String SPEC_NAME = "AuthTest";

    AuthTest() {
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void authTest(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/auth-test").basicAuth((CharSequence)"Tim", (CharSequence)"Yates"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body("Tim:Yates").build()));
    }

    @Controller(value="/auth-test")
    @Requires(property="spec.name", value="AuthTest")
    static class AuthController {
        AuthController() {
        }

        @Get
        String get(BasicAuth auth) {
            return auth.getUsername() + ":" + auth.getPassword();
        }
    }
}

