/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class ClientDisabledCondition
implements ExecutionCondition {
    public static final String JDK = "jdk";
    public static final String NETTY = "netty";
    public static final String HTTP_CLIENT_CONFIGURATION = "httpClient";
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled((String)"@ClientDisabled is not present");
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"Enabled");
    private static final ConditionEvaluationResult DISABLED = ConditionEvaluationResult.disabled((String)"Disabled");

    private static boolean jdkMajorVersionMatches(ClientDisabled d) {
        return Integer.toString(Runtime.version().feature()).equals(d.jdk());
    }

    private static boolean clientParameterMatches(ExtensionContext context, ClientDisabled d) {
        return context.getConfigurationParameter(HTTP_CLIENT_CONFIGURATION).orElse("").equalsIgnoreCase(d.httpClient());
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation((Optional)context.getElement(), ClientDisabled.class).map(d -> ClientDisabledCondition.clientParameterMatches(context, d) && ClientDisabledCondition.jdkMajorVersionMatches(d) ? DISABLED : ENABLED).orElse(ENABLED_BY_DEFAULT);
    }

    @Documented
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @ExtendWith(value={ClientDisabledCondition.class})
    public static @interface ClientDisabled {
        public String httpClient() default "";

        public String jdk() default "";
    }
}

