/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.tck.tests.ClientDisabledCondition;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.concurrent.Executors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class ContentLengthHeaderTest {
    private static final String PATH = "/content-length";
    private HttpServer server;
    private ApplicationContext applicationContext;
    private HttpClient httpClient;

    ContentLengthHeaderTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(SocketUtils.findAvailableTcpPort()), 0);
        this.server.setExecutor(Executors.newCachedThreadPool());
        this.server.createContext(PATH, new MyHandler());
        this.server.start();
        this.applicationContext = ApplicationContext.run();
        this.httpClient = (HttpClient)this.applicationContext.createBean(HttpClient.class, new Object[]{new URL("http://localhost:" + this.server.getAddress().getPort())});
    }

    @AfterEach
    void tearDown() {
        if (this.server != null) {
            this.server.stop(0);
        }
        this.applicationContext.stop();
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void postContainsHeader(boolean blocking) {
        MutableHttpRequest post = HttpRequest.POST((String)PATH, (Object)"tim");
        String retrieve = blocking ? this.httpClient.toBlocking().retrieve((HttpRequest)post) : (String)Flux.from((Publisher)this.httpClient.retrieve((HttpRequest)post)).blockFirst();
        Assertions.assertEquals((Object)"POST:3", (Object)retrieve);
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    @ClientDisabledCondition.ClientDisabled(httpClient="jdk", jdk="17")
    void getContainsHeader(boolean blocking) {
        MutableHttpRequest get = HttpRequest.GET((String)PATH);
        String retrieve = blocking ? this.httpClient.toBlocking().retrieve((HttpRequest)get) : (String)Flux.from((Publisher)this.httpClient.retrieve((HttpRequest)get)).blockFirst();
        Assertions.assertEquals((Object)"GET:", (Object)retrieve);
    }

    static class MyHandler
    implements HttpHandler {
        MyHandler() {
        }

        private String header(Headers requestHeaders, String name) {
            if (requestHeaders.containsKey(name)) {
                return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)requestHeaders.get(name));
            }
            return "";
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            String method = exchange.getRequestMethod();
            String contentLength = this.header(exchange.getRequestHeaders(), "Content-Length");
            exchange.sendResponseHeaders(200, 0L);
            try (OutputStream os = exchange.getResponseBody();){
                os.write("%s:%s".formatted(method, contentLength).getBytes());
            }
            exchange.close();
        }
    }
}

