/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class FormUrlEncodedTest {
    private static final String SPEC_NAME = "FormUrlEncodedTest";

    FormUrlEncodedTest() {
    }

    @Test
    void youCanSubmitAFormAsUrlEncoded() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Collections.emptyMap(), (HttpRequest)HttpRequest.POST((String)"/form/submit", Map.of("firstName", "Sergio")).contentType((CharSequence)"application/x-www-form-urlencoded"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).assertResponse(response -> Assertions.assertEquals((Object)"Sergio", response.getBody(String.class).get())).build()));
    }

    @Requires(property="spec.name", value="FormUrlEncodedTest")
    @Controller(value="/form")
    static class EncodingTestController {
        EncodingTestController() {
        }

        @Post(value="/submit")
        @Consumes(value={"application/x-www-form-urlencoded"})
        @Produces(value={"text/html"})
        String submit(@Body Map<String, String> form) {
            return form.get("firstName");
        }
    }
}

