/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.BodyAssertion;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.ServerUnderTestProviderUtils;
import io.micronaut.http.tck.TestScenario;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

class RedirectTest {
    private static final String SPEC_NAME = "RedirectTest";
    private static final String BODY = "It works";
    private static final BodyAssertion<String, String> EXPECTED_BODY = BodyAssertion.builder().body("It works").equals();
    private static final String REDIRECT = "redirect";

    RedirectTest() {
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void absoluteRedirection(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/redirect/redirect"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(EXPECTED_BODY).build()));
    }

    @Test
    void clientRedirection() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);){
            RedirectClient client = (RedirectClient)server.getApplicationContext().getBean(RedirectClient.class);
            Assertions.assertEquals((Object)BODY, (Object)client.redirect());
        }
    }

    @Test
    void clientRelativeUriDirect() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             HttpClient client = (HttpClient)server.getApplicationContext().createBean(HttpClient.class, new Object[]{this.relativeLoadBalancer(server, "/redirect")});){
            HttpResponse exchange = (HttpResponse)Flux.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)"direct"), String.class)).blockFirst();
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)exchange.getStatus());
            Assertions.assertEquals((Object)BODY, (Object)exchange.body());
        }
    }

    @Test
    void blockingClientRelativeUriDirect() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             HttpClient client = (HttpClient)server.getApplicationContext().createBean(HttpClient.class, new Object[]{this.relativeLoadBalancer(server, "/redirect")});){
            HttpResponse exchange = client.toBlocking().exchange((HttpRequest)HttpRequest.GET((String)"direct"), String.class);
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)exchange.getStatus());
            Assertions.assertEquals((Object)BODY, (Object)exchange.body());
        }
    }

    @Test
    void clientRelativeUriNoSlash() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             HttpClient client = (HttpClient)server.getApplicationContext().createBean(HttpClient.class, new Object[]{this.relativeLoadBalancer(server, REDIRECT)});){
            HttpResponse exchange = (HttpResponse)Flux.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)"direct"), String.class)).blockFirst();
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)exchange.getStatus());
            Assertions.assertEquals((Object)BODY, (Object)exchange.body());
        }
    }

    @Test
    void blockingClientRelativeUriNoSlash() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             HttpClient client = (HttpClient)server.getApplicationContext().createBean(HttpClient.class, new Object[]{this.relativeLoadBalancer(server, REDIRECT)});){
            HttpResponse exchange = client.toBlocking().exchange((HttpRequest)HttpRequest.GET((String)"direct"), String.class);
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)exchange.getStatus());
            Assertions.assertEquals((Object)BODY, (Object)exchange.body());
        }
    }

    @Test
    void clientRelativeUriRedirectAbsolute() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             HttpClient client = (HttpClient)server.getApplicationContext().createBean(HttpClient.class, new Object[]{server.getURL().get() + "/redirect"});){
            HttpResponse response = (HttpResponse)Flux.from((Publisher)client.exchange((HttpRequest)HttpRequest.GET((String)REDIRECT), String.class)).blockFirst();
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.getStatus());
            Assertions.assertEquals((Object)BODY, (Object)response.body());
        }
    }

    @Test
    void blockingClientRelativeUriRedirectAbsolute() throws IOException {
        try (ServerUnderTest server = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME);
             HttpClient client = (HttpClient)server.getApplicationContext().createBean(HttpClient.class, new Object[]{server.getURL().get() + "/redirect"});){
            HttpResponse response = client.toBlocking().exchange((HttpRequest)HttpRequest.GET((String)REDIRECT), String.class);
            Assertions.assertEquals((Object)HttpStatus.OK, (Object)response.getStatus());
            Assertions.assertEquals((Object)BODY, (Object)response.body());
        }
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void hostHeaderIsCorrectForRedirect(boolean blocking) throws IOException {
        try (ServerUnderTest otherServer = ServerUnderTestProviderUtils.getServerUnderTestProvider().getServer(SPEC_NAME, Collections.singletonMap("redirect.server", "true"));){
            int otherPort = (Integer)otherServer.getPort().get();
            TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/redirect/redirect-host").header((CharSequence)REDIRECT, (CharSequence)("http://localhost:" + otherPort + "/redirect/host-header")), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(BodyAssertion.builder().body("localhost:" + otherPort).equals()).build()));
        }
    }

    @Test
    @Disabled(value="not supported, see -- io.micronaut.http.client.ClientRedirectSpec#test - client: full uri, redirect: relative")
    void relativeRedirection() throws IOException {
        TestScenario.asserts((String)SPEC_NAME, (HttpRequest)HttpRequest.GET((String)"/redirect/redirect-relative"), (server, request) -> AssertionUtils.assertDoesNotThrow((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.OK).body(EXPECTED_BODY).build()));
    }

    private LoadBalancer relativeLoadBalancer(final ServerUnderTest server, final String path) {
        return new LoadBalancer(){

            public Publisher<ServiceInstance> select(@Nullable Object discriminator) {
                URL url = (URL)server.getURL().get();
                return Publishers.just((Object)ServiceInstance.of((String)url.getHost(), (URL)url));
            }

            public Optional<String> getContextPath() {
                return Optional.of(path);
            }
        };
    }

    @Requires(property="spec.name", value="RedirectTest")
    @Client(value="/redirect")
    static interface RedirectClient {
        @Get(value="/redirect")
        @Consumes(value={"text/plain", "application/json"})
        public String redirect();
    }

    @Requirements(value={@Requires(property="spec.name", value="RedirectTest"), @Requires(property="redirect.server", value="true")})
    @Controller(value="/redirect")
    static class RedirectHostHeaderController {
        RedirectHostHeaderController() {
        }

        @Get(value="/host-header")
        @Produces(value={"text/plain"})
        HttpResponse<?> hostHeader(@Header String host) {
            return HttpResponse.ok((Object)host);
        }
    }

    @Requires(property="spec.name", value="RedirectTest")
    @Controller(value="/redirect")
    static class RedirectTestController {
        RedirectTestController() {
        }

        @Get(value="/redirect")
        HttpResponse<?> redirect() {
            return HttpResponse.redirect((URI)URI.create("/redirect/direct"));
        }

        @Get(value="/redirect-relative")
        HttpResponse<?> redirectRelative() {
            return HttpResponse.redirect((URI)URI.create("./direct"));
        }

        @Get(value="/redirect-host")
        HttpResponse<?> redirectHost(@Header String redirect) {
            return HttpResponse.redirect((URI)URI.create(redirect));
        }

        @Get(value="/direct")
        @Produces(value={"text/plain"})
        HttpResponse<?> direct() {
            return HttpResponse.ok((Object)RedirectTest.BODY);
        }
    }
}

