/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.tck.tests;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import io.micronaut.http.tck.AssertionUtils;
import io.micronaut.http.tck.HttpResponseAssertion;
import io.micronaut.http.tck.ServerUnderTest;
import io.micronaut.http.tck.TestScenario;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class StatusTest {
    private static final String SPEC_NAME = "StatusTest";

    StatusTest() {
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void returnStatus(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/status/http-status"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).build()));
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void responseStatus(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/status/response-status"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).build()));
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void atStatus(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/status/at-status"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).build()));
    }

    @ParameterizedTest(name="blocking={0}")
    @ValueSource(booleans={true, false})
    void exceptionStatus(boolean blocking) throws IOException {
        TestScenario.asserts((String)SPEC_NAME, Map.of("use.blocking.client", blocking), (HttpRequest)HttpRequest.GET((String)"/status/exception-status"), (server, request) -> AssertionUtils.assertThrows((ServerUnderTest)server, (HttpRequest)request, (HttpResponseAssertion)HttpResponseAssertion.builder().status(HttpStatus.I_AM_A_TEAPOT).build()));
    }

    @Produces
    @Singleton
    @Requires(property="spec.name", value="StatusTest")
    static class TeapotExceptionHandler
    implements ExceptionHandler<TeapotException, HttpResponse<?>> {
        private final ErrorResponseProcessor<?> errorResponseProcessor;

        TeapotExceptionHandler(ErrorResponseProcessor<?> errorResponseProcessor) {
            this.errorResponseProcessor = errorResponseProcessor;
        }

        public HttpResponse<?> handle(HttpRequest request, TeapotException e) {
            return this.errorResponseProcessor.processResponse(ErrorContext.builder((HttpRequest)request).cause((Throwable)e).build(), HttpResponse.status((HttpStatus)HttpStatus.I_AM_A_TEAPOT));
        }
    }

    static class TeapotException
    extends RuntimeException {
        TeapotException() {
        }
    }

    @Requires(property="spec.name", value="StatusTest")
    @Controller(value="/status")
    static class HttpStatusController {
        HttpStatusController() {
        }

        @Get(value="/http-status")
        HttpStatus status() {
            return HttpStatus.I_AM_A_TEAPOT;
        }

        @Get(value="/at-status")
        @Status(value=HttpStatus.I_AM_A_TEAPOT)
        void atstatus() {
        }

        @Get(value="/response-status")
        HttpResponse<?> response() {
            return HttpResponse.status((HttpStatus)HttpStatus.I_AM_A_TEAPOT);
        }

        @Get(value="/exception-status")
        HttpResponse<?> exception() {
            throw new TeapotException();
        }
    }
}

