/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.multipart;

import io.micronaut.core.naming.NameUtils;
import io.micronaut.http.MediaType;
import io.micronaut.http.client.multipart.Part;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nullable;

abstract class AbstractFilePart
extends Part {
    protected final String filename;
    protected final MediaType contentType;

    AbstractFilePart(String name, String filename, @Nullable MediaType contentType) {
        super(name);
        if (filename == null) {
            throw new IllegalArgumentException("Adding file parts with a null filename is not allowed");
        }
        this.filename = filename;
        this.contentType = contentType == null ? MediaType.forExtension((String)NameUtils.extension((String)filename)).orElse(MediaType.APPLICATION_OCTET_STREAM_TYPE) : contentType;
    }

    abstract void setContent(FileUpload var1) throws IOException;

    abstract long getLength();

    @Override
    InterfaceHttpData getData(HttpRequest request, HttpDataFactory factory) {
        MediaType mediaType = this.contentType;
        String contentType = mediaType.toString();
        String encoding = mediaType.isTextBased() ? null : "binary";
        Charset charset = mediaType.getCharset().orElse(null);
        FileUpload fileUpload = factory.createFileUpload(request, this.name, this.filename, contentType, encoding, charset, this.getLength());
        try {
            this.setContent(fileUpload);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return fileUpload;
    }
}

