/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.converters;

import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class SocketAddressConverter
implements TypeConverter<CharSequence, SocketAddress> {
    public Optional<SocketAddress> convert(CharSequence object, Class<SocketAddress> targetType, ConversionContext context) {
        String[] parts = object.toString().split(":");
        if (parts.length == 2) {
            int port = Integer.valueOf(parts[1]);
            return Optional.of(new InetSocketAddress(parts[0], port));
        }
        return Optional.empty();
    }
}

