/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.filter;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.PathMatcher;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.annotation.FilterMatcher;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpFilterResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@Internal
@Prototype
@BootstrapContextCompatible
public class HttpClientFilterResolver
implements HttpFilterResolver {
    private final List<HttpClientFilterEntry> clientFilters;

    public HttpClientFilterResolver(@Parameter @Nullable Collection<String> clientIdentifiers, @Parameter @Nullable AnnotationValue<?> annotationValue, @Nullable AnnotationMetadataResolver annotationMetadataResolver, List<HttpClientFilter> clientFilters) {
        if (clientIdentifiers == null) {
            clientIdentifiers = Collections.emptyList();
        }
        if (annotationMetadataResolver == null) {
            annotationMetadataResolver = AnnotationMetadataResolver.DEFAULT;
        }
        AnnotationMetadataResolver finalAnnotationMetadataResolver = annotationMetadataResolver;
        Collection<String> finalClientIdentifiers = clientIdentifiers;
        this.clientFilters = clientFilters.stream().map(httpClientFilter -> {
            AnnotationMetadata annotationMetadata = finalAnnotationMetadataResolver.resolveMetadata(httpClientFilter);
            HttpMethod[] methods = (HttpMethod[])annotationMetadata.enumValues(Filter.class, "methods", HttpMethod.class);
            ArrayList<HttpMethod> httpMethods = new ArrayList<HttpMethod>(Arrays.asList(methods));
            if (annotationMetadata.hasStereotype(FilterMatcher.class)) {
                httpMethods.addAll(Arrays.asList(annotationMetadata.enumValues(FilterMatcher.class, "methods", HttpMethod.class)));
            }
            return new HttpClientFilterEntry((HttpClientFilter)httpClientFilter, annotationMetadata, (List<HttpMethod>)httpMethods, annotationMetadata.stringValues(Filter.class));
        }).filter(entry -> {
            Object[] clients;
            boolean hasClients;
            boolean matches;
            AnnotationMetadata annotationMetadata = ((HttpClientFilterEntry)entry).annotationMetadata;
            boolean bl = matches = !annotationMetadata.hasStereotype(FilterMatcher.class);
            if (annotationValue != null && !matches) {
                matches = annotationMetadata.hasAnnotation(annotationValue.getAnnotationName());
            }
            if (matches && (hasClients = ArrayUtils.isNotEmpty((Object[])(clients = annotationMetadata.stringValues(Filter.class, "serviceId"))))) {
                matches = this.containsIdentifier(finalClientIdentifiers, (String[])clients);
            }
            return matches;
        }).collect(Collectors.toList());
    }

    public List<HttpClientFilter> resolveFilters(HttpRequest<?> request) {
        String requestPath = StringUtils.prependUri((String)"/", (String)request.getUri().getPath());
        HttpMethod method = request.getMethod();
        ArrayList<HttpClientFilter> filterList = new ArrayList<HttpClientFilter>(this.clientFilters.size());
        for (HttpClientFilterEntry filterEntry : this.clientFilters) {
            HttpClientFilter filter = filterEntry.httpClientFilter;
            if (filter instanceof Toggleable && !((Toggleable)filter).isEnabled()) continue;
            boolean matches = true;
            if (filterEntry.hasMethods) {
                matches = this.anyMethodMatches(method, filterEntry.filterMethods);
            }
            if (filterEntry.hasPatterns) {
                boolean bl = matches = matches && this.anyPatternMatches(requestPath, filterEntry.patterns);
            }
            if (!matches) continue;
            filterList.add(filter);
        }
        return filterList;
    }

    private boolean containsIdentifier(Collection<String> clientIdentifiers, String[] clients) {
        return Arrays.stream(clients).anyMatch(clientIdentifiers::contains);
    }

    private boolean anyPatternMatches(String requestPath, String[] patterns) {
        return Arrays.stream(patterns).anyMatch(pattern -> PathMatcher.ANT.matches(pattern, requestPath));
    }

    private boolean anyMethodMatches(HttpMethod requestMethod, List<HttpMethod> methods) {
        return methods.contains(requestMethod);
    }

    private final class HttpClientFilterEntry {
        private final HttpClientFilter httpClientFilter;
        private final AnnotationMetadata annotationMetadata;
        private final List<HttpMethod> filterMethods;
        private final String[] patterns;
        private final boolean hasMethods;
        private final boolean hasPatterns;

        HttpClientFilterEntry(HttpClientFilter httpClientFilter, AnnotationMetadata annotationMetadata, List<HttpMethod> httpMethods, String[] patterns) {
            this.httpClientFilter = httpClientFilter;
            this.annotationMetadata = annotationMetadata;
            this.filterMethods = httpMethods;
            this.patterns = patterns;
            this.hasMethods = !this.filterMethods.isEmpty();
            this.hasPatterns = ArrayUtils.isNotEmpty((Object[])patterns);
        }
    }
}

