/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.interceptor;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.Format;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableArgumentValue;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.version.annotation.Version;
import io.micronaut.http.BasicAuth;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.CustomHttpMethod;
import io.micronaut.http.annotation.FilterMatcher;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.PathVariable;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.annotation.RequestAttribute;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClient;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.LoadBalancerResolver;
import io.micronaut.http.client.ReactiveClientResultTransformer;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.filter.HttpClientFilterResolver;
import io.micronaut.http.client.interceptor.configuration.ClientVersioningConfiguration;
import io.micronaut.http.client.loadbalance.FixedLoadBalancer;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ClientContextPathProvider;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.http.sse.Event;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.http.uri.UriMatchVariable;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jackson.ObjectMapperFactory;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.jackson.codec.JacksonMediaTypeCodec;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
@BootstrapContextCompatible
public class HttpClientIntroductionAdvice
implements MethodInterceptor<Object, Object>,
Closeable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final MediaType[] DEFAULT_ACCEPT_TYPES = new MediaType[]{MediaType.APPLICATION_JSON_TYPE};
    private final int HEADERS_INITIAL_CAPACITY = 3;
    private final int ATTRIBUTES_INITIAL_CAPACITY = 1;
    private final BeanContext beanContext;
    private final Map<ClientKey, HttpClient> clients = new ConcurrentHashMap<ClientKey, HttpClient>();
    private final Map<String, ClientVersioningConfiguration> versioningConfigurations = new ConcurrentHashMap<String, ClientVersioningConfiguration>();
    private final List<ReactiveClientResultTransformer> transformers;
    private final LoadBalancerResolver loadBalancerResolver;
    private final JsonMediaTypeCodec jsonMediaTypeCodec;

    public HttpClientIntroductionAdvice(BeanContext beanContext, JsonMediaTypeCodec jsonMediaTypeCodec, LoadBalancerResolver loadBalancerResolver, ReactiveClientResultTransformer ... transformers) {
        this(beanContext, jsonMediaTypeCodec, loadBalancerResolver, Arrays.asList(transformers));
    }

    @Inject
    public HttpClientIntroductionAdvice(BeanContext beanContext, JsonMediaTypeCodec jsonMediaTypeCodec, LoadBalancerResolver loadBalancerResolver, List<ReactiveClientResultTransformer> transformers) {
        this.jsonMediaTypeCodec = jsonMediaTypeCodec;
        this.beanContext = beanContext;
        this.loadBalancerResolver = loadBalancerResolver;
        this.transformers = transformers != null ? transformers : Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Object[] acceptTypes;
        AnnotationValue clientAnnotation = (AnnotationValue)context.findAnnotation(Client.class).orElseThrow(() -> new IllegalStateException("Client advice called from type that is not annotated with @Client: " + context));
        AnnotationValue filterAnnotation = context.getAnnotationNameByStereotype(FilterMatcher.class).map(arg_0 -> context.getAnnotation(arg_0)).orElse(null);
        HttpClient httpClient = this.getClient(context, (AnnotationValue<Client>)clientAnnotation, filterAnnotation);
        Class declaringType = context.getDeclaringType();
        if (Closeable.class == declaringType || AutoCloseable.class == declaringType) {
            ClientKey clientKey = new ClientKey((AnnotationValue<Client>)clientAnnotation, filterAnnotation);
            this.clients.remove(clientKey);
            httpClient.close();
            return null;
        }
        Optional httpMethodMapping = context.getAnnotationTypeByStereotype(HttpMethodMapping.class);
        if (!context.hasStereotype(HttpMethodMapping.class) || httpClient == null) return context.proceed();
        AnnotationValue mapping = context.getAnnotation(HttpMethodMapping.class);
        String uri = (String)mapping.getRequiredValue(String.class);
        if (StringUtils.isEmpty((CharSequence)uri)) {
            uri = "/" + context.getMethodName();
        }
        Class annotationType = (Class)httpMethodMapping.get();
        HttpMethod httpMethod = HttpMethod.parse((String)annotationType.getSimpleName().toUpperCase());
        String httpMethodName = context.stringValue(CustomHttpMethod.class, "method").orElse(httpMethod.name());
        ReturnType returnType = context.getReturnType();
        Class javaReturnType = returnType.getType();
        UriMatchTemplate uriTemplate = UriMatchTemplate.of((String)"");
        if (uri.length() != 1 || uri.charAt(0) != '/') {
            uriTemplate = uriTemplate.nest((CharSequence)uri);
        }
        Map paramMap = context.getParameterValueMap();
        LinkedHashMap<String, String> queryParams = new LinkedHashMap<String, String>();
        List uriVariables = uriTemplate.getVariableNames();
        Object body = null;
        Map parameters = context.getParameters();
        Argument[] arguments = context.getArguments();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>(3);
        List headerAnnotations = context.getAnnotationValuesByType(Header.class);
        for (AnnotationValue headerAnnotation : headerAnnotations) {
            String headerName = headerAnnotation.stringValue("name").orElse(null);
            String headerValue = headerAnnotation.stringValue().orElse(null);
            if (!StringUtils.isNotEmpty((CharSequence)headerName) || !StringUtils.isNotEmpty((CharSequence)headerValue)) continue;
            headers.putIfAbsent(headerName, headerValue);
        }
        context.findAnnotation(Version.class).flatMap(AnnotationValue::stringValue).filter(StringUtils::isNotEmpty).ifPresent(version -> {
            ClientVersioningConfiguration configuration = this.getVersioningConfiguration((AnnotationValue<Client>)clientAnnotation);
            configuration.getHeaders().forEach(header -> headers.put((String)header, (String)version));
            configuration.getParameters().forEach(parameter -> queryParams.put((String)parameter, (String)version));
        });
        LinkedHashMap attributes = new LinkedHashMap(1);
        List attributeAnnotations = context.getAnnotationValuesByType(RequestAttribute.class);
        for (AnnotationValue attributeAnnotation : attributeAnnotations) {
            String attributeName = attributeAnnotation.stringValue("name").orElse(null);
            Object attributeValue = attributeAnnotation.getValue(Object.class).orElse(null);
            if (!StringUtils.isNotEmpty((CharSequence)attributeName) || attributeValue == null) continue;
            attributes.put(attributeName, attributeValue);
        }
        ArrayList cookies = new ArrayList();
        ArrayList<Argument> bodyArguments = new ArrayList<Argument>();
        ConversionService conversionService = ConversionService.SHARED;
        BasicAuth basicAuth = null;
        for (Argument argument : arguments) {
            Object v2;
            String argumentName = argument.getName();
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            MutableArgumentValue value2 = (MutableArgumentValue)parameters.get(argumentName);
            Object definedValue = value2.getValue();
            if (paramMap.containsKey(argumentName) && annotationMetadata.hasStereotype(Format.class) && (v2 = paramMap.get(argumentName)) != null) {
                paramMap.put(argumentName, conversionService.convert(v2, ConversionContext.of(String.class).with(argument.getAnnotationMetadata())));
            }
            if (definedValue == null) {
                definedValue = argument.getAnnotationMetadata().stringValue(Bindable.class, "defaultValue").orElse(null);
            }
            if (definedValue == null && !argument.isNullable()) {
                throw new IllegalArgumentException(String.format("Argument [%s] is null. Null values are not allowed to be passed to client methods (%s). Add a supported Nullable annotation type if that is the desired behavior", argument.getName(), context.getExecutableMethod().toString()));
            }
            if (argument.isAnnotationPresent(Body.class)) {
                body = definedValue;
                continue;
            }
            if (annotationMetadata.isAnnotationPresent(Header.class)) {
                void var38_57;
                String string = annotationMetadata.stringValue(Header.class).orElse(null);
                if (StringUtils.isEmpty((CharSequence)string)) {
                    String string2 = NameUtils.hyphenate((String)argumentName);
                }
                void var39_78 = var38_57;
                conversionService.convert(definedValue, String.class).ifPresent(arg_0 -> HttpClientIntroductionAdvice.lambda$intercept$4(headers, (String)var39_78, arg_0));
                continue;
            }
            if (annotationMetadata.isAnnotationPresent(CookieValue.class)) {
                void var38_60;
                String string = annotationMetadata.stringValue(CookieValue.class).orElse(null);
                if (StringUtils.isEmpty((CharSequence)string)) {
                    String string3 = argumentName;
                }
                void var39_79 = var38_60;
                conversionService.convert(definedValue, String.class).ifPresent(arg_0 -> HttpClientIntroductionAdvice.lambda$intercept$5(cookies, (String)var39_79, arg_0));
                continue;
            }
            if (annotationMetadata.isAnnotationPresent(QueryValue.class)) {
                String string = annotationMetadata.stringValue(QueryValue.class).orElse(null);
                boolean bl = uriTemplate.getVariables().stream().filter(v -> v.getName().equals(string)).findFirst().map(UriMatchVariable::isExploded).orElse(false);
                if (bl) {
                    if (StringUtils.isEmpty((CharSequence)string)) continue;
                    paramMap.put(string, definedValue);
                    continue;
                }
                conversionService.convert(definedValue, ConversionContext.of(String.class).with(annotationMetadata)).ifPresent(o -> {
                    if (!StringUtils.isEmpty((CharSequence)string)) {
                        paramMap.put(string, o);
                        queryParams.put(string, (String)o);
                    } else {
                        queryParams.put(argumentName, (String)o);
                    }
                });
                continue;
            }
            if (annotationMetadata.isAnnotationPresent(RequestAttribute.class)) {
                void var38_64;
                String string = annotationMetadata.stringValue(RequestAttribute.class).orElse(null);
                if (StringUtils.isEmpty((CharSequence)string)) {
                    String string4 = NameUtils.hyphenate((String)argumentName);
                }
                void var39_81 = var38_64;
                conversionService.convert(definedValue, Object.class).ifPresent(arg_0 -> HttpClientIntroductionAdvice.lambda$intercept$8(attributes, (String)var39_81, arg_0));
                continue;
            }
            if (annotationMetadata.isAnnotationPresent(PathVariable.class)) {
                String string = annotationMetadata.stringValue(PathVariable.class).orElse(null);
                conversionService.convert(definedValue, ConversionContext.of(String.class).with(annotationMetadata)).ifPresent(o -> {
                    if (!StringUtils.isEmpty((CharSequence)o)) {
                        paramMap.put(string, o);
                    }
                });
                continue;
            }
            if (argument.getType() == BasicAuth.class) {
                basicAuth = (BasicAuth)paramMap.get(argument.getName());
                continue;
            }
            if (uriVariables.contains(argumentName)) continue;
            bodyArguments.add(argument);
        }
        if (HttpMethod.permitsRequestBody((HttpMethod)httpMethod)) {
            if (body == null && !bodyArguments.isEmpty()) {
                LinkedHashMap<String, Object> bodyMap = new LinkedHashMap<String, Object>();
                for (Argument bodyArgument : bodyArguments) {
                    String argumentName = bodyArgument.getName();
                    MutableArgumentValue value3 = (MutableArgumentValue)parameters.get(argumentName);
                    bodyMap.put(argumentName, value3.getValue());
                }
                body = bodyMap;
            }
            if (body != null) {
                boolean variableSatisfied;
                boolean bl = variableSatisfied = uriVariables.isEmpty() || uriVariables.containsAll(paramMap.keySet());
                if (!variableSatisfied) {
                    if (body instanceof Map) {
                        for (Map.Entry entry : ((Map)body).entrySet()) {
                            String k = entry.getKey().toString();
                            Object v3 = entry.getValue();
                            if (v3 == null) continue;
                            paramMap.putIfAbsent(k, v3);
                        }
                    } else {
                        BeanMap beanMap = BeanMap.of(body);
                        for (Map.Entry entry : beanMap.entrySet()) {
                            String k = (String)entry.getKey();
                            Object v4 = entry.getValue();
                            if (v4 == null) continue;
                            paramMap.putIfAbsent(k, v4);
                        }
                    }
                }
            }
        }
        uri = uriTemplate.expand(paramMap);
        uriVariables.forEach(queryParams::remove);
        MutableHttpRequest request = HttpRequest.create((HttpMethod)httpMethod, (String)this.appendQuery(uri, queryParams), (String)httpMethodName);
        if (body != null) {
            request.body(body);
            Object[] contentTypes = MediaType.of((CharSequence[])context.stringValues(Produces.class));
            if (ArrayUtils.isEmpty((Object[])contentTypes)) {
                contentTypes = DEFAULT_ACCEPT_TYPES;
            }
            if (ArrayUtils.isNotEmpty((Object[])contentTypes)) {
                request.contentType((MediaType)contentTypes[0]);
            }
        }
        request.setAttribute((CharSequence)HttpAttributes.INVOCATION_CONTEXT, context);
        request.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, (Object)this.resolveTemplate((AnnotationValue<Client>)clientAnnotation, uriTemplate.toString()));
        String serviceId = clientAnnotation.stringValue().orElse(null);
        Argument<JsonError> errorType = clientAnnotation.classValue("errorType").map(Argument::of).orElse(HttpClient.DEFAULT_ERROR_TYPE);
        request.setAttribute((CharSequence)HttpAttributes.SERVICE_ID, (Object)serviceId);
        if (!headers.isEmpty()) {
            for (Map.Entry entry : headers.entrySet()) {
                request.header((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
        }
        cookies.forEach(arg_0 -> ((MutableHttpRequest)request).cookie(arg_0));
        if (!attributes.isEmpty()) {
            for (Map.Entry entry : attributes.entrySet()) {
                request.setAttribute((CharSequence)entry.getKey(), entry.getValue());
            }
        }
        if (ArrayUtils.isEmpty((Object[])(acceptTypes = MediaType.of((CharSequence[])context.stringValues(Consumes.class))))) {
            acceptTypes = DEFAULT_ACCEPT_TYPES;
        }
        if (basicAuth != null) {
            request.basicAuth((CharSequence)basicAuth.getUsername(), (CharSequence)basicAuth.getPassword());
        }
        boolean isFuture = CompletionStage.class.isAssignableFrom(javaReturnType);
        final Class methodDeclaringType = declaringType;
        if (Publishers.isConvertibleToPublisher((Class)javaReturnType) || isFuture) {
            void var39_85;
            void var38_77;
            boolean isSingle = Publishers.isSingle((Class)javaReturnType) || isFuture || context.isTrue(Consumes.class, "single");
            Argument publisherArgument = returnType.asArgument().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
            final Class argumentType = publisherArgument.getType();
            if (HttpResponse.class.isAssignableFrom(argumentType) || HttpStatus.class.isAssignableFrom(argumentType)) {
                isSingle = true;
            }
            if (!isSingle && httpClient instanceof StreamingHttpClient) {
                StreamingHttpClient streamingHttpClient = (StreamingHttpClient)httpClient;
                if (!Void.class.isAssignableFrom(argumentType)) {
                    request.accept((MediaType[])acceptTypes);
                }
                if (HttpResponse.class.isAssignableFrom(argumentType) || Void.class.isAssignableFrom(argumentType)) {
                    Publisher<HttpResponse<ByteBuffer<?>>> publisher = streamingHttpClient.exchangeStream(request);
                } else {
                    boolean isEventStream = Arrays.asList(acceptTypes).contains(MediaType.TEXT_EVENT_STREAM_TYPE);
                    if (isEventStream && streamingHttpClient instanceof SseClient) {
                        SseClient sseClient = (SseClient)((Object)streamingHttpClient);
                        if (publisherArgument.getType() == Event.class) {
                            Publisher publisher = sseClient.eventStream(request, publisherArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT));
                        } else {
                            Flowable flowable = Flowable.fromPublisher(sseClient.eventStream(request, publisherArgument)).map(Event::getData);
                        }
                    } else {
                        boolean isJson = this.isJsonParsedMediaType((MediaType[])acceptTypes);
                        if (isJson) {
                            Publisher publisher = streamingHttpClient.jsonStream(request, publisherArgument);
                        } else {
                            Publisher<ByteBuffer<?>> byteBufferPublisher = streamingHttpClient.dataStream(request);
                            if (argumentType == ByteBuffer.class) {
                                Publisher<ByteBuffer<?>> publisher = byteBufferPublisher;
                            } else {
                                if (!conversionService.canConvert(ByteBuffer.class, argumentType)) throw new ConfigurationException("Cannot create the generated HTTP client's required return type, since no TypeConverter from ByteBuffer to " + argumentType + " is registered");
                                Flowable flowable = Flowable.fromPublisher(byteBufferPublisher).map(value -> conversionService.convert(value, argumentType).get());
                            }
                        }
                    }
                }
            } else if (Void.class.isAssignableFrom(argumentType) || Completable.class.isAssignableFrom(javaReturnType)) {
                Publisher publisher = httpClient.exchange(request, null, errorType);
            } else {
                request.accept((MediaType[])acceptTypes);
                if (HttpResponse.class.isAssignableFrom(argumentType)) {
                    Publisher publisher = httpClient.exchange(request, publisherArgument, errorType);
                } else {
                    Publisher publisher = httpClient.retrieve(request, publisherArgument, errorType);
                }
            }
            if (isFuture) {
                final CompletableFuture completableFuture = new CompletableFuture();
                var38_77.subscribe((Subscriber)new CompletionAwareSubscriber<Object>(){
                    AtomicReference<Object> reference = new AtomicReference();

                    protected void doOnSubscribe(Subscription subscription) {
                        subscription.request(1L);
                    }

                    protected void doOnNext(Object message) {
                        if (!Void.class.isAssignableFrom(argumentType)) {
                            this.reference.set(message);
                        }
                    }

                    protected void doOnError(Throwable t) {
                        HttpClientResponseException e;
                        if (t instanceof HttpClientResponseException && (e = (HttpClientResponseException)((Object)t)).getStatus() == HttpStatus.NOT_FOUND) {
                            completableFuture.complete(null);
                            return;
                        }
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Client [" + methodDeclaringType.getName() + "] received HTTP error response: " + t.getMessage(), t);
                        }
                        completableFuture.completeExceptionally(t);
                    }

                    protected void doOnComplete() {
                        completableFuture.complete(this.reference.get());
                    }
                });
                return completableFuture;
            }
            Object t = conversionService.convert((Object)var38_77, javaReturnType).orElseThrow(() -> new HttpClientException("Cannot convert response publisher to Reactive type (Unsupported Reactive type): " + javaReturnType));
            for (ReactiveClientResultTransformer transformer : this.transformers) {
                Object object = transformer.transform(var39_85);
            }
            return var39_85;
        }
        BlockingHttpClient blockingHttpClient = httpClient.toBlocking();
        if (Void.TYPE != javaReturnType) {
            request.accept((MediaType[])acceptTypes);
        }
        if (HttpResponse.class.isAssignableFrom(javaReturnType)) {
            return this.handleBlockingCall(javaReturnType, () -> blockingHttpClient.exchange(request, returnType.asArgument().getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT), errorType));
        }
        if (Void.TYPE != javaReturnType) return this.handleBlockingCall(javaReturnType, () -> blockingHttpClient.retrieve(request, returnType.asArgument(), errorType));
        return this.handleBlockingCall(javaReturnType, () -> blockingHttpClient.exchange(request, null, errorType));
    }

    private Object handleBlockingCall(Class returnType, Supplier<Object> supplier) {
        try {
            if (Void.TYPE == returnType) {
                supplier.get();
                return null;
            }
            return supplier.get();
        }
        catch (RuntimeException t) {
            if (t instanceof HttpClientResponseException && ((HttpClientResponseException)((Object)t)).getStatus() == HttpStatus.NOT_FOUND) {
                if (returnType == Optional.class) {
                    return Optional.empty();
                }
                if (HttpResponse.class.isAssignableFrom(returnType)) {
                    return ((HttpClientResponseException)((Object)t)).getResponse();
                }
                return null;
            }
            throw t;
        }
    }

    private ClientVersioningConfiguration getVersioningConfiguration(AnnotationValue<Client> clientAnnotation) {
        return this.versioningConfigurations.computeIfAbsent(this.getClientId(clientAnnotation), clientId -> this.beanContext.findBean(ClientVersioningConfiguration.class, Qualifiers.byName((String)clientId)).orElseGet(() -> (ClientVersioningConfiguration)this.beanContext.findBean(ClientVersioningConfiguration.class, Qualifiers.byName((String)"default")).orElseThrow(() -> new ConfigurationException("Attempt to apply a '@Version' to the request, but versioning configuration found neither for '" + clientId + "' nor '" + "default" + "' provided."))));
    }

    private boolean isJsonParsedMediaType(MediaType[] acceptTypes) {
        return Arrays.stream(acceptTypes).anyMatch(mediaType -> mediaType.equals((Object)MediaType.APPLICATION_JSON_STREAM_TYPE) || mediaType.getExtension().equals("json") || this.jsonMediaTypeCodec.getMediaTypes().contains(mediaType));
    }

    private String resolveTemplate(AnnotationValue<Client> clientAnnotation, String templateString) {
        String path = clientAnnotation.stringValue("path").orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            return path + templateString;
        }
        String value = clientAnnotation.stringValue().orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)value) && value.startsWith("/")) {
            return value + templateString;
        }
        return templateString;
    }

    private HttpClient getClient(MethodInvocationContext<Object, Object> context, AnnotationValue<Client> clientAnn, AnnotationValue filterAnnotation) {
        String clientId = this.getClientId(clientAnn);
        String path = clientAnn.stringValue("path").orElse(null);
        ClientKey clientKey = new ClientKey(clientAnn, filterAnnotation);
        return this.clients.computeIfAbsent(clientKey, integer -> {
            HttpClientFilterResolver filterResolver;
            HttpClient client;
            HttpClient clientBean = this.beanContext.findBean(HttpClient.class, Qualifiers.byName((String)NameUtils.hyphenate((String)clientId))).orElse(null);
            AnnotationValue jacksonFeaturesAnn = context.findAnnotation(io.micronaut.jackson.annotation.JacksonFeatures.class).orElse(null);
            Optional configurationClass = clientAnn.classValue("configuration");
            if (null != clientBean && path == null && jacksonFeaturesAnn == null && !configurationClass.isPresent() && filterAnnotation == null) {
                return clientBean;
            }
            LoadBalancer loadBalancer = this.loadBalancerResolver.resolve(clientId).orElseThrow(() -> new HttpClientException("Invalid service reference [" + clientId + "] specified to @Client"));
            String contextPath = null;
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                contextPath = path;
            } else if (StringUtils.isNotEmpty((CharSequence)clientId) && clientId.startsWith("/")) {
                contextPath = clientId;
            } else if (loadBalancer instanceof FixedLoadBalancer) {
                contextPath = ((FixedLoadBalancer)loadBalancer).getUrl().getPath();
            }
            Optional clientSpecificConfig = this.beanContext.findBean(HttpClientConfiguration.class, Qualifiers.byName((String)clientId));
            Class<HttpClientConfiguration> defaultConfiguration = configurationClass.orElse(HttpClientConfiguration.class);
            HttpClientConfiguration configuration = clientSpecificConfig.orElseGet(() -> (HttpClientConfiguration)this.beanContext.getBean(defaultConfiguration));
            if (contextPath == null && configuration instanceof ClientContextPathProvider) {
                contextPath = ((ClientContextPathProvider)configuration).getContextPath().orElse(null);
            }
            if ((client = (HttpClient)this.beanContext.createBean(HttpClient.class, new Object[]{loadBalancer, configuration, contextPath, filterResolver = (HttpClientFilterResolver)this.beanContext.createBean(HttpClientFilterResolver.class, new Object[]{Collections.singleton(clientId), filterAnnotation})})) instanceof DefaultHttpClient) {
                DefaultHttpClient defaultClient = (DefaultHttpClient)client;
                if (jacksonFeaturesAnn != null) {
                    DeserializationFeature[] disabledDeserializationFeatures;
                    SerializationFeature[] disabledSerializationFeatures;
                    DeserializationFeature[] enabledDeserializationFeatures;
                    JacksonFeatures jacksonFeatures = new JacksonFeatures();
                    SerializationFeature[] enabledSerializationFeatures = jacksonFeaturesAnn.get((CharSequence)"enabledSerializationFeatures", SerializationFeature[].class).orElse(null);
                    if (enabledSerializationFeatures != null) {
                        for (SerializationFeature serializationFeature : enabledSerializationFeatures) {
                            jacksonFeatures.addFeature(serializationFeature, true);
                        }
                    }
                    if ((enabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.get((CharSequence)"enabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
                        for (DeserializationFeature deserializationFeature : enabledDeserializationFeatures) {
                            jacksonFeatures.addFeature(deserializationFeature, true);
                        }
                    }
                    if ((disabledSerializationFeatures = (SerializationFeature[])jacksonFeaturesAnn.get((CharSequence)"disabledSerializationFeatures", SerializationFeature[].class).orElse(null)) != null) {
                        for (SerializationFeature serializationFeature : disabledSerializationFeatures) {
                            jacksonFeatures.addFeature(serializationFeature, false);
                        }
                    }
                    if ((disabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.get((CharSequence)"disabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
                        for (DeserializationFeature feature : disabledDeserializationFeatures) {
                            jacksonFeatures.addFeature(feature, false);
                        }
                    }
                    ArrayList<Object> codecs = new ArrayList<Object>(2);
                    MediaTypeCodecRegistry codecRegistry = defaultClient.getMediaTypeCodecRegistry();
                    for (MediaTypeCodec codec : codecRegistry.getCodecs()) {
                        if (codec instanceof JacksonMediaTypeCodec) {
                            codecs.add(((JacksonMediaTypeCodec)codec).cloneWithFeatures(jacksonFeatures));
                            continue;
                        }
                        codecs.add(codec);
                    }
                    if (!codecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE).isPresent()) {
                        codecs.add(HttpClientIntroductionAdvice.createNewJsonCodec(this.beanContext, jacksonFeatures));
                    }
                    defaultClient.setMediaTypeCodecRegistry(MediaTypeCodecRegistry.of(codecs));
                }
            }
            return client;
        });
    }

    private static MediaTypeCodec createNewJsonCodec(BeanContext beanContext, JacksonFeatures jacksonFeatures) {
        ObjectMapper objectMapper = new ObjectMapperFactory().objectMapper(null, null);
        jacksonFeatures.getDeserializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        jacksonFeatures.getSerializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        return new JsonMediaTypeCodec(objectMapper, (ApplicationConfiguration)beanContext.getBean(ApplicationConfiguration.class), (CodecConfiguration)beanContext.findBean(CodecConfiguration.class, Qualifiers.byName((String)"json")).orElse(null));
    }

    private String getClientId(AnnotationValue<Client> clientAnn) {
        String clientId = clientAnn.stringValue().orElse(null);
        if (clientId == null) {
            throw new HttpClientException("Either the id or value of the @Client annotation must be specified");
        }
        return clientId;
    }

    private String appendQuery(String uri, Map<String, String> queryParams) {
        if (!queryParams.isEmpty()) {
            UriBuilder builder = UriBuilder.of((CharSequence)uri);
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            return builder.toString();
        }
        return uri;
    }

    @Override
    @PreDestroy
    public void close() {
        for (HttpClient client : this.clients.values()) {
            client.close();
        }
    }

    private static /* synthetic */ void lambda$intercept$8(Map attributes, String finalAttributeName, Object o) {
        attributes.put(finalAttributeName, o);
    }

    private static /* synthetic */ void lambda$intercept$5(List cookies, String finalCookieName, String o) {
        cookies.add(new NettyCookie(finalCookieName, o));
    }

    private static /* synthetic */ void lambda$intercept$4(Map headers, String finalHeaderName, String o) {
        headers.put(finalHeaderName, o);
    }

    private class ClientKey {
        final String clientId;
        final String path;
        final AnnotationValue filterAnnotation;

        public ClientKey(AnnotationValue<Client> clientAnn, AnnotationValue filterAnnotation) {
            this.clientId = HttpClientIntroductionAdvice.this.getClientId((AnnotationValue<Client>)clientAnn);
            this.path = clientAnn.stringValue("path").orElse(null);
            this.filterAnnotation = filterAnnotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientKey clientKey = (ClientKey)o;
            return Objects.equals(this.clientId, clientKey.clientId) && Objects.equals(this.filterAnnotation, clientKey.filterAnnotation) && Objects.equals(this.path, clientKey.path);
        }

        public int hashCode() {
            return Objects.hash(this.clientId, this.path, this.filterAnnotation);
        }
    }
}

