/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.RxHttpClient;
import io.micronaut.http.client.RxProxyHttpClient;
import io.micronaut.http.client.RxStreamingHttpClient;
import io.micronaut.http.client.exceptions.ContentLengthExceededException;
import io.micronaut.http.client.exceptions.HttpClientErrorDecoder;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.exceptions.NoHostException;
import io.micronaut.http.client.exceptions.ReadTimeoutException;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.client.filter.DefaultHttpClientFilterResolver;
import io.micronaut.http.client.filters.ClientServerContextFilter;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.client.multipart.MultipartDataFactory;
import io.micronaut.http.client.netty.ConnectTTLHandler;
import io.micronaut.http.client.netty.FullNettyClientHttpResponse;
import io.micronaut.http.client.netty.IdleTimeoutHandler;
import io.micronaut.http.client.netty.IdlingConnectionHandler;
import io.micronaut.http.client.netty.NettyClientHttpRequest;
import io.micronaut.http.client.netty.NettyStreamedHttpResponse;
import io.micronaut.http.client.netty.ssl.NettyClientSslBuilder;
import io.micronaut.http.client.netty.websocket.NettyWebSocketClientHandler;
import io.micronaut.http.client.sse.RxSseClient;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.http.multipart.MultipartException;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.NettyMutableHttpResponse;
import io.micronaut.http.netty.channel.ChannelPipelineCustomizer;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.channel.NettyThreadFactory;
import io.micronaut.http.netty.stream.DefaultHttp2Content;
import io.micronaut.http.netty.stream.Http2Content;
import io.micronaut.http.netty.stream.HttpStreamsClientHandler;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.netty.stream.StreamingInboundHttp2ToHttpAdapter;
import io.micronaut.http.sse.Event;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.jackson.ObjectMapperFactory;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.jackson.codec.JsonStreamMediaTypeCodec;
import io.micronaut.jackson.parser.JacksonProcessor;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import io.micronaut.websocket.RxWebSocketClient;
import io.micronaut.websocket.annotation.ClientWebSocket;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultHttpClient
implements RxWebSocketClient,
RxHttpClient,
RxStreamingHttpClient,
RxSseClient,
RxProxyHttpClient,
ChannelPipelineCustomizer,
Closeable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final AttributeKey<Http2Stream> STREAM_KEY = AttributeKey.valueOf((String)"micronaut.http2.stream");
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    protected final Bootstrap bootstrap;
    protected EventLoopGroup group;
    protected MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected ByteBufferFactory<ByteBufAllocator, ByteBuf> byteBufferFactory = new NettyByteBufferFactory();
    private final List<HttpFilterResolver.FilterEntry<HttpClientFilter>> clientFilterEntries;
    private final HttpVersion httpVersion;
    private final Scheduler scheduler;
    private final LoadBalancer loadBalancer;
    private final HttpClientConfiguration configuration;
    private final String contextPath;
    private final SslContext sslContext;
    private final ThreadFactory threadFactory;
    private final boolean shutdownGroup;
    private final Charset defaultCharset;
    private final ChannelPoolMap<RequestKey, ChannelPool> poolMap;
    private final Logger log;
    @Nullable
    private final Long readTimeoutMillis;
    @Nullable
    private final Long connectionTimeAliveMillis;
    private final HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver;
    private final WebSocketBeanRegistry webSocketRegistry;
    private final RequestBinderRegistry requestBinderRegistry;
    private final Collection<ChannelPipelineListener> pipelineListeners = new ArrayList<ChannelPipelineListener>(2);
    private final List<InvocationInstrumenterFactory> invocationInstrumenterFactories;

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, HttpClientConfiguration configuration, @Nullable String contextPath, @Nullable ThreadFactory threadFactory, NettyClientSslBuilder nettyClientSslBuilder, MediaTypeCodecRegistry codecRegistry, @Nullable AnnotationMetadataResolver annotationMetadataResolver, List<InvocationInstrumenterFactory> invocationInstrumenterFactories, HttpClientFilter ... filters) {
        this(loadBalancer, HttpVersion.HTTP_1_1, configuration, contextPath, (HttpClientFilterResolver<ClientFilterResolutionContext>)new DefaultHttpClientFilterResolver(annotationMetadataResolver, Arrays.asList(filters)), null, threadFactory, nettyClientSslBuilder, codecRegistry, WebSocketBeanRegistry.EMPTY, (RequestBinderRegistry)new DefaultRequestBinderRegistry(ConversionService.SHARED, new RequestArgumentBinder[0]), null, NioSocketChannel::new, invocationInstrumenterFactories);
    }

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, @Nullable HttpVersion httpVersion, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @NonNull HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver, List<HttpFilterResolver.FilterEntry<HttpClientFilter>> clientFilterEntries, @Nullable ThreadFactory threadFactory, @NonNull NettyClientSslBuilder nettyClientSslBuilder, @NonNull MediaTypeCodecRegistry codecRegistry, @NonNull WebSocketBeanRegistry webSocketBeanRegistry, @NonNull RequestBinderRegistry requestBinderRegistry, @Nullable EventLoopGroup eventLoopGroup, @NonNull ChannelFactory socketChannelFactory, List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        int maxConnections;
        ArgumentUtils.requireNonNull((String)"nettyClientSslBuilder", (Object)((Object)nettyClientSslBuilder));
        ArgumentUtils.requireNonNull((String)"codecRegistry", (Object)codecRegistry);
        ArgumentUtils.requireNonNull((String)"webSocketBeanRegistry", (Object)webSocketBeanRegistry);
        ArgumentUtils.requireNonNull((String)"requestBinderRegistry", (Object)requestBinderRegistry);
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        ArgumentUtils.requireNonNull((String)"filterResolver", filterResolver);
        ArgumentUtils.requireNonNull((String)"socketChannelFactory", (Object)socketChannelFactory);
        this.loadBalancer = loadBalancer;
        this.httpVersion = httpVersion != null ? httpVersion : configuration.getHttpVersion();
        this.defaultCharset = configuration.getDefaultCharset();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            if (contextPath.charAt(0) != '/') {
                contextPath = '/' + contextPath;
            }
            this.contextPath = contextPath;
        } else {
            this.contextPath = null;
        }
        this.bootstrap = new Bootstrap();
        this.configuration = configuration;
        this.sslContext = nettyClientSslBuilder.build(configuration.getSslConfiguration(), this.httpVersion).orElse(null);
        if (eventLoopGroup != null) {
            this.group = eventLoopGroup;
            this.shutdownGroup = false;
        } else {
            this.group = this.createEventLoopGroup(configuration, threadFactory);
            this.shutdownGroup = true;
        }
        this.scheduler = Schedulers.from((Executor)this.group);
        this.threadFactory = threadFactory;
        ((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channelFactory(socketChannelFactory)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Optional readTimeout = configuration.getReadTimeout();
        this.readTimeoutMillis = readTimeout.map(duration -> !duration.isNegative() ? Long.valueOf(duration.toMillis()) : null).orElse(null);
        Optional connectTtl = configuration.getConnectTtl();
        this.connectionTimeAliveMillis = connectTtl.map(duration -> !duration.isNegative() ? Long.valueOf(duration.toMillis()) : null).orElse(null);
        this.invocationInstrumenterFactories = invocationInstrumenterFactories == null ? Collections.emptyList() : invocationInstrumenterFactories;
        final HttpClientConfiguration.ConnectionPoolConfiguration connectionPoolConfiguration = configuration.getConnectionPoolConfiguration();
        this.poolMap = connectionPoolConfiguration.isEnabled() || this.httpVersion == HttpVersion.HTTP_2_0 ? ((maxConnections = connectionPoolConfiguration.getMaxConnections()) > -1 ? new AbstractChannelPoolMap<RequestKey, ChannelPool>(){

            protected ChannelPool newPool(RequestKey key) {
                Bootstrap newBootstrap = DefaultHttpClient.this.bootstrap.clone(DefaultHttpClient.this.group);
                newBootstrap.remoteAddress((SocketAddress)key.getRemoteAddress());
                AbstractChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.newPoolHandler(key);
                long acquireTimeoutMillis = connectionPoolConfiguration.getAcquireTimeout().map(Duration::toMillis).orElse(-1L);
                return new FixedChannelPool(newBootstrap, (ChannelPoolHandler)channelPoolHandler, ChannelHealthChecker.ACTIVE, (FixedChannelPool.AcquireTimeoutAction)(acquireTimeoutMillis > -1L ? FixedChannelPool.AcquireTimeoutAction.FAIL : null), acquireTimeoutMillis, maxConnections, connectionPoolConfiguration.getMaxPendingAcquires());
            }
        } : new AbstractChannelPoolMap<RequestKey, ChannelPool>(){

            protected ChannelPool newPool(RequestKey key) {
                Bootstrap newBootstrap = DefaultHttpClient.this.bootstrap.clone(DefaultHttpClient.this.group);
                newBootstrap.remoteAddress((SocketAddress)key.getRemoteAddress());
                AbstractChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.newPoolHandler(key);
                return new SimpleChannelPool(newBootstrap, (ChannelPoolHandler)channelPoolHandler);
            }
        }) : null;
        Optional connectTimeout = configuration.getConnectTimeout();
        connectTimeout.ifPresent(duration -> {
            Bootstrap cfr_ignored_0 = (Bootstrap)this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)duration.toMillis()));
        });
        for (Map.Entry entry : configuration.getChannelOptions().entrySet()) {
            Object v = entry.getValue();
            if (v == null) continue;
            String channelOption = (String)entry.getKey();
            this.bootstrap.option(ChannelOption.valueOf((String)channelOption), v);
        }
        this.mediaTypeCodecRegistry = codecRegistry;
        this.log = configuration.getLoggerName().map(LoggerFactory::getLogger).orElse(LOG);
        this.filterResolver = filterResolver;
        this.clientFilterEntries = clientFilterEntries != null ? clientFilterEntries : filterResolver.resolveFilterEntries((AnnotationMetadataProvider)new ClientFilterResolutionContext(null, AnnotationMetadata.EMPTY_METADATA));
        this.webSocketRegistry = webSocketBeanRegistry != null ? webSocketBeanRegistry : WebSocketBeanRegistry.EMPTY;
        this.requestBinderRegistry = requestBinderRegistry;
    }

    public DefaultHttpClient(URL url) {
        this(url, (HttpClientConfiguration)new DefaultHttpClientConfiguration());
    }

    public DefaultHttpClient() {
        this(null, (HttpClientConfiguration)new DefaultHttpClientConfiguration(), Collections.emptyList());
    }

    public DefaultHttpClient(URL url, HttpClientConfiguration configuration) {
        this(url == null ? null : LoadBalancer.fixed((URL)url), configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, Collections.emptyList(), new HttpClientFilter[0]);
    }

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, HttpClientConfiguration configuration, List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        this(loadBalancer, configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, invocationInstrumenterFactories, new HttpClientFilter[0]);
    }

    public HttpClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public Logger getLog() {
        return this.log;
    }

    public HttpClient start() {
        if (!this.isRunning()) {
            this.group = this.createEventLoopGroup(this.configuration, this.threadFactory);
        }
        return this;
    }

    public boolean isRunning() {
        return !this.group.isShutdown();
    }

    public HttpClient stop() {
        if (this.isRunning()) {
            if (this.poolMap instanceof Iterable) {
                Iterable i = (Iterable)this.poolMap;
                for (Map.Entry entry : i) {
                    ChannelPool cp = (ChannelPool)entry.getValue();
                    try {
                        if (cp instanceof SimpleChannelPool) {
                            this.addInstrumentedListener(((SimpleChannelPool)cp).closeAsync(), future -> {
                                Throwable cause;
                                if (!future.isSuccess() && (cause = future.cause()) != null) {
                                    this.log.error("Error shutting down HTTP client connection pool: " + cause.getMessage(), cause);
                                }
                            });
                            continue;
                        }
                        cp.close();
                    }
                    catch (Exception cause) {
                        this.log.error("Error shutting down HTTP client connection pool: " + cause.getMessage(), (Throwable)cause);
                    }
                }
            }
            if (this.shutdownGroup) {
                Duration shutdownTimeout = this.configuration.getShutdownTimeout().orElse(Duration.ofMillis(100L));
                Duration shutdownQuietPeriod = this.configuration.getShutdownQuietPeriod().orElse(Duration.ofMillis(1L));
                Future future2 = this.group.shutdownGracefully(shutdownQuietPeriod.toMillis(), shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS);
                this.addInstrumentedListener(future2, f -> {
                    if (!f.isSuccess() && this.log.isErrorEnabled()) {
                        Throwable cause = f.cause();
                        this.log.error("Error shutting down HTTP client: " + cause.getMessage(), cause);
                    }
                });
                try {
                    future2.await(shutdownTimeout.toMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public MediaTypeCodecRegistry getMediaTypeCodecRegistry() {
        return this.mediaTypeCodecRegistry;
    }

    public void setMediaTypeCodecRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        if (mediaTypeCodecRegistry != null) {
            this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        }
    }

    public BlockingHttpClient toBlocking() {
        return new BlockingHttpClient(){

            public void close() {
                DefaultHttpClient.this.close();
            }

            public <I, O, E> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
                Flowable<HttpResponse<O>> publisher = DefaultHttpClient.this.exchange(request, bodyType, errorType);
                return (HttpResponse)publisher.doOnNext(res -> {
                    Optional byteBuf = res.getBody(ByteBuf.class);
                    byteBuf.ifPresent(bb -> {
                        if (bb.refCnt() > 0) {
                            ReferenceCountUtil.safeRelease((Object)bb);
                        }
                    });
                    if (res instanceof FullNettyClientHttpResponse) {
                        ((FullNettyClientHttpResponse)res).onComplete();
                    }
                }).blockingFirst();
            }
        };
    }

    public <I> Flowable<Event<ByteBuffer<?>>> eventStream(HttpRequest<I> request) {
        if (request instanceof MutableHttpRequest) {
            ((MutableHttpRequest)request).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM_TYPE});
        }
        return Flowable.create(emitter -> this.dataStream((HttpRequest<I>)request).subscribe(new Subscriber<ByteBuffer<?>>(){
            private Subscription dataSubscription;
            private CurrentEvent currentEvent;

            public void onSubscribe(Subscription s) {
                this.dataSubscription = s;
                Cancellable cancellable = () -> this.dataSubscription.cancel();
                emitter.setCancellable(cancellable);
                if (!emitter.isCancelled() && emitter.requested() > 0L) {
                    this.dataSubscription.request(1L);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ByteBuffer<?> buffer) {
                try {
                    int len = buffer.readableBytes();
                    if (len == 0) {
                        try {
                            Event event = Event.of((Object)DefaultHttpClient.this.byteBufferFactory.wrap(this.currentEvent.data)).name(this.currentEvent.name).retry(this.currentEvent.retry).id(this.currentEvent.id);
                            emitter.onNext((Object)event);
                        }
                        finally {
                            this.currentEvent = null;
                        }
                    } else {
                        int colonIndex;
                        if (this.currentEvent == null) {
                            this.currentEvent = new CurrentEvent();
                        }
                        if ((colonIndex = buffer.indexOf((byte)58)) > 0) {
                            String type = buffer.slice(0, colonIndex).toString(StandardCharsets.UTF_8).trim();
                            int fromIndex = colonIndex + 1;
                            if (buffer.getByte(fromIndex) == 32) {
                                ++fromIndex;
                            }
                            if (fromIndex < len) {
                                int toIndex = len - fromIndex;
                                switch (type) {
                                    case "data": {
                                        ByteBuffer content = buffer.slice(fromIndex, toIndex);
                                        byte[] d = this.currentEvent.data;
                                        if (d == null) {
                                            this.currentEvent.data = content.toByteArray();
                                            break;
                                        }
                                        this.currentEvent.data = ArrayUtils.concat((byte[])d, (byte[])content.toByteArray());
                                        break;
                                    }
                                    case "id": {
                                        ByteBuffer id = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.id = id.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "event": {
                                        ByteBuffer event = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.name = event.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "retry": {
                                        ByteBuffer retry = buffer.slice(fromIndex, toIndex);
                                        String text = retry.toString(StandardCharsets.UTF_8);
                                        if (StringUtils.isEmpty((CharSequence)text)) break;
                                        Long millis = Long.valueOf(text);
                                        this.currentEvent.retry = Duration.ofMillis(millis);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (emitter.requested() > 0L && !emitter.isCancelled()) {
                        this.dataSubscription.request(1L);
                    }
                }
                catch (Throwable e) {
                    this.onError(e);
                }
                finally {
                    if (buffer instanceof ReferenceCounted) {
                        ((ReferenceCounted)buffer).release();
                    }
                }
            }

            public void onError(Throwable t) {
                this.dataSubscription.cancel();
                if (t instanceof HttpClientException) {
                    emitter.onError(t);
                } else {
                    emitter.onError((Throwable)new HttpClientException("Error consuming Server Sent Events: " + t.getMessage(), t));
                }
            }

            public void onComplete() {
                emitter.onComplete();
            }
        }), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public <I, B> Flowable<Event<B>> eventStream(HttpRequest<I> request, Argument<B> eventType) {
        return this.eventStream(request).map(byteBufferEvent -> {
            ByteBuffer data = (ByteBuffer)byteBufferEvent.getData();
            Optional registeredCodec = this.mediaTypeCodecRegistry != null ? this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE) : Optional.empty();
            if (registeredCodec.isPresent()) {
                Object decoded = ((MediaTypeCodec)registeredCodec.get()).decode(eventType, data);
                return Event.of((Event)byteBufferEvent, (Object)decoded);
            }
            throw new CodecException("JSON codec not present");
        });
    }

    public <I> Flowable<ByteBuffer<?>> dataStream(HttpRequest<I> request) {
        return Flowable.fromPublisher(this.resolveRequestURI(request)).flatMap(this.buildDataStreamPublisher(request)).doAfterNext(buffer -> {
            ByteBuf byteBuf = (ByteBuf)buffer.asNativeBuffer();
            if (byteBuf.refCnt() > 0) {
                ReferenceCountUtil.safeRelease((Object)byteBuf);
            }
        });
    }

    public <I> Flowable<HttpResponse<ByteBuffer<?>>> exchangeStream(HttpRequest<I> request) {
        return Flowable.fromPublisher(this.resolveRequestURI(request)).flatMap(this.buildExchangeStreamPublisher(request)).doAfterNext(res -> {
            ByteBuffer buffer = (ByteBuffer)res.body();
            if (buffer instanceof ReferenceCounted) {
                ((ReferenceCounted)buffer).release();
            }
        });
    }

    public <I, O> Flowable<O> jsonStream(HttpRequest<I> request, Argument<O> type) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return Flowable.fromPublisher(this.resolveRequestURI(request)).flatMap(this.buildJsonStreamPublisher(parentRequest, request, type));
    }

    public <I> Flowable<Map<String, Object>> jsonStream(HttpRequest<I> request) {
        return this.jsonStream(request, Map.class);
    }

    public <I, O> Flowable<O> jsonStream(HttpRequest<I> request, Class<O> type) {
        return this.jsonStream(request, (Argument<O>)Argument.of(type));
    }

    public <I, O, E> Flowable<HttpResponse<O>> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        Publisher<URI> uriPublisher = this.resolveRequestURI(request);
        return Flowable.fromPublisher(uriPublisher).switchMap(this.buildExchangePublisher(parentRequest, request, bodyType, errorType));
    }

    public <T extends AutoCloseable> Flowable<T> connect(Class<T> clientEndpointType, MutableHttpRequest<?> request) {
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flowable.fromPublisher(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, request, clientEndpointType, null));
    }

    public <T extends AutoCloseable> Flowable<T> connect(Class<T> clientEndpointType, Map<String, Object> parameters) {
        WebSocketBean webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        String uri = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class).orElse("/ws");
        uri = UriTemplate.of((String)uri).expand(parameters);
        MutableHttpRequest request = HttpRequest.GET((String)uri);
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flowable.fromPublisher(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, (MutableHttpRequest<?>)request, clientEndpointType, (WebSocketBean)webSocketBean));
    }

    @Override
    public void close() {
        this.stop();
    }

    private <T> Flowable<T> connectWebSocket(final URI uri, final MutableHttpRequest<?> request, Class<T> clientEndpointType, WebSocketBean<T> webSocketBean) {
        Bootstrap bootstrap = this.bootstrap.clone();
        if (webSocketBean == null) {
            webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        }
        final WebSocketBean finalWebSocketBean = webSocketBean;
        return Flowable.create(emitter -> {
            RequestKey requestKey;
            SslContext sslContext = this.buildSslContext(uri);
            final WebSocketVersion protocolVersion = finalWebSocketBean.getBeanDefinition().enumValue(ClientWebSocket.class, "version", WebSocketVersion.class).orElse(WebSocketVersion.V13);
            final int maxFramePayloadLength = finalWebSocketBean.messageMethod().map(m -> m.intValue(OnMessage.class, "maxPayloadLength").orElse(65536)).orElse(65536);
            final String subprotocol = finalWebSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class, "subprotocol").orElse("");
            try {
                requestKey = new RequestKey(uri);
            }
            catch (HttpClientException e) {
                emitter.onError((Throwable)e);
                return;
            }
            bootstrap.remoteAddress(requestKey.getHost(), requestKey.getPort());
            bootstrap.handler((ChannelHandler)new HttpClientInitializer(sslContext, requestKey.getHost(), requestKey.getPort(), false, false, null){

                @Override
                protected void addFinalHandler(ChannelPipeline pipeline) {
                    Duration duration;
                    Optional readIdleTime;
                    pipeline.remove("http-decoder");
                    ReadTimeoutHandler readTimeoutHandler = (ReadTimeoutHandler)pipeline.get(ReadTimeoutHandler.class);
                    if (readTimeoutHandler != null) {
                        pipeline.remove((ChannelHandler)readTimeoutHandler);
                    }
                    if ((readIdleTime = DefaultHttpClient.this.configuration.getReadIdleTimeout()).isPresent() && !(duration = (Duration)readIdleTime.get()).isNegative()) {
                        pipeline.addLast("idle-state", (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
                    }
                    try {
                        String scheme = this.sslContext == null ? "ws" : "wss";
                        URI webSocketURL = UriBuilder.of((URI)uri).scheme(scheme).host(this.host).port(this.port).build();
                        MutableHttpHeaders headers = request.getHeaders();
                        EmptyHttpHeaders customHeaders = EmptyHttpHeaders.INSTANCE;
                        if (headers instanceof NettyHttpHeaders) {
                            customHeaders = ((NettyHttpHeaders)headers).getNettyHeaders();
                        }
                        if (StringUtils.isNotEmpty((CharSequence)subprotocol)) {
                            customHeaders.add("Sec-WebSocket-Protocol", (Object)subprotocol);
                        }
                        NettyWebSocketClientHandler webSocketHandler = new NettyWebSocketClientHandler(request, finalWebSocketBean, WebSocketClientHandshakerFactory.newHandshaker((URI)webSocketURL, (WebSocketVersion)protocolVersion, (String)subprotocol, (boolean)false, (HttpHeaders)customHeaders, (int)maxFramePayloadLength), DefaultHttpClient.this.requestBinderRegistry, DefaultHttpClient.this.mediaTypeCodecRegistry, emitter);
                        pipeline.addLast("micronaut-websocket-client", webSocketHandler);
                    }
                    catch (Throwable e) {
                        emitter.onError((Throwable)new WebSocketSessionException("Error opening WebSocket client session: " + e.getMessage(), e));
                    }
                }
            });
            this.addInstrumentedListener((Future)bootstrap.connect(), (GenericFutureListener)future -> {
                if (!future.isSuccess()) {
                    emitter.onError(future.cause());
                }
            });
        }, (BackpressureStrategy)BackpressureStrategy.ERROR);
    }

    protected <I> Function<URI, Flowable<HttpResponse<ByteBuffer<?>>>> buildExchangeStreamPublisher(HttpRequest<I> request) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return requestURI -> {
            Flowable<HttpResponse<Object>> streamResponsePublisher = this.buildStreamExchange((HttpRequest<?>)parentRequest, request, (URI)requestURI);
            return streamResponsePublisher.switchMap(response -> {
                StreamedHttpResponse streamedHttpResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
                Flowable httpContentFlowable = Flowable.fromPublisher((Publisher)streamedHttpResponse);
                return httpContentFlowable.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(message -> {
                    ByteBuf byteBuf = message.content();
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{byteBuf.readableBytes(), request.getMethodName(), request.getUri()});
                        this.traceBody("Response", byteBuf);
                    }
                    ByteBuffer byteBuffer = this.byteBufferFactory.wrap((Object)byteBuf);
                    NettyStreamedHttpResponse<ByteBuffer> thisResponse = new NettyStreamedHttpResponse<ByteBuffer>(streamedHttpResponse, response.status());
                    thisResponse.setBody(byteBuffer);
                    return new HttpResponseWrapper(thisResponse);
                });
            }).doOnTerminate(() -> {
                Channel c;
                Object o = request.getAttribute(NettyClientHttpRequest.CHANNEL).orElse(null);
                if (o instanceof Channel && (c = (Channel)o).isOpen()) {
                    c.close();
                }
            });
        };
    }

    protected <I, O> Function<URI, Flowable<O>> buildJsonStreamPublisher(HttpRequest<?> parentRequest, final HttpRequest<I> request, Argument<O> type) {
        return requestURI -> {
            Flowable<HttpResponse<Object>> streamResponsePublisher = this.buildStreamExchange(parentRequest, request, (URI)requestURI);
            return streamResponsePublisher.switchMap(response -> {
                if (!(response instanceof NettyStreamedHttpResponse)) {
                    throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
                }
                JsonMediaTypeCodec mediaTypeCodec = (JsonMediaTypeCodec)this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE).orElseThrow(() -> new IllegalStateException("No JSON codec found"));
                StreamedHttpResponse streamResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
                final Flowable httpContentFlowable = Flowable.fromPublisher((Publisher)streamResponse);
                boolean isJsonStream = response.getContentType().map(mediaType -> mediaType.equals((Object)MediaType.APPLICATION_JSON_STREAM_TYPE)).orElse(false);
                boolean streamArray = !Iterable.class.isAssignableFrom(type.getType()) && !isJsonStream;
                JacksonProcessor jacksonProcessor = new JacksonProcessor(mediaTypeCodec.getObjectMapper().getFactory(), streamArray, mediaTypeCodec.getObjectMapper().getDeserializationConfig()){

                    public void subscribe(Subscriber<? super JsonNode> downstreamSubscriber) {
                        httpContentFlowable.map(content -> {
                            ByteBuf chunk = content.content();
                            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                                DefaultHttpClient.this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{chunk.readableBytes(), request.getMethodName(), request.getUri()});
                                DefaultHttpClient.this.traceBody("Chunk", chunk);
                            }
                            try {
                                byte[] byArray = ByteBufUtil.getBytes((ByteBuf)chunk);
                                return byArray;
                            }
                            finally {
                                chunk.release();
                            }
                        }).subscribe((Subscriber)this);
                        super.subscribe(downstreamSubscriber);
                    }
                };
                return Flowable.fromPublisher((Publisher)jacksonProcessor).map(jsonNode -> mediaTypeCodec.decode(type, jsonNode));
            }).doOnTerminate(() -> {
                Channel c;
                Object o = request.getAttribute(NettyClientHttpRequest.CHANNEL).orElse(null);
                if (o instanceof Channel && (c = (Channel)o).isOpen()) {
                    c.close();
                }
            });
        };
    }

    protected <I> Function<URI, Flowable<ByteBuffer<?>>> buildDataStreamPublisher(HttpRequest<I> request) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return requestURI -> {
            Flowable<HttpResponse<Object>> streamResponsePublisher = this.buildStreamExchange((HttpRequest<?>)parentRequest, request, (URI)requestURI);
            Function contentMapper = message -> {
                ByteBuf byteBuf = message.content();
                return this.byteBufferFactory.wrap((Object)byteBuf);
            };
            return streamResponsePublisher.switchMap(response -> {
                if (!(response instanceof NettyStreamedHttpResponse)) {
                    throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
                }
                NettyStreamedHttpResponse nettyStreamedHttpResponse = (NettyStreamedHttpResponse)response;
                Flowable httpContentFlowable = Flowable.fromPublisher((Publisher)nettyStreamedHttpResponse.getNettyResponse());
                return httpContentFlowable.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(contentMapper);
            }).doOnTerminate(() -> {
                Channel c;
                Object o = request.getAttribute(NettyClientHttpRequest.CHANNEL).orElse(null);
                if (o instanceof Channel && (c = (Channel)o).isOpen()) {
                    c.close();
                }
            });
        };
    }

    protected <I> Flowable<HttpResponse<Object>> buildStreamExchange(@Nullable HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI) {
        SslContext sslContext = this.buildSslContext(requestURI);
        AtomicReference<HttpRequest> requestWrapper = new AtomicReference<HttpRequest>(request);
        Flowable streamResponsePublisher = Flowable.create(emitter -> {
            ChannelFuture channelFuture;
            try {
                if (this.httpVersion == HttpVersion.HTTP_2_0) {
                    channelFuture = this.doConnect(request, requestURI, sslContext, true, channelHandlerContext -> {
                        try {
                            Channel channel = channelHandlerContext.channel();
                            request.setAttribute(NettyClientHttpRequest.CHANNEL, (Object)channel);
                            this.streamRequestThroughChannel(parentRequest, requestWrapper, emitter, channel, true);
                        }
                        catch (Throwable e) {
                            emitter.onError(e);
                        }
                    });
                } else {
                    channelFuture = this.doConnect(request, requestURI, sslContext, true, null);
                    this.addInstrumentedListener((Future)channelFuture, (GenericFutureListener)((ChannelFutureListener)f -> {
                        if (f.isSuccess()) {
                            Channel channel = f.channel();
                            request.setAttribute(NettyClientHttpRequest.CHANNEL, (Object)channel);
                            this.streamRequestThroughChannel(parentRequest, requestWrapper, emitter, channel, true);
                        } else {
                            Throwable cause = f.cause();
                            emitter.onError((Throwable)new HttpClientException("Connect error:" + cause.getMessage(), cause));
                        }
                    }));
                }
            }
            catch (HttpClientException e) {
                emitter.onError((Throwable)e);
                return;
            }
            Disposable disposable = this.buildDisposableChannel(channelFuture);
            emitter.setDisposable(disposable);
            emitter.setCancellable(() -> ((Disposable)disposable).dispose());
        }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
        streamResponsePublisher = Flowable.fromPublisher(this.applyFilterToResponsePublisher(parentRequest, request, requestURI, requestWrapper, (Publisher)streamResponsePublisher));
        return streamResponsePublisher.subscribeOn(this.scheduler);
    }

    protected <I, O, E> Function<URI, Publisher<? extends HttpResponse<O>>> buildExchangePublisher(HttpRequest<?> parentRequest, HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        AtomicReference requestWrapper = new AtomicReference(request);
        return requestURI -> {
            Duration rt;
            Flowable responsePublisher = Flowable.create(emitter -> {
                boolean multipart = MediaType.MULTIPART_FORM_DATA_TYPE.equals(request.getContentType().orElse(null));
                if (this.poolMap != null && !multipart) {
                    try {
                        ChannelPool channelPool = this.poolMap.get((Object)new RequestKey((URI)requestURI));
                        Future channelFuture = channelPool.acquire();
                        this.addInstrumentedListener(channelFuture, future -> {
                            if (future.isSuccess()) {
                                Channel channel = (Channel)future.get();
                                try {
                                    this.sendRequestThroughChannel(requestWrapper, bodyType, errorType, emitter, channel, channelPool);
                                }
                                catch (Exception e) {
                                    emitter.onError((Throwable)e);
                                }
                            } else {
                                Throwable cause = future.cause();
                                emitter.onError((Throwable)new HttpClientException("Connect Error: " + cause.getMessage(), cause));
                            }
                        });
                    }
                    catch (HttpClientException e) {
                        emitter.onError((Throwable)e);
                    }
                } else {
                    SslContext sslContext = this.buildSslContext((URI)requestURI);
                    ChannelFuture connectionFuture = this.doConnect(request, (URI)requestURI, sslContext, false, null);
                    this.addInstrumentedListener((Future)connectionFuture, (GenericFutureListener)future -> {
                        if (!future.isSuccess()) {
                            Throwable cause = future.cause();
                            emitter.onError((Throwable)new HttpClientException("Connect Error: " + cause.getMessage(), cause));
                        } else {
                            try {
                                this.sendRequestThroughChannel(requestWrapper, bodyType, errorType, emitter, connectionFuture.channel(), null);
                            }
                            catch (Throwable e) {
                                emitter.onError(e);
                            }
                        }
                    });
                }
            }, (BackpressureStrategy)BackpressureStrategy.ERROR);
            Publisher finalPublisher = this.applyFilterToResponsePublisher(parentRequest, request, (URI)requestURI, requestWrapper, (Publisher)responsePublisher);
            Flowable finalFlowable = finalPublisher instanceof Flowable ? (Flowable)finalPublisher : Flowable.fromPublisher(finalPublisher);
            Optional readTimeout = this.configuration.getReadTimeout();
            if (readTimeout.isPresent() && !(rt = (Duration)readTimeout.get()).isNegative()) {
                Duration duration = rt.plus(Duration.ofSeconds(1L));
                finalFlowable = finalFlowable.timeout(duration.toMillis(), TimeUnit.MILLISECONDS).onErrorResumeNext(throwable -> {
                    if (throwable instanceof TimeoutException) {
                        return Flowable.error((Throwable)ReadTimeoutException.TIMEOUT_EXCEPTION);
                    }
                    return Flowable.error((Throwable)throwable);
                });
            }
            return finalFlowable;
        };
    }

    protected void closeChannelAsync(Channel channel) {
        if (channel.isOpen()) {
            ChannelFuture closeFuture = channel.closeFuture();
            closeFuture.addListener(f2 -> {
                if (!f2.isSuccess() && this.log.isErrorEnabled()) {
                    Throwable cause = f2.cause();
                    this.log.error("Error closing request connection: " + cause.getMessage(), cause);
                }
            });
        }
    }

    protected <I> Publisher<URI> resolveRequestURI(HttpRequest<I> request) {
        return this.resolveRequestURI(request, true);
    }

    protected <I> Publisher<URI> resolveRequestURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Publishers.just((Object)requestURI);
        }
        return this.resolveURI(request, includeContextPath);
    }

    protected <I> Publisher<URI> resolveRedirectURI(HttpRequest<?> parentRequest, HttpRequest<I> request) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Publishers.just((Object)requestURI);
        }
        if (parentRequest == null) {
            return this.resolveURI(request, false);
        }
        URI parentURI = parentRequest.getUri();
        UriBuilder uriBuilder = UriBuilder.of((URI)requestURI).scheme(parentURI.getScheme()).userInfo(parentURI.getUserInfo()).host(parentURI.getHost()).port(parentURI.getPort());
        return Publishers.just((Object)uriBuilder.build());
    }

    protected URI prependContextPath(URI requestURI) {
        if (StringUtils.isNotEmpty((CharSequence)this.contextPath)) {
            try {
                return new URI(StringUtils.prependUri((String)this.contextPath, (String)requestURI.toString()));
            }
            catch (URISyntaxException e) {
                throw new HttpClientException("Failed to construct the request URI", (Throwable)e);
            }
        }
        return requestURI;
    }

    protected Object getLoadBalancerDiscriminator() {
        return null;
    }

    protected ChannelFuture doConnect(HttpRequest<?> request, URI uri, @Nullable SslContext sslCtx, boolean isStream, Consumer<ChannelHandlerContext> contextConsumer) throws HttpClientException {
        RequestKey requestKey = new RequestKey(uri);
        return this.doConnect(request, requestKey.getHost(), requestKey.getPort(), sslCtx, isStream, contextConsumer);
    }

    protected ChannelFuture doConnect(HttpRequest<?> request, String host, int port, @Nullable SslContext sslCtx, boolean isStream, Consumer<ChannelHandlerContext> contextConsumer) {
        Bootstrap localBootstrap = this.bootstrap.clone();
        String acceptHeader = (String)request.getHeaders().get((CharSequence)"Accept");
        localBootstrap.handler((ChannelHandler)new HttpClientInitializer(sslCtx, host, port, isStream, acceptHeader != null && acceptHeader.equalsIgnoreCase("text/event-stream"), contextConsumer));
        return this.doConnect(localBootstrap, host, port);
    }

    protected NioEventLoopGroup createEventLoopGroup(HttpClientConfiguration configuration, ThreadFactory threadFactory) {
        OptionalInt numOfThreads = configuration.getNumOfThreads();
        Optional threadFactoryType = configuration.getThreadFactory();
        boolean hasThreads = numOfThreads.isPresent();
        boolean hasFactory = threadFactoryType.isPresent();
        NioEventLoopGroup group = hasThreads && hasFactory ? new NioEventLoopGroup(numOfThreads.getAsInt(), (ThreadFactory)InstantiationUtils.instantiate((Class)((Class)threadFactoryType.get()))) : (hasThreads ? (threadFactory != null ? new NioEventLoopGroup(numOfThreads.getAsInt(), threadFactory) : new NioEventLoopGroup(numOfThreads.getAsInt())) : (threadFactory != null ? new NioEventLoopGroup(NettyThreadFactory.DEFAULT_EVENT_LOOP_THREADS, threadFactory) : new NioEventLoopGroup()));
        return group;
    }

    protected ChannelFuture doConnect(Bootstrap bootstrap, String host, int port) {
        return bootstrap.connect(host, port);
    }

    protected SslContext buildSslContext(URI uriObject) {
        SslContext sslCtx;
        if ("https".equalsIgnoreCase(uriObject.getScheme()) || "wss".equalsIgnoreCase(uriObject.getScheme())) {
            sslCtx = this.sslContext;
            if (sslCtx == null && !this.configuration.getProxyAddress().isPresent()) {
                throw new HttpClientException("Cannot send HTTPS request. SSL is disabled");
            }
        } else {
            sslCtx = null;
        }
        return sslCtx;
    }

    protected void configureProxy(ChannelPipeline pipeline, Proxy proxy) {
        this.configureProxy(pipeline, proxy.type(), proxy.address());
    }

    protected void configureProxy(ChannelPipeline pipeline, Proxy.Type proxyType, SocketAddress proxyAddress) {
        InetSocketAddress isa;
        String username = this.configuration.getProxyUsername().orElse(null);
        String password = this.configuration.getProxyPassword().orElse(null);
        if (proxyAddress instanceof InetSocketAddress && (isa = (InetSocketAddress)proxyAddress).isUnresolved()) {
            proxyAddress = new InetSocketAddress(isa.getHostString(), isa.getPort());
        }
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress, username, password));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress, username, password));
                    break;
                }
            }
        } else {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress));
                    break;
                }
            }
        }
    }

    protected <I, O> Publisher<HttpResponse<O>> applyFilterToResponsePublisher(HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI, AtomicReference<HttpRequest> requestWrapper, Publisher<HttpResponse<O>> responsePublisher) {
        if (request instanceof MutableHttpRequest) {
            ((MutableHttpRequest)request).uri(requestURI);
            List filters = this.filterResolver.resolveFilters(request, this.clientFilterEntries);
            if (parentRequest != null) {
                filters.add(new ClientServerContextFilter(parentRequest));
            }
            OrderUtil.reverseSort((List)filters);
            Publisher finalResponsePublisher = responsePublisher;
            filters.add((req, chain) -> finalResponsePublisher);
            ClientFilterChain filterChain = this.buildChain(requestWrapper, filters);
            responsePublisher = parentRequest != null ? (Publisher)ServerRequestContext.with(parentRequest, () -> ((HttpClientFilter)filters.get(0)).doFilter(request, (FilterChain)filterChain)) : ((HttpClientFilter)filters.get(0)).doFilter(request, (FilterChain)filterChain);
        }
        return responsePublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NettyRequestWriter buildNettyRequest(MutableHttpRequest request, URI requestURI, MediaType requestContentType, boolean permitsBody, io.reactivex.functions.Consumer<? super Throwable> onError, boolean closeChannelAfterWrite) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        io.netty.handler.codec.http.HttpRequest nettyRequest;
        HttpPostRequestEncoder postRequestEncoder;
        block20: {
            block21: {
                postRequestEncoder = null;
                if (!permitsBody) break block21;
                Optional body = request.getBody();
                boolean hasBody = body.isPresent();
                if (requestContentType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && hasBody) {
                    Object bodyValue = body.get();
                    if (bodyValue instanceof CharSequence) {
                        ByteBuf byteBuf = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                        request.body((Object)byteBuf);
                        nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                        break block20;
                    } else {
                        postRequestEncoder = this.buildFormDataRequest(request, bodyValue);
                        nettyRequest = postRequestEncoder.finalizeRequest();
                    }
                    break block20;
                } else if (requestContentType.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE) && hasBody) {
                    Object bodyValue = body.get();
                    postRequestEncoder = this.buildMultipartRequest(request, bodyValue);
                    nettyRequest = postRequestEncoder.finalizeRequest();
                    break block20;
                } else {
                    ByteBuf bodyContent = null;
                    if (hasBody) {
                        Object bodyValue = body.get();
                        if (Publishers.isConvertibleToPublisher(bodyValue)) {
                            boolean isSingle = Publishers.isSingle(bodyValue.getClass());
                            Flowable publisher = (Flowable)ConversionService.SHARED.convert(bodyValue, Flowable.class).orElseThrow(() -> new IllegalArgumentException("Unconvertible reactive type: " + bodyValue));
                            Flowable requestBodyPublisher = publisher.map(o -> {
                                Optional registeredCodec;
                                ByteBuf encoded;
                                if (o instanceof CharSequence) {
                                    ByteBuf textChunk = Unpooled.copiedBuffer((CharSequence)((CharSequence)o), (Charset)requestContentType.getCharset().orElse(StandardCharsets.UTF_8));
                                    if (this.log.isTraceEnabled()) {
                                        this.traceChunk(textChunk);
                                    }
                                    return new DefaultHttpContent(textChunk);
                                }
                                if (o instanceof ByteBuf) {
                                    ByteBuf byteBuf = (ByteBuf)o;
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)byteBuf.readableBytes());
                                    }
                                    return new DefaultHttpContent(byteBuf);
                                }
                                if (o instanceof byte[]) {
                                    byte[] bodyBytes = (byte[])o;
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)bodyBytes.length);
                                    }
                                    return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])bodyBytes));
                                }
                                if (o instanceof ByteBuffer) {
                                    ByteBuffer byteBuffer = (ByteBuffer)o;
                                    Object nativeBuffer = byteBuffer.asNativeBuffer();
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)byteBuffer.readableBytes());
                                    }
                                    if (nativeBuffer instanceof ByteBuf) {
                                        return new DefaultHttpContent((ByteBuf)nativeBuffer);
                                    }
                                    return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])byteBuffer.toByteArray()));
                                }
                                if (this.mediaTypeCodecRegistry != null && (encoded = (ByteBuf)(registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType)).map(codec -> (ByteBuf)codec.encode(o, this.byteBufferFactory).asNativeBuffer()).orElse(null)) != null) {
                                    if (this.log.isTraceEnabled()) {
                                        this.traceChunk(encoded);
                                    }
                                    return new DefaultHttpContent(encoded);
                                }
                                throw new CodecException("Cannot encode value [" + o + "]. No possible encoders found");
                            });
                            if (!isSingle && MediaType.APPLICATION_JSON_TYPE.equals((Object)requestContentType)) {
                                requestBodyPublisher = requestBodyPublisher.lift(JsonSubscriber::new);
                            }
                            requestBodyPublisher = requestBodyPublisher.doOnError(onError);
                            request.body((Object)requestBodyPublisher);
                            io.netty.handler.codec.http.HttpRequest nettyRequest2 = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                            try {
                                nettyRequest2.setUri(requestURI.toURL().getFile());
                                return new NettyRequestWriter(requestURI.getScheme(), nettyRequest2, null, closeChannelAfterWrite);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            return new NettyRequestWriter(requestURI.getScheme(), nettyRequest2, null, closeChannelAfterWrite);
                        }
                        if (bodyValue instanceof CharSequence) {
                            bodyContent = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                        } else if (this.mediaTypeCodecRegistry != null) {
                            Optional registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType);
                            bodyContent = registeredCodec.map(codec -> (ByteBuf)codec.encode(bodyValue, this.byteBufferFactory).asNativeBuffer()).orElse(null);
                        }
                        if (bodyContent == null) {
                            bodyContent = (ByteBuf)ConversionService.SHARED.convert(bodyValue, ByteBuf.class).orElseThrow(() -> new HttpClientException("Body [" + bodyValue + "] cannot be encoded to content type [" + requestContentType + "]. No possible codecs or converters found."));
                        }
                    }
                    request.body(bodyContent);
                    try {
                        nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                    }
                    finally {
                        request.body(body.orElse(null));
                    }
                }
            }
            nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
        }
        try {
            nettyRequest.setUri(requestURI.toURL().getFile());
            return new NettyRequestWriter(requestURI.getScheme(), nettyRequest, postRequestEncoder, closeChannelAfterWrite);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new NettyRequestWriter(requestURI.getScheme(), nettyRequest, postRequestEncoder, closeChannelAfterWrite);
    }

    protected void configureHttp2Ssl(final HttpClientInitializer httpClientInitializer, final @NonNull SocketChannel ch, @NonNull SslContext sslCtx, String host, int port, HttpToHttp2ConnectionHandler connectionHandler) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("ssl", (ChannelHandler)sslCtx.newHandler(ch.alloc(), host, port));
        pipeline.addLast("http2-protocol-negotiator", (ChannelHandler)new ApplicationProtocolNegotiationHandler("h2"){

            public void handlerRemoved(ChannelHandlerContext ctx) {
                Consumer contextConsumer = httpClientInitializer.contextConsumer;
                if (contextConsumer != null) {
                    contextConsumer.accept(ctx);
                }
            }

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                if ("h2".equals(protocol)) {
                    ChannelPipeline p = ctx.pipeline();
                    if (httpClientInitializer.stream) {
                        ctx.channel().config().setAutoRead(false);
                    }
                    p.addLast("http2-settings", (ChannelHandler)new Http2SettingsHandler(ch.newPromise()));
                    httpClientInitializer.addEventStreamHandlerIfNecessary(p);
                    httpClientInitializer.addFinalHandler(p);
                    for (ChannelPipelineListener pipelineListener : DefaultHttpClient.this.pipelineListeners) {
                        pipelineListener.onConnect(p);
                    }
                } else if ("http/1.1".equals(protocol)) {
                    ChannelPipeline p = ctx.pipeline();
                    httpClientInitializer.addHttp1Handlers(p);
                } else {
                    ctx.close();
                    throw new HttpClientException("Unknown Protocol: " + protocol);
                }
            }
        });
        pipeline.addLast("http2-connection", (ChannelHandler)connectionHandler);
    }

    protected void configureHttp2ClearText(final HttpClientInitializer httpClientInitializer, @NonNull SocketChannel ch, @NonNull HttpToHttp2ConnectionHandler connectionHandler) {
        HttpClientCodec sourceCodec = new HttpClientCodec();
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec("http2-connection", (Http2ConnectionHandler)connectionHandler);
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("http-client-codec", (ChannelHandler)sourceCodec);
        httpClientInitializer.settingsHandler = new Http2SettingsHandler(ch.newPromise());
        pipeline.addLast(new ChannelHandler[]{upgradeHandler});
        pipeline.addLast("http2-upgrade-request", (ChannelHandler)new UpgradeRequestHandler(httpClientInitializer){

            public void handlerRemoved(ChannelHandlerContext ctx) {
                Consumer contextConsumer = httpClientInitializer.contextConsumer;
                if (contextConsumer != null) {
                    contextConsumer.accept(ctx);
                }
            }
        });
    }

    @NonNull
    protected HttpToHttp2ConnectionHandlerBuilder newHttp2ConnectionHandlerBuilder(@NonNull Http2Connection connection, @NonNull HttpClientConfiguration configuration, boolean stream) {
        HttpToHttp2ConnectionHandlerBuilder builder = new HttpToHttp2ConnectionHandlerBuilder();
        builder.validateHeaders(true);
        Object http2ToHttpAdapter = !stream ? new InboundHttp2ToHttpAdapterBuilder(connection).maxContentLength(configuration.getMaxContentLength()).validateHttpHeaders(true).propagateSettings(true).build() : new StreamingInboundHttp2ToHttpAdapter(connection, configuration.getMaxContentLength());
        return builder.connection(connection).frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(connection, (Http2FrameListener)http2ToHttpAdapter));
    }

    private <I> Publisher<URI> resolveURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (this.loadBalancer == null) {
            return Publishers.just((Throwable)new NoHostException("Request URI specifies no host to connect to"));
        }
        return Publishers.map((Publisher)this.loadBalancer.select(this.getLoadBalancerDiscriminator()), server -> {
            Optional authInfo = server.getMetadata().get((CharSequence)"Authorization-Info", String.class);
            if (request instanceof MutableHttpRequest && authInfo.isPresent()) {
                ((MutableHttpRequest)request).getHeaders().auth((String)authInfo.get());
            }
            return server.resolve(includeContextPath ? this.prependContextPath(requestURI) : requestURI);
        });
    }

    private <I, O, E> void sendRequestThroughChannel(AtomicReference<HttpRequest> requestWrapper, Argument<O> bodyType, Argument<E> errorType, FlowableEmitter<HttpResponse<O>> emitter, Channel channel, ChannelPool channelPool) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpRequest finalRequest = requestWrapper.get();
        URI requestURI = finalRequest.getUri();
        MediaType requestContentType = finalRequest.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)finalRequest.getMethod());
        MutableHttpRequest clientHttpRequest = (MutableHttpRequest)finalRequest;
        NettyRequestWriter requestWriter = this.buildNettyRequest(clientHttpRequest, requestURI, requestContentType, permitsBody, (io.reactivex.functions.Consumer<? super Throwable>)((io.reactivex.functions.Consumer)arg_0 -> emitter.tryOnError(arg_0)), true);
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        this.prepareHttpHeaders(requestURI, finalRequest, nettyRequest, permitsBody, this.poolMap == null);
        if (this.log.isDebugEnabled()) {
            this.debugRequest(requestURI, nettyRequest);
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest(finalRequest, nettyRequest);
        }
        this.addFullHttpResponseHandler(finalRequest, channel, channelPool, emitter, bodyType, errorType);
        requestWriter.writeAndClose(channel, channelPool, emitter);
    }

    private void streamRequestThroughChannel(final HttpRequest<?> parentRequest, AtomicReference<HttpRequest> requestWrapper, final FlowableEmitter emitter, Channel channel, final boolean failOnError) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpRequest finalRequest = requestWrapper.get();
        URI requestURI = finalRequest.getUri();
        NettyRequestWriter requestWriter = this.prepareRequest(finalRequest, requestURI, (FlowableEmitter<HttpResponse<Object>>)emitter, false);
        final io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("micronaut-http-response-full", (ChannelHandler)new SimpleChannelInboundHandlerInstrumented<FullHttpResponse>(){
            final AtomicBoolean received = new AtomicBoolean(false);
            final AtomicBoolean emitted = new AtomicBoolean(false);

            public boolean acceptInboundMessage(Object msg) {
                return msg instanceof FullHttpResponse;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                if (this.received.compareAndSet(false, true)) {
                    emitter.onError(cause);
                }
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof IdleStateEvent && this.received.compareAndSet(false, true)) {
                    emitter.onError((Throwable)ReadTimeoutException.TIMEOUT_EXCEPTION);
                }
            }

            @Override
            protected void channelReadInstrumented(ChannelHandlerContext ctx, FullHttpResponse msg) {
                if (this.received.compareAndSet(false, true)) {
                    NettyMutableHttpResponse response = new NettyMutableHttpResponse(msg, ConversionService.SHARED);
                    HttpHeaders headers = msg.headers();
                    if (DefaultHttpClient.this.log.isTraceEnabled()) {
                        DefaultHttpClient.this.log.trace("HTTP Client Streaming Response Received ({}) for Request: {} {}", new Object[]{msg.status(), nettyRequest.method().name(), nettyRequest.uri()});
                        DefaultHttpClient.this.traceHeaders(headers);
                    }
                    emitter.onNext((Object)response);
                    emitter.onComplete();
                }
            }
        });
        pipeline.addLast("micronaut-http-response-stream", (ChannelHandler)new SimpleChannelInboundHandlerInstrumented<StreamedHttpResponse>(){
            final AtomicBoolean received = new AtomicBoolean(false);

            public boolean acceptInboundMessage(Object msg) {
                return msg instanceof StreamedHttpResponse;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                if (this.received.compareAndSet(false, true)) {
                    emitter.onError(cause);
                }
            }

            @Override
            protected void channelReadInstrumented(ChannelHandlerContext ctx, StreamedHttpResponse msg) {
                if (this.received.compareAndSet(false, true)) {
                    HttpStatus httpStatus;
                    HttpResponseStatus status = msg.status();
                    int statusCode = status.code();
                    try {
                        httpStatus = HttpStatus.valueOf((int)statusCode);
                    }
                    catch (IllegalArgumentException e) {
                        emitter.onError((Throwable)e);
                        return;
                    }
                    NettyStreamedHttpResponse response = new NettyStreamedHttpResponse(msg, httpStatus);
                    HttpHeaders headers = msg.headers();
                    if (DefaultHttpClient.this.log.isTraceEnabled()) {
                        DefaultHttpClient.this.log.trace("HTTP Client Streaming Response Received ({}) for Request: {} {}", new Object[]{msg.status(), nettyRequest.method().name(), nettyRequest.uri()});
                        DefaultHttpClient.this.traceHeaders(headers);
                    }
                    if (statusCode > 300 && statusCode < 400 && DefaultHttpClient.this.configuration.isFollowRedirects() && headers.contains((CharSequence)HttpHeaderNames.LOCATION)) {
                        String location = headers.get((CharSequence)HttpHeaderNames.LOCATION);
                        try {
                            MutableHttpRequest redirectRequest = HttpRequest.GET((String)location);
                            DefaultHttpClient.this.setRedirectHeaders(nettyRequest, (MutableHttpRequest<Object>)redirectRequest);
                            Flowable redirectedExchange = Flowable.fromPublisher(DefaultHttpClient.this.resolveRedirectURI((HttpRequest<?>)parentRequest, redirectRequest)).flatMap(uri -> DefaultHttpClient.this.buildStreamExchange((HttpRequest<?>)parentRequest, redirectRequest, (URI)uri));
                            redirectedExchange.subscribe((Subscriber)new Subscriber<HttpResponse<Object>>(){
                                Subscription sub;

                                public void onSubscribe(Subscription s) {
                                    s.request(1L);
                                    this.sub = s;
                                }

                                public void onNext(HttpResponse<Object> objectHttpResponse) {
                                    emitter.onNext(objectHttpResponse);
                                    this.sub.cancel();
                                }

                                public void onError(Throwable t) {
                                    emitter.onError(t);
                                    this.sub.cancel();
                                }

                                public void onComplete() {
                                    emitter.onComplete();
                                }
                            });
                        }
                        catch (Exception e) {
                            emitter.onError((Throwable)e);
                        }
                    } else {
                        boolean errorStatus;
                        boolean bl = errorStatus = statusCode >= 400;
                        if (errorStatus && failOnError) {
                            emitter.onError((Throwable)new HttpClientResponseException(response.getStatus().getReason(), response));
                        } else {
                            emitter.onNext(response);
                            emitter.onComplete();
                        }
                    }
                }
            }
        });
        if (this.log.isDebugEnabled()) {
            this.debugRequest(requestURI, nettyRequest);
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest(requestWrapper.get(), nettyRequest);
        }
        requestWriter.writeAndClose(channel, null, emitter);
    }

    private ByteBuf charSequenceToByteBuf(CharSequence bodyValue, MediaType requestContentType) {
        CharSequence charSequence = bodyValue;
        return (ByteBuf)this.byteBufferFactory.copiedBuffer(charSequence.toString().getBytes(requestContentType.getCharset().orElse(this.defaultCharset))).asNativeBuffer();
    }

    private String getHostHeader(URI requestURI) {
        RequestKey requestKey = new RequestKey(requestURI);
        StringBuilder host = new StringBuilder(requestKey.getHost());
        int port = requestKey.getPort();
        if (port > -1 && port != 80 && port != 443) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    private <I> void prepareHttpHeaders(URI requestURI, HttpRequest<I> request, io.netty.handler.codec.http.HttpRequest nettyRequest, boolean permitsBody, boolean closeConnection) {
        HttpHeaders headers = nettyRequest.headers();
        if (!headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)this.getHostHeader(requestURI));
        }
        if (this.httpVersion != HttpVersion.HTTP_2_0) {
            if (closeConnection) {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            } else {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
        }
        if (permitsBody) {
            Optional body = request.getBody();
            if (body.isPresent()) {
                if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
                    MediaType mediaType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
                }
                if (nettyRequest instanceof FullHttpRequest) {
                    FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullHttpRequest.content().readableBytes());
                } else if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !headers.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
            } else if (!(nettyRequest instanceof StreamedHttpRequest)) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            }
        }
    }

    private <O, E> void addFullHttpResponseHandler(final HttpRequest<?> request, Channel channel, final ChannelPool channelPool, final FlowableEmitter<HttpResponse<O>> emitter, final Argument<O> bodyType, final Argument<E> errorType) {
        final ChannelPipeline pipeline = channel.pipeline();
        SimpleChannelInboundHandlerInstrumented<FullHttpResponse> newHandler = new SimpleChannelInboundHandlerInstrumented<FullHttpResponse>(false){
            AtomicBoolean complete;
            boolean keepAlive;
            {
                super(autoRelease);
                this.complete = new AtomicBoolean(false);
                this.keepAlive = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void channelReadInstrumented(ChannelHandlerContext channelHandlerContext, FullHttpResponse fullResponse) {
                block48: {
                    HttpHeaders headers;
                    HttpStatus httpStatus;
                    int statusCode;
                    HttpResponseStatus status;
                    block46: {
                        block47: {
                            status = fullResponse.status();
                            statusCode = status.code();
                            try {
                                httpStatus = HttpStatus.valueOf((int)statusCode);
                            }
                            catch (IllegalArgumentException e) {
                                block45: {
                                    if (this.complete.compareAndSet(false, true)) {
                                        emitter.tryOnError((Throwable)e);
                                    } else if (LOG.isWarnEnabled()) {
                                        LOG.warn("Unsupported http status after handler completed: " + e.getMessage(), (Throwable)e);
                                    }
                                    if (fullResponse.refCnt() > 0) {
                                        try {
                                            ReferenceCountUtil.release((Object)fullResponse);
                                        }
                                        catch (Throwable e2) {
                                            if (!LOG.isDebugEnabled()) break block45;
                                            LOG.debug("Failed to release response: {}", (Object)fullResponse);
                                        }
                                    }
                                }
                                if (!HttpUtil.isKeepAlive((HttpMessage)fullResponse)) {
                                    this.keepAlive = false;
                                }
                                pipeline.remove((ChannelHandler)this);
                                return;
                            }
                            headers = fullResponse.headers();
                            if (DefaultHttpClient.this.log.isDebugEnabled()) {
                                DefaultHttpClient.this.log.debug("Received response {} from {}", (Object)status.code(), (Object)request.getUri());
                            }
                            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                                DefaultHttpClient.this.traceHeaders(headers);
                                DefaultHttpClient.this.traceBody("Response", fullResponse.content());
                            }
                            if (statusCode <= 300 || statusCode >= 400 || !DefaultHttpClient.this.configuration.isFollowRedirects() || !headers.contains((CharSequence)HttpHeaderNames.LOCATION)) break block46;
                            String location = headers.get((CharSequence)HttpHeaderNames.LOCATION);
                            MutableHttpRequest redirectRequest = HttpRequest.GET((String)location);
                            DefaultHttpClient.this.setRedirectHeaders(request, (MutableHttpRequest<Object>)redirectRequest);
                            Flowable redirectExchange = Flowable.fromPublisher(DefaultHttpClient.this.resolveRedirectURI((HttpRequest<?>)request, redirectRequest)).switchMap(DefaultHttpClient.this.buildExchangePublisher((HttpRequest<?>)request, redirectRequest, bodyType, errorType));
                            redirectExchange.first((Object)HttpResponse.notFound()).subscribe((oHttpResponse, throwable) -> {
                                if (throwable != null) {
                                    emitter.tryOnError(throwable);
                                } else {
                                    emitter.onNext(oHttpResponse);
                                    emitter.onComplete();
                                }
                            });
                            if (fullResponse.refCnt() > 0) {
                                try {
                                    ReferenceCountUtil.release((Object)fullResponse);
                                }
                                catch (Throwable e) {
                                    if (!LOG.isDebugEnabled()) break block47;
                                    LOG.debug("Failed to release response: {}", (Object)fullResponse);
                                }
                            }
                        }
                        if (!HttpUtil.isKeepAlive((HttpMessage)fullResponse)) {
                            this.keepAlive = false;
                        }
                        pipeline.remove((ChannelHandler)this);
                        return;
                    }
                    try {
                        try {
                            if (statusCode == HttpStatus.NO_CONTENT.getCode()) {
                                headers.remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                            }
                            boolean convertBodyWithBodyType = statusCode < 400 || !DefaultHttpClient.this.configuration.isExceptionOnErrorStatus() && bodyType.equalsType(errorType);
                            FullNettyClientHttpResponse response = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, bodyType, convertBodyWithBodyType);
                            if (!this.complete.compareAndSet(false, true)) break block48;
                            if (convertBodyWithBodyType) {
                                emitter.onNext(response);
                                response.onComplete();
                                emitter.onComplete();
                                break block48;
                            }
                            try {
                                HttpClientResponseException clientError = errorType != HttpClient.DEFAULT_ERROR_TYPE ? new HttpClientResponseException(status.reasonPhrase(), null, response, new HttpClientErrorDecoder(){

                                    public Argument<?> getErrorType(MediaType mediaType) {
                                        return errorType;
                                    }
                                }) : new HttpClientResponseException(status.reasonPhrase(), response);
                                try {
                                    emitter.tryOnError((Throwable)clientError);
                                }
                                finally {
                                    response.onComplete();
                                }
                            }
                            catch (Throwable t) {
                                if (t instanceof HttpClientResponseException) {
                                    try {
                                        emitter.tryOnError(t);
                                        break block48;
                                    }
                                    finally {
                                        response.onComplete();
                                    }
                                }
                                response.onComplete();
                                FullNettyClientHttpResponse errorResponse = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, false);
                                errorResponse.onComplete();
                                HttpClientResponseException clientResponseError = new HttpClientResponseException("Error decoding HTTP error response body: " + t.getMessage(), t, errorResponse, null);
                                emitter.tryOnError((Throwable)clientResponseError);
                            }
                        }
                        catch (Throwable t) {
                            if (this.complete.compareAndSet(false, true)) {
                                if (t instanceof HttpClientResponseException) {
                                    emitter.tryOnError(t);
                                    break block48;
                                }
                                FullNettyClientHttpResponse response = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, false);
                                HttpClientResponseException clientResponseError = new HttpClientResponseException("Error decoding HTTP response body: " + t.getMessage(), t, response, new HttpClientErrorDecoder(){

                                    public Argument<?> getErrorType(MediaType mediaType) {
                                        return errorType;
                                    }
                                });
                                try {
                                    emitter.tryOnError((Throwable)clientResponseError);
                                    break block48;
                                }
                                finally {
                                    response.onComplete();
                                }
                            }
                            if (LOG.isWarnEnabled()) {
                                LOG.warn("Exception fired after handler completed: " + t.getMessage(), t);
                            }
                        }
                    }
                    finally {
                        block49: {
                            if (fullResponse.refCnt() > 0) {
                                try {
                                    ReferenceCountUtil.release((Object)fullResponse);
                                }
                                catch (Throwable e) {
                                    if (!LOG.isDebugEnabled()) break block49;
                                    LOG.debug("Failed to release response: {}", (Object)fullResponse);
                                }
                            }
                        }
                        if (!HttpUtil.isKeepAlive((HttpMessage)fullResponse)) {
                            this.keepAlive = false;
                        }
                        pipeline.remove((ChannelHandler)this);
                    }
                }
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                if (channelPool != null) {
                    if (DefaultHttpClient.this.readTimeoutMillis != null) {
                        ctx.pipeline().remove("read-timeout");
                    }
                    Channel ch = ctx.channel();
                    if (!this.keepAlive) {
                        ch.closeFuture().addListener(future -> channelPool.release(ch));
                    } else {
                        channelPool.release(ch);
                    }
                } else {
                    ctx.close();
                }
            }

            public void handlerAdded(ChannelHandlerContext ctx) {
                if (DefaultHttpClient.this.readTimeoutMillis != null) {
                    if (DefaultHttpClient.this.httpVersion == HttpVersion.HTTP_2_0) {
                        Http2SettingsHandler settingsHandler = (Http2SettingsHandler)ctx.pipeline().get("http2-settings");
                        if (settingsHandler != null) {
                            DefaultHttpClient.this.addInstrumentedListener((Future)settingsHandler.promise, future -> {
                                if (future.isSuccess()) {
                                    pipeline.addBefore("http2-connection", "read-timeout", (ChannelHandler)new ReadTimeoutHandler(DefaultHttpClient.this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS));
                                }
                            });
                        } else {
                            pipeline.addBefore("http2-connection", "read-timeout", (ChannelHandler)new ReadTimeoutHandler(DefaultHttpClient.this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS));
                        }
                    } else {
                        pipeline.addBefore("http-client-codec", "read-timeout", (ChannelHandler)new ReadTimeoutHandler(DefaultHttpClient.this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS));
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                try {
                    if (this.complete.compareAndSet(false, true)) {
                        String message = cause.getMessage();
                        if (message == null) {
                            message = cause.getClass().getSimpleName();
                        }
                        if (DefaultHttpClient.this.log.isTraceEnabled()) {
                            DefaultHttpClient.this.log.trace("HTTP Client exception ({}) occurred for request : {} {}", new Object[]{message, request.getMethodName(), request.getUri()});
                        }
                        if (cause instanceof TooLongFrameException) {
                            emitter.tryOnError((Throwable)new ContentLengthExceededException((long)DefaultHttpClient.this.configuration.getMaxContentLength()));
                        } else if (cause instanceof io.netty.handler.timeout.ReadTimeoutException) {
                            emitter.tryOnError((Throwable)ReadTimeoutException.TIMEOUT_EXCEPTION);
                        } else {
                            emitter.tryOnError((Throwable)new HttpClientException("Error occurred reading HTTP response: " + message, cause));
                        }
                    }
                }
                finally {
                    this.keepAlive = false;
                    pipeline.remove((ChannelHandler)this);
                }
            }
        };
        pipeline.addLast("micronaut-full-http-response", (ChannelHandler)newHandler);
    }

    private void setRedirectHeaders(@Nullable io.netty.handler.codec.http.HttpRequest request, MutableHttpRequest<Object> redirectRequest) {
        if (request != null) {
            request.headers().forEach(header -> redirectRequest.header((CharSequence)header.getKey(), (CharSequence)header.getValue()));
            redirectRequest.getHeaders().remove((CharSequence)HttpHeaderNames.HOST);
        }
    }

    private void setRedirectHeaders(@Nullable HttpRequest<?> request, MutableHttpRequest<Object> redirectRequest) {
        if (request != null) {
            for (Map.Entry originalHeader : request.getHeaders()) {
                List originalHeaderValue = (List)originalHeader.getValue();
                if (originalHeaderValue == null || originalHeaderValue.isEmpty()) continue;
                for (String value : originalHeaderValue) {
                    if (value == null) continue;
                    redirectRequest.header((CharSequence)originalHeader.getKey(), (CharSequence)value);
                }
            }
            redirectRequest.getHeaders().remove((CharSequence)HttpHeaderNames.HOST);
        }
    }

    private ClientFilterChain buildChain(final AtomicReference<HttpRequest> requestWrapper, final List<HttpClientFilter> filters) {
        final AtomicInteger integer = new AtomicInteger();
        final int len = filters.size();
        return new ClientFilterChain(){

            public Publisher<? extends HttpResponse<?>> proceed(MutableHttpRequest<?> request) {
                int pos = integer.incrementAndGet();
                if (pos > len) {
                    throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                }
                HttpClientFilter httpFilter = (HttpClientFilter)filters.get(pos);
                return httpFilter.doFilter((HttpRequest)requestWrapper.getAndSet(request), (FilterChain)this);
            }
        };
    }

    private HttpPostRequestEncoder buildFormDataRequest(MutableHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder(NettyHttpRequestBuilder.toHttpRequest((HttpRequest)clientHttpRequest), false);
        Map formData = bodyValue instanceof Map ? (Map)bodyValue : BeanMap.of((Object)bodyValue);
        for (Map.Entry entry : formData.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object val : collection) {
                    this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), val);
                }
                continue;
            }
            this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), value);
        }
        return postRequestEncoder;
    }

    private void addBodyAttribute(HttpPostRequestEncoder postRequestEncoder, String key, Object value) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        Optional converted = ConversionService.SHARED.convert(value, String.class);
        if (converted.isPresent()) {
            postRequestEncoder.addBodyAttribute(key, (String)converted.get());
        }
    }

    private HttpPostRequestEncoder buildMultipartRequest(MutableHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        io.netty.handler.codec.http.HttpRequest request = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)clientHttpRequest);
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder((HttpDataFactory)factory, request, true, CharsetUtil.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        if (bodyValue instanceof MultipartBody.Builder) {
            bodyValue = ((MultipartBody.Builder)bodyValue).build();
        }
        if (!(bodyValue instanceof MultipartBody)) {
            throw new MultipartException(String.format("The type %s is not a supported type for a multipart request body", bodyValue.getClass().getName()));
        }
        MultipartBody multipartBody = (MultipartBody)bodyValue;
        postRequestEncoder.setBodyHttpDatas(multipartBody.getData((MultipartDataFactory)new MultipartDataFactory<InterfaceHttpData>((HttpDataFactory)factory, request){
            final /* synthetic */ HttpDataFactory val$factory;
            final /* synthetic */ io.netty.handler.codec.http.HttpRequest val$request;
            {
                this.val$factory = httpDataFactory;
                this.val$request = httpRequest;
            }

            @NonNull
            public InterfaceHttpData createFileUpload(@NonNull String name, @NonNull String filename, @NonNull MediaType contentType, @Nullable String encoding, @Nullable Charset charset, long length) {
                return this.val$factory.createFileUpload(this.val$request, name, filename, contentType.toString(), encoding, charset, length);
            }

            @NonNull
            public InterfaceHttpData createAttribute(@NonNull String name, @NonNull String value) {
                return this.val$factory.createAttribute(this.val$request, name, value);
            }

            public void setContent(InterfaceHttpData fileUploadObject, Object content) throws IOException {
                if (fileUploadObject instanceof FileUpload) {
                    FileUpload fu = (FileUpload)fileUploadObject;
                    if (content instanceof InputStream) {
                        fu.setContent((InputStream)content);
                    } else if (content instanceof File) {
                        fu.setContent((File)content);
                    } else if (content instanceof byte[]) {
                        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])((byte[])content));
                        fu.setContent(buffer);
                    }
                }
            }
        }));
        return postRequestEncoder;
    }

    private void debugRequest(URI requestURI, io.netty.handler.codec.http.HttpRequest nettyRequest) {
        this.log.debug("Sending HTTP {} to {}", (Object)nettyRequest.method(), (Object)requestURI.toString());
    }

    private void traceRequest(HttpRequest<?> request, io.netty.handler.codec.http.HttpRequest nettyRequest) {
        HttpHeaders headers = nettyRequest.headers();
        this.traceHeaders(headers);
        if (HttpMethod.permitsRequestBody((HttpMethod)request.getMethod()) && request.getBody().isPresent() && nettyRequest instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
            ByteBuf content = fullHttpRequest.content();
            if (this.log.isTraceEnabled()) {
                this.traceBody("Request", content);
            }
        }
    }

    private void traceBody(String type, ByteBuf content) {
        this.log.trace(type + " Body");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private void traceChunk(ByteBuf content) {
        this.log.trace("Sending Chunk");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private void traceHeaders(HttpHeaders headers) {
        for (String name : headers.names()) {
            List all = headers.getAll(name);
            if (all.size() > 1) {
                for (String value : all) {
                    this.log.trace("{}: {}", (Object)name, (Object)value);
                }
                continue;
            }
            if (all.isEmpty()) continue;
            this.log.trace("{}: {}", (Object)name, all.get(0));
        }
    }

    private static MediaTypeCodecRegistry createDefaultMediaTypeRegistry() {
        ObjectMapper objectMapper = new ObjectMapperFactory().objectMapper(null, null);
        ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration();
        return MediaTypeCodecRegistry.of((MediaTypeCodec[])new MediaTypeCodec[]{new JsonMediaTypeCodec(objectMapper, applicationConfiguration, null), new JsonStreamMediaTypeCodec(objectMapper, applicationConfiguration, null)});
    }

    private <I> NettyRequestWriter prepareRequest(HttpRequest<I> request, URI requestURI, FlowableEmitter<HttpResponse<Object>> emitter, boolean closeChannelAfterWrite) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        MediaType requestContentType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)request.getMethod());
        MutableHttpRequest clientHttpRequest = (MutableHttpRequest)request;
        NettyRequestWriter requestWriter = this.buildNettyRequest(clientHttpRequest, requestURI, requestContentType, permitsBody, (io.reactivex.functions.Consumer<? super Throwable>)((io.reactivex.functions.Consumer)arg_0 -> emitter.tryOnError(arg_0)), closeChannelAfterWrite);
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        this.prepareHttpHeaders(requestURI, request, nettyRequest, permitsBody, true);
        return requestWriter;
    }

    private Disposable buildDisposableChannel(final ChannelFuture channelFuture) {
        return new Disposable(){
            private AtomicBoolean disposed = new AtomicBoolean(false);

            public void dispose() {
                Channel channel;
                if (this.disposed.compareAndSet(false, true) && (channel = channelFuture.channel()).isOpen()) {
                    DefaultHttpClient.this.closeChannelAsync(channel);
                }
            }

            public boolean isDisposed() {
                return this.disposed.get();
            }
        };
    }

    private AbstractChannelPoolHandler newPoolHandler(final RequestKey key) {
        return new AbstractChannelPoolHandler(){

            public void channelCreated(Channel ch) {
                ch.pipeline().addLast("http-client-init", (ChannelHandler)new HttpClientInitializer(key.isSecure() ? DefaultHttpClient.this.sslContext : null, key.getHost(), key.getPort(), false, false, null){

                    @Override
                    protected void addFinalHandler(ChannelPipeline pipeline) {
                    }
                });
                if (DefaultHttpClient.this.connectionTimeAliveMillis != null) {
                    ch.pipeline().addLast("connect-ttl", (ChannelHandler)new ConnectTTLHandler(DefaultHttpClient.this.connectionTimeAliveMillis));
                }
            }

            public void channelReleased(Channel ch) {
                boolean shouldCloseOnRelease;
                Duration idleTimeout = DefaultHttpClient.this.configuration.getConnectionPoolIdleTimeout().orElse(Duration.ofNanos(0L));
                ChannelPipeline pipeline = ch.pipeline();
                if (ch.isOpen()) {
                    ch.config().setAutoRead(true);
                    pipeline.addLast(new ChannelHandler[]{IdlingConnectionHandler.INSTANCE});
                    if (idleTimeout.toNanos() > 0L) {
                        pipeline.addLast("idle-state", (ChannelHandler)new IdleStateHandler(idleTimeout.toNanos(), idleTimeout.toNanos(), 0L, TimeUnit.NANOSECONDS));
                        pipeline.addLast(new ChannelHandler[]{IdleTimeoutHandler.INSTANCE});
                    }
                }
                if (DefaultHttpClient.this.connectionTimeAliveMillis != null && (shouldCloseOnRelease = Boolean.TRUE.equals(ch.attr(ConnectTTLHandler.RELEASE_CHANNEL).get())) && ch.isOpen() && !ch.eventLoop().isShuttingDown()) {
                    ch.close();
                }
                if (DefaultHttpClient.this.readTimeoutMillis != null && pipeline.context("read-timeout") != null) {
                    pipeline.remove("read-timeout");
                }
            }

            public void channelAcquired(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (pipeline.context((ChannelHandler)IdlingConnectionHandler.INSTANCE) != null) {
                    pipeline.remove((ChannelHandler)IdlingConnectionHandler.INSTANCE);
                }
                if (pipeline.context("idle-state") != null) {
                    pipeline.remove("idle-state");
                }
                if (pipeline.context((ChannelHandler)IdleTimeoutHandler.INSTANCE) != null) {
                    pipeline.remove((ChannelHandler)IdleTimeoutHandler.INSTANCE);
                }
            }
        };
    }

    public boolean isClientChannel() {
        return true;
    }

    public void doOnConnect(@NonNull ChannelPipelineListener listener) {
        this.pipelineListeners.add(Objects.requireNonNull(listener, "The listener cannot be null"));
    }

    public Flowable<MutableHttpResponse<?>> proxy(HttpRequest<?> request) {
        return Flowable.fromPublisher(this.resolveRequestURI(request)).flatMap(requestURI -> {
            AtomicReference<HttpRequest> requestWrapper = new AtomicReference<HttpRequest>(request);
            Flowable proxyResponsePublisher = Flowable.create(emitter -> {
                ChannelFuture channelFuture;
                SslContext sslContext = this.buildSslContext((URI)requestURI);
                try {
                    if (this.httpVersion == HttpVersion.HTTP_2_0) {
                        channelFuture = this.doConnect(request, (URI)requestURI, sslContext, true, channelHandlerContext -> {
                            try {
                                Channel channel = channelHandlerContext.channel();
                                request.setAttribute(NettyClientHttpRequest.CHANNEL, (Object)channel);
                                this.streamRequestThroughChannel(request, requestWrapper, emitter, channel, false);
                            }
                            catch (Throwable e) {
                                emitter.onError(e);
                            }
                        });
                    } else {
                        channelFuture = this.doConnect(request, (URI)requestURI, sslContext, true, null);
                        this.addInstrumentedListener((Future)channelFuture, (GenericFutureListener)((ChannelFutureListener)f -> {
                            if (f.isSuccess()) {
                                Channel channel = f.channel();
                                request.setAttribute(NettyClientHttpRequest.CHANNEL, (Object)channel);
                                this.streamRequestThroughChannel(request, requestWrapper, emitter, channel, false);
                            } else {
                                Throwable cause = f.cause();
                                emitter.onError((Throwable)new HttpClientException("Connect error:" + cause.getMessage(), cause));
                            }
                        }));
                    }
                }
                catch (HttpClientException e) {
                    emitter.onError((Throwable)e);
                    return;
                }
                Disposable disposable = this.buildDisposableChannel(channelFuture);
                emitter.setDisposable(disposable);
                emitter.setCancellable(() -> ((Disposable)disposable).dispose());
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER);
            proxyResponsePublisher = Flowable.fromPublisher(this.applyFilterToResponsePublisher(request, (HttpRequest)requestWrapper.get(), (URI)requestURI, requestWrapper, (Publisher)proxyResponsePublisher));
            return proxyResponsePublisher;
        });
    }

    private <V, C extends Future<V>> Future<V> addInstrumentedListener(Future<V> channelFuture, GenericFutureListener<C> listener) {
        InvocationInstrumenter instrumenter = DefaultHttpClient.combineFactories(this.invocationInstrumenterFactories);
        return channelFuture.addListener(f -> {
            try (Instrumentation ignored = instrumenter.newInstrumentation();){
                listener.operationComplete(f);
            }
        });
    }

    @NonNull
    private static InvocationInstrumenter combineFactories(Collection<InvocationInstrumenterFactory> factories) {
        if (CollectionUtils.isEmpty(factories)) {
            return InvocationInstrumenter.NOOP;
        }
        return InvocationInstrumenter.combine((Collection)factories.stream().map(InvocationInstrumenterFactory::newInvocationInstrumenter).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static class CurrentEvent {
        byte[] data;
        String id;
        String name;
        Duration retry;

        private CurrentEvent() {
        }
    }

    protected class NettyRequestWriter {
        private final io.netty.handler.codec.http.HttpRequest nettyRequest;
        private final HttpPostRequestEncoder encoder;
        private final String scheme;
        private final boolean closeChannelAfterWrite;

        NettyRequestWriter(String scheme, io.netty.handler.codec.http.HttpRequest nettyRequest, HttpPostRequestEncoder encoder, boolean closeChannelAfterWrite) {
            this.nettyRequest = nettyRequest;
            this.encoder = encoder;
            this.scheme = scheme;
            this.closeChannelAfterWrite = closeChannelAfterWrite;
        }

        protected void writeAndClose(Channel channel, ChannelPool channelPool, FlowableEmitter<?> emitter) {
            ChannelPipeline pipeline = channel.pipeline();
            if (DefaultHttpClient.this.httpVersion == HttpVersion.HTTP_2_0) {
                boolean isSecure;
                boolean bl = isSecure = DefaultHttpClient.this.sslContext != null && "https".equalsIgnoreCase(this.scheme);
                if (isSecure) {
                    this.nettyRequest.headers().add((CharSequence)AbstractNettyHttpRequest.HTTP2_SCHEME, (Object)HttpScheme.HTTPS);
                } else {
                    this.nettyRequest.headers().add((CharSequence)AbstractNettyHttpRequest.HTTP2_SCHEME, (Object)HttpScheme.HTTP);
                }
                UpgradeRequestHandler upgradeRequestHandler = (UpgradeRequestHandler)pipeline.get("http2-upgrade-request");
                Http2SettingsHandler settingsHandler = upgradeRequestHandler != null ? upgradeRequestHandler.getSettingsHandler() : (Http2SettingsHandler)pipeline.get("http2-settings");
                if (settingsHandler != null) {
                    DefaultHttpClient.this.addInstrumentedListener((Future)settingsHandler.promise, future -> {
                        if (!future.isSuccess()) {
                            throw new HttpClientException("HTTP/2 clear text upgrade failed to complete", future.cause());
                        }
                        this.processRequestWrite(channel, channelPool, emitter, pipeline);
                    });
                    return;
                }
            }
            this.processRequestWrite(channel, channelPool, emitter, pipeline);
        }

        private void processRequestWrite(Channel channel, ChannelPool channelPool, FlowableEmitter<?> emitter, ChannelPipeline pipeline) {
            ChannelFuture channelFuture;
            if (this.encoder != null && this.encoder.isChunked()) {
                channel.attr(AttributeKey.valueOf((String)"chunk-writer")).set((Object)true);
                pipeline.addAfter("http-streams-codec", "chunk-writer", (ChannelHandler)new ChunkedWriteHandler());
                channel.write((Object)this.nettyRequest);
                channelFuture = channel.writeAndFlush((Object)this.encoder);
            } else {
                channelFuture = channel.writeAndFlush((Object)this.nettyRequest);
            }
            if (channelPool != null) {
                this.closeChannelIfNecessary(channel, emitter, channelFuture, false);
            } else {
                this.closeChannelIfNecessary(channel, emitter, channelFuture, this.closeChannelAfterWrite);
            }
        }

        private void closeChannelIfNecessary(Channel channel, FlowableEmitter<?> emitter, ChannelFuture channelFuture, boolean closeChannelAfterWrite) {
            DefaultHttpClient.this.addInstrumentedListener((Future)channelFuture, f -> {
                try {
                    if (!f.isSuccess()) {
                        if (!emitter.isCancelled()) {
                            emitter.onError(f.cause());
                        }
                    } else {
                        channel.read();
                    }
                }
                finally {
                    if (this.encoder != null) {
                        this.encoder.cleanFiles();
                    }
                    channel.attr(AttributeKey.valueOf((String)"chunk-writer")).set(null);
                    if (closeChannelAfterWrite) {
                        DefaultHttpClient.this.closeChannelAsync(channel);
                    }
                }
            });
        }

        io.netty.handler.codec.http.HttpRequest getNettyRequest() {
            return this.nettyRequest;
        }
    }

    private static final class RequestKey {
        private final String host;
        private final int port;
        private final boolean secure;

        public RequestKey(URI requestURI) {
            int port;
            this.secure = "https".equalsIgnoreCase(requestURI.getScheme());
            String host = requestURI.getHost();
            if (host == null) {
                host = requestURI.getAuthority();
                if (host == null) {
                    throw new NoHostException("URI specifies no host to connect to");
                }
                int i = host.indexOf(58);
                if (i > -1) {
                    String portStr = host.substring(i + 1);
                    host = host.substring(0, i);
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        throw new HttpClientException("URI specifies an invalid port: " + portStr);
                    }
                } else {
                    port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
                }
            } else {
                port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
            }
            this.host = host;
            this.port = port;
        }

        public InetSocketAddress getRemoteAddress() {
            return InetSocketAddress.createUnresolved(this.host, this.port);
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestKey that = (RequestKey)o;
            return this.port == that.port && this.secure == that.secure && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port, this.secure);
        }
    }

    private class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private final HttpClientInitializer initializer;
        private final Http2SettingsHandler settingsHandler;

        public UpgradeRequestHandler(HttpClientInitializer initializer) {
            this.initializer = initializer;
            this.settingsHandler = initializer.settingsHandler;
        }

        public Http2SettingsHandler getSettingsHandler() {
            return this.settingsHandler;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.addLast("http2-settings", (ChannelHandler)this.initializer.settingsHandler);
            DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, io.netty.handler.codec.http.HttpMethod.GET, "/", Unpooled.EMPTY_BUFFER);
            InetSocketAddress remote = (InetSocketAddress)ctx.channel().remoteAddress();
            String hostString = remote.getHostString();
            if (hostString == null) {
                hostString = remote.getAddress().getHostAddress();
            }
            upgradeRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(hostString + ':' + remote.getPort()));
            ctx.writeAndFlush((Object)upgradeRequest);
            ctx.fireChannelActive();
            pipeline.remove((ChannelHandler)this);
            this.initializer.addFinalHandler(pipeline);
        }
    }

    private final class Http2SettingsHandler
    extends SimpleChannelInboundHandlerInstrumented<Http2Settings> {
        private final ChannelPromise promise;

        Http2SettingsHandler(ChannelPromise promise) {
            this.promise = promise;
        }

        @Override
        protected void channelReadInstrumented(ChannelHandlerContext ctx, Http2Settings msg) {
            this.promise.setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    protected class HttpClientInitializer
    extends ChannelInitializer<SocketChannel> {
        final SslContext sslContext;
        final String host;
        final int port;
        final boolean stream;
        final boolean acceptsEvents;
        Http2SettingsHandler settingsHandler;
        private final Consumer<ChannelHandlerContext> contextConsumer;

        protected HttpClientInitializer(SslContext sslContext, String host, int port, boolean stream, boolean acceptsEvents, Consumer<ChannelHandlerContext> contextConsumer) {
            this.sslContext = sslContext;
            this.stream = stream;
            this.host = host;
            this.port = port;
            this.acceptsEvents = acceptsEvents;
            this.contextConsumer = contextConsumer;
        }

        protected void initChannel(SocketChannel ch) {
            ChannelPipeline p = ch.pipeline();
            Proxy proxy = DefaultHttpClient.this.configuration.resolveProxy(this.sslContext != null, this.host, this.port);
            if (!Proxy.NO_PROXY.equals(proxy)) {
                DefaultHttpClient.this.configureProxy(p, proxy);
            }
            if (DefaultHttpClient.this.httpVersion == HttpVersion.HTTP_2_0) {
                DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
                HttpToHttp2ConnectionHandlerBuilder builder = DefaultHttpClient.this.newHttp2ConnectionHandlerBuilder((Http2Connection)connection, DefaultHttpClient.this.configuration, this.stream);
                DefaultHttpClient.this.configuration.getLogLevel().ifPresent(logLevel -> {
                    try {
                        LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                        builder.frameLogger(new Http2FrameLogger(nettyLevel, DefaultHttpClient.class));
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpClientException("Unsupported log level: " + logLevel);
                    }
                });
                HttpToHttp2ConnectionHandler connectionHandler = builder.build();
                if (this.sslContext != null) {
                    DefaultHttpClient.this.configureHttp2Ssl(this, ch, this.sslContext, this.host, this.port, connectionHandler);
                } else {
                    DefaultHttpClient.this.configureHttp2ClearText(this, ch, connectionHandler);
                }
            } else {
                Duration duration;
                Optional readIdleTime;
                if (this.stream) {
                    ch.config().setAutoRead(false);
                }
                DefaultHttpClient.this.configuration.getLogLevel().ifPresent(logLevel -> {
                    try {
                        LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                        p.addLast(new ChannelHandler[]{new LoggingHandler(DefaultHttpClient.class, nettyLevel)});
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpClientException("Unsupported log level: " + logLevel);
                    }
                });
                if (this.sslContext != null) {
                    SslHandler sslHandler = this.sslContext.newHandler(ch.alloc(), this.host, this.port);
                    p.addLast("ssl", (ChannelHandler)sslHandler);
                }
                if (DefaultHttpClient.this.poolMap == null && this.stream && (readIdleTime = DefaultHttpClient.this.configuration.getReadIdleTimeout()).isPresent() && !(duration = (Duration)readIdleTime.get()).isNegative()) {
                    p.addLast("idle-state", (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
                }
                this.addHttp1Handlers(p);
            }
        }

        private void addHttp1Handlers(ChannelPipeline p) {
            p.addLast("http-client-codec", (ChannelHandler)new HttpClientCodec());
            p.addLast("http-decoder", (ChannelHandler)new HttpContentDecompressor());
            int maxContentLength = DefaultHttpClient.this.configuration.getMaxContentLength();
            if (!this.stream) {
                p.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLength){

                    protected void finishAggregation(FullHttpMessage aggregated) throws Exception {
                        if (!HttpUtil.isContentLengthSet((HttpMessage)aggregated) && aggregated.content().readableBytes() > 0) {
                            super.finishAggregation(aggregated);
                        }
                    }
                });
            }
            this.addEventStreamHandlerIfNecessary(p);
            this.addFinalHandler(p);
            for (ChannelPipelineListener pipelineListener : DefaultHttpClient.this.pipelineListeners) {
                pipelineListener.onConnect(p);
            }
        }

        private void addEventStreamHandlerIfNecessary(ChannelPipeline p) {
            if (this.acceptsEventStream()) {
                p.addLast("micronaut-sse-event-stream", (ChannelHandler)new LineBasedFrameDecoder(DefaultHttpClient.this.configuration.getMaxContentLength(), true, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (msg instanceof HttpContent) {
                            if (msg instanceof LastHttpContent) {
                                super.channelRead(ctx, msg);
                            } else {
                                Attribute streamKey = ctx.channel().attr(STREAM_KEY);
                                if (msg instanceof Http2Content) {
                                    streamKey.set((Object)((Http2Content)msg).stream());
                                }
                                try {
                                    super.channelRead(ctx, (Object)((HttpContent)msg).content());
                                }
                                finally {
                                    streamKey.set(null);
                                }
                            }
                        } else {
                            super.channelRead(ctx, msg);
                        }
                    }
                });
                p.addLast("micronaut-sse-content", (ChannelHandler)new SimpleChannelInboundHandlerInstrumented<ByteBuf>(false){

                    public boolean acceptInboundMessage(Object msg) {
                        return msg instanceof ByteBuf;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void channelReadInstrumented(ChannelHandlerContext ctx, ByteBuf msg) {
                        try {
                            Attribute streamKey = ctx.channel().attr(STREAM_KEY);
                            Http2Stream http2Stream = (Http2Stream)streamKey.get();
                            if (http2Stream != null) {
                                ctx.fireChannelRead((Object)new DefaultHttp2Content(msg.copy(), http2Stream));
                            } else {
                                ctx.fireChannelRead((Object)new DefaultHttpContent(msg.copy()));
                            }
                        }
                        finally {
                            msg.release();
                        }
                    }
                });
            }
        }

        protected void addFinalHandler(ChannelPipeline pipeline) {
            pipeline.addLast("http-streams-codec", (ChannelHandler)new HttpStreamsClientHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof IdleStateEvent) {
                        ctx.close();
                    }
                    super.userEventTriggered(ctx, evt);
                }
            });
        }

        private boolean acceptsEventStream() {
            return this.acceptsEvents;
        }
    }

    abstract class SimpleChannelInboundHandlerInstrumented<I>
    extends SimpleChannelInboundHandler<I> {
        private final InvocationInstrumenter instrumenter;

        SimpleChannelInboundHandlerInstrumented() {
            this.instrumenter = DefaultHttpClient.combineFactories(DefaultHttpClient.this.invocationInstrumenterFactories);
        }

        SimpleChannelInboundHandlerInstrumented(boolean autoRelease) {
            super(autoRelease);
            this.instrumenter = DefaultHttpClient.combineFactories(DefaultHttpClient.this.invocationInstrumenterFactories);
        }

        protected abstract void channelReadInstrumented(ChannelHandlerContext var1, I var2) throws Exception;

        protected final void channelRead0(ChannelHandlerContext ctx, I msg) throws Exception {
            try (Instrumentation ignored = this.instrumenter.newInstrumentation();){
                this.channelReadInstrumented(ctx, msg);
            }
        }
    }

    @FunctionalInterface
    static interface ThrowingBiConsumer<T1, T2> {
        public void accept(T1 var1, T2 var2) throws Exception;
    }
}

