/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.FilterMatcher;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.LoadBalancerResolver;
import io.micronaut.http.client.RxHttpClient;
import io.micronaut.http.client.RxHttpClientRegistry;
import io.micronaut.http.client.RxStreamingHttpClient;
import io.micronaut.http.client.annotation.Client;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.client.netty.ssl.NettyClientSslBuilder;
import io.micronaut.http.codec.CodecConfiguration;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.netty.channel.DefaultEventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.EventLoopGroupRegistry;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.jackson.ObjectMapperFactory;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.jackson.codec.JacksonMediaTypeCodec;
import io.micronaut.jackson.codec.JsonMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
@BootstrapContextCompatible
@Internal
public class RxNettyHttpClientRegistry
implements AutoCloseable,
RxHttpClientRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(RxNettyHttpClientRegistry.class);
    private final Map<ClientKey, DefaultHttpClient> clients = new ConcurrentHashMap<ClientKey, DefaultHttpClient>(10);
    private final LoadBalancerResolver loadBalancerResolver;
    private final NettyClientSslBuilder nettyClientSslBuilder;
    private final ThreadFactory threadFactory;
    private final MediaTypeCodecRegistry codecRegistry;
    private final BeanContext beanContext;
    private final HttpClientConfiguration defaultHttpClientConfiguration;
    private final EventLoopGroupRegistry eventLoopGroupRegistry;
    private final List<InvocationInstrumenterFactory> invocationInstrumenterFactories;
    private final EventLoopGroupFactory eventLoopGroupFactory;
    private final HttpClientFilterResolver<ClientFilterResolutionContext> clientFilterResolver;

    public RxNettyHttpClientRegistry(HttpClientConfiguration defaultHttpClientConfiguration, HttpClientFilterResolver httpClientFilterResolver, LoadBalancerResolver loadBalancerResolver, NettyClientSslBuilder nettyClientSslBuilder, ThreadFactory threadFactory, MediaTypeCodecRegistry codecRegistry, EventLoopGroupRegistry eventLoopGroupRegistry, EventLoopGroupFactory eventLoopGroupFactory, BeanContext beanContext, List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        this.clientFilterResolver = httpClientFilterResolver;
        this.defaultHttpClientConfiguration = defaultHttpClientConfiguration;
        this.loadBalancerResolver = loadBalancerResolver;
        this.nettyClientSslBuilder = nettyClientSslBuilder;
        this.threadFactory = threadFactory;
        this.codecRegistry = codecRegistry;
        this.beanContext = beanContext;
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.eventLoopGroupRegistry = eventLoopGroupRegistry;
        this.invocationInstrumenterFactories = invocationInstrumenterFactories;
    }

    @NonNull
    public RxHttpClient getClient(HttpVersion httpVersion, @NonNull String clientId, @Nullable String path) {
        ClientKey key = new ClientKey(httpVersion, clientId, null, path, null, null);
        return this.getClient(key, this.beanContext, AnnotationMetadata.EMPTY_METADATA);
    }

    @NonNull
    public DefaultHttpClient getClient(@NonNull AnnotationMetadata metadata) {
        ClientKey key = this.getClientKey(metadata);
        return this.getClient(key, this.beanContext, metadata);
    }

    @Override
    @PreDestroy
    public void close() {
        for (HttpClient httpClient : this.clients.values()) {
            try {
                httpClient.close();
            }
            catch (Throwable e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Error shutting down HTTP client: " + e.getMessage(), e);
            }
        }
        this.clients.clear();
    }

    public void disposeClient(AnnotationMetadata annotationMetadata) {
        ClientKey key = this.getClientKey(annotationMetadata);
        RxStreamingHttpClient rxStreamingHttpClient = this.clients.get(key);
        if (rxStreamingHttpClient != null && rxStreamingHttpClient.isRunning()) {
            rxStreamingHttpClient.close();
            this.clients.remove(key);
        }
    }

    @Bean
    @BootstrapContextCompatible
    @Primary
    protected DefaultHttpClient httpClient(@Nullable InjectionPoint<?> injectionPoint, @Parameter @Nullable LoadBalancer loadBalancer, @Parameter @Nullable HttpClientConfiguration configuration, BeanContext beanContext) {
        return this.resolveClient(injectionPoint, loadBalancer, configuration, beanContext);
    }

    private DefaultHttpClient getClient(ClientKey key, BeanContext beanContext, AnnotationMetadata annotationMetadata) {
        return this.clients.computeIfAbsent(key, clientKey -> {
            DefaultHttpClient clientBean = null;
            String clientId = clientKey.clientId;
            Class<?> configurationClass = clientKey.configurationClass;
            if (clientId != null) {
                clientBean = this.beanContext.findBean(RxHttpClient.class, Qualifiers.byName((String)clientId)).orElse(null);
            }
            if (configurationClass != null && !HttpClientConfiguration.class.isAssignableFrom(configurationClass)) {
                throw new IllegalStateException("Referenced HTTP client configuration class must be an instance of HttpClientConfiguration for injection point: " + configurationClass);
            }
            List<String> filterAnnotations = clientKey.filterAnnotations;
            String path = clientKey.path;
            if (clientBean != null && path == null && configurationClass == null && filterAnnotations.isEmpty()) {
                return clientBean;
            }
            LoadBalancer loadBalancer = null;
            List<String> clientIdentifiers = null;
            HttpClientConfiguration configuration = configurationClass != null ? (HttpClientConfiguration)this.beanContext.getBean(configurationClass) : (clientId != null ? this.beanContext.findBean(HttpClientConfiguration.class, Qualifiers.byName((String)clientId)).orElse(this.defaultHttpClientConfiguration) : this.defaultHttpClientConfiguration);
            if (clientId != null) {
                loadBalancer = (LoadBalancer)this.loadBalancerResolver.resolve(new String[]{clientId}).orElseThrow(() -> new HttpClientException("Invalid service reference [" + clientId + "] specified to @Client"));
                clientIdentifiers = Collections.singletonList(clientId);
            }
            String contextPath = null;
            if (StringUtils.isNotEmpty((CharSequence)path)) {
                contextPath = path;
            } else if (StringUtils.isNotEmpty((CharSequence)clientId) && clientId.startsWith("/")) {
                contextPath = clientId;
            } else if (loadBalancer != null) {
                contextPath = loadBalancer.getContextPath().orElse(null);
            }
            DefaultHttpClient client = this.buildClient(loadBalancer, clientKey.httpVersion, configuration, clientIdentifiers, contextPath, beanContext, annotationMetadata);
            AnnotationValue<io.micronaut.jackson.annotation.JacksonFeatures> jacksonFeaturesAnn = clientKey.jacksonFeaturesAnn;
            if (jacksonFeaturesAnn != null) {
                DeserializationFeature[] disabledDeserializationFeatures;
                SerializationFeature[] disabledSerializationFeatures;
                DeserializationFeature[] enabledDeserializationFeatures;
                JacksonFeatures jacksonFeatures = new JacksonFeatures();
                SerializationFeature[] enabledSerializationFeatures = jacksonFeaturesAnn.get((CharSequence)"enabledSerializationFeatures", SerializationFeature[].class).orElse(null);
                if (enabledSerializationFeatures != null) {
                    for (SerializationFeature serializationFeature : enabledSerializationFeatures) {
                        jacksonFeatures.addFeature(serializationFeature, true);
                    }
                }
                if ((enabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.get((CharSequence)"enabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
                    for (DeserializationFeature deserializationFeature : enabledDeserializationFeatures) {
                        jacksonFeatures.addFeature(deserializationFeature, true);
                    }
                }
                if ((disabledSerializationFeatures = (SerializationFeature[])jacksonFeaturesAnn.get((CharSequence)"disabledSerializationFeatures", SerializationFeature[].class).orElse(null)) != null) {
                    for (SerializationFeature serializationFeature : disabledSerializationFeatures) {
                        jacksonFeatures.addFeature(serializationFeature, false);
                    }
                }
                if ((disabledDeserializationFeatures = (DeserializationFeature[])jacksonFeaturesAnn.get((CharSequence)"disabledDeserializationFeatures", DeserializationFeature[].class).orElse(null)) != null) {
                    for (DeserializationFeature feature : disabledDeserializationFeatures) {
                        jacksonFeatures.addFeature(feature, false);
                    }
                }
                ArrayList<Object> codecs = new ArrayList<Object>(2);
                MediaTypeCodecRegistry codecRegistry = client.getMediaTypeCodecRegistry();
                for (MediaTypeCodec codec : codecRegistry.getCodecs()) {
                    if (codec instanceof JacksonMediaTypeCodec) {
                        codecs.add(((JacksonMediaTypeCodec)codec).cloneWithFeatures(jacksonFeatures));
                        continue;
                    }
                    codecs.add(codec);
                }
                if (!codecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE).isPresent()) {
                    codecs.add(RxNettyHttpClientRegistry.createNewJsonCodec(this.beanContext, jacksonFeatures));
                }
                client.setMediaTypeCodecRegistry(MediaTypeCodecRegistry.of(codecs));
            }
            return client;
        });
    }

    private DefaultHttpClient buildClient(LoadBalancer loadBalancer, HttpVersion httpVersion, HttpClientConfiguration configuration, List<String> clientIdentifiers, String contextPath, BeanContext beanContext, AnnotationMetadata annotationMetadata) {
        EventLoopGroup eventLoopGroup = this.resolveEventLoopGroup(configuration, beanContext);
        return new DefaultHttpClient(loadBalancer, httpVersion, configuration, contextPath, this.clientFilterResolver, this.clientFilterResolver.resolveFilterEntries((AnnotationMetadataProvider)new ClientFilterResolutionContext(clientIdentifiers, annotationMetadata)), this.threadFactory, this.nettyClientSslBuilder, this.codecRegistry, WebSocketBeanRegistry.forClient((BeanContext)beanContext), beanContext.findBean(RequestBinderRegistry.class).orElseGet(() -> new DefaultRequestBinderRegistry(ConversionService.SHARED, new RequestArgumentBinder[0])), eventLoopGroup, this.resolveSocketChannelFactory(configuration, beanContext), this.invocationInstrumenterFactories);
    }

    private EventLoopGroup resolveEventLoopGroup(HttpClientConfiguration configuration, BeanContext beanContext) {
        String eventLoopGroupName = configuration.getEventLoopGroup();
        EventLoopGroup eventLoopGroup = "default".equals(eventLoopGroupName) ? this.eventLoopGroupRegistry.getDefaultEventLoopGroup() : (EventLoopGroup)beanContext.findBean(EventLoopGroup.class, Qualifiers.byName((String)eventLoopGroupName)).orElseThrow(() -> new HttpClientException("Specified event loop group is not defined: " + eventLoopGroupName));
        return eventLoopGroup;
    }

    private DefaultHttpClient resolveClient(@Nullable InjectionPoint injectionPoint, @Nullable LoadBalancer loadBalancer, @Nullable HttpClientConfiguration configuration, BeanContext beanContext) {
        if (loadBalancer != null) {
            List filterEntries = this.clientFilterResolver.resolveFilterEntries((AnnotationMetadataProvider)new ClientFilterResolutionContext(null, AnnotationMetadata.EMPTY_METADATA));
            if (configuration == null) {
                configuration = this.defaultHttpClientConfiguration;
            }
            EventLoopGroup eventLoopGroup = this.resolveEventLoopGroup(configuration, beanContext);
            return new DefaultHttpClient(loadBalancer, null, configuration, loadBalancer.getContextPath().orElse(null), this.clientFilterResolver, filterEntries, this.threadFactory, this.nettyClientSslBuilder, this.codecRegistry, WebSocketBeanRegistry.forClient((BeanContext)beanContext), beanContext.findBean(RequestBinderRegistry.class).orElseGet(() -> new DefaultRequestBinderRegistry(ConversionService.SHARED, new RequestArgumentBinder[0])), eventLoopGroup, this.resolveSocketChannelFactory(configuration, beanContext), this.invocationInstrumenterFactories);
        }
        return this.getClient(injectionPoint != null ? injectionPoint.getAnnotationMetadata() : AnnotationMetadata.EMPTY_METADATA);
    }

    private ChannelFactory resolveSocketChannelFactory(HttpClientConfiguration configuration, BeanContext beanContext) {
        String eventLoopGroup = configuration.getEventLoopGroup();
        EventLoopGroupConfiguration eventLoopGroupConfiguration = beanContext.findBean(EventLoopGroupConfiguration.class, Qualifiers.byName((String)eventLoopGroup)).orElseGet(() -> {
            if ("default".equals(eventLoopGroup)) {
                return new DefaultEventLoopGroupConfiguration();
            }
            throw new HttpClientException("Specified event loop group is not defined: " + eventLoopGroup);
        });
        return () -> this.eventLoopGroupFactory.clientSocketChannelInstance(eventLoopGroupConfiguration);
    }

    private ClientKey getClientKey(AnnotationMetadata metadata) {
        HttpVersion httpVersion = metadata.enumValue(Client.class, "httpVersion", HttpVersion.class).orElse(null);
        String clientId = metadata.stringValue(Client.class).orElse(null);
        String path = metadata.stringValue(Client.class, "path").orElse(null);
        List filterAnnotation = metadata.getAnnotationNamesByStereotype(FilterMatcher.class);
        Class configurationClass = metadata.classValue(Client.class, "configuration").orElse(null);
        AnnotationValue jacksonFeaturesAnn = metadata.findAnnotation(io.micronaut.jackson.annotation.JacksonFeatures.class).orElse(null);
        return new ClientKey(httpVersion, clientId, filterAnnotation, path, configurationClass, (AnnotationValue<io.micronaut.jackson.annotation.JacksonFeatures>)jacksonFeaturesAnn);
    }

    private static MediaTypeCodec createNewJsonCodec(BeanContext beanContext, JacksonFeatures jacksonFeatures) {
        ObjectMapper objectMapper = new ObjectMapperFactory().objectMapper(null, null);
        jacksonFeatures.getDeserializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        jacksonFeatures.getSerializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        return new JsonMediaTypeCodec(objectMapper, (ApplicationConfiguration)beanContext.getBean(ApplicationConfiguration.class), (CodecConfiguration)beanContext.findBean(CodecConfiguration.class, Qualifiers.byName((String)"json")).orElse(null));
    }

    @Internal
    private static final class ClientKey {
        final HttpVersion httpVersion;
        final String clientId;
        final List<String> filterAnnotations;
        final String path;
        final Class<?> configurationClass;
        final AnnotationValue<io.micronaut.jackson.annotation.JacksonFeatures> jacksonFeaturesAnn;

        ClientKey(HttpVersion httpVersion, String clientId, List<String> filterAnnotations, String path, Class<?> configurationClass, AnnotationValue<io.micronaut.jackson.annotation.JacksonFeatures> jacksonFeaturesAnn) {
            this.httpVersion = httpVersion;
            this.clientId = clientId;
            this.filterAnnotations = filterAnnotations;
            this.path = path;
            this.configurationClass = configurationClass;
            this.jacksonFeaturesAnn = jacksonFeaturesAnn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientKey clientKey = (ClientKey)o;
            return this.httpVersion == clientKey.httpVersion && Objects.equals(this.clientId, clientKey.clientId) && Objects.equals(this.filterAnnotations, clientKey.filterAnnotations) && Objects.equals(this.path, clientKey.path) && Objects.equals(this.configurationClass, clientKey.configurationClass) && Objects.equals(this.jacksonFeaturesAnn, clientKey.jacksonFeaturesAnn);
        }

        public int hashCode() {
            return Objects.hash(this.httpVersion, this.clientId, this.filterAnnotations, this.path, this.configurationClass, this.jacksonFeaturesAnn);
        }
    }
}

