/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpClientFactory;
import io.micronaut.http.client.ProxyHttpClient;
import io.micronaut.http.client.ProxyHttpClientFactory;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.StreamingHttpClientFactory;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.client.sse.SseClientFactory;
import io.micronaut.websocket.WebSocketClient;
import io.micronaut.websocket.WebSocketClientFactory;
import java.net.URL;

@Internal
public class NettyHttpClientFactory
implements HttpClientFactory,
SseClientFactory,
ProxyHttpClientFactory,
StreamingHttpClientFactory,
WebSocketClientFactory {
    @NonNull
    public HttpClient createClient(URL url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public HttpClient createClient(URL url, HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @NonNull
    public ProxyHttpClient createProxyClient(URL url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public ProxyHttpClient createProxyClient(URL url, HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @NonNull
    public SseClient createSseClient(URL url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public SseClient createSseClient(URL url, HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @NonNull
    public StreamingHttpClient createStreamingClient(URL url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public StreamingHttpClient createStreamingClient(URL url, HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @NonNull
    public WebSocketClient createWebSocketClient(URL url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public WebSocketClient createWebSocketClient(URL url, HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    private DefaultHttpClient createNettyClient(URL url) {
        return new DefaultHttpClient(url);
    }

    private DefaultHttpClient createNettyClient(URL url, HttpClientConfiguration configuration) {
        return new DefaultHttpClient(url, configuration);
    }
}

