/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.ProxyHttpClient;
import io.micronaut.http.client.ProxyRequestOptions;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.exceptions.ContentLengthExceededException;
import io.micronaut.http.client.exceptions.HttpClientErrorDecoder;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.exceptions.NoHostException;
import io.micronaut.http.client.exceptions.ReadTimeoutException;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.client.filter.DefaultHttpClientFilterResolver;
import io.micronaut.http.client.filters.ClientServerContextFilter;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.client.multipart.MultipartDataFactory;
import io.micronaut.http.client.netty.ConnectTTLHandler;
import io.micronaut.http.client.netty.ForwardingSubscriber;
import io.micronaut.http.client.netty.FullNettyClientHttpResponse;
import io.micronaut.http.client.netty.IdleTimeoutHandler;
import io.micronaut.http.client.netty.IdlingConnectionHandler;
import io.micronaut.http.client.netty.MicronautFlux;
import io.micronaut.http.client.netty.NettyClientHttpRequest;
import io.micronaut.http.client.netty.NettyFuturePublisher;
import io.micronaut.http.client.netty.NettyPromiseSubscriber;
import io.micronaut.http.client.netty.NettyStreamedHttpResponse;
import io.micronaut.http.client.netty.SimpleChannelInboundHandlerInstrumented;
import io.micronaut.http.client.netty.ssl.NettyClientSslBuilder;
import io.micronaut.http.client.netty.websocket.NettyWebSocketClientHandler;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.http.multipart.MultipartException;
import io.micronaut.http.netty.AbstractNettyHttpRequest;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.channel.NettyThreadFactory;
import io.micronaut.http.netty.stream.DefaultHttp2Content;
import io.micronaut.http.netty.stream.DefaultStreamedHttpResponse;
import io.micronaut.http.netty.stream.Http2Content;
import io.micronaut.http.netty.stream.HttpStreamsClientHandler;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.netty.stream.StreamingInboundHttp2ToHttpAdapter;
import io.micronaut.http.sse.Event;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.jackson.databind.JacksonDatabindMapper;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.json.codec.JsonStreamMediaTypeCodec;
import io.micronaut.json.codec.MapperMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.scheduling.instrument.Instrumentation;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import io.micronaut.websocket.WebSocketClient;
import io.micronaut.websocket.annotation.ClientWebSocket;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Internal
public class DefaultHttpClient
implements WebSocketClient,
HttpClient,
StreamingHttpClient,
SseClient,
ProxyHttpClient,
Closeable,
AutoCloseable {
    private static final Logger DEFAULT_LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final AttributeKey<Http2Stream> STREAM_KEY = AttributeKey.valueOf((String)"micronaut.http2.stream");
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final HttpHeaders REDIRECT_HEADER_BLOCKLIST = new DefaultHttpHeaders();
    protected final Bootstrap bootstrap;
    protected EventLoopGroup group;
    protected MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected ByteBufferFactory<ByteBufAllocator, ByteBuf> byteBufferFactory = new NettyByteBufferFactory();
    private final List<HttpFilterResolver.FilterEntry<HttpClientFilter>> clientFilterEntries;
    private final HttpVersion httpVersion;
    private final Scheduler scheduler;
    private final LoadBalancer loadBalancer;
    private final HttpClientConfiguration configuration;
    private final String contextPath;
    private final SslContext sslContext;
    private final ThreadFactory threadFactory;
    private final boolean shutdownGroup;
    private final Charset defaultCharset;
    private final ChannelPoolMap<RequestKey, ChannelPool> poolMap;
    private final Logger log;
    @Nullable
    private final Long readTimeoutMillis;
    @Nullable
    private final Long connectionTimeAliveMillis;
    private final HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver;
    private final WebSocketBeanRegistry webSocketRegistry;
    private final RequestBinderRegistry requestBinderRegistry;
    private final Collection<ChannelPipelineListener> pipelineListeners;
    private final List<InvocationInstrumenterFactory> invocationInstrumenterFactories;

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @Nullable ThreadFactory threadFactory, NettyClientSslBuilder nettyClientSslBuilder, MediaTypeCodecRegistry codecRegistry, @Nullable AnnotationMetadataResolver annotationMetadataResolver, List<InvocationInstrumenterFactory> invocationInstrumenterFactories, HttpClientFilter ... filters) {
        this(loadBalancer, configuration.getHttpVersion(), configuration, contextPath, (HttpClientFilterResolver<ClientFilterResolutionContext>)new DefaultHttpClientFilterResolver(annotationMetadataResolver, Arrays.asList(filters)), null, threadFactory, nettyClientSslBuilder, codecRegistry, WebSocketBeanRegistry.EMPTY, (RequestBinderRegistry)new DefaultRequestBinderRegistry(ConversionService.SHARED, new RequestArgumentBinder[0]), null, NioSocketChannel::new, Collections.emptySet(), invocationInstrumenterFactories);
    }

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, @Nullable HttpVersion httpVersion, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @NonNull HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver, List<HttpFilterResolver.FilterEntry<HttpClientFilter>> clientFilterEntries, @Nullable ThreadFactory threadFactory, @NonNull NettyClientSslBuilder nettyClientSslBuilder, @NonNull MediaTypeCodecRegistry codecRegistry, @NonNull WebSocketBeanRegistry webSocketBeanRegistry, @NonNull RequestBinderRegistry requestBinderRegistry, @Nullable EventLoopGroup eventLoopGroup, @NonNull ChannelFactory socketChannelFactory, Collection<ChannelPipelineListener> pipelineListeners, List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        int maxConnections;
        ArgumentUtils.requireNonNull((String)"nettyClientSslBuilder", (Object)((Object)nettyClientSslBuilder));
        ArgumentUtils.requireNonNull((String)"codecRegistry", (Object)codecRegistry);
        ArgumentUtils.requireNonNull((String)"webSocketBeanRegistry", (Object)webSocketBeanRegistry);
        ArgumentUtils.requireNonNull((String)"requestBinderRegistry", (Object)requestBinderRegistry);
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        ArgumentUtils.requireNonNull((String)"filterResolver", filterResolver);
        ArgumentUtils.requireNonNull((String)"socketChannelFactory", (Object)socketChannelFactory);
        this.loadBalancer = loadBalancer;
        this.httpVersion = httpVersion != null ? httpVersion : configuration.getHttpVersion();
        this.defaultCharset = configuration.getDefaultCharset();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            if (contextPath.charAt(0) != '/') {
                contextPath = '/' + contextPath;
            }
            this.contextPath = contextPath;
        } else {
            this.contextPath = null;
        }
        this.bootstrap = new Bootstrap();
        this.configuration = configuration;
        this.sslContext = nettyClientSslBuilder.build(configuration.getSslConfiguration(), this.httpVersion).orElse(null);
        if (eventLoopGroup != null) {
            this.group = eventLoopGroup;
            this.shutdownGroup = false;
        } else {
            this.group = this.createEventLoopGroup(configuration, threadFactory);
            this.shutdownGroup = true;
        }
        this.scheduler = Schedulers.fromExecutorService((ExecutorService)this.group);
        this.threadFactory = threadFactory;
        ((Bootstrap)((Bootstrap)this.bootstrap.group(this.group)).channelFactory(socketChannelFactory)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Optional readTimeout = configuration.getReadTimeout();
        this.readTimeoutMillis = readTimeout.map(duration -> !duration.isNegative() ? Long.valueOf(duration.toMillis()) : null).orElse(null);
        Optional connectTtl = configuration.getConnectTtl();
        this.connectionTimeAliveMillis = connectTtl.map(duration -> !duration.isNegative() ? Long.valueOf(duration.toMillis()) : null).orElse(null);
        this.invocationInstrumenterFactories = invocationInstrumenterFactories == null ? Collections.emptyList() : invocationInstrumenterFactories;
        final HttpClientConfiguration.ConnectionPoolConfiguration connectionPoolConfiguration = configuration.getConnectionPoolConfiguration();
        this.poolMap = connectionPoolConfiguration.isEnabled() || this.httpVersion == HttpVersion.HTTP_2_0 ? ((maxConnections = connectionPoolConfiguration.getMaxConnections()) > -1 ? new AbstractChannelPoolMap<RequestKey, ChannelPool>(){

            protected ChannelPool newPool(RequestKey key) {
                Bootstrap newBootstrap = DefaultHttpClient.this.bootstrap.clone(DefaultHttpClient.this.group);
                DefaultHttpClient.this.initBootstrapForProxy(newBootstrap, key.isSecure(), key.getHost(), key.getPort());
                newBootstrap.remoteAddress((SocketAddress)key.getRemoteAddress());
                AbstractChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.newPoolHandler(key);
                long acquireTimeoutMillis = connectionPoolConfiguration.getAcquireTimeout().map(Duration::toMillis).orElse(-1L);
                return new FixedChannelPool(newBootstrap, (ChannelPoolHandler)channelPoolHandler, ChannelHealthChecker.ACTIVE, (FixedChannelPool.AcquireTimeoutAction)(acquireTimeoutMillis > -1L ? FixedChannelPool.AcquireTimeoutAction.FAIL : null), acquireTimeoutMillis, maxConnections, connectionPoolConfiguration.getMaxPendingAcquires());
            }
        } : new AbstractChannelPoolMap<RequestKey, ChannelPool>(){

            protected ChannelPool newPool(RequestKey key) {
                Bootstrap newBootstrap = DefaultHttpClient.this.bootstrap.clone(DefaultHttpClient.this.group);
                DefaultHttpClient.this.initBootstrapForProxy(newBootstrap, key.isSecure(), key.getHost(), key.getPort());
                newBootstrap.remoteAddress((SocketAddress)key.getRemoteAddress());
                AbstractChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.newPoolHandler(key);
                return new SimpleChannelPool(newBootstrap, (ChannelPoolHandler)channelPoolHandler);
            }
        }) : null;
        Optional connectTimeout = configuration.getConnectTimeout();
        connectTimeout.ifPresent(duration -> this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)duration.toMillis())));
        for (Map.Entry entry : configuration.getChannelOptions().entrySet()) {
            Object v = entry.getValue();
            if (v == null) continue;
            String channelOption = (String)entry.getKey();
            this.bootstrap.option(ChannelOption.valueOf((String)channelOption), v);
        }
        this.mediaTypeCodecRegistry = codecRegistry;
        this.log = configuration.getLoggerName().map(LoggerFactory::getLogger).orElse(DEFAULT_LOG);
        this.filterResolver = filterResolver;
        this.clientFilterEntries = clientFilterEntries != null ? clientFilterEntries : filterResolver.resolveFilterEntries((AnnotationMetadataProvider)new ClientFilterResolutionContext(null, AnnotationMetadata.EMPTY_METADATA));
        this.webSocketRegistry = webSocketBeanRegistry != null ? webSocketBeanRegistry : WebSocketBeanRegistry.EMPTY;
        this.requestBinderRegistry = requestBinderRegistry;
        this.pipelineListeners = pipelineListeners;
    }

    public DefaultHttpClient(@Nullable URI uri) {
        this(uri, (HttpClientConfiguration)new DefaultHttpClientConfiguration());
    }

    public DefaultHttpClient() {
        this(null, (HttpClientConfiguration)new DefaultHttpClientConfiguration(), Collections.emptyList());
    }

    public DefaultHttpClient(@Nullable URI uri, @NonNull HttpClientConfiguration configuration) {
        this(uri == null ? null : LoadBalancer.fixed((URI)uri), configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, Collections.emptyList(), new HttpClientFilter[0]);
    }

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, HttpClientConfiguration configuration, List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        this(loadBalancer, configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, invocationInstrumenterFactories, new HttpClientFilter[0]);
    }

    public HttpClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public Logger getLog() {
        return this.log;
    }

    public HttpClient start() {
        if (!this.isRunning()) {
            this.group = this.createEventLoopGroup(this.configuration, this.threadFactory);
        }
        return this;
    }

    public boolean isRunning() {
        return !this.group.isShutdown();
    }

    public HttpClient stop() {
        if (this.isRunning()) {
            if (this.poolMap instanceof Iterable) {
                Iterable i = (Iterable)this.poolMap;
                for (Map.Entry entry : i) {
                    ChannelPool cp = (ChannelPool)entry.getValue();
                    try {
                        if (cp instanceof SimpleChannelPool) {
                            this.addInstrumentedListener(((SimpleChannelPool)cp).closeAsync(), future -> {
                                Throwable cause;
                                if (!future.isSuccess() && (cause = future.cause()) != null) {
                                    this.log.error("Error shutting down HTTP client connection pool: " + cause.getMessage(), cause);
                                }
                            });
                            continue;
                        }
                        cp.close();
                    }
                    catch (Exception cause) {
                        this.log.error("Error shutting down HTTP client connection pool: " + cause.getMessage(), (Throwable)cause);
                    }
                }
            }
            if (this.shutdownGroup) {
                Duration shutdownTimeout = this.configuration.getShutdownTimeout().orElse(Duration.ofMillis(100L));
                Duration shutdownQuietPeriod = this.configuration.getShutdownQuietPeriod().orElse(Duration.ofMillis(1L));
                Future future2 = this.group.shutdownGracefully(shutdownQuietPeriod.toMillis(), shutdownTimeout.toMillis(), TimeUnit.MILLISECONDS);
                this.addInstrumentedListener(future2, f -> {
                    if (!f.isSuccess() && this.log.isErrorEnabled()) {
                        Throwable cause = f.cause();
                        this.log.error("Error shutting down HTTP client: " + cause.getMessage(), cause);
                    }
                });
                try {
                    future2.await(shutdownTimeout.toMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public MediaTypeCodecRegistry getMediaTypeCodecRegistry() {
        return this.mediaTypeCodecRegistry;
    }

    public void setMediaTypeCodecRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        if (mediaTypeCodecRegistry != null) {
            this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        }
    }

    public BlockingHttpClient toBlocking() {
        return new BlockingHttpClient(){

            public void close() {
                DefaultHttpClient.this.close();
            }

            public <I, O, E> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
                Flux publisher = Flux.from(DefaultHttpClient.this.exchange(request, bodyType, errorType));
                return (HttpResponse)publisher.doOnNext(res -> {
                    Optional byteBuf = res.getBody(ByteBuf.class);
                    byteBuf.ifPresent(bb -> {
                        if (bb.refCnt() > 0) {
                            ReferenceCountUtil.safeRelease((Object)bb);
                        }
                    });
                    if (res instanceof FullNettyClientHttpResponse) {
                        ((FullNettyClientHttpResponse)res).onComplete();
                    }
                }).blockFirst();
            }
        };
    }

    public <I> Publisher<Event<ByteBuffer<?>>> eventStream(@NonNull HttpRequest<I> request) {
        return this.eventStreamOrError(request, null);
    }

    private <I> Publisher<Event<ByteBuffer<?>>> eventStreamOrError(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        if (request instanceof MutableHttpRequest) {
            ((MutableHttpRequest)request).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM_TYPE});
        }
        return Flux.create(emitter -> this.dataStream(request, errorType).subscribe(new Subscriber<ByteBuffer<?>>((FluxSink)emitter){
            private Subscription dataSubscription;
            private CurrentEvent currentEvent;
            final /* synthetic */ FluxSink val$emitter;
            {
                this.val$emitter = fluxSink;
            }

            public void onSubscribe(Subscription s) {
                this.dataSubscription = s;
                Disposable cancellable = () -> this.dataSubscription.cancel();
                this.val$emitter.onCancel(cancellable);
                if (!this.val$emitter.isCancelled() && this.val$emitter.requestedFromDownstream() > 0L) {
                    this.dataSubscription.request(1L);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ByteBuffer<?> buffer) {
                try {
                    int len = buffer.readableBytes();
                    if (len == 0) {
                        try {
                            Event event = Event.of((Object)DefaultHttpClient.this.byteBufferFactory.wrap(this.currentEvent.data)).name(this.currentEvent.name).retry(this.currentEvent.retry).id(this.currentEvent.id);
                            this.val$emitter.next((Object)event);
                        }
                        finally {
                            this.currentEvent = null;
                        }
                    } else {
                        int colonIndex;
                        if (this.currentEvent == null) {
                            this.currentEvent = new CurrentEvent();
                        }
                        if ((colonIndex = buffer.indexOf((byte)58)) > 0) {
                            String type = buffer.slice(0, colonIndex).toString(StandardCharsets.UTF_8).trim();
                            int fromIndex = colonIndex + 1;
                            if (buffer.getByte(fromIndex) == 32) {
                                ++fromIndex;
                            }
                            if (fromIndex < len) {
                                int toIndex = len - fromIndex;
                                switch (type) {
                                    case "data": {
                                        ByteBuffer content = buffer.slice(fromIndex, toIndex);
                                        byte[] d = this.currentEvent.data;
                                        if (d == null) {
                                            this.currentEvent.data = content.toByteArray();
                                            break;
                                        }
                                        this.currentEvent.data = ArrayUtils.concat((byte[])d, (byte[])content.toByteArray());
                                        break;
                                    }
                                    case "id": {
                                        ByteBuffer id = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.id = id.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "event": {
                                        ByteBuffer event = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.name = event.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "retry": {
                                        ByteBuffer retry = buffer.slice(fromIndex, toIndex);
                                        String text = retry.toString(StandardCharsets.UTF_8);
                                        if (StringUtils.isEmpty((CharSequence)text)) break;
                                        Long millis = Long.valueOf(text);
                                        this.currentEvent.retry = Duration.ofMillis(millis);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (this.val$emitter.requestedFromDownstream() > 0L && !this.val$emitter.isCancelled()) {
                        this.dataSubscription.request(1L);
                    }
                }
                catch (Throwable e) {
                    this.onError(e);
                }
                finally {
                    if (buffer instanceof ReferenceCounted) {
                        ((ReferenceCounted)buffer).release();
                    }
                }
            }

            public void onError(Throwable t) {
                this.dataSubscription.cancel();
                if (t instanceof HttpClientException) {
                    this.val$emitter.error(t);
                } else {
                    this.val$emitter.error((Throwable)new HttpClientException("Error consuming Server Sent Events: " + t.getMessage(), t));
                }
            }

            public void onComplete() {
                this.val$emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public <I, B> Publisher<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType) {
        return this.eventStream(request, eventType, DEFAULT_ERROR_TYPE);
    }

    public <I, B> Publisher<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType, @NonNull Argument<?> errorType) {
        return Flux.from(this.eventStreamOrError(request, errorType)).map(byteBufferEvent -> {
            ByteBuffer data = (ByteBuffer)byteBufferEvent.getData();
            Optional registeredCodec = this.mediaTypeCodecRegistry != null ? this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE) : Optional.empty();
            if (registeredCodec.isPresent()) {
                Object decoded = ((MediaTypeCodec)registeredCodec.get()).decode(eventType, data);
                return Event.of((Event)byteBufferEvent, (Object)decoded);
            }
            throw new CodecException("JSON codec not present");
        });
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request) {
        return this.dataStream(request, DEFAULT_ERROR_TYPE);
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return new MicronautFlux<ByteBuffer>(Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> this.dataStreamImpl(request, errorType, (HttpRequest<Object>)parentRequest, (URI)requestURI))).doAfterNext(buffer -> {
            ByteBuf byteBuf;
            Object o = buffer.asNativeBuffer();
            if (o instanceof ByteBuf && (byteBuf = (ByteBuf)o).refCnt() > 0) {
                ReferenceCountUtil.safeRelease((Object)byteBuf);
            }
        });
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request) {
        return this.exchangeStream(request, DEFAULT_ERROR_TYPE);
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return new MicronautFlux<HttpResponse>(Flux.from(this.resolveRequestURI(request)).flatMap(uri -> this.exchangeStreamImpl((HttpRequest<Object>)parentRequest, request, errorType, (URI)uri))).doAfterNext(byteBufferHttpResponse -> {
            ByteBuffer buffer = (ByteBuffer)byteBufferHttpResponse.body();
            if (buffer instanceof ReferenceCounted) {
                ((ReferenceCounted)buffer).release();
            }
        });
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type) {
        return this.jsonStream(request, type, DEFAULT_ERROR_TYPE);
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type, @NonNull Argument<?> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> this.jsonStreamImpl((HttpRequest<?>)parentRequest, request, type, errorType, (URI)requestURI));
    }

    public <I> Publisher<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> request) {
        return this.jsonStream(request, Map.class);
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Class<O> type) {
        return this.jsonStream(request, Argument.of(type));
    }

    public <I, O, E> Publisher<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        Publisher<URI> uriPublisher = this.resolveRequestURI(request);
        return Flux.from(uriPublisher).switchMap(uri -> this.exchangeImpl((URI)uri, (HttpRequest<?>)parentRequest, request, bodyType, errorType));
    }

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, MutableHttpRequest<?> request) {
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flux.from(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, request, clientEndpointType, null));
    }

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, Map<String, Object> parameters) {
        WebSocketBean webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        String uri = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class).orElse("/ws");
        uri = UriTemplate.of((String)uri).expand(parameters);
        MutableHttpRequest request = HttpRequest.GET((String)uri);
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flux.from(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, (MutableHttpRequest<?>)request, clientEndpointType, (WebSocketBean)webSocketBean));
    }

    @Override
    public void close() {
        this.stop();
    }

    private <T> Flux<T> connectWebSocket(final URI uri, MutableHttpRequest<?> request, Class<T> clientEndpointType, WebSocketBean<T> webSocketBean) {
        Bootstrap bootstrap = this.bootstrap.clone();
        if (webSocketBean == null) {
            webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        }
        WebSocketBean finalWebSocketBean = webSocketBean;
        return Flux.create(emitter -> {
            RequestKey requestKey;
            SslContext sslContext = this.buildSslContext(uri);
            WebSocketVersion protocolVersion = finalWebSocketBean.getBeanDefinition().enumValue(ClientWebSocket.class, "version", WebSocketVersion.class).orElse(WebSocketVersion.V13);
            int maxFramePayloadLength = finalWebSocketBean.messageMethod().map(m -> m.intValue(OnMessage.class, "maxPayloadLength").orElse(65536)).orElse(65536);
            String subprotocol = finalWebSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class, "subprotocol").orElse("");
            try {
                requestKey = new RequestKey(uri);
            }
            catch (HttpClientException e) {
                emitter.error((Throwable)e);
                return;
            }
            bootstrap.remoteAddress(requestKey.getHost(), requestKey.getPort());
            this.initBootstrapForProxy(bootstrap, sslContext != null, requestKey.getHost(), requestKey.getPort());
            bootstrap.handler((ChannelHandler)new HttpClientInitializer(sslContext, requestKey.getHost(), requestKey.getPort(), false, false, false, null, (MutableHttpRequest)request, subprotocol, finalWebSocketBean, protocolVersion, maxFramePayloadLength, (FluxSink)emitter){
                final /* synthetic */ MutableHttpRequest val$request;
                final /* synthetic */ String val$subprotocol;
                final /* synthetic */ WebSocketBean val$finalWebSocketBean;
                final /* synthetic */ WebSocketVersion val$protocolVersion;
                final /* synthetic */ int val$maxFramePayloadLength;
                final /* synthetic */ FluxSink val$emitter;
                {
                    this.val$request = mutableHttpRequest;
                    this.val$subprotocol = string;
                    this.val$finalWebSocketBean = webSocketBean;
                    this.val$protocolVersion = webSocketVersion;
                    this.val$maxFramePayloadLength = n;
                    this.val$emitter = fluxSink;
                    super(sslContext, host, port, stream, proxy, acceptsEvents, contextConsumer);
                }

                @Override
                protected void addFinalHandler(ChannelPipeline pipeline) {
                    Duration duration;
                    Optional readIdleTime;
                    pipeline.remove("http-decoder");
                    ReadTimeoutHandler readTimeoutHandler = (ReadTimeoutHandler)pipeline.get(ReadTimeoutHandler.class);
                    if (readTimeoutHandler != null) {
                        pipeline.remove((ChannelHandler)readTimeoutHandler);
                    }
                    if ((readIdleTime = DefaultHttpClient.this.configuration.getReadIdleTimeout()).isPresent() && !(duration = (Duration)readIdleTime.get()).isNegative()) {
                        pipeline.addLast("idle-state", (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
                    }
                    try {
                        String scheme = this.sslContext == null ? "ws" : "wss";
                        URI webSocketURL = UriBuilder.of((URI)uri).scheme(scheme).host(this.host).port(this.port).build();
                        MutableHttpHeaders headers = this.val$request.getHeaders();
                        EmptyHttpHeaders customHeaders = EmptyHttpHeaders.INSTANCE;
                        if (headers instanceof NettyHttpHeaders) {
                            customHeaders = ((NettyHttpHeaders)headers).getNettyHeaders();
                        }
                        if (StringUtils.isNotEmpty((CharSequence)this.val$subprotocol)) {
                            customHeaders.add("Sec-WebSocket-Protocol", (Object)this.val$subprotocol);
                        }
                        NettyWebSocketClientHandler webSocketHandler = new NettyWebSocketClientHandler(this.val$request, this.val$finalWebSocketBean, WebSocketClientHandshakerFactory.newHandshaker((URI)webSocketURL, (WebSocketVersion)this.val$protocolVersion, (String)this.val$subprotocol, (boolean)true, (HttpHeaders)customHeaders, (int)this.val$maxFramePayloadLength), DefaultHttpClient.this.requestBinderRegistry, DefaultHttpClient.this.mediaTypeCodecRegistry, this.val$emitter);
                        pipeline.addLast(new ChannelHandler[]{WebSocketClientCompressionHandler.INSTANCE});
                        pipeline.addLast("micronaut-websocket-client", webSocketHandler);
                    }
                    catch (Throwable e) {
                        this.val$emitter.error((Throwable)new WebSocketSessionException("Error opening WebSocket client session: " + e.getMessage(), e));
                    }
                }
            });
            this.addInstrumentedListener((Future)bootstrap.connect(), (GenericFutureListener)future -> {
                if (!future.isSuccess()) {
                    emitter.error(future.cause());
                }
            });
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.ERROR);
    }

    private <I> Flux<HttpResponse<ByteBuffer<?>>> exchangeStreamImpl(HttpRequest<Object> parentRequest, HttpRequest<I> request, Argument<?> errorType, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        return streamResponsePublisher.switchMap(response -> {
            StreamedHttpResponse streamedHttpResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
            Flux httpContentReactiveSequence = Flux.from((Publisher)streamedHttpResponse);
            return httpContentReactiveSequence.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(message -> {
                ByteBuf byteBuf = message.content();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{byteBuf.readableBytes(), request.getMethodName(), request.getUri()});
                    this.traceBody("Response", byteBuf);
                }
                ByteBuffer byteBuffer = this.byteBufferFactory.wrap((Object)byteBuf);
                NettyStreamedHttpResponse<ByteBuffer> thisResponse = new NettyStreamedHttpResponse<ByteBuffer>(streamedHttpResponse, response.status());
                thisResponse.setBody(byteBuffer);
                return new HttpResponseWrapper(thisResponse);
            });
        }).doOnTerminate(() -> {
            Channel c;
            Object o = request.getAttribute(NettyClientHttpRequest.CHANNEL).orElse(null);
            if (o instanceof Channel && (c = (Channel)o).isOpen()) {
                c.close();
            }
        });
    }

    private <I, O> Flux<O> jsonStreamImpl(HttpRequest<?> parentRequest, HttpRequest<I> request, Argument<O> type, Argument<?> errorType, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        return streamResponsePublisher.switchMap(response -> {
            if (!(response instanceof NettyStreamedHttpResponse)) {
                throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
            }
            MapperMediaTypeCodec mediaTypeCodec = (MapperMediaTypeCodec)this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE).orElseThrow(() -> new IllegalStateException("No JSON codec found"));
            StreamedHttpResponse streamResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
            Flux httpContentReactiveSequence = Flux.from((Publisher)streamResponse);
            boolean isJsonStream = response.getContentType().map(mediaType -> mediaType.equals((Object)MediaType.APPLICATION_JSON_STREAM_TYPE)).orElse(false);
            boolean streamArray = !Iterable.class.isAssignableFrom(type.getType()) && !isJsonStream;
            Processor jsonProcessor = mediaTypeCodec.getJsonMapper().createReactiveParser(p -> httpContentReactiveSequence.map(content -> {
                ByteBuf chunk = content.content();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{chunk.readableBytes(), request.getMethodName(), request.getUri()});
                    this.traceBody("Chunk", chunk);
                }
                try {
                    byte[] byArray = ByteBufUtil.getBytes((ByteBuf)chunk);
                    return byArray;
                }
                finally {
                    chunk.release();
                }
            }).subscribe((Subscriber)p), streamArray);
            return Flux.from((Publisher)jsonProcessor).map(jsonNode -> mediaTypeCodec.decode(type, jsonNode));
        }).doOnTerminate(() -> {
            Channel c;
            Object o = request.getAttribute(NettyClientHttpRequest.CHANNEL).orElse(null);
            if (o instanceof Channel && (c = (Channel)o).isOpen()) {
                c.close();
            }
        });
    }

    private <I> Flux<ByteBuffer<?>> dataStreamImpl(HttpRequest<I> request, Argument<?> errorType, HttpRequest<Object> parentRequest, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        Function<HttpContent, ByteBuffer> contentMapper = message -> {
            ByteBuf byteBuf = message.content();
            return this.byteBufferFactory.wrap((Object)byteBuf);
        };
        return streamResponsePublisher.switchMap(response -> {
            if (!(response instanceof NettyStreamedHttpResponse)) {
                throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
            }
            NettyStreamedHttpResponse nettyStreamedHttpResponse = (NettyStreamedHttpResponse)response;
            Flux httpContentReactiveSequence = Flux.from((Publisher)nettyStreamedHttpResponse.getNettyResponse());
            return httpContentReactiveSequence.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(contentMapper);
        }).doOnTerminate(() -> {
            Channel c;
            Object o = request.getAttribute(NettyClientHttpRequest.CHANNEL).orElse(null);
            if (o instanceof Channel && (c = (Channel)o).isOpen()) {
                c.close();
            }
        });
    }

    private <I> Publisher<MutableHttpResponse<Object>> buildStreamExchange(@Nullable HttpRequest<?> parentRequest, @NonNull HttpRequest<I> request, @NonNull URI requestURI, @Nullable Argument<?> errorType) {
        AtomicReference requestWrapper = new AtomicReference(request);
        Flux streamResponsePublisher = this.connectAndStream(parentRequest, request, requestURI, this.buildSslContext(requestURI), requestWrapper, false, true);
        streamResponsePublisher = this.readBodyOnError(errorType, streamResponsePublisher);
        streamResponsePublisher = Flux.from(this.applyFilterToResponsePublisher(parentRequest, request, requestURI, requestWrapper, (Publisher)streamResponsePublisher));
        return streamResponsePublisher.subscribeOn(this.scheduler);
    }

    public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> request) {
        return this.proxy(request, ProxyRequestOptions.getDefault());
    }

    public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> request, @NonNull ProxyRequestOptions options) {
        Objects.requireNonNull(options, "options");
        return Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> {
            MutableHttpRequest httpRequest;
            MutableHttpRequest mutableHttpRequest = httpRequest = request instanceof MutableHttpRequest ? (MutableHttpRequest)request : request.mutate();
            if (!options.isRetainHostHeader()) {
                httpRequest.headers(headers -> headers.remove((CharSequence)HttpHeaderNames.HOST));
            }
            AtomicReference<MutableHttpRequest> requestWrapper = new AtomicReference<MutableHttpRequest>(httpRequest);
            Flux proxyResponsePublisher = this.connectAndStream(request, (HttpRequest)request, (URI)requestURI, this.buildSslContext((URI)requestURI), (AtomicReference<HttpRequest<?>>)requestWrapper, true, false);
            proxyResponsePublisher = Flux.from(this.applyFilterToResponsePublisher(request, (HttpRequest)((HttpRequest)requestWrapper.get()), (URI)requestURI, (AtomicReference<HttpRequest<?>>)requestWrapper, (Publisher)proxyResponsePublisher));
            return proxyResponsePublisher;
        });
    }

    private <I> Flux<MutableHttpResponse<Object>> connectAndStream(HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI, SslContext sslContext, AtomicReference<HttpRequest<?>> requestWrapper, boolean isProxy, boolean failOnError) {
        return Flux.create(emitter -> {
            ChannelFuture channelFuture;
            try {
                if (this.httpVersion == HttpVersion.HTTP_2_0) {
                    channelFuture = this.doConnect(request, requestURI, sslContext, true, isProxy, (ChannelHandlerContext channelHandlerContext) -> {
                        try {
                            Channel channel = channelHandlerContext.channel();
                            request.setAttribute(NettyClientHttpRequest.CHANNEL, (Object)channel);
                            this.streamRequestThroughChannel(parentRequest, (HttpRequest)requestWrapper.get(), channel, failOnError).subscribe(new ForwardingSubscriber(emitter));
                        }
                        catch (Exception e) {
                            emitter.error((Throwable)e);
                        }
                    });
                } else {
                    channelFuture = this.doConnect(request, requestURI, sslContext, true, isProxy, null);
                    this.addInstrumentedListener((Future)channelFuture, (GenericFutureListener)((ChannelFutureListener)f -> {
                        if (f.isSuccess()) {
                            Channel channel = f.channel();
                            request.setAttribute(NettyClientHttpRequest.CHANNEL, (Object)channel);
                            this.streamRequestThroughChannel(parentRequest, (HttpRequest)requestWrapper.get(), channel, failOnError).subscribe(new ForwardingSubscriber(emitter));
                        } else {
                            Throwable cause = f.cause();
                            emitter.error((Throwable)new HttpClientException("Connect error:" + cause.getMessage(), cause));
                        }
                    }));
                }
            }
            catch (HttpClientException e) {
                emitter.error((Throwable)e);
                return;
            }
            Disposable disposable = this.buildDisposableChannel(channelFuture);
            emitter.onDispose(disposable);
            emitter.onCancel(disposable);
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    private <I, O, E> Publisher<? extends HttpResponse<O>> exchangeImpl(URI requestURI, HttpRequest<?> parentRequest, HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        Duration rt;
        AtomicReference requestWrapper = new AtomicReference(request);
        Flux responsePublisher = Flux.create(emitter -> {
            boolean multipart = MediaType.MULTIPART_FORM_DATA_TYPE.equals(request.getContentType().orElse(null));
            if (this.poolMap != null && !multipart) {
                try {
                    RequestKey requestKey = new RequestKey(requestURI);
                    ChannelPool channelPool = this.poolMap.get((Object)requestKey);
                    Future channelFuture = channelPool.acquire();
                    this.addInstrumentedListener(channelFuture, future -> {
                        if (future.isSuccess()) {
                            Channel channel = (Channel)future.get();
                            try {
                                this.sendRequestThroughChannel((HttpRequest)((HttpRequest)requestWrapper.get()), bodyType, errorType, (FluxSink)emitter, channel, requestKey.isSecure(), channelPool);
                            }
                            catch (Exception e) {
                                emitter.error((Throwable)e);
                            }
                        } else {
                            Throwable cause = future.cause();
                            emitter.error((Throwable)new HttpClientException("Connect Error: " + cause.getMessage(), cause));
                        }
                    });
                }
                catch (HttpClientException e) {
                    emitter.error((Throwable)e);
                }
            } else {
                SslContext sslContext = this.buildSslContext(requestURI);
                ChannelFuture connectionFuture = this.doConnect(request, requestURI, sslContext, false, null);
                this.addInstrumentedListener((Future)connectionFuture, (GenericFutureListener)future -> {
                    if (!future.isSuccess()) {
                        Throwable cause = future.cause();
                        if (emitter.isCancelled()) {
                            this.log.trace("Connection to {} failed, but emitter already cancelled.", (Object)requestURI, (Object)cause);
                        } else {
                            emitter.error((Throwable)new HttpClientException("Connect Error: " + cause.getMessage(), cause));
                        }
                    } else {
                        try {
                            this.sendRequestThroughChannel((HttpRequest)((HttpRequest)requestWrapper.get()), bodyType, errorType, (FluxSink)emitter, connectionFuture.channel(), sslContext != null, null);
                        }
                        catch (Exception e) {
                            emitter.error((Throwable)e);
                        }
                    }
                });
            }
        }, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.ERROR);
        Publisher finalPublisher = this.applyFilterToResponsePublisher(parentRequest, request, requestURI, requestWrapper, (Publisher)responsePublisher);
        Flux finalReactiveSequence = Flux.from(finalPublisher);
        Optional readTimeout = this.configuration.getReadTimeout();
        if (readTimeout.isPresent() && !(rt = (Duration)readTimeout.get()).isNegative()) {
            Duration duration = rt.plus(Duration.ofSeconds(1L));
            finalReactiveSequence = finalReactiveSequence.timeout(duration).onErrorResume(throwable -> {
                if (throwable instanceof TimeoutException) {
                    return Flux.error((Throwable)ReadTimeoutException.TIMEOUT_EXCEPTION);
                }
                return Flux.error((Throwable)throwable);
            });
        }
        return finalReactiveSequence;
    }

    protected void closeChannelAsync(Channel channel) {
        if (channel.isOpen()) {
            ChannelFuture closeFuture = channel.closeFuture();
            closeFuture.addListener(f2 -> {
                if (!f2.isSuccess() && this.log.isErrorEnabled()) {
                    Throwable cause = f2.cause();
                    this.log.error("Error closing request connection: " + cause.getMessage(), cause);
                }
            });
        }
    }

    protected <I> Publisher<URI> resolveRequestURI(HttpRequest<I> request) {
        return this.resolveRequestURI(request, true);
    }

    protected <I> Publisher<URI> resolveRequestURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Flux.just((Object)requestURI);
        }
        return this.resolveURI(request, includeContextPath);
    }

    protected <I> Publisher<URI> resolveRedirectURI(HttpRequest<?> parentRequest, HttpRequest<I> request) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Flux.just((Object)requestURI);
        }
        if (parentRequest == null || parentRequest.getUri().getHost() == null) {
            return this.resolveURI(request, false);
        }
        URI parentURI = parentRequest.getUri();
        UriBuilder uriBuilder = UriBuilder.of((URI)requestURI).scheme(parentURI.getScheme()).userInfo(parentURI.getUserInfo()).host(parentURI.getHost()).port(parentURI.getPort());
        return Flux.just((Object)uriBuilder.build());
    }

    protected URI prependContextPath(URI requestURI) {
        if (StringUtils.isNotEmpty((CharSequence)this.contextPath)) {
            try {
                return new URI(StringUtils.prependUri((String)this.contextPath, (String)requestURI.toString()));
            }
            catch (URISyntaxException e) {
                throw new HttpClientException("Failed to construct the request URI", (Throwable)e);
            }
        }
        return requestURI;
    }

    protected Object getLoadBalancerDiscriminator() {
        return null;
    }

    private void initBootstrapForProxy(Bootstrap bootstrap, boolean ssl, String host, int port) {
        Proxy proxy = this.configuration.resolveProxy(ssl, host, port);
        if (proxy.type() != Proxy.Type.DIRECT) {
            bootstrap.resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE);
        }
    }

    protected ChannelFuture doConnect(HttpRequest<?> request, URI uri, @Nullable SslContext sslCtx, boolean isStream, Consumer<ChannelHandlerContext> contextConsumer) throws HttpClientException {
        return this.doConnect(request, uri, sslCtx, isStream, false, contextConsumer);
    }

    protected ChannelFuture doConnect(HttpRequest<?> request, URI uri, @Nullable SslContext sslCtx, boolean isStream, boolean isProxy, Consumer<ChannelHandlerContext> contextConsumer) throws HttpClientException {
        RequestKey requestKey = new RequestKey(uri);
        return this.doConnect(request, requestKey.getHost(), requestKey.getPort(), sslCtx, isStream, isProxy, contextConsumer);
    }

    protected ChannelFuture doConnect(HttpRequest<?> request, String host, int port, @Nullable SslContext sslCtx, boolean isStream, Consumer<ChannelHandlerContext> contextConsumer) {
        return this.doConnect(request, host, port, sslCtx, isStream, false, contextConsumer);
    }

    protected ChannelFuture doConnect(HttpRequest<?> request, String host, int port, @Nullable SslContext sslCtx, boolean isStream, boolean isProxy, Consumer<ChannelHandlerContext> contextConsumer) {
        Bootstrap localBootstrap = this.bootstrap.clone();
        this.initBootstrapForProxy(localBootstrap, sslCtx != null, host, port);
        String acceptHeader = (String)request.getHeaders().get((CharSequence)"Accept");
        localBootstrap.handler((ChannelHandler)new HttpClientInitializer(sslCtx, host, port, isStream, isProxy, acceptHeader != null && acceptHeader.equalsIgnoreCase("text/event-stream"), contextConsumer));
        return this.doConnect(localBootstrap, host, port);
    }

    protected NioEventLoopGroup createEventLoopGroup(HttpClientConfiguration configuration, ThreadFactory threadFactory) {
        OptionalInt numOfThreads = configuration.getNumOfThreads();
        Optional threadFactoryType = configuration.getThreadFactory();
        boolean hasThreads = numOfThreads.isPresent();
        boolean hasFactory = threadFactoryType.isPresent();
        NioEventLoopGroup group = hasThreads && hasFactory ? new NioEventLoopGroup(numOfThreads.getAsInt(), (ThreadFactory)InstantiationUtils.instantiate((Class)((Class)threadFactoryType.get()))) : (hasThreads ? (threadFactory != null ? new NioEventLoopGroup(numOfThreads.getAsInt(), threadFactory) : new NioEventLoopGroup(numOfThreads.getAsInt())) : (threadFactory != null ? new NioEventLoopGroup(NettyThreadFactory.DEFAULT_EVENT_LOOP_THREADS, threadFactory) : new NioEventLoopGroup()));
        return group;
    }

    protected ChannelFuture doConnect(Bootstrap bootstrap, String host, int port) {
        return bootstrap.connect(host, port);
    }

    protected SslContext buildSslContext(URI uriObject) {
        SslContext sslCtx;
        if (DefaultHttpClient.isSecureScheme(uriObject.getScheme())) {
            sslCtx = this.sslContext;
            if (sslCtx == null && !this.configuration.getProxyAddress().isPresent()) {
                throw new HttpClientException("Cannot send HTTPS request. SSL is disabled");
            }
        } else {
            sslCtx = null;
        }
        return sslCtx;
    }

    protected void configureProxy(ChannelPipeline pipeline, Proxy proxy) {
        this.configureProxy(pipeline, proxy.type(), proxy.address());
    }

    protected void configureProxy(ChannelPipeline pipeline, Proxy.Type proxyType, SocketAddress proxyAddress) {
        InetSocketAddress isa;
        String username = this.configuration.getProxyUsername().orElse(null);
        String password = this.configuration.getProxyPassword().orElse(null);
        if (proxyAddress instanceof InetSocketAddress && (isa = (InetSocketAddress)proxyAddress).isUnresolved()) {
            proxyAddress = new InetSocketAddress(isa.getHostString(), isa.getPort());
        }
        if (StringUtils.isNotEmpty((CharSequence)username) && StringUtils.isNotEmpty((CharSequence)password)) {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress, username, password));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress, username, password));
                    break;
                }
            }
        } else {
            switch (proxyType) {
                case HTTP: {
                    pipeline.addLast("http-proxy", (ChannelHandler)new HttpProxyHandler(proxyAddress));
                    break;
                }
                case SOCKS: {
                    pipeline.addLast("socks5-proxy", (ChannelHandler)new Socks5ProxyHandler(proxyAddress));
                    break;
                }
            }
        }
    }

    private <I, O, R extends HttpResponse<O>> Publisher<R> applyFilterToResponsePublisher(HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI, AtomicReference<HttpRequest<?>> requestWrapper, Publisher<R> responsePublisher) {
        if (request instanceof MutableHttpRequest) {
            ((MutableHttpRequest)request).uri(requestURI);
            List filters = this.filterResolver.resolveFilters(request, this.clientFilterEntries);
            if (parentRequest != null) {
                filters.add(new ClientServerContextFilter(parentRequest));
            }
            OrderUtil.reverseSort((List)filters);
            Flux finalResponsePublisher = responsePublisher;
            filters.add((req, chain) -> finalResponsePublisher);
            ClientFilterChain filterChain = this.buildChain(requestWrapper, filters);
            if (parentRequest != null) {
                responsePublisher = (Publisher)ServerRequestContext.with(parentRequest, () -> {
                    try {
                        return Flux.from((Publisher)((HttpClientFilter)filters.get(0)).doFilter(request, (FilterChain)filterChain)).contextWrite(ctx -> ctx.put((Object)"micronaut.http.server.request", (Object)parentRequest));
                    }
                    catch (Throwable t) {
                        return Flux.error((Throwable)t);
                    }
                });
            } else {
                try {
                    responsePublisher = ((HttpClientFilter)filters.get(0)).doFilter(request, (FilterChain)filterChain);
                }
                catch (Throwable t) {
                    responsePublisher = Flux.error((Throwable)t);
                }
            }
        }
        return responsePublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NettyRequestWriter buildNettyRequest(MutableHttpRequest request, URI requestURI, MediaType requestContentType, boolean permitsBody, @Nullable Argument<?> bodyType, Consumer<? super Throwable> onError, boolean closeChannelAfterWrite) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        io.netty.handler.codec.http.HttpRequest nettyRequest;
        HttpPostRequestEncoder postRequestEncoder;
        block20: {
            block21: {
                postRequestEncoder = null;
                if (!permitsBody) break block21;
                Optional body = request.getBody();
                boolean hasBody = body.isPresent();
                if (requestContentType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && hasBody) {
                    Object bodyValue = body.get();
                    if (bodyValue instanceof CharSequence) {
                        ByteBuf byteBuf = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                        request.body((Object)byteBuf);
                        nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                        break block20;
                    } else {
                        postRequestEncoder = this.buildFormDataRequest(request, bodyValue);
                        nettyRequest = postRequestEncoder.finalizeRequest();
                    }
                    break block20;
                } else if (requestContentType.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE) && hasBody) {
                    Object bodyValue = body.get();
                    postRequestEncoder = this.buildMultipartRequest(request, bodyValue);
                    nettyRequest = postRequestEncoder.finalizeRequest();
                    break block20;
                } else {
                    ByteBuf bodyContent = null;
                    if (hasBody) {
                        Object bodyValue = body.get();
                        if (Publishers.isConvertibleToPublisher(bodyValue)) {
                            boolean isSingle = Publishers.isSingle(bodyValue.getClass());
                            Publisher publisher = (Publisher)ConversionService.SHARED.convert(bodyValue, Publisher.class).orElseThrow(() -> new IllegalArgumentException("Unconvertible reactive type: " + bodyValue));
                            Flux requestBodyPublisher = Flux.from((Publisher)publisher).map(o -> {
                                Optional registeredCodec;
                                ByteBuf encoded;
                                if (o instanceof CharSequence) {
                                    ByteBuf textChunk = Unpooled.copiedBuffer((CharSequence)((CharSequence)o), (Charset)requestContentType.getCharset().orElse(StandardCharsets.UTF_8));
                                    if (this.log.isTraceEnabled()) {
                                        this.traceChunk(textChunk);
                                    }
                                    return new DefaultHttpContent(textChunk);
                                }
                                if (o instanceof ByteBuf) {
                                    ByteBuf byteBuf = (ByteBuf)o;
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)byteBuf.readableBytes());
                                    }
                                    return new DefaultHttpContent(byteBuf);
                                }
                                if (o instanceof byte[]) {
                                    byte[] bodyBytes = (byte[])o;
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)bodyBytes.length);
                                    }
                                    return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])bodyBytes));
                                }
                                if (o instanceof ByteBuffer) {
                                    ByteBuffer byteBuffer = (ByteBuffer)o;
                                    Object nativeBuffer = byteBuffer.asNativeBuffer();
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)byteBuffer.readableBytes());
                                    }
                                    if (nativeBuffer instanceof ByteBuf) {
                                        return new DefaultHttpContent((ByteBuf)nativeBuffer);
                                    }
                                    return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])byteBuffer.toByteArray()));
                                }
                                if (this.mediaTypeCodecRegistry != null && (encoded = (ByteBuf)(registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType)).map(codec -> {
                                    if (bodyType != null && bodyType.isInstance(o)) {
                                        return (ByteBuf)codec.encode(bodyType, o, this.byteBufferFactory).asNativeBuffer();
                                    }
                                    return (ByteBuf)codec.encode(o, this.byteBufferFactory).asNativeBuffer();
                                }).orElse(null)) != null) {
                                    if (this.log.isTraceEnabled()) {
                                        this.traceChunk(encoded);
                                    }
                                    return new DefaultHttpContent(encoded);
                                }
                                throw new CodecException("Cannot encode value [" + o + "]. No possible encoders found");
                            });
                            if (!isSingle && MediaType.APPLICATION_JSON_TYPE.equals((Object)requestContentType)) {
                                requestBodyPublisher = JsonSubscriber.lift((Publisher)requestBodyPublisher);
                            }
                            requestBodyPublisher = requestBodyPublisher.doOnError(onError);
                            request.body((Object)requestBodyPublisher);
                            io.netty.handler.codec.http.HttpRequest nettyRequest2 = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                            try {
                                nettyRequest2.setUri(requestURI.toURL().getFile());
                                return new NettyRequestWriter(requestURI.getScheme(), nettyRequest2, null, closeChannelAfterWrite);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            return new NettyRequestWriter(requestURI.getScheme(), nettyRequest2, null, closeChannelAfterWrite);
                        }
                        if (bodyValue instanceof CharSequence) {
                            bodyContent = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                        } else if (this.mediaTypeCodecRegistry != null) {
                            Optional registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType);
                            bodyContent = registeredCodec.map(codec -> {
                                if (bodyType != null && bodyType.isInstance(bodyValue)) {
                                    return (ByteBuf)codec.encode(bodyType, bodyValue, this.byteBufferFactory).asNativeBuffer();
                                }
                                return (ByteBuf)codec.encode(bodyValue, this.byteBufferFactory).asNativeBuffer();
                            }).orElse(null);
                        }
                        if (bodyContent == null) {
                            bodyContent = (ByteBuf)ConversionService.SHARED.convert(bodyValue, ByteBuf.class).orElseThrow(() -> new HttpClientException("Body [" + bodyValue + "] cannot be encoded to content type [" + requestContentType + "]. No possible codecs or converters found."));
                        }
                    }
                    request.body(bodyContent);
                    try {
                        nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                    }
                    finally {
                        request.body(body.orElse(null));
                    }
                }
            }
            nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
        }
        try {
            nettyRequest.setUri(requestURI.toURL().getFile());
            return new NettyRequestWriter(requestURI.getScheme(), nettyRequest, postRequestEncoder, closeChannelAfterWrite);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new NettyRequestWriter(requestURI.getScheme(), nettyRequest, postRequestEncoder, closeChannelAfterWrite);
    }

    protected void configureHttp2Ssl(final HttpClientInitializer httpClientInitializer, final @NonNull SocketChannel ch, @NonNull SslContext sslCtx, String host, int port, HttpToHttp2ConnectionHandler connectionHandler) {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("ssl", (ChannelHandler)sslCtx.newHandler(ch.alloc(), host, port));
        pipeline.addLast("http2-protocol-negotiator", (ChannelHandler)new ApplicationProtocolNegotiationHandler("h2"){

            public void handlerRemoved(ChannelHandlerContext ctx) {
                Consumer contextConsumer = httpClientInitializer.contextConsumer;
                if (contextConsumer != null) {
                    contextConsumer.accept(ctx);
                }
            }

            protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
                if ("h2".equals(protocol)) {
                    ChannelPipeline p = ctx.pipeline();
                    if (httpClientInitializer.stream) {
                        ctx.channel().config().setAutoRead(false);
                    }
                    p.addLast("http2-settings", (ChannelHandler)new Http2SettingsHandler(ch.newPromise()));
                    httpClientInitializer.addEventStreamHandlerIfNecessary(p);
                    httpClientInitializer.addFinalHandler(p);
                    for (ChannelPipelineListener pipelineListener : DefaultHttpClient.this.pipelineListeners) {
                        pipelineListener.onConnect(p);
                    }
                } else if ("http/1.1".equals(protocol)) {
                    ChannelPipeline p = ctx.pipeline();
                    httpClientInitializer.addHttp1Handlers(p);
                } else {
                    ctx.close();
                    throw new HttpClientException("Unknown Protocol: " + protocol);
                }
            }
        });
        pipeline.addLast("http2-connection", (ChannelHandler)connectionHandler);
    }

    protected void configureHttp2ClearText(final HttpClientInitializer httpClientInitializer, @NonNull SocketChannel ch, @NonNull HttpToHttp2ConnectionHandler connectionHandler) {
        HttpClientCodec sourceCodec = new HttpClientCodec();
        Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec("http2-connection", (Http2ConnectionHandler)connectionHandler);
        HttpClientUpgradeHandler upgradeHandler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 65536);
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("http-client-codec", (ChannelHandler)sourceCodec);
        httpClientInitializer.settingsHandler = new Http2SettingsHandler(ch.newPromise());
        pipeline.addLast(new ChannelHandler[]{upgradeHandler});
        pipeline.addLast("http2-upgrade-request", (ChannelHandler)new UpgradeRequestHandler(httpClientInitializer){

            public void handlerRemoved(ChannelHandlerContext ctx) {
                Consumer contextConsumer = httpClientInitializer.contextConsumer;
                if (contextConsumer != null) {
                    contextConsumer.accept(ctx);
                }
            }
        });
    }

    @NonNull
    protected HttpToHttp2ConnectionHandlerBuilder newHttp2ConnectionHandlerBuilder(@NonNull Http2Connection connection, @NonNull HttpClientConfiguration configuration, boolean stream) {
        HttpToHttp2ConnectionHandlerBuilder builder = new HttpToHttp2ConnectionHandlerBuilder();
        builder.validateHeaders(true);
        Object http2ToHttpAdapter = !stream ? new InboundHttp2ToHttpAdapterBuilder(connection).maxContentLength(configuration.getMaxContentLength()).validateHttpHeaders(true).propagateSettings(true).build() : new StreamingInboundHttp2ToHttpAdapter(connection, configuration.getMaxContentLength());
        return builder.connection(connection).frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener(connection, (Http2FrameListener)http2ToHttpAdapter));
    }

    private Flux<MutableHttpResponse<Object>> readBodyOnError(final @Nullable Argument<?> errorType, @NonNull Flux<MutableHttpResponse<Object>> publisher) {
        if (errorType != null && errorType != HttpClient.DEFAULT_ERROR_TYPE) {
            return publisher.onErrorResume(clientException -> {
                HttpResponse response;
                if (clientException instanceof HttpClientResponseException && (response = ((HttpClientResponseException)((Object)clientException)).getResponse()) instanceof NettyStreamedHttpResponse) {
                    return Mono.create(emitter -> {
                        NettyStreamedHttpResponse streamedResponse = (NettyStreamedHttpResponse)response;
                        final StreamedHttpResponse nettyResponse = streamedResponse.getNettyResponse();
                        nettyResponse.subscribe((Subscriber)new Subscriber<HttpContent>(){
                            final CompositeByteBuf buffer;
                            Subscription s;
                            {
                                this.buffer = ((ByteBufAllocator)DefaultHttpClient.this.byteBufferFactory.getNativeAllocator()).compositeBuffer();
                            }

                            public void onSubscribe(Subscription s) {
                                this.s = s;
                                s.request(1L);
                            }

                            public void onNext(HttpContent httpContent) {
                                this.buffer.addComponent(true, httpContent.content());
                                this.s.request(1L);
                            }

                            public void onError(Throwable t) {
                                this.buffer.release();
                                emitter.error(t);
                            }

                            public void onComplete() {
                                try {
                                    DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(nettyResponse.protocolVersion(), nettyResponse.status(), (ByteBuf)this.buffer, nettyResponse.headers(), (HttpHeaders)new DefaultHttpHeaders(true));
                                    FullNettyClientHttpResponse fullNettyClientHttpResponse = new FullNettyClientHttpResponse((FullHttpResponse)fullHttpResponse, response.status(), DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, errorType, true);
                                    fullNettyClientHttpResponse.onComplete();
                                    emitter.error((Throwable)new HttpClientResponseException(fullHttpResponse.status().reasonPhrase(), null, fullNettyClientHttpResponse, new HttpClientErrorDecoder(){

                                        public Argument<?> getErrorType(MediaType mediaType) {
                                            return errorType;
                                        }
                                    }));
                                }
                                finally {
                                    this.buffer.release();
                                }
                            }
                        });
                    });
                }
                return Mono.error((Throwable)clientException);
            });
        }
        return publisher;
    }

    private <I> Publisher<URI> resolveURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (this.loadBalancer == null) {
            return Flux.error((Throwable)new NoHostException("Request URI specifies no host to connect to"));
        }
        return Flux.from((Publisher)this.loadBalancer.select(this.getLoadBalancerDiscriminator())).map(server -> {
            Optional authInfo = server.getMetadata().get((CharSequence)"Authorization-Info", String.class);
            if (request instanceof MutableHttpRequest && authInfo.isPresent()) {
                ((MutableHttpRequest)request).getHeaders().auth((String)authInfo.get());
            }
            return server.resolve(includeContextPath ? this.prependContextPath(requestURI) : requestURI);
        });
    }

    private <I, O, E> void sendRequestThroughChannel(HttpRequest<I> finalRequest, Argument<O> bodyType, Argument<E> errorType, FluxSink<? super HttpResponse<O>> emitter, Channel channel, boolean secure, ChannelPool channelPool) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        URI requestURI = finalRequest.getUri();
        MediaType requestContentType = finalRequest.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)finalRequest.getMethod());
        MutableHttpRequest clientHttpRequest = (MutableHttpRequest)finalRequest;
        NettyRequestWriter requestWriter = this.buildNettyRequest(clientHttpRequest, requestURI, requestContentType, permitsBody, bodyType, throwable -> {
            if (!emitter.isCancelled()) {
                emitter.error(throwable);
            }
        }, true);
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        this.prepareHttpHeaders(requestURI, finalRequest, nettyRequest, permitsBody, this.poolMap == null);
        if (this.log.isDebugEnabled()) {
            this.debugRequest(requestURI, nettyRequest);
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest(finalRequest, nettyRequest);
        }
        Promise responsePromise = channel.eventLoop().newPromise();
        channel.pipeline().addLast("micronaut-full-http-response", new FullHttpResponseHandler<O>(responsePromise, channelPool, secure, finalRequest, bodyType, errorType));
        Flux publisher = new NettyFuturePublisher(responsePromise, true);
        if (bodyType != null && bodyType.isVoid()) {
            publisher = Flux.from(publisher).filter(r -> false);
        }
        publisher.subscribe(new ForwardingSubscriber<HttpResponse<O>>(emitter));
        requestWriter.writeAndClose(channel, channelPool, emitter);
    }

    private Flux<MutableHttpResponse<Object>> streamRequestThroughChannel(HttpRequest<?> parentRequest, HttpRequest<?> request, Channel channel, boolean failOnError) {
        return Flux.create(sink -> {
            try {
                this.streamRequestThroughChannel0(parentRequest, request, (FluxSink)sink, channel);
            }
            catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
                sink.error((Throwable)e);
            }
        }).flatMap(resp -> this.handleStreamHttpError(resp, failOnError));
    }

    private <R extends HttpResponse<?>> Flux<R> handleStreamHttpError(R response, boolean failOnError) {
        boolean errorStatus;
        boolean bl = errorStatus = response.code() >= 400;
        if (errorStatus && failOnError) {
            return Flux.error((Throwable)new HttpClientResponseException(response.getStatus().getReason(), response));
        }
        return Flux.just(response);
    }

    private void streamRequestThroughChannel0(HttpRequest<?> parentRequest, HttpRequest<?> finalRequest, FluxSink emitter, Channel channel) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        NettyRequestWriter requestWriter = this.prepareRequest(finalRequest, finalRequest.getUri(), (FluxSink<HttpResponse<Object>>)emitter, false);
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        Promise responsePromise = channel.eventLoop().newPromise();
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("micronaut-http-response-full", (ChannelHandler)new StreamFullHttpResponseHandler((Promise<HttpResponse<?>>)responsePromise, parentRequest, finalRequest));
        pipeline.addLast("micronaut-http-response-stream", (ChannelHandler)new StreamStreamHttpResponseHandler((Promise<HttpResponse<?>>)responsePromise, parentRequest, finalRequest));
        if (this.log.isDebugEnabled()) {
            this.debugRequest(finalRequest.getUri(), nettyRequest);
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest(finalRequest, nettyRequest);
        }
        requestWriter.writeAndClose(channel, null, emitter);
        responsePromise.addListener(future -> {
            if (future.isSuccess()) {
                emitter.next(future.getNow());
                emitter.complete();
            } else {
                emitter.error(future.cause());
            }
        });
    }

    private ByteBuf charSequenceToByteBuf(CharSequence bodyValue, MediaType requestContentType) {
        CharSequence charSequence = bodyValue;
        return (ByteBuf)this.byteBufferFactory.copiedBuffer(charSequence.toString().getBytes(requestContentType.getCharset().orElse(this.defaultCharset))).asNativeBuffer();
    }

    private String getHostHeader(URI requestURI) {
        RequestKey requestKey = new RequestKey(requestURI);
        StringBuilder host = new StringBuilder(requestKey.getHost());
        int port = requestKey.getPort();
        if (port > -1 && port != 80 && port != 443) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    private <I> void prepareHttpHeaders(URI requestURI, HttpRequest<I> request, io.netty.handler.codec.http.HttpRequest nettyRequest, boolean permitsBody, boolean closeConnection) {
        HttpHeaders headers = nettyRequest.headers();
        if (!headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)this.getHostHeader(requestURI));
        }
        if (this.httpVersion != HttpVersion.HTTP_2_0) {
            if (closeConnection) {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            } else {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
        }
        if (permitsBody) {
            Optional body = request.getBody();
            if (body.isPresent()) {
                if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
                    MediaType mediaType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
                }
                if (nettyRequest instanceof FullHttpRequest) {
                    FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullHttpRequest.content().readableBytes());
                } else if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !headers.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
            } else if (!(nettyRequest instanceof StreamedHttpRequest)) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            }
        }
    }

    private boolean discardH2cStream(HttpMessage message) {
        if (this.httpVersion == HttpVersion.HTTP_2_0) {
            int streamId = message.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), -1);
            if (streamId == 1) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received response on HTTP2 stream 1, the stream used to respond to the initial upgrade request. Ignoring.");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addReadTimeoutHandler(ChannelPipeline pipeline) {
        if (this.readTimeoutMillis != null) {
            if (this.httpVersion == HttpVersion.HTTP_2_0) {
                Http2SettingsHandler settingsHandler = (Http2SettingsHandler)pipeline.get("http2-settings");
                if (settingsHandler != null) {
                    this.addInstrumentedListener((Future)settingsHandler.promise, (GenericFutureListener)future -> {
                        if (future.isSuccess()) {
                            pipeline.addBefore("http2-connection", "read-timeout", (ChannelHandler)new ReadTimeoutHandler(this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS));
                        }
                    });
                } else {
                    pipeline.addBefore("http2-connection", "read-timeout", (ChannelHandler)new ReadTimeoutHandler(this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS));
                }
            } else {
                pipeline.addBefore("http-client-codec", "read-timeout", (ChannelHandler)new ReadTimeoutHandler(this.readTimeoutMillis.longValue(), TimeUnit.MILLISECONDS));
            }
        }
    }

    private void removeReadTimeoutHandler(ChannelPipeline pipeline) {
        if (this.readTimeoutMillis != null && pipeline.context("read-timeout") != null) {
            pipeline.remove("read-timeout");
        }
    }

    private ClientFilterChain buildChain(final AtomicReference<HttpRequest<?>> requestWrapper, final List<HttpClientFilter> filters) {
        final AtomicInteger integer = new AtomicInteger();
        final int len = filters.size();
        return new ClientFilterChain(){

            public Publisher<? extends HttpResponse<?>> proceed(MutableHttpRequest<?> request) {
                int pos = integer.incrementAndGet();
                if (pos > len) {
                    throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                }
                HttpClientFilter httpFilter = (HttpClientFilter)filters.get(pos);
                try {
                    return httpFilter.doFilter((HttpRequest)requestWrapper.getAndSet(request), (FilterChain)this);
                }
                catch (Throwable t) {
                    return Flux.error((Throwable)t);
                }
            }
        };
    }

    private HttpPostRequestEncoder buildFormDataRequest(MutableHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder(NettyHttpRequestBuilder.toHttpRequest((HttpRequest)clientHttpRequest), false);
        Map formData = bodyValue instanceof Map ? (Map)bodyValue : BeanMap.of((Object)bodyValue);
        for (Map.Entry entry : formData.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object val : collection) {
                    this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), val);
                }
                continue;
            }
            this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), value);
        }
        return postRequestEncoder;
    }

    private void addBodyAttribute(HttpPostRequestEncoder postRequestEncoder, String key, Object value) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        Optional converted = ConversionService.SHARED.convert(value, String.class);
        if (converted.isPresent()) {
            postRequestEncoder.addBodyAttribute(key, (String)converted.get());
        }
    }

    private HttpPostRequestEncoder buildMultipartRequest(MutableHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        io.netty.handler.codec.http.HttpRequest request = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)clientHttpRequest);
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder((HttpDataFactory)factory, request, true, CharsetUtil.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        if (bodyValue instanceof MultipartBody.Builder) {
            bodyValue = ((MultipartBody.Builder)bodyValue).build();
        }
        if (!(bodyValue instanceof MultipartBody)) {
            throw new MultipartException(String.format("The type %s is not a supported type for a multipart request body", bodyValue.getClass().getName()));
        }
        MultipartBody multipartBody = (MultipartBody)bodyValue;
        postRequestEncoder.setBodyHttpDatas(multipartBody.getData((MultipartDataFactory)new MultipartDataFactory<InterfaceHttpData>((HttpDataFactory)factory, request){
            final /* synthetic */ HttpDataFactory val$factory;
            final /* synthetic */ io.netty.handler.codec.http.HttpRequest val$request;
            {
                this.val$factory = httpDataFactory;
                this.val$request = httpRequest;
            }

            @NonNull
            public InterfaceHttpData createFileUpload(@NonNull String name, @NonNull String filename, @NonNull MediaType contentType, @Nullable String encoding, @Nullable Charset charset, long length) {
                return this.val$factory.createFileUpload(this.val$request, name, filename, contentType.toString(), encoding, charset, length);
            }

            @NonNull
            public InterfaceHttpData createAttribute(@NonNull String name, @NonNull String value) {
                return this.val$factory.createAttribute(this.val$request, name, value);
            }

            public void setContent(InterfaceHttpData fileUploadObject, Object content) throws IOException {
                if (fileUploadObject instanceof FileUpload) {
                    FileUpload fu = (FileUpload)fileUploadObject;
                    if (content instanceof InputStream) {
                        fu.setContent((InputStream)content);
                    } else if (content instanceof File) {
                        fu.setContent((File)content);
                    } else if (content instanceof byte[]) {
                        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])((byte[])content));
                        fu.setContent(buffer);
                    }
                }
            }
        }));
        return postRequestEncoder;
    }

    private void debugRequest(URI requestURI, io.netty.handler.codec.http.HttpRequest nettyRequest) {
        this.log.debug("Sending HTTP {} to {}", (Object)nettyRequest.method(), (Object)requestURI.toString());
    }

    private void traceRequest(HttpRequest<?> request, io.netty.handler.codec.http.HttpRequest nettyRequest) {
        HttpHeaders headers = nettyRequest.headers();
        this.traceHeaders(headers);
        if (HttpMethod.permitsRequestBody((HttpMethod)request.getMethod()) && request.getBody().isPresent() && nettyRequest instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
            ByteBuf content = fullHttpRequest.content();
            if (this.log.isTraceEnabled()) {
                this.traceBody("Request", content);
            }
        }
    }

    private void traceBody(String type, ByteBuf content) {
        this.log.trace(type + " Body");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private void traceChunk(ByteBuf content) {
        this.log.trace("Sending Chunk");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private void traceHeaders(HttpHeaders headers) {
        for (String name : headers.names()) {
            List all = headers.getAll(name);
            if (all.size() > 1) {
                for (String value : all) {
                    this.log.trace("{}: {}", (Object)name, (Object)value);
                }
                continue;
            }
            if (all.isEmpty()) continue;
            this.log.trace("{}: {}", (Object)name, all.get(0));
        }
    }

    private static MediaTypeCodecRegistry createDefaultMediaTypeRegistry() {
        JacksonDatabindMapper mapper = new JacksonDatabindMapper();
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        return MediaTypeCodecRegistry.of((MediaTypeCodec[])new MediaTypeCodec[]{new JsonMediaTypeCodec((JsonMapper)mapper, configuration, null), new JsonStreamMediaTypeCodec((JsonMapper)mapper, configuration, null)});
    }

    private <I> NettyRequestWriter prepareRequest(HttpRequest<I> request, URI requestURI, FluxSink<HttpResponse<Object>> emitter, boolean closeChannelAfterWrite) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        MediaType requestContentType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)request.getMethod());
        if (!(request instanceof MutableHttpRequest)) {
            throw new IllegalArgumentException("A MutableHttpRequest is required");
        }
        MutableHttpRequest clientHttpRequest = (MutableHttpRequest)request;
        NettyRequestWriter requestWriter = this.buildNettyRequest(clientHttpRequest, requestURI, requestContentType, permitsBody, null, throwable -> {
            if (!emitter.isCancelled()) {
                emitter.error(throwable);
            }
        }, closeChannelAfterWrite);
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        this.prepareHttpHeaders(requestURI, request, nettyRequest, permitsBody, true);
        return requestWriter;
    }

    private Disposable buildDisposableChannel(final ChannelFuture channelFuture) {
        return new Disposable(){
            private AtomicBoolean disposed = new AtomicBoolean(false);

            public void dispose() {
                Channel channel;
                if (this.disposed.compareAndSet(false, true) && (channel = channelFuture.channel()).isOpen()) {
                    DefaultHttpClient.this.closeChannelAsync(channel);
                }
            }

            public boolean isDisposed() {
                return this.disposed.get();
            }
        };
    }

    private AbstractChannelPoolHandler newPoolHandler(final RequestKey key) {
        return new AbstractChannelPoolHandler(){

            public void channelCreated(Channel ch) {
                ch.pipeline().addLast("http-client-init", (ChannelHandler)new HttpClientInitializer(key.isSecure() ? DefaultHttpClient.this.sslContext : null, key.getHost(), key.getPort(), false, false, false, null){

                    @Override
                    protected void addFinalHandler(ChannelPipeline pipeline) {
                    }
                });
                if (DefaultHttpClient.this.connectionTimeAliveMillis != null) {
                    ch.pipeline().addLast("connect-ttl", (ChannelHandler)new ConnectTTLHandler(DefaultHttpClient.this.connectionTimeAliveMillis));
                }
            }

            public void channelReleased(Channel ch) {
                boolean shouldCloseOnRelease;
                Duration idleTimeout = DefaultHttpClient.this.configuration.getConnectionPoolIdleTimeout().orElse(Duration.ofNanos(0L));
                ChannelPipeline pipeline = ch.pipeline();
                if (ch.isOpen()) {
                    ch.config().setAutoRead(true);
                    pipeline.addLast(new ChannelHandler[]{IdlingConnectionHandler.INSTANCE});
                    if (idleTimeout.toNanos() > 0L) {
                        pipeline.addLast("idle-state", (ChannelHandler)new IdleStateHandler(idleTimeout.toNanos(), idleTimeout.toNanos(), 0L, TimeUnit.NANOSECONDS));
                        pipeline.addLast(new ChannelHandler[]{IdleTimeoutHandler.INSTANCE});
                    }
                }
                if (DefaultHttpClient.this.connectionTimeAliveMillis != null && (shouldCloseOnRelease = Boolean.TRUE.equals(ch.attr(ConnectTTLHandler.RELEASE_CHANNEL).get())) && ch.isOpen() && !ch.eventLoop().isShuttingDown()) {
                    ch.close();
                }
                DefaultHttpClient.this.removeReadTimeoutHandler(pipeline);
            }

            public void channelAcquired(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (pipeline.context((ChannelHandler)IdlingConnectionHandler.INSTANCE) != null) {
                    pipeline.remove((ChannelHandler)IdlingConnectionHandler.INSTANCE);
                }
                if (pipeline.context("idle-state") != null) {
                    pipeline.remove("idle-state");
                }
                if (pipeline.context((ChannelHandler)IdleTimeoutHandler.INSTANCE) != null) {
                    pipeline.remove((ChannelHandler)IdleTimeoutHandler.INSTANCE);
                }
            }
        };
    }

    private <V, C extends Future<V>> Future<V> addInstrumentedListener(Future<V> channelFuture, GenericFutureListener<C> listener) {
        InvocationInstrumenter instrumenter = this.combineFactories();
        return channelFuture.addListener(f -> {
            try (Instrumentation ignored = instrumenter.newInstrumentation();){
                listener.operationComplete(f);
            }
        });
    }

    @NonNull
    private InvocationInstrumenter combineFactories() {
        if (CollectionUtils.isEmpty(this.invocationInstrumenterFactories)) {
            return InvocationInstrumenter.NOOP;
        }
        return InvocationInstrumenter.combine((Collection)this.invocationInstrumenterFactories.stream().map(InvocationInstrumenterFactory::newInvocationInstrumenter).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private static boolean isSecureScheme(String scheme) {
        return "https".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme);
    }

    static {
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.HOST, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"");
    }

    private class StreamStreamHttpResponseHandler
    extends BaseHttpResponseHandler<StreamedHttpResponse, HttpResponse<?>> {
        public StreamStreamHttpResponseHandler(Promise<HttpResponse<?>> responsePromise, HttpRequest<?> parentRequest, HttpRequest<?> finalRequest) {
            super(responsePromise, parentRequest, finalRequest);
        }

        @Override
        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof StreamedHttpResponse;
        }

        @Override
        protected void buildResponse(Promise<? super HttpResponse<?>> promise, StreamedHttpResponse msg, HttpStatus httpStatus) {
            promise.trySuccess(new NettyStreamedHttpResponse(msg, httpStatus));
        }

        @Override
        protected Function<URI, Publisher<? extends HttpResponse<?>>> makeRedirectHandler(HttpRequest<?> parentRequest, MutableHttpRequest<Object> redirectRequest) {
            return uri -> DefaultHttpClient.this.buildStreamExchange(parentRequest, (HttpRequest)redirectRequest, uri, null);
        }
    }

    private class StreamFullHttpResponseHandler
    extends BaseHttpResponseHandler<FullHttpResponse, HttpResponse<?>> {
        public StreamFullHttpResponseHandler(Promise<HttpResponse<?>> responsePromise, HttpRequest<?> parentRequest, HttpRequest<?> finalRequest) {
            super(responsePromise, parentRequest, finalRequest);
        }

        @Override
        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof FullHttpResponse;
        }

        @Override
        protected void buildResponse(Promise<? super HttpResponse<?>> promise, FullHttpResponse msg, HttpStatus httpStatus) {
            Publisher bodyPublisher = msg.content() instanceof EmptyByteBuf ? Publishers.empty() : Publishers.just((Object)new DefaultLastHttpContent(msg.content()));
            DefaultStreamedHttpResponse nettyResponse = new DefaultStreamedHttpResponse(msg.protocolVersion(), msg.status(), msg.headers(), bodyPublisher);
            promise.trySuccess(new NettyStreamedHttpResponse((StreamedHttpResponse)nettyResponse, httpStatus));
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            DefaultHttpClient.this.addReadTimeoutHandler(ctx.pipeline());
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            super.handlerRemoved(ctx);
            DefaultHttpClient.this.removeReadTimeoutHandler(ctx.pipeline());
        }

        @Override
        protected Function<URI, Publisher<? extends HttpResponse<?>>> makeRedirectHandler(HttpRequest<?> parentRequest, MutableHttpRequest<Object> redirectRequest) {
            return uri -> DefaultHttpClient.this.buildStreamExchange(parentRequest, (HttpRequest)redirectRequest, uri, null);
        }
    }

    private class FullHttpResponseHandler<O>
    extends BaseHttpResponseHandler<FullHttpResponse, HttpResponse<O>> {
        private final boolean secure;
        private final Argument<O> bodyType;
        private final Argument<?> errorType;
        private final ChannelPool channelPool;
        private boolean keepAlive;

        public FullHttpResponseHandler(Promise<HttpResponse<O>> responsePromise, ChannelPool channelPool, boolean secure, HttpRequest<?> request, Argument<O> bodyType, Argument<?> errorType) {
            super(responsePromise, request, request);
            this.keepAlive = true;
            this.secure = secure;
            this.bodyType = bodyType;
            this.errorType = errorType;
            this.channelPool = channelPool;
        }

        @Override
        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof FullHttpResponse && (this.secure || !DefaultHttpClient.this.discardH2cStream((HttpMessage)msg));
        }

        @Override
        protected Function<URI, Publisher<? extends HttpResponse<O>>> makeRedirectHandler(HttpRequest<?> parentRequest, MutableHttpRequest<Object> redirectRequest) {
            return uri -> DefaultHttpClient.this.exchangeImpl(uri, parentRequest, (HttpRequest)redirectRequest, this.bodyType, this.errorType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void channelReadInstrumented(ChannelHandlerContext channelHandlerContext, FullHttpResponse fullResponse) throws Exception {
            try {
                fullResponse.retain();
                super.channelReadInstrumented(channelHandlerContext, fullResponse);
            }
            finally {
                block10: {
                    if (fullResponse.refCnt() > 1) {
                        try {
                            ReferenceCountUtil.release((Object)fullResponse);
                        }
                        catch (Exception e) {
                            if (!DefaultHttpClient.this.log.isDebugEnabled()) break block10;
                            DefaultHttpClient.this.log.debug("Failed to release response: {}", (Object)fullResponse);
                        }
                    }
                }
                if (!HttpUtil.isKeepAlive((HttpMessage)fullResponse)) {
                    this.keepAlive = false;
                }
                channelHandlerContext.pipeline().remove((ChannelHandler)this);
            }
        }

        @Override
        protected void buildResponse(Promise<? super HttpResponse<O>> promise, FullHttpResponse msg, HttpStatus httpStatus) {
            try {
                if (DefaultHttpClient.this.log.isTraceEnabled()) {
                    DefaultHttpClient.this.traceBody("Response", msg.content());
                }
                if (httpStatus == HttpStatus.NO_CONTENT) {
                    msg.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                }
                boolean convertBodyWithBodyType = httpStatus.getCode() < 400 || !DefaultHttpClient.this.configuration.isExceptionOnErrorStatus() && this.bodyType.equalsType(this.errorType);
                FullNettyClientHttpResponse<O> response = new FullNettyClientHttpResponse<O>(msg, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, this.bodyType, convertBodyWithBodyType);
                if (convertBodyWithBodyType) {
                    promise.trySuccess(response);
                    response.onComplete();
                } else {
                    try {
                        promise.tryFailure((Throwable)this.makeErrorFromRequestBody(msg.status(), response));
                        response.onComplete();
                    }
                    catch (HttpClientResponseException t) {
                        promise.tryFailure((Throwable)t);
                        response.onComplete();
                    }
                    catch (Exception t) {
                        response.onComplete();
                        promise.tryFailure((Throwable)this.makeErrorBodyParseError(msg, httpStatus, t));
                    }
                }
            }
            catch (HttpClientResponseException t) {
                promise.tryFailure((Throwable)t);
            }
            catch (Exception t) {
                this.makeNormalBodyParseError(msg, httpStatus, t, cause -> {
                    if (!promise.tryFailure((Throwable)cause) && DefaultHttpClient.this.log.isWarnEnabled()) {
                        DefaultHttpClient.this.log.warn("Exception fired after handler completed: " + t.getMessage(), (Throwable)t);
                    }
                });
            }
        }

        private HttpClientResponseException makeErrorFromRequestBody(HttpResponseStatus status, FullNettyClientHttpResponse<?> response) {
            if (this.errorType != null && this.errorType != HttpClient.DEFAULT_ERROR_TYPE) {
                return new HttpClientResponseException(status.reasonPhrase(), null, response, new HttpClientErrorDecoder(){

                    public Argument<?> getErrorType(MediaType mediaType) {
                        return FullHttpResponseHandler.this.errorType;
                    }
                });
            }
            return new HttpClientResponseException(status.reasonPhrase(), response);
        }

        private HttpClientResponseException makeErrorBodyParseError(FullHttpResponse fullResponse, HttpStatus httpStatus, Throwable t) {
            FullNettyClientHttpResponse errorResponse = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, false);
            errorResponse.onComplete();
            return new HttpClientResponseException("Error decoding HTTP error response body: " + t.getMessage(), t, errorResponse, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeNormalBodyParseError(FullHttpResponse fullResponse, HttpStatus httpStatus, Throwable t, Consumer<HttpClientResponseException> forward) {
            FullNettyClientHttpResponse response = new FullNettyClientHttpResponse(fullResponse, httpStatus, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, false);
            HttpClientResponseException clientResponseError = new HttpClientResponseException("Error decoding HTTP response body: " + t.getMessage(), t, response, new HttpClientErrorDecoder(){

                public Argument<?> getErrorType(MediaType mediaType) {
                    return FullHttpResponseHandler.this.errorType;
                }
            });
            try {
                forward.accept(clientResponseError);
            }
            finally {
                response.onComplete();
            }
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            if (this.channelPool != null) {
                DefaultHttpClient.this.removeReadTimeoutHandler(ctx.pipeline());
                Channel ch = ctx.channel();
                if (!this.keepAlive) {
                    ch.closeFuture().addListener(future -> this.channelPool.release(ch));
                } else {
                    this.channelPool.release(ch);
                }
            } else {
                ctx.close();
            }
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            DefaultHttpClient.this.addReadTimeoutHandler(ctx.pipeline());
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            super.exceptionCaught(ctx, cause);
            this.keepAlive = false;
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private abstract class BaseHttpResponseHandler<R extends io.netty.handler.codec.http.HttpResponse, O>
    extends SimpleChannelInboundHandlerInstrumented<R> {
        private final Promise<O> responsePromise;
        private final HttpRequest<?> parentRequest;
        private final HttpRequest<?> finalRequest;

        public BaseHttpResponseHandler(Promise<O> responsePromise, HttpRequest<?> parentRequest, HttpRequest<?> finalRequest) {
            super(DefaultHttpClient.this.combineFactories());
            this.responsePromise = responsePromise;
            this.parentRequest = parentRequest;
            this.finalRequest = finalRequest;
        }

        public abstract boolean acceptInboundMessage(Object var1);

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            String message = cause.getMessage();
            if (message == null) {
                message = cause.getClass().getSimpleName();
            }
            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                DefaultHttpClient.this.log.trace("HTTP Client exception ({}) occurred for request : {} {}", new Object[]{message, this.finalRequest.getMethodName(), this.finalRequest.getUri()});
            }
            Object result = cause instanceof TooLongFrameException ? new ContentLengthExceededException((long)DefaultHttpClient.this.configuration.getMaxContentLength()) : (cause instanceof io.netty.handler.timeout.ReadTimeoutException ? ReadTimeoutException.TIMEOUT_EXCEPTION : new HttpClientException("Error occurred reading HTTP response: " + message, cause));
            this.responsePromise.tryFailure((Throwable)result);
        }

        @Override
        protected void channelReadInstrumented(ChannelHandlerContext ctx, R msg) throws Exception {
            HttpStatus httpStatus;
            if (this.responsePromise.isDone()) {
                return;
            }
            if (DefaultHttpClient.this.log.isDebugEnabled()) {
                DefaultHttpClient.this.log.debug("Received response {} from {}", (Object)msg.status().code(), (Object)this.finalRequest.getUri());
            }
            int code = msg.status().code();
            HttpHeaders headers1 = msg.headers();
            if (code > 300 && code < 400 && DefaultHttpClient.this.configuration.isFollowRedirects() && headers1.contains((CharSequence)HttpHeaderNames.LOCATION)) {
                MutableHttpRequest redirectRequest;
                String location = headers1.get((CharSequence)HttpHeaderNames.LOCATION);
                if (code == 307) {
                    redirectRequest = HttpRequest.create((HttpMethod)this.finalRequest.getMethod(), (String)location);
                    this.finalRequest.getBody().ifPresent(arg_0 -> ((MutableHttpRequest)redirectRequest).body(arg_0));
                } else {
                    redirectRequest = HttpRequest.GET((String)location);
                }
                this.setRedirectHeaders(this.finalRequest, (MutableHttpRequest<Object>)redirectRequest);
                Flux.from(DefaultHttpClient.this.resolveRedirectURI(this.parentRequest, redirectRequest)).flatMap(this.makeRedirectHandler(this.parentRequest, (MutableHttpRequest<Object>)redirectRequest)).subscribe(new NettyPromiseSubscriber<O>(this.responsePromise));
                return;
            }
            HttpResponseStatus status = msg.status();
            int statusCode = status.code();
            try {
                httpStatus = HttpStatus.valueOf((int)statusCode);
            }
            catch (IllegalArgumentException e) {
                this.responsePromise.tryFailure((Throwable)e);
                return;
            }
            HttpHeaders headers = msg.headers();
            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                DefaultHttpClient.this.log.trace("HTTP Client Response Received ({}) for Request: {} {}", new Object[]{msg.status(), this.finalRequest.getMethodName(), this.finalRequest.getUri()});
                DefaultHttpClient.this.traceHeaders(headers);
            }
            this.buildResponse(this.responsePromise, msg, httpStatus);
        }

        private void setRedirectHeaders(@Nullable HttpRequest<?> request, MutableHttpRequest<Object> redirectRequest) {
            if (request != null) {
                for (Map.Entry originalHeader : request.getHeaders()) {
                    List originalHeaderValue;
                    if (REDIRECT_HEADER_BLOCKLIST.contains((String)originalHeader.getKey()) || (originalHeaderValue = (List)originalHeader.getValue()) == null || originalHeaderValue.isEmpty()) continue;
                    for (String value : originalHeaderValue) {
                        if (value == null) continue;
                        redirectRequest.header((CharSequence)originalHeader.getKey(), (CharSequence)value);
                    }
                }
            }
        }

        protected abstract Function<URI, Publisher<? extends O>> makeRedirectHandler(HttpRequest<?> var1, MutableHttpRequest<Object> var2);

        protected abstract void buildResponse(Promise<? super O> var1, R var2, HttpStatus var3);
    }

    private static class CurrentEvent {
        byte[] data;
        String id;
        String name;
        Duration retry;

        private CurrentEvent() {
        }
    }

    protected class NettyRequestWriter {
        private final io.netty.handler.codec.http.HttpRequest nettyRequest;
        private final HttpPostRequestEncoder encoder;
        private final String scheme;
        private final boolean closeChannelAfterWrite;

        NettyRequestWriter(String scheme, io.netty.handler.codec.http.HttpRequest nettyRequest, HttpPostRequestEncoder encoder, boolean closeChannelAfterWrite) {
            this.nettyRequest = nettyRequest;
            this.encoder = encoder;
            this.scheme = scheme;
            this.closeChannelAfterWrite = closeChannelAfterWrite;
        }

        protected void writeAndClose(Channel channel, ChannelPool channelPool, FluxSink<?> emitter) {
            ChannelPipeline pipeline = channel.pipeline();
            if (DefaultHttpClient.this.httpVersion == HttpVersion.HTTP_2_0) {
                boolean isSecure;
                boolean bl = isSecure = DefaultHttpClient.this.sslContext != null && DefaultHttpClient.isSecureScheme(this.scheme);
                if (isSecure) {
                    this.nettyRequest.headers().add((CharSequence)AbstractNettyHttpRequest.HTTP2_SCHEME, (Object)HttpScheme.HTTPS);
                } else {
                    this.nettyRequest.headers().add((CharSequence)AbstractNettyHttpRequest.HTTP2_SCHEME, (Object)HttpScheme.HTTP);
                }
                UpgradeRequestHandler upgradeRequestHandler = (UpgradeRequestHandler)pipeline.get("http2-upgrade-request");
                Http2SettingsHandler settingsHandler = upgradeRequestHandler != null ? upgradeRequestHandler.getSettingsHandler() : (Http2SettingsHandler)pipeline.get("http2-settings");
                if (settingsHandler != null) {
                    DefaultHttpClient.this.addInstrumentedListener((Future)settingsHandler.promise, future -> {
                        if (!future.isSuccess()) {
                            throw new HttpClientException("HTTP/2 clear text upgrade failed to complete", future.cause());
                        }
                        this.processRequestWrite(channel, channelPool, emitter, pipeline);
                    });
                    return;
                }
            }
            this.processRequestWrite(channel, channelPool, emitter, pipeline);
        }

        private void processRequestWrite(Channel channel, ChannelPool channelPool, FluxSink<?> emitter, ChannelPipeline pipeline) {
            ChannelFuture channelFuture;
            if (this.encoder != null && this.encoder.isChunked()) {
                channel.attr(AttributeKey.valueOf((String)"chunk-writer")).set((Object)true);
                pipeline.addAfter("http-streams-codec", "chunk-writer", (ChannelHandler)new ChunkedWriteHandler());
                channel.write((Object)this.nettyRequest);
                channelFuture = channel.writeAndFlush((Object)this.encoder);
            } else {
                channelFuture = channel.writeAndFlush((Object)this.nettyRequest);
            }
            if (channelPool != null) {
                this.closeChannelIfNecessary(channel, emitter, channelFuture, false);
            } else {
                this.closeChannelIfNecessary(channel, emitter, channelFuture, this.closeChannelAfterWrite);
            }
        }

        private void closeChannelIfNecessary(Channel channel, FluxSink<?> emitter, ChannelFuture channelFuture, boolean closeChannelAfterWrite) {
            DefaultHttpClient.this.addInstrumentedListener((Future)channelFuture, f -> {
                try {
                    if (!f.isSuccess()) {
                        if (!emitter.isCancelled()) {
                            emitter.error(f.cause());
                        }
                    } else {
                        channel.read();
                    }
                }
                finally {
                    if (this.encoder != null) {
                        this.encoder.cleanFiles();
                    }
                    channel.attr(AttributeKey.valueOf((String)"chunk-writer")).set(null);
                    if (closeChannelAfterWrite) {
                        DefaultHttpClient.this.closeChannelAsync(channel);
                    }
                }
            });
        }

        io.netty.handler.codec.http.HttpRequest getNettyRequest() {
            return this.nettyRequest;
        }
    }

    private static final class RequestKey {
        private final String host;
        private final int port;
        private final boolean secure;

        public RequestKey(URI requestURI) {
            int port;
            this.secure = DefaultHttpClient.isSecureScheme(requestURI.getScheme());
            String host = requestURI.getHost();
            if (host == null) {
                host = requestURI.getAuthority();
                if (host == null) {
                    throw new NoHostException("URI specifies no host to connect to");
                }
                int i = host.indexOf(58);
                if (i > -1) {
                    String portStr = host.substring(i + 1);
                    host = host.substring(0, i);
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        throw new HttpClientException("URI specifies an invalid port: " + portStr);
                    }
                } else {
                    port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
                }
            } else {
                port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
            }
            this.host = host;
            this.port = port;
        }

        public InetSocketAddress getRemoteAddress() {
            return InetSocketAddress.createUnresolved(this.host, this.port);
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestKey that = (RequestKey)o;
            return this.port == that.port && this.secure == that.secure && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return Objects.hash(this.host, this.port, this.secure);
        }
    }

    private class UpgradeRequestHandler
    extends ChannelInboundHandlerAdapter {
        private final HttpClientInitializer initializer;
        private final Http2SettingsHandler settingsHandler;

        public UpgradeRequestHandler(HttpClientInitializer initializer) {
            this.initializer = initializer;
            this.settingsHandler = initializer.settingsHandler;
        }

        public Http2SettingsHandler getSettingsHandler() {
            return this.settingsHandler;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.addLast("http2-settings", (ChannelHandler)this.initializer.settingsHandler);
            DefaultFullHttpRequest upgradeRequest = new DefaultFullHttpRequest(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, io.netty.handler.codec.http.HttpMethod.GET, "/", Unpooled.EMPTY_BUFFER);
            InetSocketAddress remote = (InetSocketAddress)ctx.channel().remoteAddress();
            String hostString = remote.getHostString();
            if (hostString == null) {
                hostString = remote.getAddress().getHostAddress();
            }
            upgradeRequest.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)(hostString + ':' + remote.getPort()));
            ctx.writeAndFlush((Object)upgradeRequest);
            ctx.fireChannelActive();
            pipeline.remove((ChannelHandler)this);
            this.initializer.addFinalHandler(pipeline);
        }
    }

    private final class Http2SettingsHandler
    extends SimpleChannelInboundHandlerInstrumented<Http2Settings> {
        private final ChannelPromise promise;

        Http2SettingsHandler(ChannelPromise promise) {
            super(DefaultHttpClient.this.combineFactories());
            this.promise = promise;
        }

        @Override
        protected void channelReadInstrumented(ChannelHandlerContext ctx, Http2Settings msg) {
            this.promise.setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    protected class HttpClientInitializer
    extends ChannelInitializer<SocketChannel> {
        final SslContext sslContext;
        final String host;
        final int port;
        final boolean stream;
        final boolean proxy;
        final boolean acceptsEvents;
        Http2SettingsHandler settingsHandler;
        private final Consumer<ChannelHandlerContext> contextConsumer;

        protected HttpClientInitializer(SslContext sslContext, String host, int port, boolean stream, boolean proxy, boolean acceptsEvents, Consumer<ChannelHandlerContext> contextConsumer) {
            this.sslContext = sslContext;
            this.stream = stream;
            this.host = host;
            this.port = port;
            this.proxy = proxy;
            this.acceptsEvents = acceptsEvents;
            this.contextConsumer = contextConsumer;
        }

        protected void initChannel(SocketChannel ch) {
            ChannelPipeline p = ch.pipeline();
            Proxy proxy = DefaultHttpClient.this.configuration.resolveProxy(this.sslContext != null, this.host, this.port);
            if (!Proxy.NO_PROXY.equals(proxy)) {
                DefaultHttpClient.this.configureProxy(p, proxy);
            }
            if (DefaultHttpClient.this.httpVersion == HttpVersion.HTTP_2_0) {
                DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
                HttpToHttp2ConnectionHandlerBuilder builder = DefaultHttpClient.this.newHttp2ConnectionHandlerBuilder((Http2Connection)connection, DefaultHttpClient.this.configuration, this.stream);
                DefaultHttpClient.this.configuration.getLogLevel().ifPresent(logLevel -> {
                    try {
                        LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                        builder.frameLogger(new Http2FrameLogger(nettyLevel, DefaultHttpClient.class));
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpClientException("Unsupported log level: " + logLevel);
                    }
                });
                HttpToHttp2ConnectionHandler connectionHandler = builder.build();
                if (this.sslContext != null) {
                    DefaultHttpClient.this.configureHttp2Ssl(this, ch, this.sslContext, this.host, this.port, connectionHandler);
                } else {
                    DefaultHttpClient.this.configureHttp2ClearText(this, ch, connectionHandler);
                }
            } else {
                Duration duration;
                Optional readIdleTime;
                if (this.stream) {
                    ch.config().setAutoRead(false);
                }
                DefaultHttpClient.this.configuration.getLogLevel().ifPresent(logLevel -> {
                    try {
                        LogLevel nettyLevel = LogLevel.valueOf((String)logLevel.name());
                        p.addLast(new ChannelHandler[]{new LoggingHandler(DefaultHttpClient.class, nettyLevel)});
                    }
                    catch (IllegalArgumentException e) {
                        throw new HttpClientException("Unsupported log level: " + logLevel);
                    }
                });
                if (this.sslContext != null) {
                    SslHandler sslHandler = this.sslContext.newHandler(ch.alloc(), this.host, this.port);
                    sslHandler.setHandshakeTimeoutMillis(DefaultHttpClient.this.configuration.getSslConfiguration().getHandshakeTimeout().toMillis());
                    p.addLast("ssl", (ChannelHandler)sslHandler);
                }
                if (DefaultHttpClient.this.poolMap == null && this.stream && (readIdleTime = DefaultHttpClient.this.configuration.getReadIdleTimeout()).isPresent() && !(duration = (Duration)readIdleTime.get()).isNegative()) {
                    p.addLast("idle-state", (ChannelHandler)new IdleStateHandler(duration.toMillis(), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS));
                }
                this.addHttp1Handlers(p);
            }
        }

        private void addHttp1Handlers(ChannelPipeline p) {
            p.addLast("http-client-codec", (ChannelHandler)new HttpClientCodec());
            p.addLast("http-decoder", (ChannelHandler)new HttpContentDecompressor());
            int maxContentLength = DefaultHttpClient.this.configuration.getMaxContentLength();
            if (!this.stream) {
                p.addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLength){

                    protected void finishAggregation(FullHttpMessage aggregated) throws Exception {
                        if (!HttpUtil.isContentLengthSet((HttpMessage)aggregated) && aggregated.content().readableBytes() > 0) {
                            super.finishAggregation(aggregated);
                        }
                    }
                });
            }
            this.addEventStreamHandlerIfNecessary(p);
            this.addFinalHandler(p);
            for (ChannelPipelineListener pipelineListener : DefaultHttpClient.this.pipelineListeners) {
                pipelineListener.onConnect(p);
            }
        }

        private void addEventStreamHandlerIfNecessary(ChannelPipeline p) {
            if (this.acceptsEventStream() && !this.proxy) {
                p.addLast("micronaut-sse-event-stream", (ChannelHandler)new LineBasedFrameDecoder(DefaultHttpClient.this.configuration.getMaxContentLength(), true, true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        if (msg instanceof HttpContent) {
                            if (msg instanceof LastHttpContent) {
                                super.channelRead(ctx, msg);
                            } else {
                                Attribute streamKey = ctx.channel().attr(STREAM_KEY);
                                if (msg instanceof Http2Content) {
                                    streamKey.set((Object)((Http2Content)msg).stream());
                                }
                                try {
                                    super.channelRead(ctx, (Object)((HttpContent)msg).content());
                                }
                                finally {
                                    streamKey.set(null);
                                }
                            }
                        } else {
                            super.channelRead(ctx, msg);
                        }
                    }
                });
                p.addLast("micronaut-sse-content", (ChannelHandler)new SimpleChannelInboundHandlerInstrumented<ByteBuf>(DefaultHttpClient.this.combineFactories(), false){

                    public boolean acceptInboundMessage(Object msg) {
                        return msg instanceof ByteBuf;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void channelReadInstrumented(ChannelHandlerContext ctx, ByteBuf msg) {
                        try {
                            Attribute streamKey = ctx.channel().attr(STREAM_KEY);
                            Http2Stream http2Stream = (Http2Stream)streamKey.get();
                            if (http2Stream != null) {
                                ctx.fireChannelRead((Object)new DefaultHttp2Content(msg.copy(), http2Stream));
                            } else {
                                ctx.fireChannelRead((Object)new DefaultHttpContent(msg.copy()));
                            }
                        }
                        finally {
                            msg.release();
                        }
                    }
                });
            }
        }

        protected void addFinalHandler(ChannelPipeline pipeline) {
            pipeline.addLast("http-streams-codec", (ChannelHandler)new HttpStreamsClientHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof IdleStateEvent) {
                        ctx.close();
                    }
                    super.userEventTriggered(ctx, evt);
                }

                protected boolean isValidInMessage(Object msg) {
                    return super.isValidInMessage(msg) && (HttpClientInitializer.this.sslContext != null || !DefaultHttpClient.this.discardH2cStream((HttpMessage)msg));
                }
            });
        }

        private boolean acceptsEventStream() {
            return this.acceptsEvents;
        }
    }

    @FunctionalInterface
    static interface ThrowingBiConsumer<T1, T2> {
        public void accept(T1 var1, T2 var2) throws Exception;
    }
}

