/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.PoolSink;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@Internal
final class CancellableMonoSink<T>
implements Publisher<T>,
Sinks.One<T>,
Subscription,
PoolSink<T> {
    private static final Object EMPTY = new Object();
    @Nullable
    private final BlockHint blockHint;
    private T value;
    private Throwable failure;
    private boolean complete = false;
    private Subscriber<? super T> subscriber = null;
    private boolean subscriberWaiting = false;

    CancellableMonoSink(@Nullable BlockHint blockHint) {
        this.blockHint = blockHint;
    }

    @Override
    @Nullable
    public BlockHint getBlockHint() {
        return this.blockHint;
    }

    public synchronized void subscribe(Subscriber<? super T> s) {
        if (this.subscriber != null) {
            s.onError((Throwable)new IllegalStateException("Only one subscriber allowed"));
        }
        this.subscriber = s;
        this.subscriber.onSubscribe((Subscription)this);
    }

    private void tryForward() {
        if (this.subscriberWaiting && this.complete) {
            if (this.failure == null) {
                if (this.value != EMPTY) {
                    this.subscriber.onNext(this.value);
                }
                this.subscriber.onComplete();
            } else {
                this.subscriber.onError(this.failure);
            }
        }
    }

    @NonNull
    public synchronized Sinks.EmitResult tryEmitValue(T value) {
        if (this.complete) {
            return Sinks.EmitResult.FAIL_OVERFLOW;
        }
        this.value = value;
        this.complete = true;
        this.tryForward();
        return Sinks.EmitResult.OK;
    }

    public void emitValue(T value, @NonNull Sinks.EmitFailureHandler failureHandler) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public Sinks.EmitResult tryEmitEmpty() {
        return this.tryEmitValue(EMPTY);
    }

    @NonNull
    public synchronized Sinks.EmitResult tryEmitError(@NonNull Throwable error) {
        if (this.complete) {
            return Sinks.EmitResult.FAIL_OVERFLOW;
        }
        this.failure = error;
        this.complete = true;
        this.tryForward();
        return Sinks.EmitResult.OK;
    }

    public void emitEmpty(@NonNull Sinks.EmitFailureHandler failureHandler) {
        throw new UnsupportedOperationException();
    }

    public void emitError(@NonNull Throwable error, @NonNull Sinks.EmitFailureHandler failureHandler) {
        throw new UnsupportedOperationException();
    }

    public synchronized int currentSubscriberCount() {
        return this.subscriber == null ? 0 : 1;
    }

    @NonNull
    public Mono<T> asMono() {
        return Mono.from((Publisher)this);
    }

    public Object scanUnsafe(@NonNull Scannable.Attr key) {
        return null;
    }

    public synchronized void request(long n) {
        if (n > 0L && !this.subscriberWaiting) {
            this.subscriberWaiting = true;
            this.tryForward();
        }
    }

    public synchronized void cancel() {
        this.complete = true;
    }
}

