/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.beans.BeanMap;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.ConversionServiceAware;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.client.BlockingHttpClient;
import io.micronaut.http.client.DefaultHttpClientConfiguration;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.ProxyHttpClient;
import io.micronaut.http.client.ProxyRequestOptions;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.exceptions.ContentLengthExceededException;
import io.micronaut.http.client.exceptions.HttpClientErrorDecoder;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.exceptions.HttpClientExceptionUtils;
import io.micronaut.http.client.exceptions.HttpClientResponseException;
import io.micronaut.http.client.exceptions.NoHostException;
import io.micronaut.http.client.exceptions.ReadTimeoutException;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.client.filter.DefaultHttpClientFilterResolver;
import io.micronaut.http.client.filters.ClientServerContextFilter;
import io.micronaut.http.client.multipart.MultipartBody;
import io.micronaut.http.client.multipart.MultipartDataFactory;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.CompositeNettyClientCustomizer;
import io.micronaut.http.client.netty.ConnectionManager;
import io.micronaut.http.client.netty.ForwardingSubscriber;
import io.micronaut.http.client.netty.FullNettyClientHttpResponse;
import io.micronaut.http.client.netty.HttpLineBasedFrameDecoder;
import io.micronaut.http.client.netty.MicronautFlux;
import io.micronaut.http.client.netty.MutableHttpRequestWrapper;
import io.micronaut.http.client.netty.NettyClientCustomizer;
import io.micronaut.http.client.netty.NettyClientHttpRequest;
import io.micronaut.http.client.netty.NettyFuturePublisher;
import io.micronaut.http.client.netty.NettyPromiseSubscriber;
import io.micronaut.http.client.netty.NettyStreamedHttpResponse;
import io.micronaut.http.client.netty.SimpleChannelInboundHandlerInstrumented;
import io.micronaut.http.client.netty.ssl.NettyClientSslBuilder;
import io.micronaut.http.client.netty.websocket.NettyWebSocketClientHandler;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ContextPathUtils;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.filter.FilterOrder;
import io.micronaut.http.filter.FilterRunner;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.http.multipart.MultipartException;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.stream.DefaultStreamedHttpResponse;
import io.micronaut.http.netty.stream.HttpStreamsClientHandler;
import io.micronaut.http.netty.stream.JsonSubscriber;
import io.micronaut.http.netty.stream.StreamedHttpRequest;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.micronaut.http.reactive.execution.ReactiveExecutionFlow;
import io.micronaut.http.sse.Event;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.http.util.HttpHeadersUtil;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.codec.JsonMediaTypeCodec;
import io.micronaut.json.codec.JsonStreamMediaTypeCodec;
import io.micronaut.json.codec.MapperMediaTypeCodec;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.scheduling.instrument.InvocationInstrumenter;
import io.micronaut.scheduling.instrument.InvocationInstrumenterFactory;
import io.micronaut.websocket.WebSocketClient;
import io.micronaut.websocket.annotation.ClientWebSocket;
import io.micronaut.websocket.annotation.OnMessage;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.EmptyByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

@Internal
public class DefaultHttpClient
implements WebSocketClient,
HttpClient,
StreamingHttpClient,
SseClient,
ProxyHttpClient,
Closeable,
AutoCloseable {
    private static final Logger DEFAULT_LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final HttpHeaders REDIRECT_HEADER_BLOCKLIST = new DefaultHttpHeaders();
    protected MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected ByteBufferFactory<ByteBufAllocator, ByteBuf> byteBufferFactory = new NettyByteBufferFactory();
    ConnectionManager connectionManager;
    private final List<HttpFilterResolver.FilterEntry> clientFilterEntries;
    private final LoadBalancer loadBalancer;
    private final HttpClientConfiguration configuration;
    private final String contextPath;
    private final Charset defaultCharset;
    private final Logger log;
    private final HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver;
    private final WebSocketBeanRegistry webSocketRegistry;
    private final RequestBinderRegistry requestBinderRegistry;
    private final List<InvocationInstrumenterFactory> invocationInstrumenterFactories;
    private final String informationalServiceId;
    private final ConversionService conversionService;

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @Nullable ThreadFactory threadFactory, NettyClientSslBuilder nettyClientSslBuilder, MediaTypeCodecRegistry codecRegistry, @Nullable AnnotationMetadataResolver annotationMetadataResolver, List<InvocationInstrumenterFactory> invocationInstrumenterFactories, ConversionService conversionService, HttpClientFilter ... filters) {
        this(loadBalancer, null, configuration, contextPath, (HttpClientFilterResolver<ClientFilterResolutionContext>)new DefaultHttpClientFilterResolver(null, annotationMetadataResolver, Arrays.asList(filters)), null, threadFactory, nettyClientSslBuilder, codecRegistry, WebSocketBeanRegistry.EMPTY, (RequestBinderRegistry)new DefaultRequestBinderRegistry(conversionService, new RequestArgumentBinder[0]), null, (ChannelFactory<? extends SocketChannel>)((ChannelFactory)NioSocketChannel::new), (ChannelFactory<? extends DatagramChannel>)((ChannelFactory)NioDatagramChannel::new), CompositeNettyClientCustomizer.EMPTY, invocationInstrumenterFactories, null, conversionService);
    }

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, @Nullable HttpVersionSelection explicitHttpVersion, @NonNull HttpClientConfiguration configuration, @Nullable String contextPath, @NonNull HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver, List<HttpFilterResolver.FilterEntry> clientFilterEntries, @Nullable ThreadFactory threadFactory, @NonNull NettyClientSslBuilder nettyClientSslBuilder, @NonNull MediaTypeCodecRegistry codecRegistry, @NonNull WebSocketBeanRegistry webSocketBeanRegistry, @NonNull RequestBinderRegistry requestBinderRegistry, @Nullable EventLoopGroup eventLoopGroup, @NonNull ChannelFactory<? extends SocketChannel> socketChannelFactory, @NonNull ChannelFactory<? extends DatagramChannel> udpChannelFactory, NettyClientCustomizer clientCustomizer, List<InvocationInstrumenterFactory> invocationInstrumenterFactories, @Nullable String informationalServiceId, ConversionService conversionService) {
        ArgumentUtils.requireNonNull((String)"nettyClientSslBuilder", (Object)((Object)nettyClientSslBuilder));
        ArgumentUtils.requireNonNull((String)"codecRegistry", (Object)codecRegistry);
        ArgumentUtils.requireNonNull((String)"webSocketBeanRegistry", (Object)webSocketBeanRegistry);
        ArgumentUtils.requireNonNull((String)"requestBinderRegistry", (Object)requestBinderRegistry);
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        ArgumentUtils.requireNonNull((String)"filterResolver", filterResolver);
        ArgumentUtils.requireNonNull((String)"socketChannelFactory", socketChannelFactory);
        this.loadBalancer = loadBalancer;
        this.defaultCharset = configuration.getDefaultCharset();
        if (StringUtils.isNotEmpty((CharSequence)contextPath)) {
            if (((String)contextPath).charAt(0) != '/') {
                contextPath = "/" + (String)contextPath;
            }
            this.contextPath = contextPath;
        } else {
            this.contextPath = null;
        }
        this.configuration = configuration;
        this.invocationInstrumenterFactories = invocationInstrumenterFactories == null ? Collections.emptyList() : invocationInstrumenterFactories;
        this.mediaTypeCodecRegistry = codecRegistry;
        this.log = configuration.getLoggerName().map(LoggerFactory::getLogger).orElse(DEFAULT_LOG);
        this.filterResolver = filterResolver;
        this.clientFilterEntries = clientFilterEntries != null ? clientFilterEntries : filterResolver.resolveFilterEntries((AnnotationMetadataProvider)new ClientFilterResolutionContext(null, AnnotationMetadata.EMPTY_METADATA));
        this.webSocketRegistry = webSocketBeanRegistry != null ? webSocketBeanRegistry : WebSocketBeanRegistry.EMPTY;
        this.requestBinderRegistry = requestBinderRegistry;
        this.informationalServiceId = informationalServiceId;
        this.conversionService = conversionService;
        this.connectionManager = new ConnectionManager(this.log, eventLoopGroup, threadFactory, configuration, explicitHttpVersion, this.combineFactories(), socketChannelFactory, udpChannelFactory, nettyClientSslBuilder, clientCustomizer, informationalServiceId);
    }

    public DefaultHttpClient(@Nullable URI uri) {
        this(uri, (HttpClientConfiguration)new DefaultHttpClientConfiguration());
    }

    public DefaultHttpClient() {
        this(null, (HttpClientConfiguration)new DefaultHttpClientConfiguration(), Collections.emptyList());
    }

    public DefaultHttpClient(@Nullable URI uri, @NonNull HttpClientConfiguration configuration) {
        this(uri == null ? null : LoadBalancer.fixed((URI)uri), configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, Collections.emptyList(), ConversionService.SHARED, new HttpClientFilter[0]);
    }

    public DefaultHttpClient(@Nullable LoadBalancer loadBalancer, HttpClientConfiguration configuration, List<InvocationInstrumenterFactory> invocationInstrumenterFactories) {
        this(loadBalancer, configuration, null, (ThreadFactory)new DefaultThreadFactory(MultithreadEventLoopGroup.class), new NettyClientSslBuilder(new ResourceResolver()), DefaultHttpClient.createDefaultMediaTypeRegistry(), AnnotationMetadataResolver.DEFAULT, invocationInstrumenterFactories, ConversionService.SHARED, new HttpClientFilter[0]);
    }

    static boolean isAcceptEvents(HttpRequest<?> request) {
        String acceptHeader = (String)request.getHeaders().get((CharSequence)"Accept");
        return acceptHeader != null && acceptHeader.equalsIgnoreCase("text/event-stream");
    }

    public HttpClientConfiguration getConfiguration() {
        return this.configuration;
    }

    public Logger getLog() {
        return this.log;
    }

    public ConnectionManager connectionManager() {
        return this.connectionManager;
    }

    public HttpClient start() {
        if (!this.isRunning()) {
            this.connectionManager.start();
        }
        return this;
    }

    public boolean isRunning() {
        return this.connectionManager.isRunning();
    }

    public HttpClient stop() {
        if (this.isRunning()) {
            this.connectionManager.shutdown();
        }
        return this;
    }

    public MediaTypeCodecRegistry getMediaTypeCodecRegistry() {
        return this.mediaTypeCodecRegistry;
    }

    public void setMediaTypeCodecRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        if (mediaTypeCodecRegistry != null) {
            this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        }
    }

    public BlockingHttpClient toBlocking() {
        return new BlockingHttpClient(){

            public void close() {
                DefaultHttpClient.this.close();
            }

            public <I, O, E> HttpResponse<O> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
                BlockHint blockHint = BlockHint.willBlockThisThread();
                Flux publisher = Flux.from(DefaultHttpClient.this.exchange(request, bodyType, errorType, blockHint));
                return (HttpResponse)publisher.doOnNext(res -> {
                    Optional byteBuf = res.getBody(ByteBuf.class);
                    byteBuf.ifPresent(bb -> {
                        if (bb.refCnt() > 0) {
                            ReferenceCountUtil.safeRelease((Object)bb);
                        }
                    });
                    if (res instanceof FullNettyClientHttpResponse) {
                        ((FullNettyClientHttpResponse)res).onComplete();
                    }
                }).blockFirst();
            }

            public <I, O, E> O retrieve(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
                HttpResponse response = this.exchange(request, bodyType, errorType);
                if (HttpStatus.class.isAssignableFrom(bodyType.getType())) {
                    return (O)response.getStatus();
                }
                Optional body = response.getBody();
                if (!body.isPresent() && response.getBody(Argument.of(byte[].class)).isPresent()) {
                    throw DefaultHttpClient.this.decorate(new HttpClientResponseException(String.format("Failed to decode the body for the given content type [%s]", response.getContentType().orElse(null)), response));
                }
                return (O)body.orElseThrow(() -> DefaultHttpClient.this.decorate(new HttpClientResponseException("Empty body", response)));
            }
        };
    }

    @NonNull
    private <I> MutableHttpRequest<?> toMutableRequest(HttpRequest<I> request) {
        return MutableHttpRequestWrapper.wrapIfNecessary(this.conversionService, request);
    }

    public <I> Publisher<Event<ByteBuffer<?>>> eventStream(@NonNull HttpRequest<I> request) {
        this.setupConversionService(request);
        return this.eventStreamOrError(request, null);
    }

    private <I> Publisher<Event<ByteBuffer<?>>> eventStreamOrError(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        if (request instanceof MutableHttpRequest) {
            ((MutableHttpRequest)request).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM_TYPE});
        }
        return Flux.create(emitter -> this.dataStream(request, errorType).subscribe(new Subscriber<ByteBuffer<?>>(){
            private Subscription dataSubscription;
            private CurrentEvent currentEvent;
            final /* synthetic */ FluxSink val$emitter;
            {
                this.val$emitter = fluxSink;
            }

            public void onSubscribe(Subscription s) {
                this.dataSubscription = s;
                Disposable cancellable = () -> this.dataSubscription.cancel();
                this.val$emitter.onCancel(cancellable);
                if (!this.val$emitter.isCancelled() && this.val$emitter.requestedFromDownstream() > 0L) {
                    this.dataSubscription.request(1L);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ByteBuffer<?> buffer) {
                try {
                    int len = buffer.readableBytes();
                    if (len == 0) {
                        try {
                            Event event = Event.of((Object)DefaultHttpClient.this.byteBufferFactory.wrap(this.currentEvent.data)).name(this.currentEvent.name).retry(this.currentEvent.retry).id(this.currentEvent.id);
                            this.val$emitter.next((Object)event);
                        }
                        finally {
                            this.currentEvent = null;
                        }
                    } else {
                        int colonIndex;
                        if (this.currentEvent == null) {
                            this.currentEvent = new CurrentEvent();
                        }
                        if ((colonIndex = buffer.indexOf((byte)58)) > 0) {
                            String type = buffer.slice(0, colonIndex).toString(StandardCharsets.UTF_8).trim();
                            int fromIndex = colonIndex + 1;
                            if (buffer.getByte(fromIndex) == 32) {
                                ++fromIndex;
                            }
                            if (fromIndex < len) {
                                int toIndex = len - fromIndex;
                                switch (type) {
                                    case "data": {
                                        ByteBuffer content = buffer.slice(fromIndex, toIndex);
                                        byte[] d = this.currentEvent.data;
                                        if (d == null) {
                                            this.currentEvent.data = content.toByteArray();
                                            break;
                                        }
                                        this.currentEvent.data = ArrayUtils.concat((byte[])d, (byte[])content.toByteArray());
                                        break;
                                    }
                                    case "id": {
                                        ByteBuffer id = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.id = id.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "event": {
                                        ByteBuffer event = buffer.slice(fromIndex, toIndex);
                                        this.currentEvent.name = event.toString(StandardCharsets.UTF_8).trim();
                                        break;
                                    }
                                    case "retry": {
                                        ByteBuffer retry = buffer.slice(fromIndex, toIndex);
                                        String text = retry.toString(StandardCharsets.UTF_8);
                                        if (StringUtils.isEmpty((CharSequence)text)) break;
                                        Long millis = Long.valueOf(text);
                                        this.currentEvent.retry = Duration.ofMillis(millis);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (this.val$emitter.requestedFromDownstream() > 0L && !this.val$emitter.isCancelled()) {
                        this.dataSubscription.request(1L);
                    }
                }
                catch (Throwable e) {
                    this.onError(e);
                }
                finally {
                    if (buffer instanceof ReferenceCounted) {
                        ((ReferenceCounted)buffer).release();
                    }
                }
            }

            public void onError(Throwable t) {
                this.dataSubscription.cancel();
                if (t instanceof HttpClientException) {
                    this.val$emitter.error(t);
                } else {
                    this.val$emitter.error((Throwable)DefaultHttpClient.this.decorate(new HttpClientException("Error consuming Server Sent Events: " + t.getMessage(), t)));
                }
            }

            public void onComplete() {
                this.val$emitter.complete();
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.BUFFER);
    }

    public <I, B> Publisher<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType) {
        this.setupConversionService(request);
        return this.eventStream(request, eventType, DEFAULT_ERROR_TYPE);
    }

    public <I, B> Publisher<Event<B>> eventStream(@NonNull HttpRequest<I> request, @NonNull Argument<B> eventType, @NonNull Argument<?> errorType) {
        this.setupConversionService(request);
        return Flux.from(this.eventStreamOrError(request, errorType)).map(byteBufferEvent -> {
            ByteBuffer data = (ByteBuffer)byteBufferEvent.getData();
            Optional registeredCodec = this.mediaTypeCodecRegistry != null ? this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE) : Optional.empty();
            if (registeredCodec.isPresent()) {
                Object decoded = ((MediaTypeCodec)registeredCodec.get()).decode(eventType, data);
                return Event.of((Event)byteBufferEvent, (Object)decoded);
            }
            throw new CodecException("JSON codec not present");
        });
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request) {
        this.setupConversionService(request);
        return this.dataStream(request, DEFAULT_ERROR_TYPE);
    }

    public <I> Publisher<ByteBuffer<?>> dataStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        this.setupConversionService(request);
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return new MicronautFlux<ByteBuffer>(Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> this.dataStreamImpl((MutableHttpRequest)this.toMutableRequest(request), errorType, (HttpRequest<Object>)parentRequest, (URI)requestURI))).doAfterNext(buffer -> {
            ByteBuf byteBuf;
            Object o = buffer.asNativeBuffer();
            if (o instanceof ByteBuf && (byteBuf = (ByteBuf)o).refCnt() > 0) {
                ReferenceCountUtil.safeRelease((Object)byteBuf);
            }
        });
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request) {
        return this.exchangeStream(request, DEFAULT_ERROR_TYPE);
    }

    public <I> Publisher<HttpResponse<ByteBuffer<?>>> exchangeStream(@NonNull HttpRequest<I> request, @NonNull Argument<?> errorType) {
        this.setupConversionService(request);
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        return new MicronautFlux<HttpResponse>(Flux.from(this.resolveRequestURI(request)).flatMap(uri -> this.exchangeStreamImpl((HttpRequest<Object>)parentRequest, (MutableHttpRequest)this.toMutableRequest(request), errorType, (URI)uri))).doAfterNext(byteBufferHttpResponse -> {
            ByteBuffer buffer = (ByteBuffer)byteBufferHttpResponse.body();
            if (buffer instanceof ReferenceCounted) {
                ((ReferenceCounted)buffer).release();
            }
        });
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type) {
        return this.jsonStream(request, type, DEFAULT_ERROR_TYPE);
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Argument<O> type, @NonNull Argument<?> errorType) {
        this.setupConversionService(request);
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        this.setupConversionService(parentRequest);
        return Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> this.jsonStreamImpl((HttpRequest<?>)parentRequest, (MutableHttpRequest)this.toMutableRequest(request), type, errorType, (URI)requestURI));
    }

    public <I> Publisher<Map<String, Object>> jsonStream(@NonNull HttpRequest<I> request) {
        return this.jsonStream(request, Map.class);
    }

    public <I, O> Publisher<O> jsonStream(@NonNull HttpRequest<I> request, @NonNull Class<O> type) {
        this.setupConversionService(request);
        return this.jsonStream(request, Argument.of(type));
    }

    public <I, O, E> Publisher<HttpResponse<O>> exchange(@NonNull HttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType) {
        return this.exchange(request, bodyType, errorType, null);
    }

    @NonNull
    private <I, O, E> Flux<HttpResponse<O>> exchange(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType, @Nullable BlockHint blockHint) {
        this.setupConversionService(request);
        HttpRequest parentRequest = ServerRequestContext.currentRequest().orElse(null);
        Publisher<URI> uriPublisher = this.resolveRequestURI(request);
        return Flux.from(uriPublisher).switchMap(uri -> this.exchangeImpl((URI)uri, (HttpRequest<?>)parentRequest, (MutableHttpRequest)this.toMutableRequest(request), bodyType, errorType, blockHint));
    }

    public <I, O, E> Publisher<O> retrieve(HttpRequest<I> request, Argument<O> bodyType, Argument<E> errorType) {
        this.setupConversionService(request);
        Flux exchange = Flux.from(this.exchange(request, bodyType, errorType));
        if (bodyType.getType() == Void.TYPE) {
            return exchange.ignoreElements();
        }
        return exchange.map(response -> {
            if (bodyType.getType() == HttpStatus.class) {
                return response.getStatus();
            }
            Optional body = response.getBody();
            if (!body.isPresent() && response.getBody(byte[].class).isPresent()) {
                throw this.decorate(new HttpClientResponseException(String.format("Failed to decode the body for the given content type [%s]", response.getContentType().orElse(null)), response));
            }
            return body.orElseThrow(() -> this.decorate(new HttpClientResponseException("Empty body", response)));
        });
    }

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, MutableHttpRequest<?> request) {
        this.setupConversionService((HttpRequest<?>)request);
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flux.from(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, request, clientEndpointType, null));
    }

    public <T extends AutoCloseable> Publisher<T> connect(Class<T> clientEndpointType, Map<String, Object> parameters) {
        WebSocketBean webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        String uri = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class).orElse("/ws");
        uri = UriTemplate.of((String)uri).expand(parameters);
        MutableHttpRequest request = HttpRequest.GET((String)uri);
        Publisher<URI> uriPublisher = this.resolveRequestURI((HttpRequest)request);
        return Flux.from(uriPublisher).switchMap(resolvedURI -> this.connectWebSocket((URI)resolvedURI, (MutableHttpRequest<?>)request, clientEndpointType, (WebSocketBean)webSocketBean));
    }

    @Override
    public void close() {
        this.stop();
    }

    private <T> Publisher<T> connectWebSocket(URI uri, MutableHttpRequest<?> request, Class<T> clientEndpointType, WebSocketBean<T> webSocketBean) {
        RequestKey requestKey;
        try {
            requestKey = new RequestKey(this, uri);
        }
        catch (HttpClientException e) {
            return Flux.error((Throwable)e);
        }
        if (webSocketBean == null) {
            webSocketBean = this.webSocketRegistry.getWebSocket(clientEndpointType);
        }
        WebSocketVersion protocolVersion = webSocketBean.getBeanDefinition().enumValue(ClientWebSocket.class, "version", WebSocketVersion.class).orElse(WebSocketVersion.V13);
        int maxFramePayloadLength = webSocketBean.messageMethod().map(m -> m.intValue(OnMessage.class, "maxPayloadLength").orElse(65536)).orElse(65536);
        String subprotocol = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class, "subprotocol").orElse("");
        URI webSocketURL = UriBuilder.of((URI)uri).scheme(!requestKey.isSecure() ? "ws" : "wss").host(requestKey.getHost()).port(requestKey.getPort()).build();
        MutableHttpHeaders headers = request.getHeaders();
        EmptyHttpHeaders customHeaders = EmptyHttpHeaders.INSTANCE;
        if (headers instanceof NettyHttpHeaders) {
            customHeaders = ((NettyHttpHeaders)headers).getNettyHeaders();
        }
        if (StringUtils.isNotEmpty((CharSequence)subprotocol)) {
            NettyHttpHeaders.validateHeader((CharSequence)"Sec-WebSocket-Protocol", (CharSequence)subprotocol);
            customHeaders.add("Sec-WebSocket-Protocol", (Object)subprotocol);
        }
        NettyWebSocketClientHandler handler = new NettyWebSocketClientHandler(request, webSocketBean, WebSocketClientHandshakerFactory.newHandshaker((URI)webSocketURL, (WebSocketVersion)protocolVersion, (String)subprotocol, (boolean)true, (HttpHeaders)customHeaders, (int)maxFramePayloadLength), this.requestBinderRegistry, this.mediaTypeCodecRegistry, this.conversionService);
        return this.connectionManager.connectForWebsocket(requestKey, (ChannelHandler)handler).then(handler.getHandshakeCompletedMono());
    }

    private <I> Flux<HttpResponse<ByteBuffer<?>>> exchangeStreamImpl(HttpRequest<Object> parentRequest, MutableHttpRequest<I> request, Argument<?> errorType, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        return streamResponsePublisher.switchMap(response -> {
            StreamedHttpResponse streamedHttpResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
            Flux httpContentReactiveSequence = Flux.from((Publisher)streamedHttpResponse);
            return httpContentReactiveSequence.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(message -> {
                ByteBuf byteBuf = message.content();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{byteBuf.readableBytes(), request.getMethodName(), request.getUri()});
                    this.traceBody("Response", byteBuf);
                }
                ByteBuffer byteBuffer = this.byteBufferFactory.wrap((Object)byteBuf);
                NettyStreamedHttpResponse<ByteBuffer> thisResponse = new NettyStreamedHttpResponse<ByteBuffer>(streamedHttpResponse, this.conversionService);
                thisResponse.setBody(byteBuffer);
                return new HttpResponseWrapper(thisResponse);
            });
        });
    }

    private <I, O> Flux<O> jsonStreamImpl(HttpRequest<?> parentRequest, MutableHttpRequest<I> request, Argument<O> type, Argument<?> errorType, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        return streamResponsePublisher.switchMap(response -> {
            if (!(response instanceof NettyStreamedHttpResponse)) {
                throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
            }
            MapperMediaTypeCodec mediaTypeCodec = (MapperMediaTypeCodec)this.mediaTypeCodecRegistry.findCodec(MediaType.APPLICATION_JSON_TYPE).orElseThrow(() -> new IllegalStateException("No JSON codec found"));
            StreamedHttpResponse streamResponse = NettyHttpResponseBuilder.toStreamResponse((HttpResponse)response);
            Flux httpContentReactiveSequence = Flux.from((Publisher)streamResponse);
            boolean isJsonStream = response.getContentType().map(mediaType -> mediaType.equals((Object)MediaType.APPLICATION_JSON_STREAM_TYPE)).orElse(false);
            boolean streamArray = !Iterable.class.isAssignableFrom(type.getType()) && !isJsonStream;
            Processor jsonProcessor = mediaTypeCodec.getJsonMapper().createReactiveParser(p -> httpContentReactiveSequence.map(content -> {
                ByteBuf chunk = content.content();
                if (this.log.isTraceEnabled()) {
                    this.log.trace("HTTP Client Streaming Response Received Chunk (length: {}) for Request: {} {}", new Object[]{chunk.readableBytes(), request.getMethodName(), request.getUri()});
                    this.traceBody("Chunk", chunk);
                }
                try {
                    byte[] byArray = ByteBufUtil.getBytes((ByteBuf)chunk);
                    return byArray;
                }
                finally {
                    chunk.release();
                }
            }).subscribe((Subscriber)p), streamArray);
            return Flux.from((Publisher)jsonProcessor).map(jsonNode -> mediaTypeCodec.decode(type, jsonNode));
        });
    }

    private <I> Flux<ByteBuffer<?>> dataStreamImpl(MutableHttpRequest<I> request, Argument<?> errorType, HttpRequest<Object> parentRequest, URI requestURI) {
        Flux streamResponsePublisher = Flux.from(this.buildStreamExchange(parentRequest, request, requestURI, errorType));
        Function<HttpContent, ByteBuffer> contentMapper = message -> {
            ByteBuf byteBuf = message.content();
            return this.byteBufferFactory.wrap((Object)byteBuf);
        };
        return streamResponsePublisher.switchMap(response -> {
            if (!(response instanceof NettyStreamedHttpResponse)) {
                throw new IllegalStateException("Response has been wrapped in non streaming type. Do not wrap the response in client filters for stream requests");
            }
            NettyStreamedHttpResponse nettyStreamedHttpResponse = (NettyStreamedHttpResponse)response;
            Flux httpContentReactiveSequence = Flux.from((Publisher)nettyStreamedHttpResponse.getNettyResponse());
            return httpContentReactiveSequence.filter(message -> !(message.content() instanceof EmptyByteBuf)).map(contentMapper);
        });
    }

    private <I> Publisher<MutableHttpResponse<?>> buildStreamExchange(@Nullable HttpRequest<?> parentRequest, @NonNull MutableHttpRequest<I> request, @NonNull URI requestURI, @Nullable Argument<?> errorType) {
        AtomicReference requestWrapper = new AtomicReference(request);
        Flux streamResponsePublisher = this.connectAndStream(parentRequest, (HttpRequest<I>)request, requestURI, requestWrapper, false, true);
        streamResponsePublisher = this.readBodyOnError(errorType, streamResponsePublisher);
        streamResponsePublisher = Flux.from(this.applyFilterToResponsePublisher(parentRequest, (HttpRequest<I>)request, requestURI, requestWrapper, (Publisher)streamResponsePublisher));
        return streamResponsePublisher;
    }

    public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> request) {
        return this.proxy(request, ProxyRequestOptions.getDefault());
    }

    public Publisher<MutableHttpResponse<?>> proxy(@NonNull HttpRequest<?> request, @NonNull ProxyRequestOptions options) {
        Objects.requireNonNull(options, "options");
        this.setupConversionService(request);
        return Flux.from(this.resolveRequestURI(request)).flatMap(requestURI -> {
            MutableHttpRequest<?> httpRequest = this.toMutableRequest(request);
            if (!options.isRetainHostHeader()) {
                httpRequest.headers(headers -> headers.remove((CharSequence)HttpHeaderNames.HOST));
            }
            AtomicReference requestWrapper = new AtomicReference(httpRequest);
            Flux proxyResponsePublisher = this.connectAndStream(request, (HttpRequest)request, (URI)requestURI, requestWrapper, true, false);
            proxyResponsePublisher = Flux.from(this.applyFilterToResponsePublisher(request, (HttpRequest)((HttpRequest)requestWrapper.get()), (URI)requestURI, requestWrapper, (Publisher)proxyResponsePublisher));
            return proxyResponsePublisher;
        });
    }

    private void setupConversionService(HttpRequest<?> httpRequest) {
        if (httpRequest instanceof ConversionServiceAware) {
            ((ConversionServiceAware)httpRequest).setConversionService(this.conversionService);
        }
    }

    private <I> Flux<MutableHttpResponse<?>> connectAndStream(HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI, AtomicReference<MutableHttpRequest<?>> requestWrapper, boolean isProxy, boolean failOnError) {
        RequestKey requestKey;
        try {
            requestKey = new RequestKey(this, requestURI);
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
        return this.connectionManager.connect(requestKey, null).flatMapMany(poolHandle -> {
            request.setAttribute(NettyClientHttpRequest.CHANNEL, (Object)poolHandle.channel);
            boolean sse = !isProxy && DefaultHttpClient.isAcceptEvents(request);
            poolHandle.channel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter((ConnectionManager.PoolHandle)poolHandle){
                boolean ignoreOneLast = false;
                final /* synthetic */ ConnectionManager.PoolHandle val$poolHandle;
                {
                    this.val$poolHandle = poolHandle;
                }

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (msg instanceof io.netty.handler.codec.http.HttpResponse && ((io.netty.handler.codec.http.HttpResponse)msg).status().equals((Object)HttpResponseStatus.CONTINUE)) {
                        this.ignoreOneLast = true;
                    }
                    super.channelRead(ctx, msg);
                    if (msg instanceof LastHttpContent) {
                        if (this.ignoreOneLast) {
                            this.ignoreOneLast = false;
                        } else {
                            ctx.pipeline().remove("http-streams-codec");
                            ctx.pipeline().remove((ChannelHandler)this);
                        }
                    }
                }

                public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
                    this.val$poolHandle.release();
                }
            }});
            if (sse) {
                poolHandle.channel.pipeline().addLast("micronaut-sse-event-stream", (ChannelHandler)new HttpLineBasedFrameDecoder(this.configuration.getMaxContentLength(), true, true));
            }
            poolHandle.channel.pipeline().addLast("http-streams-codec", (ChannelHandler)new HttpStreamsClientHandler());
            return this.streamRequestThroughChannel(parentRequest, (MutableHttpRequest<?>)((MutableHttpRequest)requestWrapper.get()), (ConnectionManager.PoolHandle)poolHandle, failOnError, requestKey.isSecure());
        });
    }

    private <I, O, E> Publisher<? extends HttpResponse<O>> exchangeImpl(URI requestURI, HttpRequest<?> parentRequest, MutableHttpRequest<I> request, @NonNull Argument<O> bodyType, @NonNull Argument<E> errorType, @Nullable BlockHint blockHint) {
        Duration rt;
        RequestKey requestKey;
        AtomicReference requestWrapper = new AtomicReference(request);
        try {
            requestKey = new RequestKey(this, requestURI);
        }
        catch (HttpClientException e) {
            return Flux.error((Throwable)e);
        }
        Mono<ConnectionManager.PoolHandle> handlePublisher = this.connectionManager.connect(requestKey, blockHint);
        Flux responsePublisher = handlePublisher.flatMapMany(poolHandle -> {
            poolHandle.channel.pipeline().addLast("http-aggregator", (ChannelHandler)new HttpObjectAggregator(this.configuration.getMaxContentLength()){

                protected void finishAggregation(FullHttpMessage aggregated) throws Exception {
                    if (!HttpUtil.isContentLengthSet((HttpMessage)aggregated) && aggregated.content().readableBytes() > 0) {
                        super.finishAggregation(aggregated);
                    }
                }
            }).addLast("http-streams-codec", (ChannelHandler)new HttpStreamsClientHandler());
            return Flux.create(emitter -> {
                try {
                    this.sendRequestThroughChannel((HttpRequest)((HttpRequest)requestWrapper.get()), bodyType, errorType, (FluxSink)emitter, requestKey.isSecure(), (ConnectionManager.PoolHandle)poolHandle);
                }
                catch (Exception e) {
                    emitter.error((Throwable)e);
                }
            });
        });
        Publisher finalPublisher = this.applyFilterToResponsePublisher(parentRequest, (HttpRequest<I>)request, requestURI, requestWrapper, (Publisher)responsePublisher);
        Flux finalReactiveSequence = Flux.from(finalPublisher);
        Optional readTimeout = this.configuration.getReadTimeout();
        if (readTimeout.isPresent() && !(rt = (Duration)readTimeout.get()).isNegative()) {
            Duration duration = rt.plus(Duration.ofSeconds(1L));
            finalReactiveSequence = finalReactiveSequence.timeout(duration).onErrorResume(throwable -> {
                if (throwable instanceof TimeoutException) {
                    return Flux.error((Throwable)ReadTimeoutException.TIMEOUT_EXCEPTION);
                }
                return Flux.error((Throwable)throwable);
            });
        }
        return finalReactiveSequence;
    }

    protected <I> Publisher<URI> resolveRequestURI(HttpRequest<I> request) {
        return this.resolveRequestURI(request, true);
    }

    protected <I> Publisher<URI> resolveRequestURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Flux.just((Object)requestURI);
        }
        return this.resolveURI(request, includeContextPath);
    }

    protected <I> Publisher<URI> resolveRedirectURI(HttpRequest<?> parentRequest, HttpRequest<I> request) {
        URI requestURI = request.getUri();
        if (requestURI.getScheme() != null) {
            return Flux.just((Object)requestURI);
        }
        if (parentRequest == null || parentRequest.getUri().getHost() == null) {
            return this.resolveURI(request, false);
        }
        URI parentURI = parentRequest.getUri();
        UriBuilder uriBuilder = UriBuilder.of((URI)requestURI).scheme(parentURI.getScheme()).userInfo(parentURI.getUserInfo()).host(parentURI.getHost()).port(parentURI.getPort());
        return Flux.just((Object)uriBuilder.build());
    }

    protected Object getLoadBalancerDiscriminator() {
        return null;
    }

    private <I, R extends HttpResponse<?>> Publisher<R> applyFilterToResponsePublisher(HttpRequest<?> parentRequest, HttpRequest<I> request, URI requestURI, AtomicReference<MutableHttpRequest<?>> requestWrapper, Publisher<R> responsePublisher) {
        if (!(request instanceof MutableHttpRequest)) {
            return responsePublisher;
        }
        MutableHttpRequest mutRequest = (MutableHttpRequest)request;
        mutRequest.uri(requestURI);
        if (this.informationalServiceId != null && !mutRequest.getAttribute((CharSequence)HttpAttributes.SERVICE_ID).isPresent()) {
            mutRequest.setAttribute((CharSequence)HttpAttributes.SERVICE_ID, (Object)this.informationalServiceId);
        }
        List filters = this.filterResolver.resolveFilters(request, this.clientFilterEntries);
        if (parentRequest != null) {
            filters.add(new GenericHttpFilter.AroundLegacy((HttpFilter)new ClientServerContextFilter(parentRequest), (FilterOrder)new FilterOrder.Fixed(Integer.MIN_VALUE)));
        }
        FilterRunner.sortReverse((List)filters);
        filters.add(new GenericHttpFilter.TerminalReactive(responsePublisher));
        FilterRunner runner = new FilterRunner(filters);
        Mono responseMono = Mono.from((Publisher)ReactiveExecutionFlow.fromFlow((ExecutionFlow)runner.run(request)).toPublisher());
        if (parentRequest != null) {
            responseMono = responseMono.contextWrite(c -> {
                if (c.hasKey((Object)"micronaut.http.server.request")) {
                    return c;
                }
                return c.put((Object)"micronaut.http.server.request", (Object)parentRequest);
            });
        }
        return responseMono;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected NettyRequestWriter buildNettyRequest(MutableHttpRequest request, URI requestURI, MediaType requestContentType, boolean permitsBody, @Nullable Argument<?> bodyType, Consumer<? super Throwable> onError) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        io.netty.handler.codec.http.HttpRequest nettyRequest;
        HttpPostRequestEncoder postRequestEncoder;
        block20: {
            block21: {
                postRequestEncoder = null;
                if (!permitsBody) break block21;
                Optional body = request.getBody();
                boolean hasBody = body.isPresent();
                if (requestContentType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE) && hasBody) {
                    Object bodyValue = body.get();
                    if (bodyValue instanceof CharSequence) {
                        ByteBuf byteBuf = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                        request.body((Object)byteBuf);
                        nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                        break block20;
                    } else {
                        postRequestEncoder = this.buildFormDataRequest(request, bodyValue);
                        nettyRequest = postRequestEncoder.finalizeRequest();
                    }
                    break block20;
                } else if (requestContentType.equals((Object)MediaType.MULTIPART_FORM_DATA_TYPE) && hasBody) {
                    Object bodyValue = body.get();
                    postRequestEncoder = this.buildMultipartRequest(request, bodyValue);
                    nettyRequest = postRequestEncoder.finalizeRequest();
                    break block20;
                } else {
                    ByteBuf bodyContent = null;
                    if (hasBody) {
                        Object bodyValue = body.get();
                        if (Publishers.isConvertibleToPublisher(bodyValue)) {
                            boolean isSingle = Publishers.isSingle(bodyValue.getClass());
                            Publisher publisher = (Publisher)this.conversionService.convert(bodyValue, Publisher.class).orElseThrow(() -> new IllegalArgumentException("Unconvertible reactive type: " + bodyValue));
                            Flux requestBodyPublisher = Flux.from((Publisher)publisher).map(o -> {
                                Optional registeredCodec;
                                ByteBuf encoded;
                                if (o instanceof CharSequence) {
                                    ByteBuf textChunk = Unpooled.copiedBuffer((CharSequence)((CharSequence)o), (Charset)requestContentType.getCharset().orElse(StandardCharsets.UTF_8));
                                    if (this.log.isTraceEnabled()) {
                                        this.traceChunk(textChunk);
                                    }
                                    return new DefaultHttpContent(textChunk);
                                }
                                if (o instanceof ByteBuf) {
                                    ByteBuf byteBuf = (ByteBuf)o;
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)byteBuf.readableBytes());
                                    }
                                    return new DefaultHttpContent(byteBuf);
                                }
                                if (o instanceof byte[]) {
                                    byte[] bodyBytes = (byte[])o;
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)bodyBytes.length);
                                    }
                                    return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])bodyBytes));
                                }
                                if (o instanceof ByteBuffer) {
                                    ByteBuffer byteBuffer = (ByteBuffer)o;
                                    Object nativeBuffer = byteBuffer.asNativeBuffer();
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace("Sending Bytes Chunk. Length: {}", (Object)byteBuffer.readableBytes());
                                    }
                                    if (nativeBuffer instanceof ByteBuf) {
                                        return new DefaultHttpContent((ByteBuf)nativeBuffer);
                                    }
                                    return new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])byteBuffer.toByteArray()));
                                }
                                if (this.mediaTypeCodecRegistry != null && (encoded = (ByteBuf)(registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType)).map(codec -> {
                                    if (bodyType != null && bodyType.isInstance(o)) {
                                        return (ByteBuf)codec.encode(bodyType, o, this.byteBufferFactory).asNativeBuffer();
                                    }
                                    return (ByteBuf)codec.encode(o, this.byteBufferFactory).asNativeBuffer();
                                }).orElse(null)) != null) {
                                    if (this.log.isTraceEnabled()) {
                                        this.traceChunk(encoded);
                                    }
                                    return new DefaultHttpContent(encoded);
                                }
                                throw new CodecException("Cannot encode value [" + o + "]. No possible encoders found");
                            });
                            if (!isSingle && MediaType.APPLICATION_JSON_TYPE.equals((Object)requestContentType)) {
                                requestBodyPublisher = JsonSubscriber.lift((Publisher)requestBodyPublisher);
                            }
                            requestBodyPublisher = requestBodyPublisher.doOnError(onError);
                            request.body((Object)requestBodyPublisher);
                            io.netty.handler.codec.http.HttpRequest nettyRequest2 = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                            try {
                                nettyRequest2.setUri(requestURI.toURL().getFile());
                                return new NettyRequestWriter(nettyRequest2, null);
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            return new NettyRequestWriter(nettyRequest2, null);
                        }
                        if (bodyValue instanceof CharSequence) {
                            bodyContent = this.charSequenceToByteBuf((CharSequence)bodyValue, requestContentType);
                        } else if (this.mediaTypeCodecRegistry != null) {
                            Optional registeredCodec = this.mediaTypeCodecRegistry.findCodec(requestContentType);
                            bodyContent = registeredCodec.map(codec -> {
                                if (bodyType != null && bodyType.isInstance(bodyValue)) {
                                    return (ByteBuf)codec.encode(bodyType, bodyValue, this.byteBufferFactory).asNativeBuffer();
                                }
                                return (ByteBuf)codec.encode(bodyValue, this.byteBufferFactory).asNativeBuffer();
                            }).orElse(null);
                        }
                        if (bodyContent == null) {
                            bodyContent = (ByteBuf)this.conversionService.convert(bodyValue, ByteBuf.class).orElseThrow(() -> this.decorate(new HttpClientException("Body [" + bodyValue + "] cannot be encoded to content type [" + requestContentType + "]. No possible codecs or converters found.")));
                        }
                    }
                    request.body(bodyContent);
                    try {
                        nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
                    }
                    finally {
                        request.body(body.orElse(null));
                    }
                }
            }
            nettyRequest = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)request);
        }
        try {
            nettyRequest.setUri(requestURI.toURL().getFile());
            return new NettyRequestWriter(nettyRequest, postRequestEncoder);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new NettyRequestWriter(nettyRequest, postRequestEncoder);
    }

    private Flux<MutableHttpResponse<?>> readBodyOnError(final @Nullable Argument<?> errorType, @NonNull Flux<MutableHttpResponse<?>> publisher) {
        if (errorType != null && errorType != HttpClient.DEFAULT_ERROR_TYPE) {
            return publisher.onErrorResume(clientException -> {
                HttpResponse response;
                if (clientException instanceof HttpClientResponseException && (response = ((HttpClientResponseException)((Object)clientException)).getResponse()) instanceof NettyStreamedHttpResponse) {
                    return Mono.create(emitter -> {
                        NettyStreamedHttpResponse streamedResponse = (NettyStreamedHttpResponse)response;
                        final StreamedHttpResponse nettyResponse = streamedResponse.getNettyResponse();
                        nettyResponse.subscribe((Subscriber)new Subscriber<HttpContent>(){
                            final CompositeByteBuf buffer;
                            Subscription s;
                            {
                                this.buffer = ((ByteBufAllocator)DefaultHttpClient.this.byteBufferFactory.getNativeAllocator()).compositeBuffer();
                            }

                            public void onSubscribe(Subscription s) {
                                this.s = s;
                                s.request(1L);
                            }

                            public void onNext(HttpContent httpContent) {
                                this.buffer.addComponent(true, httpContent.content());
                                this.s.request(1L);
                            }

                            public void onError(Throwable t) {
                                this.buffer.release();
                                emitter.error(t);
                            }

                            public void onComplete() {
                                try {
                                    DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(nettyResponse.protocolVersion(), nettyResponse.status(), (ByteBuf)this.buffer, nettyResponse.headers(), (HttpHeaders)new DefaultHttpHeaders(true));
                                    FullNettyClientHttpResponse fullNettyClientHttpResponse = new FullNettyClientHttpResponse((FullHttpResponse)fullHttpResponse, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, errorType, true, DefaultHttpClient.this.conversionService);
                                    fullNettyClientHttpResponse.onComplete();
                                    emitter.error((Throwable)DefaultHttpClient.this.decorate(new HttpClientResponseException(fullHttpResponse.status().reasonPhrase(), null, fullNettyClientHttpResponse, new HttpClientErrorDecoder(){

                                        public Argument<?> getErrorType(MediaType mediaType) {
                                            return errorType;
                                        }
                                    })));
                                }
                                finally {
                                    this.buffer.release();
                                }
                            }
                        });
                    });
                }
                return Mono.error((Throwable)clientException);
            });
        }
        return publisher;
    }

    private <I> Publisher<URI> resolveURI(HttpRequest<I> request, boolean includeContextPath) {
        URI requestURI = request.getUri();
        if (this.loadBalancer == null) {
            return Flux.error((Throwable)this.decorate(new NoHostException("Request URI specifies no host to connect to")));
        }
        return Flux.from((Publisher)this.loadBalancer.select(this.getLoadBalancerDiscriminator())).map(server -> {
            Optional authInfo = server.getMetadata().get((CharSequence)"Authorization-Info", String.class);
            if (request instanceof MutableHttpRequest && authInfo.isPresent()) {
                ((MutableHttpRequest)request).getHeaders().auth((String)authInfo.get());
            }
            try {
                return server.resolve(includeContextPath ? ContextPathUtils.prepend((URI)requestURI, (String)this.contextPath) : requestURI);
            }
            catch (URISyntaxException e) {
                throw this.decorate(new HttpClientException("Failed to construct the request URI", (Throwable)e));
            }
        });
    }

    private <I, O, E> void sendRequestThroughChannel(HttpRequest<I> finalRequest, Argument<O> bodyType, Argument<E> errorType, FluxSink<? super HttpResponse<O>> emitter, boolean secure, ConnectionManager.PoolHandle poolHandle) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        URI requestURI = finalRequest.getUri();
        MediaType requestContentType = finalRequest.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)finalRequest.getMethod());
        MutableHttpRequest clientHttpRequest = (MutableHttpRequest)finalRequest;
        NettyRequestWriter requestWriter = this.buildNettyRequest(clientHttpRequest, requestURI, requestContentType, permitsBody, bodyType, throwable -> {
            if (!emitter.isCancelled()) {
                emitter.error(throwable);
            }
        });
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        this.prepareHttpHeaders(poolHandle, requestURI, finalRequest, nettyRequest, permitsBody);
        if (this.log.isDebugEnabled()) {
            this.debugRequest(requestURI, nettyRequest);
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest(finalRequest, nettyRequest);
        }
        Promise responsePromise = poolHandle.channel.eventLoop().newPromise();
        poolHandle.channel.pipeline().addLast("micronaut-full-http-response", new FullHttpResponseHandler<O>(responsePromise, poolHandle, secure, finalRequest, bodyType, errorType));
        poolHandle.notifyRequestPipelineBuilt();
        NettyFuturePublisher publisher = new NettyFuturePublisher(responsePromise, true);
        publisher.subscribe(new ForwardingSubscriber<HttpResponse<O>>(emitter));
        requestWriter.write(poolHandle, secure, emitter);
    }

    private Flux<MutableHttpResponse<?>> streamRequestThroughChannel(HttpRequest<?> parentRequest, MutableHttpRequest<?> request, ConnectionManager.PoolHandle poolHandle, boolean failOnError, boolean secure) {
        return Flux.create(sink -> {
            try {
                this.streamRequestThroughChannel0(parentRequest, request, (FluxSink<? super MutableHttpResponse<?>>)sink, poolHandle, secure);
            }
            catch (HttpPostRequestEncoder.ErrorDataEncoderException e) {
                sink.error((Throwable)e);
            }
        }).flatMap(resp -> this.handleStreamHttpError(resp, failOnError));
    }

    private <R extends HttpResponse<?>> Flux<R> handleStreamHttpError(R response, boolean failOnError) {
        boolean errorStatus;
        boolean bl = errorStatus = response.code() >= 400;
        if (errorStatus && failOnError) {
            return Flux.error((Throwable)this.decorate(new HttpClientResponseException(response.reason(), response)));
        }
        return Flux.just(response);
    }

    private void streamRequestThroughChannel0(HttpRequest<?> parentRequest, MutableHttpRequest<?> request, FluxSink<? super MutableHttpResponse<?>> emitter, ConnectionManager.PoolHandle poolHandle, boolean secure) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        URI requestURI = request.getUri();
        boolean permitsBody = HttpMethod.permitsRequestBody((HttpMethod)request.getMethod());
        NettyRequestWriter requestWriter = this.buildNettyRequest(request, requestURI, request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE), permitsBody, null, throwable -> {
            if (!emitter.isCancelled()) {
                emitter.error(throwable);
            }
        });
        this.prepareHttpHeaders(poolHandle, requestURI, (HttpRequest)request, requestWriter.getNettyRequest(), permitsBody);
        io.netty.handler.codec.http.HttpRequest nettyRequest = requestWriter.getNettyRequest();
        Promise responsePromise = poolHandle.channel.eventLoop().newPromise();
        ChannelPipeline pipeline = poolHandle.channel.pipeline();
        pipeline.addLast("micronaut-http-response-full", (ChannelHandler)new StreamFullHttpResponseHandler((Promise<? super MutableHttpResponse<?>>)responsePromise, parentRequest, (HttpRequest<?>)request));
        pipeline.addLast("micronaut-http-response-stream", (ChannelHandler)new StreamStreamHttpResponseHandler((Promise<? super MutableHttpResponse<?>>)responsePromise, parentRequest, (HttpRequest<?>)request));
        poolHandle.notifyRequestPipelineBuilt();
        if (this.log.isDebugEnabled()) {
            this.debugRequest(request.getUri(), nettyRequest);
        }
        if (this.log.isTraceEnabled()) {
            this.traceRequest((HttpRequest<?>)request, nettyRequest);
        }
        requestWriter.write(poolHandle, secure, emitter);
        responsePromise.addListener(future -> {
            if (future.isSuccess()) {
                emitter.next(future.getNow());
                emitter.complete();
            } else {
                emitter.error(future.cause());
            }
        });
    }

    private ByteBuf charSequenceToByteBuf(CharSequence bodyValue, MediaType requestContentType) {
        CharSequence charSequence = bodyValue;
        return (ByteBuf)this.byteBufferFactory.copiedBuffer(charSequence.toString().getBytes(requestContentType.getCharset().orElse(this.defaultCharset))).asNativeBuffer();
    }

    private String getHostHeader(URI requestURI) {
        RequestKey requestKey = new RequestKey(this, requestURI);
        StringBuilder host = new StringBuilder(requestKey.getHost());
        int port = requestKey.getPort();
        if (port > -1 && port != 80 && port != 443) {
            host.append(":").append(port);
        }
        return host.toString();
    }

    private <I> void prepareHttpHeaders(ConnectionManager.PoolHandle poolHandle, URI requestURI, HttpRequest<I> request, io.netty.handler.codec.http.HttpRequest nettyRequest, boolean permitsBody) {
        HttpHeaders headers = nettyRequest.headers();
        if (!headers.contains((CharSequence)HttpHeaderNames.HOST)) {
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)this.getHostHeader(requestURI));
        }
        if (!poolHandle.http2) {
            if (poolHandle.canReturn()) {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            } else {
                headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
        }
        if (permitsBody) {
            Optional body = request.getBody();
            if (body.isPresent()) {
                if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
                    MediaType mediaType = request.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)mediaType);
                }
                if (nettyRequest instanceof FullHttpRequest) {
                    FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
                    headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fullHttpRequest.content().readableBytes());
                } else if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !headers.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
                    headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                }
            } else if (!(nettyRequest instanceof StreamedHttpRequest)) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            }
        }
    }

    private HttpPostRequestEncoder buildFormDataRequest(MutableHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder(NettyHttpRequestBuilder.toHttpRequest((HttpRequest)clientHttpRequest), false);
        Map formData = bodyValue instanceof Map ? (Map)bodyValue : BeanMap.of((Object)bodyValue);
        for (Map.Entry entry : formData.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object val : collection) {
                    this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), val);
                }
                continue;
            }
            this.addBodyAttribute(postRequestEncoder, (String)entry.getKey(), value);
        }
        return postRequestEncoder;
    }

    private void addBodyAttribute(HttpPostRequestEncoder postRequestEncoder, String key, Object value) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        Optional converted = this.conversionService.convert(value, String.class);
        if (converted.isPresent()) {
            postRequestEncoder.addBodyAttribute(key, (String)converted.get());
        }
    }

    private HttpPostRequestEncoder buildMultipartRequest(MutableHttpRequest clientHttpRequest, Object bodyValue) throws HttpPostRequestEncoder.ErrorDataEncoderException {
        DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
        io.netty.handler.codec.http.HttpRequest request = NettyHttpRequestBuilder.toHttpRequest((HttpRequest)clientHttpRequest);
        HttpPostRequestEncoder postRequestEncoder = new HttpPostRequestEncoder((HttpDataFactory)factory, request, true, CharsetUtil.UTF_8, HttpPostRequestEncoder.EncoderMode.HTML5);
        if (bodyValue instanceof MultipartBody.Builder) {
            bodyValue = ((MultipartBody.Builder)bodyValue).build();
        }
        if (!(bodyValue instanceof MultipartBody)) {
            throw new MultipartException(String.format("The type %s is not a supported type for a multipart request body", bodyValue.getClass().getName()));
        }
        MultipartBody multipartBody = (MultipartBody)bodyValue;
        postRequestEncoder.setBodyHttpDatas(multipartBody.getData((MultipartDataFactory)new MultipartDataFactory<InterfaceHttpData>(){
            final /* synthetic */ HttpDataFactory val$factory;
            final /* synthetic */ io.netty.handler.codec.http.HttpRequest val$request;
            {
                this.val$factory = httpDataFactory;
                this.val$request = httpRequest;
            }

            @NonNull
            public InterfaceHttpData createFileUpload(@NonNull String name, @NonNull String filename, @NonNull MediaType contentType, @Nullable String encoding, @Nullable Charset charset, long length) {
                return this.val$factory.createFileUpload(this.val$request, name, filename, contentType.toString(), encoding, charset, length);
            }

            @NonNull
            public InterfaceHttpData createAttribute(@NonNull String name, @NonNull String value) {
                return this.val$factory.createAttribute(this.val$request, name, value);
            }

            public void setContent(InterfaceHttpData fileUploadObject, Object content) throws IOException {
                if (fileUploadObject instanceof FileUpload) {
                    FileUpload fu = (FileUpload)fileUploadObject;
                    if (content instanceof InputStream) {
                        fu.setContent((InputStream)content);
                    } else if (content instanceof File) {
                        fu.setContent((File)content);
                    } else if (content instanceof byte[]) {
                        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])((byte[])content));
                        fu.setContent(buffer);
                    }
                }
            }
        }));
        return postRequestEncoder;
    }

    private void debugRequest(URI requestURI, io.netty.handler.codec.http.HttpRequest nettyRequest) {
        this.log.debug("Sending HTTP {} to {}", (Object)nettyRequest.method(), (Object)requestURI.toString());
    }

    private void traceRequest(HttpRequest<?> request, io.netty.handler.codec.http.HttpRequest nettyRequest) {
        HttpHeaders headers = nettyRequest.headers();
        HttpHeadersUtil.trace((Logger)this.log, (Set)headers.names(), arg_0 -> ((HttpHeaders)headers).getAll(arg_0));
        if (HttpMethod.permitsRequestBody((HttpMethod)request.getMethod()) && request.getBody().isPresent() && nettyRequest instanceof FullHttpRequest) {
            FullHttpRequest fullHttpRequest = (FullHttpRequest)nettyRequest;
            ByteBuf content = fullHttpRequest.content();
            if (this.log.isTraceEnabled()) {
                this.traceBody("Request", content);
            }
        }
    }

    private void traceBody(String type, ByteBuf content) {
        this.log.trace(type + " Body");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private void traceChunk(ByteBuf content) {
        this.log.trace("Sending Chunk");
        this.log.trace("----");
        this.log.trace(content.toString(this.defaultCharset));
        this.log.trace("----");
    }

    private static MediaTypeCodecRegistry createDefaultMediaTypeRegistry() {
        JsonMapper mapper = JsonMapper.createDefault();
        ApplicationConfiguration configuration = new ApplicationConfiguration();
        return MediaTypeCodecRegistry.of((MediaTypeCodec[])new MediaTypeCodec[]{new JsonMediaTypeCodec(mapper, configuration, null), new JsonStreamMediaTypeCodec(mapper, configuration, null)});
    }

    @NonNull
    private InvocationInstrumenter combineFactories() {
        if (CollectionUtils.isEmpty(this.invocationInstrumenterFactories)) {
            return InvocationInstrumenter.NOOP;
        }
        return InvocationInstrumenter.combine(this.invocationInstrumenterFactories.stream().map(InvocationInstrumenterFactory::newInvocationInstrumenter).filter(Objects::nonNull).toList());
    }

    static boolean isSecureScheme(String scheme) {
        return "https".equalsIgnoreCase(scheme) || "wss".equalsIgnoreCase(scheme);
    }

    private <E extends HttpClientException> E decorate(E exc) {
        return (E)((Object)HttpClientExceptionUtils.populateServiceId(exc, (String)this.informationalServiceId, (HttpClientConfiguration)this.configuration));
    }

    static {
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.HOST, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"");
        REDIRECT_HEADER_BLOCKLIST.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"");
    }

    public static final class RequestKey {
        private final String host;
        private final int port;
        private final boolean secure;

        public RequestKey(DefaultHttpClient ctx, URI requestURI) {
            int port;
            this.secure = DefaultHttpClient.isSecureScheme(requestURI.getScheme());
            String host = requestURI.getHost();
            if (host == null) {
                host = requestURI.getAuthority();
                if (host == null) {
                    throw this.decorate(ctx, new NoHostException("URI specifies no host to connect to"));
                }
                int i = host.indexOf(58);
                if (i > -1) {
                    String portStr = host.substring(i + 1);
                    host = host.substring(0, i);
                    try {
                        port = Integer.parseInt(portStr);
                    }
                    catch (NumberFormatException e) {
                        throw this.decorate(ctx, new HttpClientException("URI specifies an invalid port: " + portStr));
                    }
                } else {
                    port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
                }
            } else {
                port = requestURI.getPort() > -1 ? requestURI.getPort() : (this.secure ? 443 : 80);
            }
            this.host = host;
            this.port = port;
        }

        public InetSocketAddress getRemoteAddress() {
            return InetSocketAddress.createUnresolved(this.host, this.port);
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestKey that = (RequestKey)o;
            return this.port == that.port && this.secure == that.secure && Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            return ObjectUtils.hash((Object)this.host, (Object)this.port, (Object)this.secure);
        }

        private <E extends HttpClientException> E decorate(DefaultHttpClient ctx, E exc) {
            return (E)HttpClientExceptionUtils.populateServiceId(exc, (String)ctx.informationalServiceId, (HttpClientConfiguration)ctx.configuration);
        }
    }

    private class NettyRequestWriter {
        private final io.netty.handler.codec.http.HttpRequest nettyRequest;
        private final HttpPostRequestEncoder encoder;

        NettyRequestWriter(io.netty.handler.codec.http.HttpRequest nettyRequest, HttpPostRequestEncoder encoder) {
            this.nettyRequest = nettyRequest;
            this.encoder = encoder;
        }

        protected void write(ConnectionManager.PoolHandle poolHandle, boolean isSecure, FluxSink<?> emitter) {
            ChannelFuture writeFuture;
            Channel channel = poolHandle.channel;
            if (this.encoder != null && this.encoder.isChunked()) {
                channel.attr(AttributeKey.valueOf((String)"chunk-writer")).set((Object)true);
                channel.pipeline().addAfter("http-streams-codec", "chunk-writer", (ChannelHandler)new ChunkedWriteHandler());
                channel.write((Object)this.nettyRequest);
                writeFuture = channel.writeAndFlush((Object)this.encoder);
            } else {
                writeFuture = channel.writeAndFlush((Object)this.nettyRequest);
            }
            DefaultHttpClient.this.connectionManager.addInstrumentedListener(writeFuture, f -> {
                try {
                    if (!f.isSuccess()) {
                        poolHandle.taint();
                        if (!emitter.isCancelled()) {
                            emitter.error(f.cause());
                        }
                    } else {
                        channel.read();
                    }
                }
                finally {
                    if (this.encoder != null) {
                        this.encoder.cleanFiles();
                    }
                    channel.attr(AttributeKey.valueOf((String)"chunk-writer")).set(null);
                }
            });
        }

        io.netty.handler.codec.http.HttpRequest getNettyRequest() {
            return this.nettyRequest;
        }
    }

    private class FullHttpResponseHandler<O>
    extends BaseHttpResponseHandler<FullHttpResponse, HttpResponse<O>> {
        private final boolean secure;
        private final Argument<O> bodyType;
        private final Argument<?> errorType;
        private final ConnectionManager.PoolHandle poolHandle;

        public FullHttpResponseHandler(Promise<HttpResponse<O>> responsePromise, ConnectionManager.PoolHandle poolHandle, boolean secure, HttpRequest<?> request, Argument<O> bodyType, Argument<?> errorType) {
            super(responsePromise, request, request);
            this.secure = secure;
            this.bodyType = bodyType;
            this.errorType = errorType;
            this.poolHandle = poolHandle;
        }

        @Override
        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof FullHttpResponse;
        }

        @Override
        protected Function<URI, Publisher<? extends HttpResponse<O>>> makeRedirectHandler(HttpRequest<?> parentRequest, MutableHttpRequest<Object> redirectRequest) {
            return uri -> DefaultHttpClient.this.exchangeImpl((URI)uri, parentRequest, redirectRequest, this.bodyType, this.errorType, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void channelReadInstrumented(ChannelHandlerContext channelHandlerContext, FullHttpResponse fullResponse) throws Exception {
            try {
                fullResponse.retain();
                super.channelReadInstrumented(channelHandlerContext, fullResponse);
            }
            finally {
                block10: {
                    if (fullResponse.refCnt() > 1) {
                        try {
                            ReferenceCountUtil.release((Object)fullResponse);
                        }
                        catch (Exception e) {
                            if (!DefaultHttpClient.this.log.isDebugEnabled()) break block10;
                            DefaultHttpClient.this.log.debug("Failed to release response: {}", (Object)fullResponse);
                        }
                    }
                }
                if (!HttpUtil.isKeepAlive((HttpMessage)fullResponse)) {
                    this.poolHandle.taint();
                }
                channelHandlerContext.pipeline().remove((ChannelHandler)this);
            }
        }

        @Override
        protected void removeHandler(ChannelHandlerContext ctx) {
        }

        @Override
        protected void buildResponse(Promise<? super HttpResponse<O>> promise, FullHttpResponse msg) {
            try {
                if (DefaultHttpClient.this.log.isTraceEnabled()) {
                    DefaultHttpClient.this.traceBody("Response", msg.content());
                }
                if (msg.status().equals((Object)HttpResponseStatus.NO_CONTENT)) {
                    msg.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                }
                boolean convertBodyWithBodyType = FullHttpResponseHandler.shouldConvertWithBodyType(msg, DefaultHttpClient.this.configuration, this.bodyType, this.errorType);
                FullNettyClientHttpResponse<O> response = new FullNettyClientHttpResponse<O>(msg, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, this.bodyType, convertBodyWithBodyType, DefaultHttpClient.this.conversionService);
                if (convertBodyWithBodyType) {
                    promise.trySuccess(response);
                    response.onComplete();
                } else {
                    try {
                        promise.tryFailure((Throwable)this.makeErrorFromRequestBody(msg.status(), response));
                        response.onComplete();
                    }
                    catch (HttpClientResponseException t) {
                        promise.tryFailure((Throwable)t);
                        response.onComplete();
                    }
                    catch (Exception t) {
                        response.onComplete();
                        promise.tryFailure((Throwable)this.makeErrorBodyParseError(msg, t));
                    }
                }
            }
            catch (HttpClientResponseException t) {
                promise.tryFailure((Throwable)t);
            }
            catch (Exception t) {
                this.makeNormalBodyParseError(msg, t, cause -> {
                    if (!promise.tryFailure((Throwable)cause) && DefaultHttpClient.this.log.isWarnEnabled()) {
                        DefaultHttpClient.this.log.warn("Exception fired after handler completed: " + t.getMessage(), (Throwable)t);
                    }
                });
            }
        }

        private static <O, E> boolean shouldConvertWithBodyType(FullHttpResponse msg, HttpClientConfiguration configuration, Argument<O> bodyType, Argument<E> errorType) {
            if (msg.status().code() < 400) {
                return true;
            }
            return !configuration.isExceptionOnErrorStatus() && bodyType.equalsType(errorType);
        }

        private HttpClientResponseException makeErrorFromRequestBody(HttpResponseStatus status, FullNettyClientHttpResponse<?> response) {
            if (this.errorType != null && this.errorType != HttpClient.DEFAULT_ERROR_TYPE) {
                return DefaultHttpClient.this.decorate(new HttpClientResponseException(status.reasonPhrase(), null, response, new HttpClientErrorDecoder(){

                    public Argument<?> getErrorType(MediaType mediaType) {
                        return FullHttpResponseHandler.this.errorType;
                    }
                }));
            }
            return DefaultHttpClient.this.decorate(new HttpClientResponseException(status.reasonPhrase(), response));
        }

        private HttpClientResponseException makeErrorBodyParseError(FullHttpResponse fullResponse, Throwable t) {
            FullNettyClientHttpResponse errorResponse = new FullNettyClientHttpResponse(fullResponse, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, false, DefaultHttpClient.this.conversionService);
            errorResponse.onComplete();
            return DefaultHttpClient.this.decorate(new HttpClientResponseException("Error decoding HTTP error response body: " + t.getMessage(), t, errorResponse, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeNormalBodyParseError(FullHttpResponse fullResponse, Throwable t, Consumer<HttpClientResponseException> forward) {
            FullNettyClientHttpResponse response = new FullNettyClientHttpResponse(fullResponse, DefaultHttpClient.this.mediaTypeCodecRegistry, DefaultHttpClient.this.byteBufferFactory, null, false, DefaultHttpClient.this.conversionService);
            HttpClientResponseException clientResponseError = DefaultHttpClient.this.decorate(new HttpClientResponseException("Error decoding HTTP response body: " + t.getMessage(), t, response, new HttpClientErrorDecoder(){

                public Argument<?> getErrorType(MediaType mediaType) {
                    return FullHttpResponseHandler.this.errorType;
                }
            }));
            try {
                forward.accept(clientResponseError);
            }
            finally {
                response.onComplete();
            }
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            ctx.pipeline().remove("http-aggregator");
            try {
                ctx.pipeline().remove("chunk-writer");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            ctx.pipeline().remove("http-streams-codec");
            this.poolHandle.release();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            super.exceptionCaught(ctx, cause);
            this.poolHandle.taint();
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private class StreamFullHttpResponseHandler
    extends BaseHttpResponseHandler<FullHttpResponse, MutableHttpResponse<?>> {
        public StreamFullHttpResponseHandler(Promise<? super MutableHttpResponse<?>> responsePromise, HttpRequest<?> parentRequest, HttpRequest<?> finalRequest) {
            super(responsePromise, parentRequest, finalRequest);
        }

        @Override
        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof FullHttpResponse;
        }

        @Override
        protected void removeHandler(ChannelHandlerContext ctx) {
            ctx.pipeline().remove("micronaut-http-response-full");
            ctx.pipeline().remove("micronaut-http-response-stream");
        }

        @Override
        protected void buildResponse(Promise<? super MutableHttpResponse<?>> promise, FullHttpResponse msg) {
            Publisher bodyPublisher = msg.content() instanceof EmptyByteBuf ? Publishers.empty() : Publishers.just((Object)new DefaultLastHttpContent(msg.content()));
            DefaultStreamedHttpResponse nettyResponse = new DefaultStreamedHttpResponse(msg.protocolVersion(), msg.status(), msg.headers(), bodyPublisher);
            promise.trySuccess(new NettyStreamedHttpResponse((StreamedHttpResponse)nettyResponse, DefaultHttpClient.this.conversionService));
        }

        @Override
        protected Function<URI, Publisher<? extends MutableHttpResponse<?>>> makeRedirectHandler(HttpRequest<?> parentRequest, MutableHttpRequest<Object> redirectRequest) {
            return uri -> DefaultHttpClient.this.buildStreamExchange(parentRequest, redirectRequest, (URI)uri, null);
        }
    }

    private class StreamStreamHttpResponseHandler
    extends BaseHttpResponseHandler<StreamedHttpResponse, MutableHttpResponse<?>> {
        public StreamStreamHttpResponseHandler(Promise<? super MutableHttpResponse<?>> responsePromise, HttpRequest<?> parentRequest, HttpRequest<?> finalRequest) {
            super(responsePromise, parentRequest, finalRequest);
        }

        @Override
        public boolean acceptInboundMessage(Object msg) {
            return msg instanceof StreamedHttpResponse;
        }

        @Override
        protected void removeHandler(ChannelHandlerContext ctx) {
            ctx.pipeline().remove("micronaut-http-response-full");
            ctx.pipeline().remove("micronaut-http-response-stream");
        }

        @Override
        protected void buildResponse(Promise<? super MutableHttpResponse<?>> promise, StreamedHttpResponse msg) {
            promise.trySuccess(new NettyStreamedHttpResponse(msg, DefaultHttpClient.this.conversionService));
        }

        @Override
        protected Function<URI, Publisher<? extends MutableHttpResponse<?>>> makeRedirectHandler(HttpRequest<?> parentRequest, MutableHttpRequest<Object> redirectRequest) {
            return uri -> DefaultHttpClient.this.buildStreamExchange(parentRequest, redirectRequest, (URI)uri, null);
        }
    }

    private abstract class BaseHttpResponseHandler<R extends io.netty.handler.codec.http.HttpResponse, O>
    extends SimpleChannelInboundHandlerInstrumented<R> {
        private final Promise<? super O> responsePromise;
        private final HttpRequest<?> parentRequest;
        private final HttpRequest<?> finalRequest;

        public BaseHttpResponseHandler(Promise<? super O> responsePromise, HttpRequest<?> parentRequest, HttpRequest<?> finalRequest) {
            super(DefaultHttpClient.this.connectionManager.instrumenter);
            this.responsePromise = responsePromise;
            this.parentRequest = parentRequest;
            this.finalRequest = finalRequest;
        }

        public abstract boolean acceptInboundMessage(Object var1);

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            String message = cause.getMessage();
            if (message == null) {
                message = cause.getClass().getSimpleName();
            }
            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                DefaultHttpClient.this.log.trace("HTTP Client exception ({}) occurred for request : {} {}", new Object[]{message, this.finalRequest.getMethodName(), this.finalRequest.getUri()});
            }
            Object result = cause instanceof TooLongFrameException ? DefaultHttpClient.this.decorate(new ContentLengthExceededException((long)DefaultHttpClient.this.configuration.getMaxContentLength())) : (cause instanceof io.netty.handler.timeout.ReadTimeoutException ? ReadTimeoutException.TIMEOUT_EXCEPTION : DefaultHttpClient.this.decorate(new HttpClientException("Error occurred reading HTTP response: " + message, cause)));
            this.responsePromise.tryFailure((Throwable)result);
        }

        @Override
        protected void channelReadInstrumented(ChannelHandlerContext ctx, R msg) throws Exception {
            if (this.responsePromise.isDone()) {
                return;
            }
            if (DefaultHttpClient.this.log.isDebugEnabled()) {
                DefaultHttpClient.this.log.debug("Received response {} from {}", (Object)msg.status().code(), (Object)this.finalRequest.getUri());
            }
            int code = msg.status().code();
            HttpHeaders headers1 = msg.headers();
            if (code > 300 && code < 400 && DefaultHttpClient.this.configuration.isFollowRedirects() && headers1.contains((CharSequence)HttpHeaderNames.LOCATION)) {
                MutableHttpRequest redirectRequest;
                String location = headers1.get((CharSequence)HttpHeaderNames.LOCATION);
                if (code == 307) {
                    redirectRequest = HttpRequest.create((HttpMethod)this.finalRequest.getMethod(), (String)location);
                    this.finalRequest.getBody().ifPresent(arg_0 -> ((MutableHttpRequest)redirectRequest).body(arg_0));
                } else {
                    redirectRequest = HttpRequest.GET((String)location);
                }
                this.setRedirectHeaders(this.finalRequest, (MutableHttpRequest<Object>)redirectRequest);
                Flux.from(DefaultHttpClient.this.resolveRedirectURI(this.parentRequest, redirectRequest)).flatMap(this.makeRedirectHandler(this.parentRequest, (MutableHttpRequest<Object>)redirectRequest)).subscribe(new NettyPromiseSubscriber<O>(this.responsePromise));
                return;
            }
            HttpHeaders headers = msg.headers();
            if (DefaultHttpClient.this.log.isTraceEnabled()) {
                DefaultHttpClient.this.log.trace("HTTP Client Response Received ({}) for Request: {} {}", new Object[]{msg.status(), this.finalRequest.getMethodName(), this.finalRequest.getUri()});
                HttpHeadersUtil.trace((Logger)DefaultHttpClient.this.log, (Set)headers.names(), arg_0 -> ((HttpHeaders)headers).getAll(arg_0));
            }
            this.buildResponse(this.responsePromise, msg);
            this.removeHandler(ctx);
        }

        private void setRedirectHeaders(@Nullable HttpRequest<?> request, MutableHttpRequest<Object> redirectRequest) {
            if (request != null) {
                for (Map.Entry originalHeader : request.getHeaders()) {
                    List originalHeaderValue;
                    if (REDIRECT_HEADER_BLOCKLIST.contains((String)originalHeader.getKey()) || (originalHeaderValue = (List)originalHeader.getValue()) == null || originalHeaderValue.isEmpty()) continue;
                    for (String value : originalHeaderValue) {
                        if (value == null) continue;
                        redirectRequest.header((CharSequence)originalHeader.getKey(), (CharSequence)value);
                    }
                }
            }
        }

        protected abstract void removeHandler(ChannelHandlerContext var1);

        protected abstract Function<URI, Publisher<? extends O>> makeRedirectHandler(HttpRequest<?> var1, MutableHttpRequest<Object> var2);

        protected abstract void buildResponse(Promise<? super O> var1, R var2);
    }

    private static class CurrentEvent {
        byte[] data;
        String id;
        String name;
        Duration retry;

        private CurrentEvent() {
        }
    }

    @FunctionalInterface
    static interface ThrowingBiConsumer<T1, T2> {
        public void accept(T1 var1, T2 var2) throws Exception;
    }
}

