/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.LoadBalancer;
import io.micronaut.http.client.filter.ClientFilterResolutionContext;
import io.micronaut.http.client.filter.DefaultHttpClientFilterResolver;
import io.micronaut.http.client.netty.CompositeNettyClientCustomizer;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.client.netty.NettyClientCustomizer;
import io.micronaut.http.client.netty.ssl.ClientSslBuilder;
import io.micronaut.http.client.netty.ssl.NettyClientSslFactory;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.filter.HttpClientFilterResolver;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.http.ssl.CertificateProvider;
import io.micronaut.websocket.context.WebSocketBeanRegistry;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.resolver.AddressResolverGroup;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;

@Internal
public final class DefaultHttpClientBuilder {
    @Nullable
    LoadBalancer loadBalancer = null;
    @Nullable
    HttpVersionSelection explicitHttpVersion = null;
    HttpClientConfiguration configuration;
    @Nullable
    String contextPath = null;
    @NonNull
    AnnotationMetadataResolver annotationMetadataResolver = AnnotationMetadataResolver.DEFAULT;
    HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver;
    List<HttpFilterResolver.FilterEntry> clientFilterEntries = null;
    @Nullable
    ThreadFactory threadFactory;
    ClientSslBuilder nettyClientSslBuilder;
    NettyClientSslFactory sslFactory;
    BeanProvider<CertificateProvider> certificateProviders;
    MediaTypeCodecRegistry codecRegistry;
    MessageBodyHandlerRegistry handlerRegistry;
    @NonNull
    WebSocketBeanRegistry webSocketBeanRegistry = WebSocketBeanRegistry.EMPTY;
    RequestBinderRegistry requestBinderRegistry;
    @Nullable
    EventLoopGroup eventLoopGroup = null;
    @NonNull
    ChannelFactory<? extends Channel> socketChannelFactory = NioSocketChannel::new;
    @NonNull
    ChannelFactory<? extends Channel> udpChannelFactory = NioDatagramChannel::new;
    NettyClientCustomizer clientCustomizer = CompositeNettyClientCustomizer.EMPTY;
    @Nullable
    String informationalServiceId = null;
    @NonNull
    ConversionService conversionService = ConversionService.SHARED;
    @Nullable
    AddressResolverGroup<?> resolverGroup = null;
    @Nullable
    ExecutorService blockingExecutor = null;

    DefaultHttpClientBuilder() {
    }

    @NonNull
    DefaultHttpClientBuilder loadBalancer(@Nullable LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return this;
    }

    @NonNull
    public DefaultHttpClientBuilder uri(@Nullable URI uri) {
        return this.loadBalancer(uri == null ? null : LoadBalancer.fixed((URI)uri));
    }

    @NonNull
    DefaultHttpClientBuilder explicitHttpVersion(@Nullable HttpVersionSelection explicitHttpVersion) {
        this.explicitHttpVersion = explicitHttpVersion;
        return this;
    }

    @NonNull
    public DefaultHttpClientBuilder configuration(@NonNull HttpClientConfiguration configuration) {
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.configuration = configuration;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder contextPath(@Nullable String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder filterResolver(@NonNull HttpClientFilterResolver<ClientFilterResolutionContext> filterResolver) {
        ArgumentUtils.requireNonNull((String)"filterResolver", filterResolver);
        this.filterResolver = filterResolver;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder annotationMetadataResolver(@Nullable AnnotationMetadataResolver annotationMetadataResolver) {
        if (annotationMetadataResolver != null) {
            this.annotationMetadataResolver = annotationMetadataResolver;
        }
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder filters(HttpClientFilter ... filters) {
        return this.filterResolver((HttpClientFilterResolver<ClientFilterResolutionContext>)new DefaultHttpClientFilterResolver(null, this.annotationMetadataResolver, Arrays.asList(filters)));
    }

    @NonNull
    DefaultHttpClientBuilder clientFilterEntries(@Nullable List<HttpFilterResolver.FilterEntry> clientFilterEntries) {
        this.clientFilterEntries = clientFilterEntries;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder threadFactory(@Nullable ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    @NonNull
    public DefaultHttpClientBuilder nettyClientSslBuilder(@NonNull ClientSslBuilder nettyClientSslBuilder) {
        ArgumentUtils.requireNonNull((String)"nettyClientSslBuilder", (Object)nettyClientSslBuilder);
        this.nettyClientSslBuilder = nettyClientSslBuilder;
        return this;
    }

    @NonNull
    public DefaultHttpClientBuilder sslFactory(@NonNull NettyClientSslFactory sslFactory, @NonNull BeanProvider<CertificateProvider> certificateProviders) {
        ArgumentUtils.requireNonNull((String)"sslFactory", (Object)sslFactory);
        ArgumentUtils.requireNonNull((String)"certificateProviders", certificateProviders);
        this.sslFactory = sslFactory;
        this.certificateProviders = certificateProviders;
        return this;
    }

    @NonNull
    @Deprecated
    DefaultHttpClientBuilder codecRegistry(@NonNull MediaTypeCodecRegistry codecRegistry) {
        ArgumentUtils.requireNonNull((String)"codecRegistry", (Object)codecRegistry);
        this.codecRegistry = codecRegistry;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder handlerRegistry(@NonNull MessageBodyHandlerRegistry handlerRegistry) {
        ArgumentUtils.requireNonNull((String)"handlerRegistry", (Object)handlerRegistry);
        this.handlerRegistry = handlerRegistry;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder webSocketBeanRegistry(@NonNull WebSocketBeanRegistry webSocketBeanRegistry) {
        ArgumentUtils.requireNonNull((String)"webSocketBeanRegistry", (Object)webSocketBeanRegistry);
        this.webSocketBeanRegistry = webSocketBeanRegistry;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder requestBinderRegistry(@NonNull RequestBinderRegistry requestBinderRegistry) {
        ArgumentUtils.requireNonNull((String)"requestBinderRegistry", (Object)requestBinderRegistry);
        this.requestBinderRegistry = requestBinderRegistry;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder eventLoopGroup(@Nullable EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder socketChannelFactory(@NonNull ChannelFactory<? extends Channel> socketChannelFactory) {
        ArgumentUtils.requireNonNull((String)"socketChannelFactory", socketChannelFactory);
        this.socketChannelFactory = socketChannelFactory;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder udpChannelFactory(@NonNull ChannelFactory<? extends Channel> udpChannelFactory) {
        ArgumentUtils.requireNonNull((String)"udpChannelFactory", udpChannelFactory);
        this.udpChannelFactory = udpChannelFactory;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder clientCustomizer(@NonNull NettyClientCustomizer clientCustomizer) {
        ArgumentUtils.requireNonNull((String)"clientCustomizer", (Object)clientCustomizer);
        this.clientCustomizer = clientCustomizer;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder informationalServiceId(@Nullable String informationalServiceId) {
        this.informationalServiceId = informationalServiceId;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder conversionService(@NonNull ConversionService conversionService) {
        ArgumentUtils.requireNonNull((String)"conversionService", (Object)conversionService);
        this.conversionService = conversionService;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder resolverGroup(@Nullable AddressResolverGroup<?> resolverGroup) {
        this.resolverGroup = resolverGroup;
        return this;
    }

    @NonNull
    DefaultHttpClientBuilder blockingExecutor(@Nullable ExecutorService blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
        return this;
    }

    @NonNull
    public DefaultHttpClient build() {
        return new DefaultHttpClient(this);
    }
}

