/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.buffer.netty.NettyReadBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ReadBuffer;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.body.stream.BodySizeLimits;
import io.micronaut.http.body.stream.BufferConsumer;
import io.micronaut.http.client.exceptions.ResponseClosedException;
import io.micronaut.http.client.netty.SimpleChannelInboundHandlerInstrumented;
import io.micronaut.http.netty.body.NettyByteBodyFactory;
import io.micronaut.http.netty.body.StreamingNettyByteBody;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class Http1ResponseHandler
extends SimpleChannelInboundHandlerInstrumented<HttpObject> {
    private static final Logger LOG = LoggerFactory.getLogger(Http1ResponseHandler.class);
    private ReaderState<?> state;

    public Http1ResponseHandler(ResponseListener listener) {
        super(false);
        this.state = new BeforeResponse(listener);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        ctx.read();
    }

    @Override
    protected void channelReadInstrumented(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg.decoderResult().isFailure()) {
            ReferenceCountUtil.release((Object)msg);
            this.exceptionCaught(ctx, msg.decoderResult().cause());
            return;
        }
        this.state.read(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.state.channelReadComplete(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.state.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.state.exceptionCaught(ctx, cause);
    }

    private void transitionToState(ChannelHandlerContext ctx, ReaderState<?> fromState, ReaderState<?> nextState) {
        if (!ctx.executor().inEventLoop()) {
            throw new IllegalStateException("Not on event loop");
        }
        if (this.state != fromState) {
            throw new IllegalStateException("Wrong source state");
        }
        fromState.leave(ctx);
        this.state = nextState;
    }

    private final class BeforeResponse
    extends ReaderState<HttpResponse> {
        private final ResponseListener listener;

        BeforeResponse(ResponseListener listener) {
            this.listener = listener;
        }

        @Override
        void read(ChannelHandlerContext ctx, HttpResponse msg) {
            ReaderState nextState;
            if (msg.status().code() == HttpResponseStatus.CONTINUE.code()) {
                this.listener.continueReceived(ctx);
                nextState = new DiscardingContinueContent(this);
            } else {
                nextState = new BufferedContent(this.listener, msg);
            }
            Http1ResponseHandler.this.transitionToState(ctx, this, nextState);
            if (msg instanceof HttpContent) {
                HttpContent c = (HttpContent)msg;
                nextState.read(ctx, c);
            }
        }

        @Override
        void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            Http1ResponseHandler.this.transitionToState(ctx, this, AfterContent.INSTANCE);
            this.listener.fail(ctx, cause);
            this.listener.finish(ctx);
        }
    }

    static interface ResponseListener {
        @NonNull
        default public BodySizeLimits sizeLimits() {
            return BodySizeLimits.UNLIMITED;
        }

        default public boolean isHeadResponse() {
            return false;
        }

        default public void continueReceived(@NonNull ChannelHandlerContext ctx) {
        }

        public void fail(@NonNull ChannelHandlerContext var1, @NonNull Throwable var2);

        public void complete(@NonNull HttpResponse var1, @NonNull CloseableByteBody var2);

        public void finish(@NonNull ChannelHandlerContext var1);

        default public void allowDiscard() {
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class ReaderState<M extends HttpObject> {
        private ReaderState() {
        }

        abstract void read(ChannelHandlerContext var1, M var2);

        void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.read();
        }

        abstract void exceptionCaught(ChannelHandlerContext var1, Throwable var2);

        void channelInactive(ChannelHandlerContext ctx) {
            this.exceptionCaught(ctx, (Throwable)new ResponseClosedException("Connection closed before response was received"));
        }

        void leave(ChannelHandlerContext ctx) {
        }
    }

    private static final class AfterContent
    extends ReaderState<HttpContent> {
        static final AfterContent INSTANCE = new AfterContent();

        private AfterContent() {
        }

        @Override
        void read(ChannelHandlerContext ctx, HttpContent msg) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Discarding unexpected message {}", (Object)msg);
            }
            ReferenceCountUtil.release((Object)msg);
        }

        @Override
        void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        void channelInactive(ChannelHandlerContext ctx) {
            ctx.fireChannelInactive();
        }
    }

    private final class DiscardingContinueContent
    extends ReaderState<HttpContent> {
        private final BeforeResponse beforeResponse;

        DiscardingContinueContent(BeforeResponse beforeResponse) {
            this.beforeResponse = beforeResponse;
        }

        @Override
        void read(ChannelHandlerContext ctx, HttpContent msg) {
            msg.release();
            if (msg instanceof LastHttpContent) {
                Http1ResponseHandler.this.transitionToState(ctx, this, this.beforeResponse);
            }
        }

        @Override
        void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.beforeResponse.exceptionCaught(ctx, cause);
        }
    }

    private final class DiscardingContent
    extends ReaderState<HttpContent> {
        private final ResponseListener listener;
        private final StreamingNettyByteBody.SharedBuffer streaming;

        DiscardingContent(ResponseListener listener, StreamingNettyByteBody.SharedBuffer streaming) {
            this.listener = listener;
            this.streaming = streaming;
        }

        @Override
        void read(ChannelHandlerContext ctx, HttpContent msg) {
            msg.release();
            if (msg instanceof LastHttpContent) {
                Http1ResponseHandler.this.transitionToState(ctx, this, AfterContent.INSTANCE);
                this.listener.finish(ctx);
            }
        }

        @Override
        void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            Http1ResponseHandler.this.transitionToState(ctx, this, AfterContent.INSTANCE);
            this.streaming.error(cause);
            this.listener.finish(ctx);
        }
    }

    private final class UnbufferedContent
    extends ReaderState<HttpContent>
    implements BufferConsumer.Upstream {
        private final ResponseListener listener;
        private final ChannelHandlerContext streamingContext;
        private final StreamingNettyByteBody.SharedBuffer streaming;
        private final boolean wasAutoRead;
        private long demand;

        UnbufferedContent(ResponseListener listener, ChannelHandlerContext ctx, HttpResponse response) {
            this.listener = listener;
            this.streaming = new NettyByteBodyFactory(ctx.channel()).createStreamingBuffer(listener.sizeLimits(), (BufferConsumer.Upstream)this);
            if (!listener.isHeadResponse()) {
                this.streaming.setExpectedLengthFrom(response.headers());
            }
            this.streamingContext = ctx;
            this.wasAutoRead = ctx.channel().config().isAutoRead();
            ctx.channel().config().setAutoRead(false);
        }

        @Override
        void leave(ChannelHandlerContext ctx) {
            ctx.channel().config().setAutoRead(this.wasAutoRead);
        }

        void add(ReadBuffer buf) {
            int n = buf.readable();
            if (n != 0) {
                this.demand -= (long)n;
                this.streaming.add(buf);
            } else {
                buf.close();
            }
        }

        @Override
        void read(ChannelHandlerContext ctx, HttpContent msg) {
            this.add(NettyReadBufferFactory.of((ByteBufAllocator)ctx.alloc()).adapt(msg.content()));
            if (msg instanceof LastHttpContent) {
                Http1ResponseHandler.this.transitionToState(ctx, this, AfterContent.INSTANCE);
                this.streaming.complete();
                this.listener.finish(ctx);
            }
        }

        @Override
        void channelReadComplete(ChannelHandlerContext ctx) {
            if (this.demand > 0L) {
                ctx.read();
            }
        }

        @Override
        void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            Http1ResponseHandler.this.transitionToState(ctx, this, AfterContent.INSTANCE);
            this.streaming.error(cause);
            this.listener.finish(ctx);
        }

        public void start() {
            if (this.streamingContext.executor().inEventLoop()) {
                this.start0();
            } else {
                this.streamingContext.executor().execute(this::start0);
            }
        }

        private void start0() {
            this.onBytesConsumed0(1L);
        }

        public void onBytesConsumed(long bytesConsumed) {
            if (this.streamingContext.executor().inEventLoop()) {
                this.onBytesConsumed0(bytesConsumed);
            } else {
                this.streamingContext.executor().execute(() -> this.onBytesConsumed0(bytesConsumed));
            }
        }

        private void onBytesConsumed0(long bytesConsumed) {
            if (Http1ResponseHandler.this.state != this) {
                return;
            }
            long oldDemand = this.demand;
            long newDemand = oldDemand + bytesConsumed;
            if (newDemand < oldDemand) {
                newDemand = Long.MAX_VALUE;
            }
            this.demand = newDemand;
            if (oldDemand <= 0L && newDemand > 0L) {
                this.streamingContext.read();
            }
        }

        public void allowDiscard() {
            if (this.streamingContext.executor().inEventLoop()) {
                this.allowDiscard0();
            } else {
                this.streamingContext.executor().execute(this::allowDiscard0);
            }
        }

        private void allowDiscard0() {
            if (Http1ResponseHandler.this.state == this) {
                Http1ResponseHandler.this.transitionToState(this.streamingContext, this, new DiscardingContent(this.listener, this.streaming));
                this.disregardBackpressure();
            }
            this.listener.allowDiscard();
        }

        public void disregardBackpressure() {
            if (this.streamingContext.executor().inEventLoop()) {
                this.disregardBackpressure0();
            } else {
                this.streamingContext.executor().execute(this::disregardBackpressure0);
            }
        }

        private void disregardBackpressure0() {
            long oldDemand = this.demand;
            this.demand = Long.MAX_VALUE;
            if (oldDemand <= 0L && Http1ResponseHandler.this.state == this) {
                this.streamingContext.read();
            }
        }
    }

    private final class BufferedContent
    extends ReaderState<HttpContent> {
        private final ResponseListener listener;
        private final HttpResponse response;
        private List<ByteBuf> buffered;

        BufferedContent(ResponseListener listener, HttpResponse response) {
            this.listener = listener;
            this.response = response;
        }

        @Override
        void read(ChannelHandlerContext ctx, HttpContent msg) {
            if (msg.content().isReadable()) {
                if (this.buffered == null) {
                    this.buffered = new ArrayList<ByteBuf>();
                }
                this.buffered.add(msg.content());
            } else {
                msg.release();
            }
            if (msg instanceof LastHttpContent) {
                List<ByteBuf> buffered = this.buffered;
                this.buffered = null;
                Http1ResponseHandler.this.transitionToState(ctx, this, AfterContent.INSTANCE);
                BodySizeLimits limits = this.listener.sizeLimits();
                if (buffered == null) {
                    this.complete((CloseableByteBody)NettyByteBodyFactory.empty());
                } else if (buffered.size() == 1) {
                    this.complete(new NettyByteBodyFactory(ctx.channel()).createChecked(limits, buffered.get(0)));
                } else {
                    CompositeByteBuf composite = ctx.alloc().compositeBuffer();
                    composite.addComponents(true, buffered);
                    this.complete(new NettyByteBodyFactory(ctx.channel()).createChecked(limits, (ByteBuf)composite));
                }
                this.listener.finish(ctx);
            }
        }

        @Override
        void channelReadComplete(ChannelHandlerContext ctx) {
            this.devolveToStreaming(ctx);
            Http1ResponseHandler.this.state.channelReadComplete(ctx);
        }

        @Override
        void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.devolveToStreaming(ctx);
            Http1ResponseHandler.this.state.exceptionCaught(ctx, cause);
        }

        private void devolveToStreaming(ChannelHandlerContext ctx) {
            assert (ctx.executor().inEventLoop());
            UnbufferedContent unbufferedContent = new UnbufferedContent(this.listener, ctx, this.response);
            if (this.buffered != null) {
                for (ByteBuf buf : this.buffered) {
                    unbufferedContent.add(NettyReadBufferFactory.of((ByteBufAllocator)ctx.alloc()).adapt(buf));
                }
            }
            Http1ResponseHandler.this.transitionToState(ctx, this, unbufferedContent);
            this.complete((CloseableByteBody)new StreamingNettyByteBody(unbufferedContent.streaming));
        }

        private void complete(CloseableByteBody body) {
            assert (Http1ResponseHandler.this.state != this) : "should have been replaced already";
            this.listener.complete(this.response, body);
        }
    }
}

