/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.execution.DelayedExecutionFlow;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.exceptions.HttpClientException;
import io.micronaut.http.client.netty.BlockHint;
import io.micronaut.http.client.netty.ConnectionManager;
import io.micronaut.http.client.netty.Pool;
import io.micronaut.http.netty.channel.loom.EventLoopVirtualThreadScheduler;
import io.netty.channel.EventLoop;
import io.netty.channel.SingleThreadIoEventLoop;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.internal.ThreadExecutorMap;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;

@Internal
final class Pool49
implements Pool {
    private final Pool.Listener listener;
    private final Logger log;
    private final HttpClientConfiguration.ConnectionPoolConfiguration connectionPoolConfiguration;
    private final Map<EventExecutor, LocalPoolPair> localPoolsByLoop;
    private final List<LocalPoolPair> localPools;
    @Nullable
    private final LongAdder globalPending;
    private final AtomicReference<GlobalStats> globalStats = new AtomicReference<GlobalStats>(GlobalStats.EMPTY);
    private final Queue<PendingRequest> globalPendingRequests = new LinkedBlockingQueue<PendingRequest>();
    Function<List<LocalPoolPair>, LocalPoolPair> pickPreferredPoolOverride;

    Pool49(Pool.Listener listener, Logger log, HttpClientConfiguration.ConnectionPoolConfiguration connectionPoolConfiguration, Iterable<? extends EventExecutor> group) {
        this.log = log;
        this.connectionPoolConfiguration = connectionPoolConfiguration;
        this.listener = listener;
        this.localPoolsByLoop = new LinkedHashMap<EventExecutor, LocalPoolPair>();
        for (EventExecutor eventExecutor : group) {
            this.localPoolsByLoop.put(eventExecutor, new LocalPoolPair(eventExecutor));
        }
        this.localPools = List.copyOf(this.localPoolsByLoop.values());
        this.globalPending = connectionPoolConfiguration.getMaxPendingAcquires() != Integer.MAX_VALUE ? new LongAdder() : null;
    }

    private void dispatchSafe(Pool.ResizerConnection connection, PendingRequest toDispatch) {
        block2: {
            try {
                connection.dispatch(toDispatch);
            }
            catch (Exception e) {
                if (toDispatch.tryCompleteExceptionally(e)) break block2;
                this.log.debug("Failure during connection dispatch operation, but dispatch request was already complete.", (Throwable)e);
            }
        }
    }

    @Override
    public void onNewConnectionFailure(@NonNull EventLoop eventLoop, @Nullable Throwable error) throws Exception {
        LocalPoolPair poolPair = this.localPoolsByLoop.get(eventLoop);
        assert (poolPair != null);
        poolPair.onNewConnectionFailure(this.listener.wrapError(error));
    }

    @Override
    public Pool.PendingRequest createPendingRequest(@Nullable BlockHint blockHint) {
        return new PendingRequest(blockHint);
    }

    @Override
    public Pool.Http1PoolEntry createHttp1PoolEntry(@NonNull EventLoop eventLoop, @NonNull Pool.ResizerConnection connection) {
        return new Http1PoolEntry(eventLoop, connection);
    }

    @Override
    public Pool.Http2PoolEntry createHttp2PoolEntry(@NonNull EventLoop eventLoop, @NonNull Pool.ResizerConnection connection) {
        return new Http2PoolEntry(eventLoop, connection);
    }

    @Override
    public void forEachConnection(Consumer<Pool.ResizerConnection> c) {
        for (LocalPoolPair localPool : this.localPools) {
            localPool.http1.connections.forEach(e -> c.accept(e.connection));
            localPool.http2.connections.forEach(e -> c.accept(e.connection));
        }
    }

    @Nullable
    LocalPoolPair pickPreferredPool() throws HttpClientException {
        if (this.pickPreferredPoolOverride != null) {
            return this.pickPreferredPoolOverride.apply(this.localPools);
        }
        LocalPoolPair poolPair = null;
        HttpClientConfiguration.ConnectionPoolConfiguration.ConnectionLocality configLocality = this.connectionPoolConfiguration.getConnectionLocality();
        if (configLocality != HttpClientConfiguration.ConnectionPoolConfiguration.ConnectionLocality.IGNORE) {
            EventExecutor currentExecutor = null;
            EventLoopVirtualThreadScheduler elvts = EventLoopVirtualThreadScheduler.current();
            if (elvts != null) {
                currentExecutor = elvts.eventLoop();
            }
            if (currentExecutor == null) {
                currentExecutor = ThreadExecutorMap.currentExecutor();
            }
            if (currentExecutor == null) {
                for (LocalPoolPair pool : this.localPools) {
                    if (!pool.loop.inEventLoop()) continue;
                    poolPair = pool;
                    break;
                }
            } else {
                poolPair = this.localPoolsByLoop.get(currentExecutor);
            }
            if (poolPair == null && configLocality == HttpClientConfiguration.ConnectionPoolConfiguration.ConnectionLocality.ENFORCED_ALWAYS) {
                throw new HttpClientException("Attempted to open a HTTP connection from thread " + String.valueOf(Thread.currentThread()) + " which is not part of the client event loop group, but configured the pool in locality mode ENFORCED_ALWAYS, which disallows requesting from outside this group");
            }
        }
        return poolPair;
    }

    private boolean openConnectionStep1() {
        GlobalStats oldStats;
        do {
            if (!this.limitsHit(oldStats = this.globalStats.get())) continue;
            return false;
        } while (!this.globalStats.compareAndSet(oldStats, oldStats.addPendingConnectionCount(1)));
        return true;
    }

    private boolean limitsHit(GlobalStats oldStats) {
        return oldStats.pendingConnectionCount >= this.connectionPoolConfiguration.getMaxPendingConnections() || oldStats.seenHttp1 && oldStats.http1ConnectionCount + oldStats.pendingConnectionCount >= this.connectionPoolConfiguration.getMaxConcurrentHttp1Connections() || oldStats.seenHttp2 && oldStats.http2ConnectionCount + oldStats.pendingConnectionCount >= this.connectionPoolConfiguration.getMaxConcurrentHttp2Connections() || !oldStats.seenHttp1 && !oldStats.seenHttp2 && (oldStats.pendingConnectionCount >= this.connectionPoolConfiguration.getMaxConcurrentHttp1Connections() || oldStats.pendingConnectionCount >= this.connectionPoolConfiguration.getMaxConcurrentHttp2Connections());
    }

    private void openGlobalConnectionIfNecessary() {
        while (!this.globalPendingRequests.isEmpty()) {
            if (!this.openConnectionStep1()) {
                return;
            }
            PendingRequest request = this.globalPendingRequests.poll();
            LocalPoolPair pool = request == null || request.preferredPool == null ? this.localPools.get(ThreadLocalRandom.current().nextInt(this.localPools.size())) : request.preferredPool;
            pool.loop.execute(() -> {
                pool.openConnectionStep2();
                if (request != null) {
                    request.destPool = pool;
                    pool.addLocalPendingRequest(request);
                }
                pool.openConnectionStep3();
            });
            if (request != null) continue;
            break;
        }
        if (!this.limitsHit(this.globalStats.get())) {
            for (LocalPoolPair pool : RandomOffsetIterator.iterable(this.localPools)) {
                if (!pool.needPendingConnection) continue;
                pool.loop.execute(pool::openLocalConnectionIfNecessary);
            }
        }
    }

    private record GlobalStats(int http1ConnectionCount, int http2ConnectionCount, int pendingConnectionCount, boolean seenHttp1, boolean seenHttp2) {
        static final GlobalStats EMPTY = new GlobalStats(0, 0, 0, false, false);

        GlobalStats addHttp1ConnectionCount(int n) {
            return new GlobalStats(this.http1ConnectionCount + n, this.http2ConnectionCount, this.pendingConnectionCount, true, this.seenHttp2);
        }

        GlobalStats addHttp2ConnectionCount(int n) {
            return new GlobalStats(this.http1ConnectionCount, this.http2ConnectionCount + n, this.pendingConnectionCount, this.seenHttp1, true);
        }

        GlobalStats addPendingConnectionCount(int n) {
            return new GlobalStats(this.http1ConnectionCount, this.http2ConnectionCount, this.pendingConnectionCount + n, this.seenHttp1, this.seenHttp2);
        }
    }

    final class LocalPoolPair {
        final EventExecutor loop;
        final LocalPool<Http1PoolEntry> http1;
        final LocalPool<Http2PoolEntry> http2;
        int localPendingConnections = 0;
        final AtomicBoolean dispatchPendingRequestsQueued = new AtomicBoolean(false);
        final Queue<PendingRequest> localPendingRequests = new ArrayDeque<PendingRequest>();
        volatile boolean needPendingConnection = false;

        LocalPoolPair(EventExecutor loop) {
            this.loop = loop;
            this.http1 = new LocalPool();
            this.http2 = new LocalPool();
        }

        void notifyGlobalPendingRequestQueued() {
            if (!this.dispatchPendingRequestsQueued.compareAndSet(false, true)) {
                return;
            }
            this.loop.execute(() -> {
                this.dispatchPendingRequestsQueued.set(false);
                this.dispatchPendingRequests();
            });
        }

        @Nullable
        PoolEntry findAvailablePoolEntry() {
            assert (this.loop.inEventLoop());
            PoolEntry http2 = this.http2.peekAvailable();
            if (http2 != null) {
                return http2;
            }
            PoolEntry http1 = this.http1.peekAvailable();
            if (http1 != null) {
                return http1;
            }
            return null;
        }

        private void addLocalPendingRequest(PendingRequest request) {
            this.localPendingRequests.add(request);
            this.needPendingConnection = true;
        }

        void dispatchPendingRequests() {
            PendingRequest request;
            PoolEntry poolEntry;
            while (!this.localPendingRequests.isEmpty()) {
                poolEntry = this.findAvailablePoolEntry();
                if (poolEntry == null) {
                    return;
                }
                request = this.localPendingRequests.poll();
                assert (request != null);
                request.dispatchTo(poolEntry);
            }
            this.needPendingConnection = false;
            if (Pool49.this.globalPendingRequests.isEmpty()) {
                return;
            }
            while ((poolEntry = this.findAvailablePoolEntry()) != null) {
                request = Pool49.this.globalPendingRequests.poll();
                if (request == null) {
                    return;
                }
                request.dispatchTo(poolEntry);
            }
            return;
        }

        void openConnectionStep2() {
            ++this.localPendingConnections;
            this.needPendingConnection = this.localPendingRequests.size() < this.localPendingConnections;
        }

        void openConnectionStep3() {
            try {
                Pool49.this.listener.openNewConnection((EventLoop)this.loop);
            }
            catch (Exception e) {
                this.onNewConnectionFailure(e);
            }
        }

        void openLocalConnectionIfNecessary() {
            assert (this.loop.inEventLoop());
            while (this.localPendingRequests.size() > this.localPendingConnections && Pool49.this.openConnectionStep1()) {
                this.openConnectionStep2();
                this.openConnectionStep3();
            }
        }

        void onNewConnectionFailure(Throwable error) {
            assert (this.loop.inEventLoop());
            Pool49.this.globalStats.updateAndGet(s -> s.addPendingConnectionCount(-1));
            --this.localPendingConnections;
            PendingRequest local = this.localPendingRequests.poll();
            if (local != null) {
                local.tryCompleteExceptionally(error);
            } else {
                PendingRequest global = Pool49.this.globalPendingRequests.poll();
                if (global != null) {
                    global.tryCompleteExceptionally(error);
                } else {
                    Pool49.this.log.error("Failed to connect to remote", error);
                }
            }
            this.openLocalConnectionIfNecessary();
            Pool49.this.openGlobalConnectionIfNecessary();
        }

        public String toString() {
            String s;
            EventExecutor eventExecutor = this.loop;
            if (eventExecutor instanceof SingleThreadIoEventLoop) {
                SingleThreadIoEventLoop l = (SingleThreadIoEventLoop)eventExecutor;
                s = l.threadProperties().name();
            } else {
                s = this.loop.toString();
            }
            return "Pool[" + s + "]";
        }
    }

    final class PendingRequest
    extends AtomicBoolean
    implements Pool.PendingRequest {
        private static final AtomicInteger NEXT_DEBUG_ID = new AtomicInteger(1);
        @Nullable
        final BlockHint blockHint;
        private final DelayedExecutionFlow<ConnectionManager.PoolHandle> sink = DelayedExecutionFlow.create();
        private final LocalPoolPair preferredPool;
        private final boolean permitStealing;
        private volatile LocalPoolPair destPool;
        private int debugId;

        PendingRequest(BlockHint blockHint) {
            this.blockHint = blockHint;
            this.preferredPool = Pool49.this.pickPreferredPool();
            this.permitStealing = this.preferredPool == null || Pool49.this.connectionPoolConfiguration.getConnectionLocality() == HttpClientConfiguration.ConnectionPoolConfiguration.ConnectionLocality.PREFERRED;
        }

        private synchronized int debugId() {
            if (this.debugId == 0) {
                this.debugId = NEXT_DEBUG_ID.getAndIncrement();
            }
            return this.debugId;
        }

        @Override
        @NonNull
        public ExecutionFlow<ConnectionManager.PoolHandle> flow() {
            return this.sink;
        }

        @Override
        public void dispatch() {
            if (Pool49.this.globalPending != null && Pool49.this.globalPending.sum() >= (long)Pool49.this.connectionPoolConfiguration.getMaxPendingAcquires()) {
                this.tryCompleteExceptionally(new HttpClientException("Cannot acquire connection, exceeded max pending acquires configuration"));
                return;
            }
            if (Pool49.this.log.isTraceEnabled()) {
                Pool49.this.log.trace("{}: Starting dispatch, preferred pool {}", (Object)this, (Object)this.preferredPool);
            }
            if (Pool49.this.globalPending != null) {
                Pool49.this.globalPending.increment();
            }
            this.redispatch();
        }

        @Override
        public void redispatch() {
            if (this.preferredPool == null) {
                this.destPool = Pool49.this.localPools.get(ThreadLocalRandom.current().nextInt(Pool49.this.localPools.size()));
                if (Pool49.this.log.isTraceEnabled()) {
                    Pool49.this.log.trace("{}: Scheduling dispatch on {}", (Object)this, (Object)this.destPool);
                }
            } else {
                this.destPool = this.preferredPool;
            }
            if (this.destPool.loop.inEventLoop()) {
                this.dispatchLocal();
            } else {
                this.destPool.loop.execute(this::dispatchLocal);
            }
        }

        private void dispatchLocal() {
            PoolEntry available;
            assert (this.destPool.loop.inEventLoop());
            boolean traceEnabled = Pool49.this.log.isTraceEnabled();
            if (traceEnabled) {
                Pool49.this.log.trace("{}: Attempting dispatch on {}", (Object)this, (Object)this.destPool);
            }
            if ((available = this.destPool.findAvailablePoolEntry()) != null) {
                this.dispatchTo(available);
                return;
            }
            if (this.permitStealing) {
                for (LocalPoolPair pool : RandomOffsetIterator.iterable(Pool49.this.localPools)) {
                    if (pool == this.destPool || pool.http1.firstAvailable == null && pool.http2.firstAvailable == null) continue;
                    this.destPool = pool;
                    pool.loop.execute(this::dispatchLocal);
                    return;
                }
            }
            if (this.preferredPool != null && this.destPool != this.preferredPool) {
                if (traceEnabled) {
                    Pool49.this.log.trace("{}: Moving back to preferred pool to open a new connection", (Object)this);
                }
                this.destPool = this.preferredPool;
                this.destPool.loop.execute(this::dispatchLocal);
                return;
            }
            if (this.blockHint != null && this.blockHint.blocks((EventExecutor)((EventLoop)this.destPool.loop))) {
                this.tryCompleteExceptionally(BlockHint.createException());
                return;
            }
            boolean open = Pool49.this.openConnectionStep1();
            if (open) {
                this.destPool.openConnectionStep2();
            }
            if (open || !this.permitStealing) {
                if (traceEnabled) {
                    Pool49.this.log.trace("{}: Adding to local pending requests", (Object)this);
                }
                this.destPool.addLocalPendingRequest(this);
            } else {
                if (traceEnabled) {
                    Pool49.this.log.trace("{}: Adding to global pending requests", (Object)this);
                }
                this.destPool = null;
                Pool49.this.globalPendingRequests.add(this);
                for (LocalPoolPair pool : Pool49.this.localPools) {
                    pool.notifyGlobalPendingRequestQueued();
                }
            }
            if (open) {
                if (traceEnabled) {
                    Pool49.this.log.trace("{}: Opening a new connection", (Object)this);
                }
                this.destPool.openConnectionStep3();
            }
        }

        private void dispatchTo(PoolEntry entry) {
            if (Pool49.this.log.isTraceEnabled()) {
                Pool49.this.log.trace("{}: Dispatching to connection {}", (Object)this, (Object)entry);
            }
            if (this.destPool == null) {
                this.destPool = entry.poolPair;
            } else {
                assert (this.destPool.loop.inEventLoop());
                assert (this.destPool == entry.poolPair);
            }
            BlockHint blockHint = this.blockHint;
            if (blockHint != null && blockHint.blocks(entry.poolPair.loop)) {
                this.tryCompleteExceptionally(BlockHint.createException());
                return;
            }
            entry.preDispatch(this);
            Pool49.this.dispatchSafe(entry.connection, this);
        }

        @Override
        @Nullable
        public EventExecutor likelyEventLoop() {
            LocalPoolPair pool = this.destPool;
            return pool == null ? null : pool.loop;
        }

        boolean tryCompleteExceptionally(Throwable t) {
            if (this.compareAndSet(false, true)) {
                if (Pool49.this.globalPending != null) {
                    Pool49.this.globalPending.decrement();
                }
                this.sink.completeExceptionally(t);
                return true;
            }
            return false;
        }

        @Override
        public boolean tryComplete(ConnectionManager.PoolHandle value) {
            if (this.compareAndSet(false, true)) {
                if (Pool49.this.globalPending != null) {
                    Pool49.this.globalPending.decrement();
                }
                if (this.sink.isCancelled()) {
                    return false;
                }
                this.sink.complete((Object)value);
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return "PendingRequest[" + this.debugId() + "]";
        }
    }

    final class Http1PoolEntry
    extends PoolEntry
    implements Pool.Http1PoolEntry {
        Http1PoolEntry(EventLoop eventLoop, Pool.ResizerConnection connection) {
            super(eventLoop, connection);
        }

        @Override
        public void onConnectionEstablished() {
            this.checkInEventLoop();
            if (this.poolPair.http1.connections.add(this)) {
                this.markAvailable();
                this.onOpenConnection();
            }
        }

        @Override
        public void onConnectionInactive() {
            this.checkInEventLoop();
            this.poolPair.http1.removeAvailable(this);
            if (this.poolPair.http1.connections.remove(this)) {
                Pool49.this.globalStats.updateAndGet(s -> s.addHttp1ConnectionCount(-1));
                Pool49.this.openGlobalConnectionIfNecessary();
            }
        }

        @Override
        public void markAvailable() {
            this.checkInEventLoop();
            if (this.poolPair.http1.addAvailable(this)) {
                if (Pool49.this.log.isTraceEnabled()) {
                    Pool49.this.log.trace("{} became available", (Object)this);
                }
                this.poolPair.dispatchPendingRequests();
            }
        }

        @Override
        public void markUnavailable() {
            if (this.poolPair.http1.removeAvailable(this) && Pool49.this.log.isTraceEnabled()) {
                Pool49.this.log.trace("{} became unavailable", (Object)this);
            }
        }

        @Override
        void preDispatch(PendingRequest request) {
            this.checkInEventLoop();
            if (!this.poolPair.http1.removeAvailable(this)) {
                throw new IllegalStateException("Entry wasn't available " + String.valueOf(this.poolPair.http1.firstAvailable) + " " + String.valueOf(this.poolPair.http1.lastAvailable) + " " + String.valueOf(this));
            }
        }
    }

    final class Http2PoolEntry
    extends PoolEntry
    implements Pool.Http2PoolEntry {
        private int available;

        Http2PoolEntry(EventLoop eventLoop, Pool.ResizerConnection connection) {
            super(eventLoop, connection);
            this.available = 0;
        }

        @Override
        public void onConnectionEstablished(int maxStreamCount) {
            this.checkInEventLoop();
            if (this.poolPair.http2.connections.add(this)) {
                this.markAvailable0(maxStreamCount);
                this.onOpenConnection();
            }
        }

        @Override
        public void onConnectionInactive() {
            this.checkInEventLoop();
            if (this.available > 0) {
                this.available = 0;
                this.poolPair.http2.removeAvailable(this);
            }
            if (this.poolPair.http2.connections.remove(this)) {
                Pool49.this.globalStats.updateAndGet(s -> s.addHttp2ConnectionCount(-1));
                Pool49.this.openGlobalConnectionIfNecessary();
            }
        }

        @Override
        public void markAvailable() {
            this.markAvailable0(1);
        }

        private void markAvailable0(int n) {
            this.checkInEventLoop();
            if (Pool49.this.log.isTraceEnabled()) {
                Pool49.this.log.trace("{} became available x{}", (Object)this, (Object)n);
            }
            boolean newlyAvailable = this.available == 0;
            this.available += n;
            if (newlyAvailable) {
                this.poolPair.http2.addAvailable(this);
                this.poolPair.dispatchPendingRequests();
            }
        }

        @Override
        public void markUnavailable() {
            this.checkInEventLoop();
            if (Pool49.this.log.isTraceEnabled()) {
                Pool49.this.log.trace("{} became unavailable", (Object)this);
            }
            this.available = 0;
            this.poolPair.http2.removeAvailable(this);
        }

        @Override
        void preDispatch(PendingRequest request) {
            this.checkInEventLoop();
            assert (this.available > 0);
            --this.available;
            if (this.available == 0) {
                this.poolPair.http2.removeAvailable(this);
            }
        }
    }

    private final class LocalPool<E extends PoolEntry> {
        final Set<E> connections = ConcurrentHashMap.newKeySet();
        volatile E firstAvailable;
        E lastAvailable;

        LocalPool() {
        }

        @Nullable
        PoolEntry peekAvailable() {
            return this.firstAvailable;
        }

        boolean addAvailable(E entry) {
            E last = this.lastAvailable;
            if (((PoolEntry)entry).nextAvailable != null || last == entry) {
                return false;
            }
            if (last == null) {
                assert (this.firstAvailable == null);
                this.firstAvailable = entry;
            } else {
                ((PoolEntry)last).nextAvailable = entry;
            }
            ((PoolEntry)entry).prevAvailable = last;
            this.lastAvailable = entry;
            return true;
        }

        boolean removeAvailable(E entry) {
            PoolEntry next = ((PoolEntry)entry).nextAvailable;
            PoolEntry prev = ((PoolEntry)entry).prevAvailable;
            if (next == null) {
                if (prev == null) {
                    if (this.lastAvailable == entry) {
                        assert (this.firstAvailable == entry);
                        this.lastAvailable = null;
                        this.firstAvailable = null;
                        return true;
                    }
                    return false;
                }
                ((PoolEntry)entry).prevAvailable = null;
                assert (this.lastAvailable == entry);
                this.lastAvailable = prev;
                prev.nextAvailable = null;
                return true;
            }
            ((PoolEntry)entry).nextAvailable = null;
            if (prev == null) {
                assert (this.firstAvailable == entry);
                this.firstAvailable = next;
                next.prevAvailable = null;
                return true;
            }
            ((PoolEntry)entry).prevAvailable = null;
            next.prevAvailable = prev;
            prev.nextAvailable = next;
            return true;
        }
    }

    private static final class RandomOffsetIterator<E>
    implements Iterator<E> {
        final List<E> source;
        final int start;
        int i;

        private RandomOffsetIterator(List<E> source) {
            this.source = source;
            this.i = this.start = ThreadLocalRandom.current().nextInt(source.size());
        }

        static <E> Iterable<E> iterable(List<E> source) {
            return () -> new RandomOffsetIterator(source);
        }

        @Override
        public boolean hasNext() {
            return this.i != -1;
        }

        @Override
        public E next() {
            int pos = this.i;
            if (pos == -1) {
                throw new NoSuchElementException();
            }
            int next = pos + 1;
            if (next == this.source.size()) {
                next = 0;
            }
            if (next == this.start) {
                next = -1;
            }
            this.i = next;
            return this.source.get(pos);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private abstract class PoolEntry {
        private static final AtomicInteger NEXT_DEBUG_ID = new AtomicInteger(1);
        final LocalPoolPair poolPair;
        final Pool.ResizerConnection connection;
        int debugId;
        PoolEntry prevAvailable;
        PoolEntry nextAvailable;

        PoolEntry(EventLoop eventLoop, Pool.ResizerConnection connection) {
            this.poolPair = Pool49.this.localPoolsByLoop.get(eventLoop);
            if (this.poolPair == null) {
                throw new IllegalArgumentException("Event loop not part of given group");
            }
            this.connection = connection;
        }

        private synchronized int debugId() {
            if (this.debugId == 0) {
                this.debugId = NEXT_DEBUG_ID.getAndIncrement();
            }
            return this.debugId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.debugId() + ", pool=" + String.valueOf(this.poolPair) + "]";
        }

        final void checkInEventLoop() {
            assert (this.poolPair.loop.inEventLoop());
        }

        final void onOpenConnection() {
            GlobalStats newStats;
            GlobalStats oldStats;
            this.checkInEventLoop();
            --this.poolPair.localPendingConnections;
            do {
                oldStats = Pool49.this.globalStats.get();
                newStats = oldStats.addPendingConnectionCount(-1);
            } while (!Pool49.this.globalStats.weakCompareAndSetPlain(oldStats, newStats = this instanceof Http2PoolEntry ? newStats.addHttp2ConnectionCount(1) : newStats.addHttp1ConnectionCount(1)));
            Pool49.this.openGlobalConnectionIfNecessary();
        }

        abstract void preDispatch(PendingRequest var1);
    }
}

