/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.NoSuchElementException;

@Internal
final class HttpLineBasedFrameDecoder
extends LineBasedFrameDecoder {
    static final String NAME = "micronaut-sse-event-stream";
    private boolean ignoreOneLast = false;

    HttpLineBasedFrameDecoder(int maxLength, boolean stripDelimiter, boolean failFast) {
        super(maxLength, stripDelimiter, failFast);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpResponse response;
        if (msg instanceof HttpResponse && (response = (HttpResponse)msg).status().equals((Object)HttpResponseStatus.CONTINUE)) {
            this.ignoreOneLast = true;
        }
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            super.channelRead(ctx, (Object)content.content());
        } else {
            ctx.fireChannelRead(msg);
        }
        if (msg instanceof LastHttpContent) {
            if (this.ignoreOneLast) {
                this.ignoreOneLast = false;
            } else {
                ctx.pipeline().remove(NAME);
                ctx.fireChannelRead((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            }
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        ctx.pipeline().addAfter(NAME, "micronaut-sse-content", Wrap.INSTANCE);
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        try {
            ctx.pipeline().remove("micronaut-sse-content");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @ChannelHandler.Sharable
    private static class Wrap
    extends ChannelInboundHandlerAdapter {
        static final ChannelHandler INSTANCE = new Wrap();
        static final String NAME = "micronaut-sse-content";

        private Wrap() {
        }

        public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws Exception {
            if (msg instanceof ByteBuf) {
                ByteBuf buffer = (ByteBuf)msg;
                ByteBuf copy = buffer.copy();
                buffer.release();
                ctx.fireChannelRead((Object)new DefaultHttpContent(copy));
            } else {
                ctx.fireChannelRead(msg);
            }
        }
    }
}

