/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyReader;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.cookies.NettyCookies;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FullNettyClientHttpResponse<B>
implements HttpResponse<B>,
NettyHttpResponseBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpClient.class);
    private final NettyHttpHeaders headers;
    private final NettyCookies nettyCookies;
    private final MutableConvertibleValues<Object> attributes;
    private final io.netty.handler.codec.http.HttpResponse nettyHttpResponse;
    private final ByteBuf unpooledContent;
    private final Map<Argument, Optional> convertedBodies = new HashMap<Argument, Optional>();
    private final MessageBodyHandlerRegistry handlerRegistry;
    private final B body;
    private final ConversionService conversionService;

    FullNettyClientHttpResponse(FullHttpResponse fullHttpResponse, MessageBodyHandlerRegistry handlerRegistry, Argument<B> bodyType, boolean convertBody, ConversionService conversionService) {
        Class rawBodyType;
        this.conversionService = conversionService;
        this.headers = new NettyHttpHeaders(fullHttpResponse.headers(), conversionService);
        this.attributes = new MutableConvertibleValuesMap();
        this.nettyHttpResponse = fullHttpResponse;
        this.unpooledContent = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((ByteBuf)fullHttpResponse.content()));
        this.handlerRegistry = handlerRegistry;
        this.nettyCookies = new NettyCookies(fullHttpResponse.headers(), conversionService);
        Class clazz = rawBodyType = bodyType != null ? bodyType.getType() : null;
        if (rawBodyType != null && !HttpStatus.class.isAssignableFrom(rawBodyType)) {
            if (HttpResponse.class.isAssignableFrom(bodyType.getType())) {
                Optional responseBodyType = bodyType.getFirstTypeVariable();
                if (responseBodyType.isPresent()) {
                    Argument finalResponseBodyType = (Argument)responseBodyType.get();
                    this.body = convertBody || this.isParseableBodyType(finalResponseBodyType.getType()) ? this.getBody(finalResponseBodyType).orElse(null) : null;
                } else {
                    this.body = null;
                }
            } else {
                this.body = convertBody || this.isParseableBodyType(rawBodyType) ? this.getBody(bodyType).orElse(null) : null;
            }
        } else {
            this.body = null;
        }
    }

    public String reason() {
        return this.nettyHttpResponse.status().reasonPhrase();
    }

    public int code() {
        return this.nettyHttpResponse.status().code();
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Cookies getCookies() {
        return this.nettyCookies;
    }

    public Optional<Cookie> getCookie(String name) {
        return this.nettyCookies.findCookie((CharSequence)name);
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    public <T> Optional<T> getBody(Class<T> type) {
        if (type == null) {
            return Optional.empty();
        }
        return this.getBody(Argument.of(type));
    }

    public <T> Optional<T> getBody(Argument<T> type) {
        if (type == null) {
            return Optional.empty();
        }
        if (type.getType() == Void.TYPE) {
            return Optional.empty();
        }
        Optional result = this.convertedBodies.computeIfAbsent(type, argument -> {
            Optional converted;
            boolean isOptional = argument.getType() == Optional.class;
            Argument finalArgument = isOptional ? argument.getFirstTypeVariable().orElse(argument) : argument;
            try {
                converted = this.convertByteBuf(finalArgument);
            }
            catch (RuntimeException e) {
                if (this.code() < 400) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error decoding HTTP error response body: {}", (Object)e.getMessage(), (Object)e);
                }
                converted = Optional.empty();
            }
            if (isOptional) {
                return Optional.of(converted);
            }
            return converted;
        });
        if (LOG.isTraceEnabled() && result.isEmpty()) {
            LOG.trace("Unable to convert response body to target type {}", (Object)type.getType());
        }
        return result;
    }

    private boolean isParseableBodyType(Class<?> rawBodyType) {
        return CharSequence.class.isAssignableFrom(rawBodyType) || Map.class.isAssignableFrom(rawBodyType);
    }

    private <T> Optional<T> convertByteBuf(Argument<T> type) {
        if (this.unpooledContent.refCnt() == 0 || this.unpooledContent.readableBytes() == 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Full HTTP response received an empty body");
            }
            if (!this.convertedBodies.isEmpty()) {
                for (Map.Entry<Argument, Optional> entry : this.convertedBodies.entrySet()) {
                    Argument existing = entry.getKey();
                    if (!type.getType().isAssignableFrom(existing.getType())) continue;
                    return entry.getValue();
                }
            }
            return Optional.empty();
        }
        Optional contentType = this.getContentType();
        if (contentType.isPresent()) {
            MediaType ct;
            MessageBodyReader r;
            Optional reader = this.handlerRegistry.findReader(type, List.of((MediaType)contentType.get()));
            if (reader.isPresent() && (r = (MessageBodyReader)reader.get()).isReadable(type, ct = (MediaType)contentType.get())) {
                return Optional.of(r.read(type, ct, (Headers)this.headers, NettyByteBufferFactory.DEFAULT.wrap(this.unpooledContent.slice())));
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Missing or unknown Content-Type received from server.");
        }
        return this.conversionService.convert((Object)this.unpooledContent.slice(), ByteBuf.class, type);
    }

    @NonNull
    public FullHttpResponse toFullHttpResponse() {
        DefaultFullHttpResponse copy = new DefaultFullHttpResponse(this.nettyHttpResponse.protocolVersion(), this.nettyHttpResponse.status(), this.unpooledContent, this.nettyHttpResponse.headers(), DefaultLastHttpContent.EMPTY_LAST_CONTENT.trailingHeaders());
        copy.setDecoderResult(this.nettyHttpResponse.decoderResult());
        return copy;
    }

    @NonNull
    public io.netty.handler.codec.http.HttpResponse toHttpResponse() {
        return this.nettyHttpResponse;
    }

    public boolean isStream() {
        return false;
    }
}

