/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty.ssl;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Secondary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.http.HttpVersion;
import io.micronaut.http.client.HttpVersionSelection;
import io.micronaut.http.client.netty.ssl.ClientSslBuilder;
import io.micronaut.http.netty.NettyTlsUtils;
import io.micronaut.http.ssl.AbstractClientSslConfiguration;
import io.micronaut.http.ssl.ClientAuthentication;
import io.micronaut.http.ssl.SslBuilder;
import io.micronaut.http.ssl.SslConfiguration;
import io.micronaut.http.ssl.SslConfigurationException;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import jakarta.inject.Singleton;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@BootstrapContextCompatible
@Secondary
public class NettyClientSslBuilder
extends SslBuilder<SslContext>
implements ClientSslBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(NettyClientSslBuilder.class);

    public NettyClientSslBuilder(ResourceResolver resourceResolver) {
        super(resourceResolver);
    }

    public final Optional<SslContext> build(SslConfiguration ssl) {
        return this.build(ssl, HttpVersion.HTTP_1_1);
    }

    public final Optional<SslContext> build(SslConfiguration ssl, HttpVersion httpVersion) {
        if (!ssl.isEnabled()) {
            return Optional.empty();
        }
        return Optional.of(this.build(ssl, HttpVersionSelection.forLegacyVersion((HttpVersion)httpVersion)));
    }

    @Override
    @NonNull
    public final SslContext build(SslConfiguration ssl, HttpVersionSelection versionSelection) {
        Optional ciphers;
        SslContextBuilder sslBuilder = SslContextBuilder.forClient().keyManager(this.getKeyManagerFactory(ssl)).trustManager(this.getTrustManagerFactory(ssl)).sslProvider(NettyTlsUtils.sslProvider((SslConfiguration)ssl));
        Optional protocols = ssl.getProtocols();
        if (protocols.isPresent()) {
            sslBuilder.protocols((String[])protocols.get());
        }
        if ((ciphers = ssl.getCiphers()).isPresent()) {
            sslBuilder = sslBuilder.ciphers(Arrays.asList((String[])ciphers.get()));
        } else if (versionSelection.isHttp2CipherSuites()) {
            sslBuilder.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
        }
        Optional clientAuthentication = ssl.getClientAuthentication();
        if (clientAuthentication.isPresent()) {
            ClientAuthentication clientAuth = (ClientAuthentication)clientAuthentication.get();
            if (clientAuth == ClientAuthentication.NEED) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.REQUIRE);
            } else if (clientAuth == ClientAuthentication.WANT) {
                sslBuilder = sslBuilder.clientAuth(ClientAuth.OPTIONAL);
            }
        }
        if (versionSelection.isAlpn()) {
            SslProvider provider = SslProvider.isAlpnSupported((SslProvider)SslProvider.OPENSSL) ? SslProvider.OPENSSL : SslProvider.JDK;
            sslBuilder.sslProvider(provider);
            sslBuilder.applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, versionSelection.getAlpnSupportedProtocols()));
        }
        try {
            return sslBuilder.build();
        }
        catch (SSLException ex) {
            throw new SslConfigurationException("An error occurred while setting up SSL", (Throwable)ex);
        }
    }

    @Override
    public final QuicSslContext buildHttp3(SslConfiguration ssl) {
        QuicSslContextBuilder sslBuilder = QuicSslContextBuilder.forClient().keyManager(this.getKeyManagerFactory(ssl), (String)ssl.getKeyStore().getPassword().orElse(null)).trustManager(this.getTrustManagerFactory(ssl)).applicationProtocols(Http3.supportedApplicationProtocols());
        Optional clientAuthentication = ssl.getClientAuthentication();
        if (clientAuthentication.isPresent()) {
            ClientAuthentication clientAuth = (ClientAuthentication)clientAuthentication.get();
            if (clientAuth == ClientAuthentication.NEED) {
                sslBuilder.clientAuth(ClientAuth.REQUIRE);
            } else if (clientAuth == ClientAuthentication.WANT) {
                sslBuilder.clientAuth(ClientAuth.OPTIONAL);
            }
        }
        return sslBuilder.build();
    }

    protected KeyManagerFactory getKeyManagerFactory(SslConfiguration ssl) {
        try {
            Optional ks = this.getKeyStore(ssl);
            if (ks.isPresent()) {
                return NettyTlsUtils.storeToFactory((SslConfiguration)ssl, (KeyStore)ks.orElse(null));
            }
            return null;
        }
        catch (Exception ex) {
            throw new SslConfigurationException((Throwable)ex);
        }
    }

    protected TrustManagerFactory getTrustManagerFactory(SslConfiguration ssl) {
        try {
            AbstractClientSslConfiguration configuration;
            Optional trustStore = this.getTrustStore(ssl);
            if (trustStore.isPresent()) {
                return super.getTrustManagerFactory((KeyStore)trustStore.get());
            }
            if (ssl instanceof AbstractClientSslConfiguration && (configuration = (AbstractClientSslConfiguration)ssl).isInsecureTrustAllCertificates()) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("HTTP Client is configured to trust all certificates ('insecure-trust-all-certificates' is set to true). Trusting all certificates is not secure and should not be used in production.");
                }
                return InsecureTrustManagerFactory.INSTANCE;
            }
            return null;
        }
        catch (Exception ex) {
            throw new SslConfigurationException((Throwable)ex);
        }
    }
}

