/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.ServerHttpRequest;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.client.netty.MutableHttpRequestWrapper;
import io.micronaut.http.netty.NettyHttpRequestBuilder;
import java.io.Closeable;
import java.io.IOException;

@Internal
final class RawHttpRequestWrapper<B>
extends MutableHttpRequestWrapper<B>
implements MutableHttpRequest<B>,
NettyHttpRequestBuilder,
ServerHttpRequest<B>,
Closeable {
    private final CloseableByteBody byteBody;

    public RawHttpRequestWrapper(ConversionService conversionService, MutableHttpRequest<B> delegate, CloseableByteBody byteBody) {
        super(conversionService, delegate);
        this.byteBody = byteBody;
    }

    @NonNull
    public ByteBody byteBody() {
        return this.byteBody;
    }

    @Nullable
    public ByteBody byteBodyDirect() {
        return this.byteBody;
    }

    @Override
    public <T> MutableHttpRequest<T> body(T body) {
        throw new UnsupportedOperationException("Changing the body of raw requests is currently not supported");
    }

    @NonNull
    public io.netty.handler.codec.http.HttpRequest toHttpRequestWithoutBody() {
        return NettyHttpRequestBuilder.asBuilder((HttpRequest)this.getDelegate()).toHttpRequestWithoutBody();
    }

    @Override
    public void close() throws IOException {
        this.byteBody.close();
    }
}

