/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.ByteBodyHttpResponse;
import io.micronaut.http.body.ByteBody;
import io.micronaut.http.body.CloseableByteBody;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import java.util.Optional;
import java.util.function.Supplier;

@Internal
final class NettyClientByteBodyResponse
implements ByteBodyHttpResponse<Object> {
    final HttpResponse nettyResponse;
    private final CloseableByteBody body;
    private final NettyHttpHeaders headers;
    private final Supplier<MutableConvertibleValues<Object>> attributes = SupplierUtil.memoized(MutableConvertibleValuesMap::new);

    NettyClientByteBodyResponse(HttpResponse nettyResponse, CloseableByteBody body, ConversionService conversionService) {
        this.nettyResponse = nettyResponse;
        this.body = body;
        this.headers = new NettyHttpHeaders(nettyResponse.headers(), conversionService);
    }

    @NonNull
    public ByteBody byteBody() {
        return this.body;
    }

    public void close() {
        this.body.close();
    }

    public int code() {
        return this.nettyResponse.status().code();
    }

    public String reason() {
        return this.nettyResponse.status().reasonPhrase();
    }

    @NonNull
    public NettyHttpHeaders getHeaders() {
        return this.headers;
    }

    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes.get();
    }

    @NonNull
    public Optional<Object> getBody() {
        return Optional.empty();
    }
}

