/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.client.HttpClient;
import io.micronaut.http.client.HttpClientConfiguration;
import io.micronaut.http.client.HttpClientFactory;
import io.micronaut.http.client.ProxyHttpClient;
import io.micronaut.http.client.ProxyHttpClientFactory;
import io.micronaut.http.client.RawHttpClient;
import io.micronaut.http.client.RawHttpClientFactory;
import io.micronaut.http.client.StreamingHttpClient;
import io.micronaut.http.client.StreamingHttpClientFactory;
import io.micronaut.http.client.netty.DefaultHttpClient;
import io.micronaut.http.client.sse.SseClient;
import io.micronaut.http.client.sse.SseClientFactory;
import io.micronaut.websocket.WebSocketClient;
import io.micronaut.websocket.WebSocketClientFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

@Internal
public class NettyHttpClientFactory
implements HttpClientFactory,
SseClientFactory,
ProxyHttpClientFactory,
StreamingHttpClientFactory,
WebSocketClientFactory,
RawHttpClientFactory {
    @NonNull
    public HttpClient createClient(URL url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public HttpClient createClient(URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @NonNull
    public ProxyHttpClient createProxyClient(URL url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public ProxyHttpClient createProxyClient(URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @NonNull
    public SseClient createSseClient(@Nullable URL url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public SseClient createSseClient(@Nullable URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @NonNull
    public StreamingHttpClient createStreamingClient(URL url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public StreamingHttpClient createStreamingClient(URL url, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    @NonNull
    public WebSocketClient createWebSocketClient(URI uri) {
        return this.createNettyClient(uri);
    }

    @NonNull
    public WebSocketClient createWebSocketClient(URI uri, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(uri, configuration);
    }

    @NonNull
    public RawHttpClient createRawClient(@Nullable URI url) {
        return this.createNettyClient(url);
    }

    @NonNull
    public RawHttpClient createRawClient(@Nullable URI url, @NonNull HttpClientConfiguration configuration) {
        return this.createNettyClient(url, configuration);
    }

    private DefaultHttpClient createNettyClient(URL url) {
        try {
            return this.createNettyClient(url != null ? url.toURI() : null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DefaultHttpClient createNettyClient(URL url, HttpClientConfiguration configuration) {
        try {
            return this.createNettyClient(url != null ? url.toURI() : null, configuration);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DefaultHttpClient createNettyClient(URI uri) {
        return DefaultHttpClient.builder().uri(uri).build();
    }

    private DefaultHttpClient createNettyClient(URI uri, HttpClientConfiguration configuration) {
        return DefaultHttpClient.builder().uri(uri).configuration(configuration).build();
    }
}

