/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.util.AttributeKey;

@Internal
@ChannelHandler.Sharable
abstract class InitialConnectionErrorHandler
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<Throwable> FAILURE_KEY = AttributeKey.valueOf(InitialConnectionErrorHandler.class, (String)"FAILURE_KEY");

    InitialConnectionErrorHandler() {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        InitialConnectionErrorHandler.setFailureCause(ctx.channel(), cause);
        ctx.close();
    }

    static void setFailureCause(Channel channel, Throwable cause) {
        channel.attr(FAILURE_KEY).set((Object)cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.onNewConnectionFailure(ctx.channel().eventLoop(), (Throwable)ctx.channel().attr(FAILURE_KEY).get());
    }

    protected abstract void onNewConnectionFailure(@NonNull EventLoop var1, @Nullable Throwable var2) throws Exception;
}

