/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.cookies;

import io.micronaut.core.annotation.Internal;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.Objects;
import javax.annotation.Nonnull;

@Internal
public class NettyCookie
implements io.micronaut.http.cookie.Cookie {
    private final Cookie nettyCookie;

    public NettyCookie(Cookie nettyCookie) {
        this.nettyCookie = nettyCookie;
    }

    public NettyCookie(String name, String value) {
        Objects.requireNonNull(name, "Argument name cannot be null");
        Objects.requireNonNull(value, "Argument value cannot be null");
        this.nettyCookie = new DefaultCookie(name, value);
    }

    public Cookie getNettyCookie() {
        return this.nettyCookie;
    }

    @Nonnull
    public String getName() {
        return this.nettyCookie.name();
    }

    @Nonnull
    public String getValue() {
        return this.nettyCookie.value();
    }

    public String getDomain() {
        return this.nettyCookie.domain();
    }

    public String getPath() {
        return this.nettyCookie.path();
    }

    public boolean isHttpOnly() {
        return this.nettyCookie.isHttpOnly();
    }

    public boolean isSecure() {
        return this.nettyCookie.isSecure();
    }

    public long getMaxAge() {
        return this.nettyCookie.maxAge();
    }

    @Nonnull
    public io.micronaut.http.cookie.Cookie maxAge(long maxAge) {
        this.nettyCookie.setMaxAge(maxAge);
        return this;
    }

    @Nonnull
    public io.micronaut.http.cookie.Cookie value(@Nonnull String value) {
        this.nettyCookie.setValue(value);
        return this;
    }

    @Nonnull
    public io.micronaut.http.cookie.Cookie domain(String domain) {
        this.nettyCookie.setDomain(domain);
        return this;
    }

    @Nonnull
    public io.micronaut.http.cookie.Cookie path(String path) {
        this.nettyCookie.setPath(path);
        return this;
    }

    @Nonnull
    public io.micronaut.http.cookie.Cookie secure(boolean secure) {
        this.nettyCookie.setSecure(secure);
        return this;
    }

    @Nonnull
    public io.micronaut.http.cookie.Cookie httpOnly(boolean httpOnly) {
        this.nettyCookie.setHttpOnly(httpOnly);
        return this;
    }

    public int compareTo(io.micronaut.http.cookie.Cookie o) {
        NettyCookie nettyCookie = (NettyCookie)o;
        return nettyCookie.nettyCookie.compareTo((Object)this.nettyCookie);
    }
}

