/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.websocket;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.bind.DefaultExecutableBinder;
import io.micronaut.core.bind.exceptions.UnsatisfiedArgumentException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.websocket.NettyRxWebSocketSession;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.bind.WebSocketState;
import io.micronaut.websocket.bind.WebSocketStateBinderRegistry;
import io.micronaut.websocket.context.WebSocketBean;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractNettyWebSocketHandler
extends SimpleChannelInboundHandler<Object> {
    public static final String ID = "websocket-handler";
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final ArgumentBinderRegistry<WebSocketState> webSocketBinder;
    protected final Map<String, Object> uriVariables;
    protected final WebSocketBean<?> webSocketBean;
    protected final HttpRequest<?> originatingRequest;
    protected final MethodExecutionHandle<?, ?> messageHandler;
    protected final NettyRxWebSocketSession session;
    protected final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected final WebSocketVersion webSocketVersion;
    protected final WebSocketSessionRepository webSocketSessionRepository;
    private final Argument<?> bodyArgument;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    protected AbstractNettyWebSocketHandler(ChannelHandlerContext ctx, RequestBinderRegistry binderRegistry, MediaTypeCodecRegistry mediaTypeCodecRegistry, WebSocketBean<?> webSocketBean, HttpRequest<?> request, Map<String, Object> uriVariables, WebSocketVersion version, WebSocketSessionRepository webSocketSessionRepository) {
        this.webSocketSessionRepository = webSocketSessionRepository;
        this.webSocketBinder = new WebSocketStateBinderRegistry((ArgumentBinderRegistry)binderRegistry);
        this.uriVariables = uriVariables;
        this.webSocketBean = webSocketBean;
        this.originatingRequest = request;
        this.messageHandler = webSocketBean.messageMethod().orElse(null);
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.webSocketVersion = version;
        this.session = this.createWebSocketSession(ctx);
        if (this.session != null) {
            DefaultExecutableBinder binder = new DefaultExecutableBinder();
            if (this.messageHandler != null) {
                BoundExecutable bound = binder.tryBind((Executable)this.messageHandler.getExecutableMethod(), this.webSocketBinder, (Object)new WebSocketState((WebSocketSession)this.session, this.originatingRequest));
                List unboundArguments = bound.getUnboundArguments();
                if (unboundArguments.size() == 1) {
                    this.bodyArgument = (Argument)unboundArguments.iterator().next();
                } else {
                    this.bodyArgument = null;
                    if (this.LOG.isErrorEnabled()) {
                        this.LOG.error("WebSocket @OnMessage method " + webSocketBean.getTarget() + "." + this.messageHandler.getExecutableMethod() + " should define exactly 1 message parameter, but found 2 possible candidates: " + unboundArguments);
                    }
                    if (this.session.isOpen()) {
                        this.session.close(CloseReason.INTERNAL_ERROR);
                    }
                }
            } else {
                this.bodyArgument = null;
            }
            Optional executionHandle = webSocketBean.openMethod();
            if (executionHandle.isPresent()) {
                BoundExecutable boundExecutable;
                MethodExecutionHandle openMethod;
                block18: {
                    openMethod = (MethodExecutionHandle)executionHandle.get();
                    boundExecutable = null;
                    try {
                        boundExecutable = this.bindMethod(request, this.webSocketBinder, openMethod, Collections.emptyList());
                    }
                    catch (Throwable e) {
                        if (this.LOG.isErrorEnabled()) {
                            this.LOG.error("Error Binding method @OnOpen for WebSocket [" + webSocketBean + "]: " + e.getMessage(), e);
                        }
                        if (!this.session.isOpen()) break block18;
                        this.session.close(CloseReason.INTERNAL_ERROR);
                    }
                }
                if (boundExecutable != null) {
                    try {
                        BoundExecutable finalBoundExecutable = boundExecutable;
                        Object result = this.invokeExecutable(finalBoundExecutable, openMethod);
                        if (Publishers.isConvertibleToPublisher((Object)result)) {
                            Flowable<?> flowable = this.instrumentPublisher(ctx, result);
                            flowable.subscribe(o -> {}, error -> {
                                if (this.LOG.isErrorEnabled()) {
                                    this.LOG.error("Error Opening WebSocket [" + webSocketBean + "]: " + error.getMessage(), error);
                                }
                                if (this.session.isOpen()) {
                                    this.session.close(CloseReason.INTERNAL_ERROR);
                                }
                            }, () -> {});
                        }
                    }
                    catch (Throwable e) {
                        if (this.LOG.isErrorEnabled()) {
                            this.LOG.error("Error Opening WebSocket [" + webSocketBean + "]: " + e.getMessage(), e);
                        }
                        if (this.session.isOpen()) {
                            this.session.close(CloseReason.INTERNAL_ERROR);
                        }
                    }
                }
            }
        } else {
            this.bodyArgument = null;
        }
    }

    public Argument<?> getBodyArgument() {
        return this.bodyArgument;
    }

    public NettyRxWebSocketSession getSession() {
        return this.session;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Optional opt = this.webSocketBean.errorMethod();
        if (opt.isPresent()) {
            MethodExecutionHandle errorMethod = (MethodExecutionHandle)opt.get();
            try {
                Object result;
                BoundExecutable boundExecutable = this.bindMethod(this.originatingRequest, this.webSocketBinder, errorMethod, Collections.singletonList(cause));
                Object target = errorMethod.getTarget();
                try {
                    result = boundExecutable.invoke(target);
                }
                catch (Exception e) {
                    if (this.LOG.isErrorEnabled()) {
                        this.LOG.error("Error invoking to @OnError handler " + target.getClass().getSimpleName() + "." + errorMethod.getExecutableMethod() + ": " + e.getMessage(), (Throwable)e);
                    }
                    this.handleUnexpected(ctx, e);
                    return;
                }
                if (Publishers.isConvertibleToPublisher((Object)result)) {
                    Flowable<?> flowable = this.instrumentPublisher(ctx, result);
                    flowable.toList().subscribe((objects, throwable) -> {
                        if (throwable != null && this.LOG.isErrorEnabled()) {
                            this.LOG.error("Error subscribing to @OnError handler " + target.getClass().getSimpleName() + "." + errorMethod.getExecutableMethod() + ": " + throwable.getMessage(), throwable);
                        }
                        this.handleUnexpected(ctx, (Throwable)throwable);
                    });
                }
            }
            catch (UnsatisfiedArgumentException e) {
                this.handleUnexpected(ctx, cause);
            }
        } else {
            this.handleUnexpected(ctx, cause);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.handleCloseReason(ctx, CloseReason.ABNORMAL_CLOSURE);
    }

    protected abstract NettyRxWebSocketSession createWebSocketSession(ChannelHandlerContext var1);

    protected Flowable<?> instrumentPublisher(ChannelHandlerContext ctx, Object result) {
        Flowable actual = (Flowable)Publishers.convertPublisher((Object)result, Flowable.class);
        return actual.subscribeOn(Schedulers.from((Executor)ctx.channel().eventLoop()));
    }

    protected Object invokeExecutable(BoundExecutable boundExecutable, MethodExecutionHandle<?, ?> messageHandler) {
        return boundExecutable.invoke(messageHandler.getTarget());
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    protected void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame msg) {
        block22: {
            if (msg instanceof TextWebSocketFrame || msg instanceof BinaryWebSocketFrame) {
                if (this.messageHandler == null) {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug("WebSocket bean [" + this.webSocketBean.getTarget() + "] received message, but defined no @OnMessage handler. Dropping frame...");
                    }
                    this.writeCloseFrameAndTerminate(ctx, CloseReason.UNSUPPORTED_DATA);
                } else {
                    Argument<?> bodyArgument = this.getBodyArgument();
                    Optional<Object> converted = ConversionService.SHARED.convert((Object)msg.content(), bodyArgument);
                    NettyRxWebSocketSession currentSession = this.getSession();
                    if (!converted.isPresent()) {
                        MediaType mediaType;
                        try {
                            mediaType = this.messageHandler.stringValue(Consumes.class).map(MediaType::new).orElse(MediaType.APPLICATION_JSON_TYPE);
                        }
                        catch (IllegalArgumentException e) {
                            this.exceptionCaught(ctx, e);
                            return;
                        }
                        try {
                            converted = this.mediaTypeCodecRegistry.findCodec(mediaType).map(codec -> codec.decode(bodyArgument, new NettyByteBufferFactory(ctx.alloc()).wrap(msg.content())));
                        }
                        catch (CodecException e) {
                            if (this.LOG.isErrorEnabled()) {
                                this.LOG.error("Error Processing WebSocket Message [" + this.webSocketBean + "]: " + e.getMessage(), (Throwable)e);
                            }
                            this.exceptionCaught(ctx, e);
                            return;
                        }
                    }
                    if (converted.isPresent()) {
                        Object v = converted.get();
                        DefaultExecutableBinder executableBinder = new DefaultExecutableBinder(Collections.singletonMap(bodyArgument, v));
                        try {
                            BoundExecutable boundExecutable = executableBinder.bind((Executable)this.messageHandler.getExecutableMethod(), this.webSocketBinder, (Object)new WebSocketState((WebSocketSession)currentSession, this.originatingRequest));
                            Object result = this.invokeExecutable(boundExecutable, this.messageHandler);
                            if (Publishers.isConvertibleToPublisher((Object)result)) {
                                Flowable<?> flowable = this.instrumentPublisher(ctx, result);
                                flowable.subscribe(o -> {}, error -> {
                                    if (this.LOG.isErrorEnabled()) {
                                        this.LOG.error("Error Processing WebSocket Message [" + this.webSocketBean + "]: " + error.getMessage(), error);
                                    }
                                    this.exceptionCaught(ctx, (Throwable)error);
                                }, () -> this.messageHandled(ctx, this.session, v));
                                break block22;
                            }
                            this.messageHandled(ctx, this.session, v);
                        }
                        catch (Throwable e) {
                            if (this.LOG.isErrorEnabled()) {
                                this.LOG.error("Error Processing WebSocket Message [" + this.webSocketBean + "]: " + e.getMessage(), e);
                            }
                            this.exceptionCaught(ctx, e);
                        }
                    } else {
                        this.writeCloseFrameAndTerminate(ctx, CloseReason.UNSUPPORTED_DATA.getCode(), CloseReason.UNSUPPORTED_DATA.getReason() + ": Received data cannot be converted to target type: " + bodyArgument);
                    }
                }
            } else if (msg instanceof PingWebSocketFrame) {
                PingWebSocketFrame frame = (PingWebSocketFrame)msg;
                ctx.writeAndFlush((Object)new PongWebSocketFrame(frame.content()));
            } else {
                if (msg instanceof PongWebSocketFrame) {
                    return;
                }
                if (msg instanceof CloseWebSocketFrame) {
                    CloseWebSocketFrame cwsf = (CloseWebSocketFrame)msg;
                    this.handleCloseFrame(ctx, cwsf);
                } else {
                    this.writeCloseFrameAndTerminate(ctx, CloseReason.UNSUPPORTED_DATA);
                }
            }
        }
    }

    protected void messageHandled(ChannelHandlerContext ctx, NettyRxWebSocketSession session, Object message) {
    }

    protected void writeCloseFrameAndTerminate(ChannelHandlerContext ctx, CloseReason closeReason) {
        int code = closeReason.getCode();
        String reason = closeReason.getReason();
        this.writeCloseFrameAndTerminate(ctx, code, reason);
    }

    private void handleCloseReason(ChannelHandlerContext ctx, CloseReason cr) {
        if (this.closed.compareAndSet(false, true)) {
            Optional opt;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Closing WebSocket session {} with reason {}", (Object)this.getSession(), (Object)cr);
            }
            if ((opt = this.webSocketBean.closeMethod()).isPresent()) {
                MethodExecutionHandle methodExecutionHandle = (MethodExecutionHandle)opt.get();
                Object target = methodExecutionHandle.getTarget();
                try {
                    BoundExecutable boundExecutable = this.bindMethod(this.originatingRequest, this.webSocketBinder, methodExecutionHandle, Collections.singletonList(cr));
                    this.invokeAndClose(ctx, target, boundExecutable, methodExecutionHandle, true);
                }
                catch (Throwable e) {
                    if (this.LOG.isErrorEnabled()) {
                        this.LOG.error("Error invoking @OnClose handler for WebSocket bean [" + target + "]: " + e.getMessage(), e);
                    }
                }
            } else {
                ctx.close();
            }
        }
    }

    private void handleCloseFrame(ChannelHandlerContext ctx, CloseWebSocketFrame cwsf) {
        CloseReason cr = new CloseReason(cwsf.statusCode(), cwsf.reasonText());
        this.handleCloseReason(ctx, cr);
    }

    private void invokeAndClose(ChannelHandlerContext ctx, Object target, BoundExecutable boundExecutable, MethodExecutionHandle<?, ?> methodExecutionHandle, boolean isClose) {
        Object result;
        try {
            result = this.invokeExecutable(boundExecutable, methodExecutionHandle);
        }
        catch (Exception e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error("Error invoking @OnClose handler " + target.getClass().getSimpleName() + "." + methodExecutionHandle.getExecutableMethod() + ": " + e.getMessage(), (Throwable)e);
            }
            ctx.close();
            return;
        }
        if (Publishers.isConvertibleToPublisher((Object)result)) {
            Flowable<?> flowable = this.instrumentPublisher(ctx, result);
            flowable.toList().subscribe((objects, throwable) -> {
                if (throwable != null && this.LOG.isErrorEnabled()) {
                    this.LOG.error("Error subscribing to @" + (isClose ? "OnClose" : "OnError") + " handler for WebSocket bean [" + target + "]: " + throwable.getMessage(), throwable);
                }
                ctx.close();
            });
        } else {
            ctx.close();
        }
    }

    private BoundExecutable bindMethod(HttpRequest<?> request, ArgumentBinderRegistry<WebSocketState> binderRegistry, MethodExecutionHandle<?, ?> openMethod, List<?> parameters) {
        ExecutableMethod executable = openMethod.getExecutableMethod();
        Map<Argument<?>, Object> preBound = this.prepareBoundVariables(executable, parameters);
        DefaultExecutableBinder executableBinder = new DefaultExecutableBinder(preBound);
        return executableBinder.bind((Executable)executable, binderRegistry, (Object)new WebSocketState((WebSocketSession)this.getSession(), request));
    }

    private Map<Argument<?>, Object> prepareBoundVariables(ExecutableMethod<?, ?> executable, List<?> parameters) {
        HashMap preBound = new HashMap(executable.getArguments().length);
        block0: for (Argument argument : executable.getArguments()) {
            Class type = argument.getType();
            for (Object object : parameters) {
                if (!type.isInstance(object)) continue;
                preBound.put(argument, object);
                continue block0;
            }
        }
        return preBound;
    }

    private void handleUnexpected(ChannelHandlerContext ctx, Throwable cause) {
        Channel channel;
        String msg;
        if (cause instanceof IOException && (msg = cause.getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        if (this.LOG.isErrorEnabled()) {
            this.LOG.error("Unexpected Exception in WebSocket [" + this.webSocketBean.getTarget() + "]: " + cause.getMessage(), cause);
        }
        if ((channel = ctx.channel()).isOpen()) {
            CloseReason internalError = CloseReason.INTERNAL_ERROR;
            this.writeCloseFrameAndTerminate(ctx, internalError);
        }
    }

    private void writeCloseFrameAndTerminate(ChannelHandlerContext ctx, int code, String reason) {
        CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(code, reason);
        ctx.channel().writeAndFlush((Object)closeFrame).addListener(future -> this.handleCloseFrame(ctx, new CloseWebSocketFrame(code, reason)));
    }
}

