/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Internal
@TypeHint(value={NettyMutableHttpResponse.class})
public class NettyMutableHttpResponse<B>
implements MutableHttpResponse<B> {
    private static final ServerCookieEncoder DEFAULT_SERVER_COOKIE_ENCODER = ServerCookieEncoder.LAX;
    protected FullHttpResponse nettyResponse;
    final NettyHttpHeaders headers;
    private final ConversionService conversionService;
    private B body;
    private final Map<Class, Optional> convertedBodies = new LinkedHashMap<Class, Optional>(1);
    private final MutableConvertibleValues<Object> attributes;
    private ServerCookieEncoder serverCookieEncoder = DEFAULT_SERVER_COOKIE_ENCODER;

    public NettyMutableHttpResponse(FullHttpResponse nettyResponse, ConversionService conversionService) {
        this.nettyResponse = nettyResponse;
        this.headers = new NettyHttpHeaders(nettyResponse.headers(), conversionService);
        this.attributes = new MutableConvertibleValuesMap(new ConcurrentHashMap(4), conversionService);
        this.conversionService = conversionService;
    }

    public NettyMutableHttpResponse(ConversionService conversionService) {
        this.nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        this.headers = new NettyHttpHeaders(this.nettyResponse.headers(), conversionService);
        this.attributes = new MutableConvertibleValuesMap(new ConcurrentHashMap(4), conversionService);
        this.conversionService = conversionService;
    }

    public String toString() {
        HttpStatus status = this.getStatus();
        return status.getCode() + " " + status.getReason();
    }

    public Optional<MediaType> getContentType() {
        Optional contentType = super.getContentType();
        if (contentType.isPresent()) {
            return contentType;
        }
        Optional<B> body = this.getBody();
        if (body.isPresent()) {
            return MediaType.fromType(body.get().getClass());
        }
        return Optional.empty();
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public HttpStatus getStatus() {
        return HttpStatus.valueOf((int)this.nettyResponse.status().code());
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        if (!(cookie instanceof NettyCookie)) {
            throw new IllegalArgumentException("Argument is not a Netty compatible Cookie");
        }
        NettyCookie nettyCookie = (NettyCookie)cookie;
        String value = this.serverCookieEncoder.encode(nettyCookie.getNettyCookie());
        this.headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, value);
        return this;
    }

    public MutableHttpResponse<B> cookies(Set<Cookie> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return this;
        }
        for (Cookie cookie : cookies) {
            this.cookie(cookie);
        }
        return this;
    }

    public Optional<B> getBody() {
        return Optional.ofNullable(this.body);
    }

    public <T1> Optional<T1> getBody(Class<T1> type) {
        return this.getBody(Argument.of(type));
    }

    public <T> Optional<T> getBody(Argument<T> type) {
        return this.convertedBodies.computeIfAbsent(type.getType(), aClass -> this.getBody().flatMap(b -> {
            ArgumentConversionContext context = ConversionContext.of((Argument)type);
            if (b instanceof ByteBuffer) {
                return this.conversionService.convert(((ByteBuffer)b).asNativeBuffer(), context);
            }
            return this.conversionService.convert(b, context);
        }));
    }

    public MutableHttpResponse<B> status(HttpStatus status, CharSequence message) {
        message = message == null ? status.getReason() : message;
        this.nettyResponse.setStatus(new HttpResponseStatus(status.getCode(), message.toString()));
        return this;
    }

    public FullHttpResponse getNativeResponse() {
        return this.nettyResponse;
    }

    public NettyMutableHttpResponse<B> body(B body) {
        this.body = body;
        if (body instanceof ByteBuf) {
            this.replace((ByteBuf)body);
        }
        return this;
    }

    public NettyMutableHttpResponse replace(ByteBuf body) {
        this.nettyResponse = this.nettyResponse.replace(body);
        this.headers.setNettyHeaders(this.nettyResponse.headers());
        return this;
    }

    public ServerCookieEncoder getServerCookieEncoder() {
        return this.serverCookieEncoder;
    }

    public void setServerCookieEncoder(ServerCookieEncoder serverCookieEncoder) {
        this.serverCookieEncoder = serverCookieEncoder;
    }
}

