/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.websocket;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.websocket.WebSocketMessageEncoder;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.RxWebSocketSession;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.AttributeKey;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

@Internal
public class NettyRxWebSocketSession
implements RxWebSocketSession {
    public static final AttributeKey<NettyRxWebSocketSession> WEB_SOCKET_SESSION_KEY = AttributeKey.newInstance((String)"micronaut.websocket.session");
    private final String id;
    private final Channel channel;
    private final HttpRequest<?> request;
    private final String protocolVersion;
    private final boolean isSecure;
    private final MediaTypeCodecRegistry codecRegistry;
    private final MutableConvertibleValues<Object> attributes;
    private final WebSocketMessageEncoder messageEncoder;

    protected NettyRxWebSocketSession(String id, Channel channel, HttpRequest<?> request, MediaTypeCodecRegistry codecRegistry, String protocolVersion, boolean isSecure) {
        this.id = id;
        this.channel = channel;
        this.request = request;
        this.protocolVersion = protocolVersion;
        this.isSecure = isSecure;
        this.channel.attr(WEB_SOCKET_SESSION_KEY).set((Object)this);
        this.codecRegistry = codecRegistry;
        this.messageEncoder = new WebSocketMessageEncoder(this.codecRegistry);
        this.attributes = request.getAttribute((CharSequence)"micronaut.SESSION", MutableConvertibleValues.class).orElseGet(MutableConvertibleValuesMap::new);
    }

    public String getId() {
        return this.id;
    }

    public MutableConvertibleValues<Object> getAttributes() {
        return this.attributes;
    }

    public boolean isOpen() {
        return this.channel.isOpen() && this.channel.isActive();
    }

    public boolean isWritable() {
        return this.channel.isWritable();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public Set<? extends RxWebSocketSession> getOpenSessions() {
        return Collections.emptySet();
    }

    public URI getRequestURI() {
        return this.request.getUri();
    }

    public ConvertibleMultiValues<String> getRequestParameters() {
        return this.request.getParameters();
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public <T> CompletableFuture<T> sendAsync(T message, MediaType mediaType) {
        if (this.isOpen()) {
            if (message != null) {
                CompletableFuture future = new CompletableFuture();
                WebSocketFrame frame = message instanceof WebSocketFrame ? (WebSocketFrame)message : this.messageEncoder.encodeMessage(message, mediaType);
                this.channel.writeAndFlush((Object)frame).addListener(f -> {
                    if (f.isSuccess()) {
                        future.complete(message);
                    } else {
                        future.completeExceptionally((Throwable)new WebSocketSessionException("Send Failure: " + f.cause().getMessage(), f.cause()));
                    }
                });
                return future;
            }
            return CompletableFuture.completedFuture(null);
        }
        throw new WebSocketSessionException("Session closed");
    }

    public void sendSync(Object message, MediaType mediaType) {
        if (this.isOpen()) {
            if (message != null) {
                try {
                    WebSocketFrame frame = message instanceof WebSocketFrame ? (WebSocketFrame)message : this.messageEncoder.encodeMessage(message, mediaType);
                    this.channel.writeAndFlush((Object)frame).sync().get();
                }
                catch (InterruptedException e) {
                    throw new WebSocketSessionException("Send interrupt: " + e.getMessage(), (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new WebSocketSessionException("Send Failure: " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            throw new WebSocketSessionException("Session closed");
        }
    }

    public <T> Flowable<T> send(T message, MediaType mediaType) {
        if (message == null) {
            return Flowable.empty();
        }
        return Flowable.create(emitter -> {
            if (!this.isOpen()) {
                emitter.onError((Throwable)new WebSocketSessionException("Session closed"));
            } else {
                WebSocketFrame frame = message instanceof WebSocketFrame ? (WebSocketFrame)message : this.messageEncoder.encodeMessage(message, mediaType);
                ChannelFuture channelFuture = this.channel.writeAndFlush((Object)frame);
                channelFuture.addListener(future -> {
                    if (future.isSuccess()) {
                        emitter.onNext(message);
                        emitter.onComplete();
                    } else {
                        emitter.onError((Throwable)new WebSocketSessionException("Send Failure: " + future.cause().getMessage(), future.cause()));
                    }
                });
            }
        }, (BackpressureStrategy)BackpressureStrategy.ERROR);
    }

    public void close() {
        this.close(CloseReason.NORMAL);
    }

    public void close(CloseReason closeReason) {
        if (this.channel.isOpen()) {
            this.channel.writeAndFlush((Object)new CloseWebSocketFrame(closeReason.getCode(), closeReason.getReason())).addListener(future -> this.channel.close());
        }
    }

    public String toString() {
        return "WebSocket Session: " + this.getId();
    }

    public MutableConvertibleValues<Object> put(CharSequence key, @Nullable Object value) {
        return this.attributes.put(key, value);
    }

    public MutableConvertibleValues<Object> remove(CharSequence key) {
        return this.attributes.remove(key);
    }

    public MutableConvertibleValues<Object> clear() {
        return this.attributes.clear();
    }

    public Set<String> names() {
        return this.attributes.names();
    }

    public Collection<Object> values() {
        return this.attributes.values();
    }

    public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
        return this.attributes.get(name, conversionContext);
    }
}

