/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.graal;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.SystemPropertiesSupport;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.graal.AutomaticFeatureUtils;
import io.micronaut.http.bind.binders.ContinuationArgumentBinder;
import io.micronaut.http.netty.channel.NettyThreadFactory;
import io.micronaut.http.netty.channel.converters.EpollChannelOptionFactory;
import io.micronaut.http.netty.channel.converters.KQueueChannelOptionFactory;
import io.micronaut.http.netty.websocket.NettyWebSocketSession;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

@Internal
@AutomaticFeature
public class HttpNettyFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class unsafeNew;
        RuntimeClassInitialization.initializeAtRunTime((String[])new String[]{"io.netty", "io.micronaut.http.server.netty.ServerAttributeKeys", "io.micronaut.http.server.netty.handler.accesslog.HttpAccessLogHandler", "io.micronaut.session.http.SessionLogElement", "io.micronaut.http.client.netty.ConnectTTLHandler", "io.micronaut.http.client.netty.DefaultHttpClient", "io.micronaut.http.server.netty.websocket.NettyServerWebSocketUpgradeHandler", "io.micronaut.buffer.netty.NettyByteBufferFactory"});
        RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{NettyWebSocketSession.class, NettyThreadFactory.class, EpollChannelOptionFactory.class, KQueueChannelOptionFactory.class, ContinuationArgumentBinder.class, ContinuationArgumentBinder.Companion.class});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"io.netty.util.internal.shaded.org.jctools"});
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"io.netty.util.internal.logging.InternalLoggerFactory", "io.netty.util.internal.logging.Slf4JLoggerFactory", "io.netty.util.internal.logging.LocationAwareSlf4JLogger"});
        try {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.registerClasses(access, "io.netty.channel.kqueue.KQueueChannelOption", "io.netty.channel.epoll.EpollChannelOption");
        this.registerMethods(access, "io.netty.buffer.AbstractByteBufAllocator", "toLeakAwareBuffer");
        this.registerMethods(access, "io.netty.buffer.AdvancedLeakAwareByteBuf", "touch", "recordLeakNonRefCountingOperation");
        this.registerMethods(access, "io.netty.util.ReferenceCountUtil", "touch");
        System.setProperty("io.netty.tryReflectionSetAccessible", "true");
        ((SystemPropertiesSupport)ImageSingletons.lookup(SystemPropertiesSupport.class)).initializeProperty("io.netty.tryReflectionSetAccessible", "true");
        try {
            RuntimeReflection.register((Executable[])new Executable[]{access.findClassByName("java.nio.DirectByteBuffer").getDeclaredConstructor(Long.TYPE, Integer.TYPE)});
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        Class unsafeOld = access.findClassByName("sun.misc.Unsafe");
        if (unsafeOld != null) {
            try {
                RuntimeReflection.register((Executable[])new Executable[]{unsafeOld.getDeclaredMethod("allocateUninitializedArray", Class.class, Integer.TYPE)});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if ((unsafeNew = access.findClassByName("jdk.internal.misc.Unsafe")) != null) {
            try {
                RuntimeReflection.register((Executable[])new Executable[]{unsafeNew.getDeclaredMethod("allocateUninitializedArray", Class.class, Integer.TYPE)});
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private void registerClasses(Feature.BeforeAnalysisAccess access, String ... classes) {
        for (String clazz : classes) {
            AutomaticFeatureUtils.registerClassForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)clazz);
            AutomaticFeatureUtils.registerFieldsForRuntimeReflection((Feature.BeforeAnalysisAccess)access, (String)clazz);
        }
    }

    private void registerMethods(Feature.BeforeAnalysisAccess access, String clz, String ... methods) {
        for (Method declaredMethod : access.findClassByName(clz).getDeclaredMethods()) {
            if (!Arrays.asList(methods).contains(declaredMethod.getName())) continue;
            RuntimeReflection.register((Executable[])new Executable[]{declaredMethod});
        }
    }
}

