/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.util.SupplierUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.multipart.AbstractHttpData;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MemoryFileUpload;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Supplier;

final class MixedFileUploadPatched
extends AbstractHttpData
implements FileUpload {
    private static final Supplier<ResourceLeakDetector<MixedFileUploadPatched>> LEAK_DETECTOR = SupplierUtil.memoized(() -> ResourceLeakDetectorFactory.instance().newResourceLeakDetector(MixedFileUploadPatched.class));
    private final String baseDir;
    private final boolean deleteOnExit;
    private FileUpload fileUpload;
    private final long limitSize;
    private final long definedSize;
    private final ResourceLeakTracker<MixedFileUploadPatched> tracker;

    public MixedFileUploadPatched(String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size, long limitSize, String baseDir, boolean deleteOnExit) {
        super(name, charset, size);
        this.limitSize = limitSize;
        this.fileUpload = size > this.limitSize ? new DiskFileUpload(name, filename, contentType, contentTransferEncoding, charset, size) : new MemoryFileUpload(name, filename, contentType, contentTransferEncoding, charset, size);
        this.tracker = LEAK_DETECTOR.get().track((Object)this);
        this.definedSize = size;
        this.baseDir = baseDir;
        this.deleteOnExit = deleteOnExit;
    }

    public void setMaxSize(long maxSize) {
        super.setMaxSize(maxSize);
        this.fileUpload.setMaxSize(maxSize);
    }

    public void addContent(ByteBuf buffer, boolean last) throws IOException {
        if (this.fileUpload instanceof MemoryFileUpload) {
            try {
                this.checkSize(this.fileUpload.length() + (long)buffer.readableBytes());
                if (this.fileUpload.length() + (long)buffer.readableBytes() > this.limitSize) {
                    DiskFileUpload diskFileUpload = new DiskFileUpload(this.fileUpload.getName(), this.fileUpload.getFilename(), this.fileUpload.getContentType(), this.fileUpload.getContentTransferEncoding(), this.fileUpload.getCharset(), this.definedSize, this.baseDir, this.deleteOnExit);
                    diskFileUpload.setMaxSize(this.getMaxSize());
                    ByteBuf data = this.fileUpload.getByteBuf();
                    if (data != null && data.isReadable()) {
                        diskFileUpload.addContent(data.retain(), false);
                    }
                    this.fileUpload.release();
                    this.fileUpload = diskFileUpload;
                }
            }
            catch (IOException e) {
                buffer.release();
                throw e;
            }
        }
        this.fileUpload.addContent(buffer, last);
    }

    public void delete() {
        this.fileUpload.delete();
        if (this.tracker != null) {
            this.tracker.close((Object)this);
        }
    }

    public byte[] get() throws IOException {
        return this.fileUpload.get();
    }

    public ByteBuf getByteBuf() throws IOException {
        return this.fileUpload.getByteBuf();
    }

    public String getContentType() {
        return this.fileUpload.getContentType();
    }

    public String getContentTransferEncoding() {
        return this.fileUpload.getContentTransferEncoding();
    }

    public String getFilename() {
        return this.fileUpload.getFilename();
    }

    public String getString() throws IOException {
        return this.fileUpload.getString();
    }

    public String getString(Charset encoding) throws IOException {
        return this.fileUpload.getString(encoding);
    }

    public boolean isCompleted() {
        return this.fileUpload.isCompleted();
    }

    public boolean isInMemory() {
        return this.fileUpload.isInMemory();
    }

    public long length() {
        return this.fileUpload.length();
    }

    public long definedLength() {
        return this.fileUpload.definedLength();
    }

    public MixedFileUploadPatched touch() {
        return this.touch(null);
    }

    public MixedFileUploadPatched touch(Object hint) {
        if (this.tracker != null) {
            this.tracker.record(hint);
        }
        return this;
    }

    public boolean renameTo(File dest) throws IOException {
        return this.fileUpload.renameTo(dest);
    }

    public void setCharset(Charset charset) {
        super.setCharset(charset);
        if (this.fileUpload != null) {
            this.fileUpload.setCharset(charset);
        }
    }

    public void setContent(ByteBuf buffer) throws IOException {
        try {
            this.checkSize(buffer.readableBytes());
        }
        catch (IOException e) {
            buffer.release();
            throw e;
        }
        if ((long)buffer.readableBytes() > this.limitSize && this.fileUpload instanceof MemoryFileUpload) {
            FileUpload memoryUpload = this.fileUpload;
            this.fileUpload = new DiskFileUpload(memoryUpload.getName(), memoryUpload.getFilename(), memoryUpload.getContentType(), memoryUpload.getContentTransferEncoding(), memoryUpload.getCharset(), this.definedSize, this.baseDir, this.deleteOnExit);
            this.fileUpload.setMaxSize(this.getMaxSize());
            memoryUpload.release();
        }
        this.fileUpload.setContent(buffer);
    }

    public void setContent(File file) throws IOException {
        this.checkSize(file.length());
        if (file.length() > this.limitSize && this.fileUpload instanceof MemoryFileUpload) {
            FileUpload memoryUpload = this.fileUpload;
            this.fileUpload = new DiskFileUpload(memoryUpload.getName(), memoryUpload.getFilename(), memoryUpload.getContentType(), memoryUpload.getContentTransferEncoding(), memoryUpload.getCharset(), this.definedSize, this.baseDir, this.deleteOnExit);
            this.fileUpload.setMaxSize(this.getMaxSize());
            memoryUpload.release();
        }
        this.fileUpload.setContent(file);
    }

    public void setContent(InputStream inputStream) throws IOException {
        if (this.fileUpload instanceof MemoryFileUpload) {
            FileUpload memoryUpload = this.fileUpload;
            this.fileUpload = new DiskFileUpload(this.fileUpload.getName(), this.fileUpload.getFilename(), this.fileUpload.getContentType(), this.fileUpload.getContentTransferEncoding(), this.fileUpload.getCharset(), this.definedSize, this.baseDir, this.deleteOnExit);
            this.fileUpload.setMaxSize(this.getMaxSize());
            memoryUpload.release();
        }
        this.fileUpload.setContent(inputStream);
    }

    public void setContentType(String contentType) {
        this.fileUpload.setContentType(contentType);
    }

    public void setContentTransferEncoding(String contentTransferEncoding) {
        this.fileUpload.setContentTransferEncoding(contentTransferEncoding);
    }

    public void setFilename(String filename) {
        this.fileUpload.setFilename(filename);
    }

    public InterfaceHttpData.HttpDataType getHttpDataType() {
        return this.fileUpload.getHttpDataType();
    }

    public int hashCode() {
        return this.fileUpload.hashCode();
    }

    public boolean equals(Object obj) {
        return this.fileUpload.equals(obj);
    }

    public int compareTo(InterfaceHttpData o) {
        return this.fileUpload.compareTo((Object)o);
    }

    public String toString() {
        return "Mixed: " + this.fileUpload;
    }

    public ByteBuf getChunk(int length) throws IOException {
        return this.fileUpload.getChunk(length);
    }

    public File getFile() throws IOException {
        return this.fileUpload.getFile();
    }

    public FileUpload copy() {
        return this.fileUpload.copy();
    }

    public FileUpload duplicate() {
        return this.fileUpload.duplicate();
    }

    public FileUpload retainedDuplicate() {
        return this.fileUpload.retainedDuplicate();
    }

    public FileUpload replace(ByteBuf content) {
        return this.fileUpload.replace(content);
    }

    public MixedFileUploadPatched retain() {
        return (MixedFileUploadPatched)super.retain();
    }

    public MixedFileUploadPatched retain(int increment) {
        return (MixedFileUploadPatched)super.retain(increment);
    }
}

