/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.websocket;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinderRegistry;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.bind.DefaultExecutableBinder;
import io.micronaut.core.bind.exceptions.UnsatisfiedArgumentException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Executable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.websocket.NettyWebSocketSession;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketPongMessage;
import io.micronaut.websocket.WebSocketSession;
import io.micronaut.websocket.bind.WebSocketState;
import io.micronaut.websocket.bind.WebSocketStateBinderRegistry;
import io.micronaut.websocket.context.WebSocketBean;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@Internal
public abstract class AbstractNettyWebSocketHandler
extends SimpleChannelInboundHandler<Object> {
    public static final String ID = "websocket-handler";
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final ArgumentBinderRegistry<WebSocketState> webSocketBinder;
    protected final Map<String, Object> uriVariables;
    protected final WebSocketBean<?> webSocketBean;
    protected final HttpRequest<?> originatingRequest;
    protected final MethodExecutionHandle<?, ?> messageHandler;
    protected final MethodExecutionHandle<?, ?> pongHandler;
    protected final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    protected final WebSocketVersion webSocketVersion;
    protected final String subProtocol;
    protected final WebSocketSessionRepository webSocketSessionRepository;
    protected final ConversionService conversionService;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicReference<CompositeByteBuf> frameBuffer = new AtomicReference();

    protected AbstractNettyWebSocketHandler(ChannelHandlerContext ctx, RequestBinderRegistry binderRegistry, MediaTypeCodecRegistry mediaTypeCodecRegistry, WebSocketBean<?> webSocketBean, HttpRequest<?> request, Map<String, Object> uriVariables, WebSocketVersion version, String subProtocol, WebSocketSessionRepository webSocketSessionRepository, ConversionService conversionService) {
        this.subProtocol = subProtocol;
        this.webSocketSessionRepository = webSocketSessionRepository;
        this.webSocketBinder = new WebSocketStateBinderRegistry(binderRegistry, conversionService);
        this.uriVariables = uriVariables;
        this.webSocketBean = webSocketBean;
        this.originatingRequest = request;
        this.messageHandler = webSocketBean.messageMethod().orElse(null);
        this.pongHandler = webSocketBean.pongMethod().orElse(null);
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
        this.webSocketVersion = version;
        this.conversionService = conversionService;
    }

    protected Publisher<?> callOpenMethod(ChannelHandlerContext ctx) {
        NettyWebSocketSession session = this.getSession();
        Optional executionHandle = this.webSocketBean.openMethod();
        if (executionHandle.isPresent()) {
            BoundExecutable boundExecutable;
            MethodExecutionHandle openMethod = (MethodExecutionHandle)executionHandle.get();
            try {
                boundExecutable = this.bindMethod(this.originatingRequest, this.webSocketBinder, openMethod, Collections.emptyList());
            }
            catch (Throwable e) {
                if (session.isOpen()) {
                    session.close(CloseReason.INTERNAL_ERROR);
                }
                return Mono.error((Throwable)e);
            }
            try {
                Object result = this.invokeExecutable(boundExecutable, openMethod);
                if (Publishers.isConvertibleToPublisher((Object)result)) {
                    return Flux.from(this.instrumentPublisher(ctx, result)).doOnError(t -> {
                        if (session.isOpen()) {
                            session.close(CloseReason.INTERNAL_ERROR);
                        }
                    });
                }
                return Mono.empty();
            }
            catch (Throwable e) {
                if (session.isOpen()) {
                    session.close(CloseReason.INTERNAL_ERROR);
                }
                return Mono.error((Throwable)e);
            }
        }
        return Mono.empty();
    }

    public abstract Argument<?> getBodyArgument();

    public abstract Argument<?> getPongArgument();

    public abstract NettyWebSocketSession getSession();

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.cleanupBuffer();
        this.forwardErrorToUser(ctx, e -> this.handleUnexpected(ctx, (Throwable)e), cause);
    }

    protected final void forwardErrorToUser(ChannelHandlerContext ctx, Consumer<Throwable> fallback, Throwable cause) {
        Optional opt = this.webSocketBean.errorMethod();
        if (opt.isPresent()) {
            MethodExecutionHandle errorMethod = (MethodExecutionHandle)opt.get();
            try {
                Object result;
                BoundExecutable boundExecutable = this.bindMethod(this.originatingRequest, this.webSocketBinder, errorMethod, Collections.singletonList(cause));
                Object target = errorMethod.getTarget();
                try {
                    result = boundExecutable.invoke(target);
                }
                catch (Exception e) {
                    if (this.LOG.isErrorEnabled()) {
                        this.LOG.error("Error invoking to @OnError handler " + target.getClass().getSimpleName() + "." + errorMethod.getExecutableMethod() + ": " + e.getMessage(), (Throwable)e);
                    }
                    fallback.accept(e);
                    return;
                }
                if (Publishers.isConvertibleToPublisher((Object)result)) {
                    Flux flowable = Flux.from(this.instrumentPublisher(ctx, result));
                    flowable.collectList().subscribe(objects -> fallback.accept(cause), throwable -> {
                        if (throwable != null && this.LOG.isErrorEnabled()) {
                            this.LOG.error("Error subscribing to @OnError handler " + target.getClass().getSimpleName() + "." + errorMethod.getExecutableMethod() + ": " + throwable.getMessage(), throwable);
                        }
                        fallback.accept(cause);
                    });
                }
            }
            catch (UnsatisfiedArgumentException e) {
                fallback.accept(cause);
            }
        } else {
            fallback.accept(cause);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.handleCloseReason(ctx, CloseReason.ABNORMAL_CLOSURE, false);
    }

    protected abstract NettyWebSocketSession createWebSocketSession(ChannelHandlerContext var1);

    protected Publisher<?> instrumentPublisher(ChannelHandlerContext ctx, Object result) {
        Publisher actual = (Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)result, Publisher.class);
        return Flux.from((Publisher)actual).subscribeOn(Schedulers.fromExecutorService((ExecutorService)ctx.channel().eventLoop()));
    }

    protected Object invokeExecutable(BoundExecutable boundExecutable, MethodExecutionHandle<?, ?> messageHandler) {
        return boundExecutable.invoke(messageHandler.getTarget());
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            this.handleWebSocketFrame(ctx, frame);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    protected void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame msg) {
        block29: {
            if (msg instanceof TextWebSocketFrame || msg instanceof BinaryWebSocketFrame || msg instanceof ContinuationWebSocketFrame) {
                if (this.messageHandler == null) {
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug("WebSocket bean [" + this.webSocketBean.getTarget() + "] received message, but defined no @OnMessage handler. Dropping frame...");
                    }
                    this.writeCloseFrameAndTerminate(ctx, CloseReason.UNSUPPORTED_DATA);
                } else {
                    ByteBuf content;
                    ByteBuf msgContent = msg.content().retain();
                    if (!msg.isFinalFragment()) {
                        this.frameBuffer.updateAndGet(buffer -> {
                            if (buffer == null) {
                                buffer = ctx.alloc().compositeBuffer();
                            }
                            buffer.addComponent(true, msgContent);
                            return buffer;
                        });
                        return;
                    }
                    CompositeByteBuf buffer2 = this.frameBuffer.getAndSet(null);
                    if (buffer2 == null) {
                        content = msgContent;
                    } else {
                        buffer2.addComponent(true, msgContent);
                        content = buffer2;
                    }
                    Argument<?> bodyArgument = this.getBodyArgument();
                    Optional<Object> converted = this.conversionService.convert((Object)content, bodyArgument);
                    content.release();
                    if (!converted.isPresent()) {
                        MediaType mediaType;
                        try {
                            mediaType = this.messageHandler.stringValue(Consumes.class).map(MediaType::of).orElse(MediaType.APPLICATION_JSON_TYPE);
                        }
                        catch (IllegalArgumentException e) {
                            this.exceptionCaught(ctx, e);
                            return;
                        }
                        try {
                            converted = this.mediaTypeCodecRegistry.findCodec(mediaType).map(codec -> codec.decode(bodyArgument, new NettyByteBufferFactory(ctx.alloc()).wrap(msg.content())));
                        }
                        catch (CodecException e) {
                            this.messageProcessingException(ctx, e);
                            return;
                        }
                    }
                    if (converted.isPresent()) {
                        Object v = converted.get();
                        NettyWebSocketSession currentSession = this.getSession();
                        DefaultExecutableBinder executableBinder = new DefaultExecutableBinder(Collections.singletonMap(bodyArgument, v));
                        try {
                            BoundExecutable boundExecutable = executableBinder.bind((Executable)this.messageHandler.getExecutableMethod(), this.webSocketBinder, (Object)new WebSocketState((WebSocketSession)currentSession, this.originatingRequest));
                            Object result = this.invokeExecutable(boundExecutable, this.messageHandler);
                            if (Publishers.isConvertibleToPublisher((Object)result)) {
                                Flux flowable = Flux.from(this.instrumentPublisher(ctx, result));
                                flowable.subscribe(o -> {}, error -> this.messageProcessingException(ctx, (Throwable)error), () -> this.messageHandled(ctx, v));
                                break block29;
                            }
                            this.messageHandled(ctx, v);
                        }
                        catch (Throwable e) {
                            this.messageProcessingException(ctx, e);
                        }
                    } else {
                        this.writeCloseFrameAndTerminate(ctx, CloseReason.UNSUPPORTED_DATA.getCode(), CloseReason.UNSUPPORTED_DATA.getReason() + ": Received data cannot be converted to target type: " + bodyArgument);
                    }
                }
            } else if (msg instanceof PingWebSocketFrame) {
                PingWebSocketFrame frame = (PingWebSocketFrame)msg.retain();
                ctx.writeAndFlush((Object)new PongWebSocketFrame(frame.content()));
            } else if (msg instanceof PongWebSocketFrame) {
                if (this.pongHandler != null) {
                    ByteBuf content = msg.content();
                    WebSocketPongMessage message = new WebSocketPongMessage(NettyByteBufferFactory.DEFAULT.wrap(content));
                    NettyWebSocketSession currentSession = this.getSession();
                    DefaultExecutableBinder executableBinder = new DefaultExecutableBinder(Collections.singletonMap(this.getPongArgument(), message));
                    try {
                        BoundExecutable boundExecutable = executableBinder.bind((Executable)this.pongHandler.getExecutableMethod(), this.webSocketBinder, (Object)new WebSocketState((WebSocketSession)currentSession, this.originatingRequest));
                        Object result = this.invokeExecutable(boundExecutable, this.pongHandler);
                        if (Publishers.isConvertibleToPublisher((Object)result)) {
                            content.retain();
                            Flux flowable = Flux.from(this.instrumentPublisher(ctx, result));
                            flowable.subscribe(o -> {}, error -> {
                                if (this.LOG.isErrorEnabled()) {
                                    this.LOG.error("Error Processing WebSocket Pong Message [" + this.webSocketBean + "]: " + error.getMessage(), error);
                                }
                                this.exceptionCaught(ctx, (Throwable)error);
                            }, () -> ((ByteBuf)content).release());
                        }
                    }
                    catch (Throwable e) {
                        if (this.LOG.isErrorEnabled()) {
                            this.LOG.error("Error Processing WebSocket Message [" + this.webSocketBean + "]: " + e.getMessage(), e);
                        }
                        this.exceptionCaught(ctx, e);
                    }
                }
            } else if (msg instanceof CloseWebSocketFrame) {
                CloseWebSocketFrame cwsf = (CloseWebSocketFrame)msg;
                this.handleCloseFrame(ctx, cwsf);
            } else {
                this.writeCloseFrameAndTerminate(ctx, CloseReason.UNSUPPORTED_DATA);
            }
        }
    }

    private void messageProcessingException(ChannelHandlerContext ctx, Throwable e) {
        if (this.LOG.isErrorEnabled()) {
            this.LOG.error("Error Processing WebSocket Message [" + this.webSocketBean + "]: " + e.getMessage(), e);
        }
        this.exceptionCaught(ctx, e);
    }

    protected void messageHandled(ChannelHandlerContext ctx, Object message) {
    }

    protected void writeCloseFrameAndTerminate(ChannelHandlerContext ctx, CloseReason closeReason) {
        int code = closeReason.getCode();
        String reason = closeReason.getReason();
        this.writeCloseFrameAndTerminate(ctx, code, reason);
    }

    protected void handleCloseReason(ChannelHandlerContext ctx, CloseReason cr, boolean writeCloseReason) {
        this.cleanupBuffer();
        if (this.closed.compareAndSet(false, true)) {
            Optional opt;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Closing WebSocket session {} with reason {}", (Object)this.getSession(), (Object)cr);
            }
            if ((opt = this.webSocketBean.closeMethod()).isPresent()) {
                MethodExecutionHandle methodExecutionHandle = (MethodExecutionHandle)opt.get();
                Object target = methodExecutionHandle.getTarget();
                try {
                    BoundExecutable boundExecutable = this.bindMethod(this.originatingRequest, this.webSocketBinder, methodExecutionHandle, Collections.singletonList(cr));
                    this.invokeAndClose(ctx, target, boundExecutable, methodExecutionHandle, true);
                }
                catch (Throwable e) {
                    if (this.LOG.isErrorEnabled()) {
                        this.LOG.error("Error invoking @OnClose handler for WebSocket bean [" + target + "]: " + e.getMessage(), e);
                    }
                }
            } else if (writeCloseReason) {
                this.writeCloseFrameAndTerminate(ctx, cr);
            }
        }
    }

    private void handleCloseFrame(ChannelHandlerContext ctx, CloseWebSocketFrame cwsf) {
        CloseReason cr = new CloseReason(cwsf.statusCode(), cwsf.reasonText());
        this.handleCloseReason(ctx, cr, true);
    }

    private void invokeAndClose(ChannelHandlerContext ctx, Object target, BoundExecutable boundExecutable, MethodExecutionHandle<?, ?> methodExecutionHandle, boolean isClose) {
        Object result;
        try {
            result = this.invokeExecutable(boundExecutable, methodExecutionHandle);
        }
        catch (Exception e) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error("Error invoking @OnClose handler " + target.getClass().getSimpleName() + "." + methodExecutionHandle.getExecutableMethod() + ": " + e.getMessage(), (Throwable)e);
            }
            ctx.close();
            return;
        }
        if (Publishers.isConvertibleToPublisher((Object)result)) {
            Flux reactiveSequence = Flux.from(this.instrumentPublisher(ctx, result));
            reactiveSequence.collectList().subscribe(objects -> {}, throwable -> {
                if (throwable != null && this.LOG.isErrorEnabled()) {
                    this.LOG.error("Error subscribing to @" + (isClose ? "OnClose" : "OnError") + " handler for WebSocket bean [" + target + "]: " + throwable.getMessage(), throwable);
                }
                ctx.close();
            });
        } else {
            ctx.close();
        }
    }

    private BoundExecutable bindMethod(HttpRequest<?> request, ArgumentBinderRegistry<WebSocketState> binderRegistry, MethodExecutionHandle<?, ?> openMethod, List<?> parameters) {
        ExecutableMethod executable = openMethod.getExecutableMethod();
        Map<Argument<?>, Object> preBound = this.prepareBoundVariables(executable, parameters);
        DefaultExecutableBinder executableBinder = new DefaultExecutableBinder(preBound);
        return executableBinder.bind((Executable)executable, binderRegistry, (Object)new WebSocketState((WebSocketSession)this.getSession(), request));
    }

    private Map<Argument<?>, Object> prepareBoundVariables(ExecutableMethod<?, ?> executable, List<?> parameters) {
        HashMap preBound = new HashMap(executable.getArguments().length);
        block0: for (Argument argument : executable.getArguments()) {
            Class type = argument.getType();
            for (Object object : parameters) {
                if (!type.isInstance(object)) continue;
                preBound.put(argument, object);
                continue block0;
            }
        }
        return preBound;
    }

    private void handleUnexpected(ChannelHandlerContext ctx, Throwable cause) {
        Channel channel;
        String msg;
        if (cause instanceof IOException && (msg = cause.getMessage()) != null && msg.contains("Connection reset")) {
            return;
        }
        if (this.LOG.isErrorEnabled()) {
            this.LOG.error("Unexpected Exception in WebSocket [" + this.webSocketBean.getTarget() + "]: " + cause.getMessage(), cause);
        }
        if ((channel = ctx.channel()).isOpen()) {
            CloseReason internalError = CloseReason.INTERNAL_ERROR;
            this.writeCloseFrameAndTerminate(ctx, internalError);
        }
    }

    private void writeCloseFrameAndTerminate(ChannelHandlerContext ctx, int code, String reason) {
        this.cleanupBuffer();
        CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(code, reason);
        ctx.channel().writeAndFlush((Object)closeFrame).addListener(future -> this.handleCloseFrame(ctx, new CloseWebSocketFrame(code, reason)));
    }

    private void cleanupBuffer() {
        CompositeByteBuf buffer = this.frameBuffer.getAndSet(null);
        if (buffer != null) {
            buffer.release();
        }
    }
}

