/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupFactory;
import io.micronaut.http.netty.channel.NettyChannelType;
import io.netty.channel.Channel;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioDomainSocketChannel;
import io.netty.channel.socket.nio.NioServerDomainSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

@Internal
@Singleton
@Named(value="nio")
@BootstrapContextCompatible
public class NioEventLoopGroupFactory
implements EventLoopGroupFactory {
    public static final String NAME = "nio";

    @Override
    public IoHandlerFactory createIoHandlerFactory() {
        return NioIoHandler.newFactory();
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type) throws UnsupportedOperationException {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> NioServerSocketChannel.class;
            case NettyChannelType.CLIENT_SOCKET -> NioSocketChannel.class;
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> NioServerDomainSocketChannel.class;
            case NettyChannelType.DOMAIN_SOCKET -> NioDomainSocketChannel.class;
            case NettyChannelType.DATAGRAM_SOCKET -> NioDatagramChannel.class;
        };
    }

    @Override
    public Class<? extends Channel> channelClass(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return this.channelClass(type);
    }

    @Override
    public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> new NioServerSocketChannel();
            case NettyChannelType.CLIENT_SOCKET -> new NioSocketChannel();
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> new NioServerDomainSocketChannel();
            case NettyChannelType.DOMAIN_SOCKET -> new NioDomainSocketChannel();
            case NettyChannelType.DATAGRAM_SOCKET -> new NioDatagramChannel();
        };
    }

    @Override
    @NonNull
    public Channel channelInstance(NettyChannelType type, @Nullable EventLoopGroupConfiguration configuration, Channel parent, int fd) {
        java.nio.channels.Channel inheritedChannel;
        if (fd != 0) {
            throw new IllegalArgumentException("With nio, only channel fd 0 is supported. Either switch to fd 0, or use the epoll transport that supports any fd.");
        }
        try {
            inheritedChannel = System.inheritedChannel();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NettyChannelType.SERVER_SOCKET -> {
                if (!(inheritedChannel instanceof ServerSocketChannel)) {
                    throw new IllegalArgumentException("Inherited channel is not a ServerSocketChannel. You probably have to pass it as 'accepted-fd' instead of 'fd'.");
                }
                ServerSocketChannel ssc = (ServerSocketChannel)inheritedChannel;
                yield new NioServerSocketChannel(ssc);
            }
            case NettyChannelType.CLIENT_SOCKET -> {
                if (!(inheritedChannel instanceof SocketChannel)) {
                    throw new IllegalArgumentException("Inherited channel is not a SocketChannel. You probably have to pass it as 'fd' instead of 'accepted-fd'.");
                }
                SocketChannel sc = (SocketChannel)inheritedChannel;
                yield new NioSocketChannel(parent, sc);
            }
            case NettyChannelType.DOMAIN_SERVER_SOCKET -> {
                if (!(inheritedChannel instanceof ServerSocketChannel)) {
                    throw new IllegalArgumentException("Inherited channel is not a ServerSocketChannel. You probably have to pass it as 'accepted-fd' instead of 'fd'.");
                }
                ServerSocketChannel ssc = (ServerSocketChannel)inheritedChannel;
                yield new NioServerDomainSocketChannel(ssc);
            }
            case NettyChannelType.DOMAIN_SOCKET -> {
                if (!(inheritedChannel instanceof SocketChannel)) {
                    throw new IllegalArgumentException("Inherited channel is not a SocketChannel. You probably have to pass it as 'fd' instead of 'accepted-fd'.");
                }
                SocketChannel sc = (SocketChannel)inheritedChannel;
                yield new NioDomainSocketChannel(parent, sc);
            }
            case NettyChannelType.DATAGRAM_SOCKET -> {
                if (!(inheritedChannel instanceof DatagramChannel)) {
                    throw new IllegalArgumentException("Inherited channel is not a DatagramChannel.");
                }
                DatagramChannel dc = (DatagramChannel)inheritedChannel;
                yield new NioDatagramChannel(dc);
            }
        };
    }
}

