/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.netty.handler.codec.quic.QuicSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.util.ReferenceCountUtil;

@Internal
public record SslContextHolder(@Nullable SslContext sslContext, @Nullable Object quicSslContextObject) {
    public void retain() {
        if (this.sslContext != null) {
            ReferenceCountUtil.retain((Object)this.sslContext);
        }
        if (this.quicSslContextObject != null) {
            ReferenceCountUtil.retain((Object)this.quicSslContextObject);
        }
    }

    public void release() {
        if (this.sslContext != null) {
            ReferenceCountUtil.release((Object)this.sslContext);
        }
        if (this.quicSslContextObject != null) {
            ReferenceCountUtil.release((Object)this.quicSslContextObject);
        }
    }

    public QuicSslContext quicSslContext() {
        return (QuicSslContext)this.quicSslContextObject;
    }
}

