/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel.loom;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.netty.channel.loom.LoomBranchSupport;
import io.micronaut.http.netty.channel.loom.PrivateLoomSupport;
import io.micronaut.scheduling.LoomSupport;
import io.netty.util.AttributeMap;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.Executor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public interface EventLoopVirtualThreadScheduler {
    @NonNull
    public AttributeMap attributeMap();

    @NonNull
    public EventExecutor eventLoop();

    @Nullable
    public static EventLoopVirtualThreadScheduler current() {
        if (LoomBranchSupport.isSupported()) {
            if (!LoomSupport.isVirtual((Thread)Thread.currentThread())) {
                return null;
            }
            LoomBranchSupport.VirtualThreadSchedulerProxy virtualThreadSchedulerProxy = LoomBranchSupport.currentScheduler();
            if (virtualThreadSchedulerProxy instanceof EventLoopVirtualThreadScheduler) {
                EventLoopVirtualThreadScheduler elvts = (EventLoopVirtualThreadScheduler)((Object)virtualThreadSchedulerProxy);
                return elvts;
            }
            return null;
        }
        if (PrivateLoomSupport.isSupported()) {
            Thread thread = Thread.currentThread();
            if (!LoomSupport.isVirtual((Thread)thread)) {
                return null;
            }
            Executor executor = PrivateLoomSupport.getScheduler(thread);
            if (executor instanceof EventLoopVirtualThreadScheduler) {
                EventLoopVirtualThreadScheduler elvts = (EventLoopVirtualThreadScheduler)((Object)executor);
                return elvts;
            }
            return null;
        }
        return null;
    }
}

