/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.TypeHint;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ThreadFactory;

@Singleton
@Factory
@TypeHint(value={NioServerSocketChannel.class, NioSocketChannel.class}, typeNames={"sun.security.ssl.SSLContextImpl$TLSContext"}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS, TypeHint.AccessType.ALL_PUBLIC_CONSTRUCTORS})
@BootstrapContextCompatible
public class NettyThreadFactory {
    public static final String NAME = "netty";
    @Deprecated(forRemoval=true, since="4.2.0")
    public static final int DEFAULT_EVENT_LOOP_THREADS = 1;

    public static int getDefaultEventLoopThreads() {
        return EventLoopThreadsHolder.DEFAULT_EVENT_LOOP_THREADS;
    }

    @Singleton
    @Named(value="netty")
    @BootstrapContextCompatible
    protected ThreadFactory nettyThreadFactory() {
        return new DefaultThreadFactory("default-" + DefaultThreadFactory.toPoolName(NioEventLoopGroup.class));
    }

    private static final class EventLoopThreadsHolder {
        static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt((String)"io.netty.eventLoopThreads", (int)(NettyRuntime.availableProcessors() * 2)));

        private EventLoopThreadsHolder() {
        }
    }
}

