/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseWrapper;
import io.micronaut.http.netty.stream.DefaultStreamedHttpResponse;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.List;
import java.util.Objects;
import org.reactivestreams.Publisher;

public interface NettyHttpResponseBuilder {
    @NonNull
    public FullHttpResponse toFullHttpResponse();

    @NonNull
    default public StreamedHttpResponse toStreamHttpResponse() {
        FullHttpResponse fullHttpResponse = this.toFullHttpResponse();
        DefaultStreamedHttpResponse streamedHttpResponse = new DefaultStreamedHttpResponse(fullHttpResponse.protocolVersion(), fullHttpResponse.status(), true, (Publisher<HttpContent>)Publishers.just((Object)new DefaultLastHttpContent(fullHttpResponse.content())));
        streamedHttpResponse.headers().setAll(fullHttpResponse.headers());
        return streamedHttpResponse;
    }

    @NonNull
    default public io.netty.handler.codec.http.HttpResponse toHttpResponse() {
        if (this.isStream()) {
            return this.toStreamHttpResponse();
        }
        return this.toFullHttpResponse();
    }

    public boolean isStream();

    @NonNull
    public static io.netty.handler.codec.http.HttpResponse toHttpResponse(@NonNull HttpResponse<?> response) {
        Object fullHttpResponse;
        Objects.requireNonNull(response, "The response cannot be null");
        while (response instanceof HttpResponseWrapper) {
            HttpResponseWrapper wrapper = (HttpResponseWrapper)response;
            response = wrapper.getDelegate();
        }
        if (response instanceof NettyHttpResponseBuilder) {
            NettyHttpResponseBuilder builder = (NettyHttpResponseBuilder)response;
            fullHttpResponse = builder.toHttpResponse();
        } else {
            ByteBuf byteBuf = response.getBody(ByteBuf.class).orElse(null);
            fullHttpResponse = byteBuf != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.code(), (String)response.reason()), byteBuf) : new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.code(), (String)response.reason()));
            response.getHeaders().forEach((arg_0, arg_1) -> NettyHttpResponseBuilder.lambda$toHttpResponse$0((io.netty.handler.codec.http.HttpResponse)fullHttpResponse, arg_0, arg_1));
        }
        return fullHttpResponse;
    }

    @NonNull
    public static FullHttpResponse toFullHttpResponse(@NonNull HttpResponse<?> response, @NonNull ByteBuf byteBuf) {
        while (response instanceof HttpResponseWrapper) {
            HttpResponseWrapper wrapper = (HttpResponseWrapper)response;
            response = wrapper.getDelegate();
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.code(), (String)response.reason()), byteBuf);
        response.getHeaders().forEach((s, strings) -> httpResponse.headers().add(s, (Iterable)strings));
        return httpResponse;
    }

    @NonNull
    public static StreamedHttpResponse toStreamResponse(@NonNull HttpResponse<?> response) {
        Objects.requireNonNull(response, "The response cannot be null");
        while (response instanceof HttpResponseWrapper) {
            HttpResponseWrapper wrapper = (HttpResponseWrapper)response;
            response = wrapper.getDelegate();
        }
        if (response instanceof NettyHttpResponseBuilder) {
            NettyHttpResponseBuilder builder = (NettyHttpResponseBuilder)response;
            if (builder.isStream()) {
                return builder.toStreamHttpResponse();
            }
            FullHttpResponse fullHttpResponse = builder.toFullHttpResponse();
            return new DefaultStreamedHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.code(), (String)response.reason()), (Publisher<HttpContent>)Publishers.just((Object)new DefaultLastHttpContent(fullHttpResponse.content())));
        }
        ByteBuf byteBuf = response.getBody(ByteBuf.class).orElse(null);
        DefaultStreamedHttpResponse fullHttpResponse = byteBuf != null ? new DefaultStreamedHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.code(), (String)response.reason()), (Publisher<HttpContent>)Publishers.just((Object)new DefaultLastHttpContent(byteBuf))) : new DefaultStreamedHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.code(), (String)response.reason()), (Publisher<HttpContent>)Publishers.empty());
        response.getHeaders().forEach((s, strings) -> fullHttpResponse.headers().add(s, (Iterable)strings));
        return fullHttpResponse;
    }

    private static /* synthetic */ void lambda$toHttpResponse$0(io.netty.handler.codec.http.HttpResponse fullHttpResponse, String s, List strings) {
        fullHttpResponse.headers().add(s, (Iterable)strings);
    }
}

