/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpMessage;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.ServerCookieEncoder;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.NettyHttpResponseBuilder;
import io.micronaut.http.netty.stream.DefaultStreamedHttpResponse;
import io.micronaut.http.netty.stream.StreamedHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;

@Internal
@TypeHint(value={NettyMutableHttpResponse.class})
public final class NettyMutableHttpResponse<B>
implements MutableHttpResponse<B>,
NettyHttpResponseBuilder {
    private final HttpVersion httpVersion;
    private HttpResponseStatus httpResponseStatus;
    private final NettyHttpHeaders headers;
    private Object body;
    private Optional<Object> optionalBody;
    private final HttpHeaders nettyHeaders;
    private final HttpHeaders trailingNettyHeaders;
    private final DecoderResult decoderResult;
    private final ConversionService conversionService;
    private MutableConvertibleValues<Object> attributes;
    private final BodyConvertor bodyConvertor = this.newBodyConvertor();
    private MessageBodyWriter<B> messageBodyWriter;

    public NettyMutableHttpResponse(FullHttpResponse nettyResponse, ConversionService conversionService) {
        this(nettyResponse.protocolVersion(), nettyResponse.status(), nettyResponse.headers(), nettyResponse.trailingHeaders(), nettyResponse.content(), nettyResponse.decoderResult(), conversionService);
    }

    public NettyMutableHttpResponse(ConversionService conversionService) {
        this(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, null, conversionService);
    }

    public NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, ConversionService conversionService) {
        this(httpVersion, httpResponseStatus, null, conversionService);
    }

    public NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, Object body, ConversionService conversionService) {
        this(httpVersion, httpResponseStatus, null, body, conversionService);
    }

    public NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, HttpHeaders nettyHeaders, Object body, ConversionService conversionService) {
        this(httpVersion, httpResponseStatus, nettyHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE, body, null, conversionService);
    }

    private NettyMutableHttpResponse(HttpVersion httpVersion, HttpResponseStatus httpResponseStatus, HttpHeaders nettyHeaders, HttpHeaders trailingNettyHeaders, Object body, DecoderResult decoderResult, ConversionService conversionService) {
        boolean hasHeaders;
        this.httpVersion = httpVersion;
        this.httpResponseStatus = httpResponseStatus;
        this.trailingNettyHeaders = trailingNettyHeaders;
        this.decoderResult = decoderResult;
        this.conversionService = conversionService;
        boolean bl = hasHeaders = nettyHeaders != null;
        if (!hasHeaders) {
            nettyHeaders = new DefaultHttpHeaders(false);
        }
        this.nettyHeaders = nettyHeaders;
        this.headers = new NettyHttpHeaders(nettyHeaders, conversionService);
        if (body == null) {
            this.body = null;
            this.optionalBody = Optional.empty();
        } else {
            this.body = body;
            this.optionalBody = Optional.of(body);
            Optional mediaType = MediaType.fromType(body.getClass());
            if (!(!mediaType.isPresent() || hasHeaders && nettyHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_TYPE))) {
                this.contentType((MediaType)mediaType.get());
            }
        }
    }

    public Optional<MessageBodyWriter<B>> getBodyWriter() {
        return Optional.ofNullable(this.messageBodyWriter);
    }

    public MutableHttpMessage<B> bodyWriter(MessageBodyWriter<B> messageBodyWriter) {
        this.messageBodyWriter = messageBodyWriter;
        return this;
    }

    public HttpVersion getNettyHttpVersion() {
        return this.httpVersion;
    }

    public HttpResponseStatus getNettyHttpStatus() {
        return this.httpResponseStatus;
    }

    public HttpHeaders getNettyHeaders() {
        return this.nettyHeaders;
    }

    public String toString() {
        return this.code() + " " + this.reason();
    }

    public MutableHttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            NettyMutableHttpResponse nettyMutableHttpResponse = this;
            synchronized (nettyMutableHttpResponse) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap(new ConcurrentHashMap(4));
                }
            }
        }
        return attributes;
    }

    public HttpResponse<B> setAttribute(CharSequence name, Object value) {
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            if (value == null) {
                this.getAttributes().remove((CharSequence)name.toString());
            } else {
                this.getAttributes().put((CharSequence)name.toString(), value);
            }
        }
        return this;
    }

    public int code() {
        return this.httpResponseStatus.code();
    }

    public String reason() {
        return this.httpResponseStatus.reasonPhrase();
    }

    public MutableHttpResponse<B> cookie(Cookie cookie) {
        ServerCookieEncoder.INSTANCE.encode(new Cookie[]{cookie}).forEach(c -> this.headers.add((CharSequence)HttpHeaderNames.SET_COOKIE, (CharSequence)c));
        return this;
    }

    public MutableHttpResponse<B> cookies(Set<Cookie> cookies) {
        if (cookies == null || cookies.isEmpty()) {
            return this;
        }
        for (Cookie cookie : cookies) {
            this.cookie(cookie);
        }
        return this;
    }

    public Optional<B> getBody() {
        return this.optionalBody;
    }

    public <T1> Optional<T1> getBody(Class<T1> type) {
        return this.getBody(Argument.of(type));
    }

    public <T> Optional<T> getBody(ArgumentConversionContext<T> conversionContext) {
        return this.bodyConvertor.convert(conversionContext, this.body);
    }

    public MutableHttpResponse<B> status(int status, CharSequence message) {
        if (message == null) {
            message = HttpStatus.getDefaultReason((int)status);
        }
        this.httpResponseStatus = new HttpResponseStatus(status, message.toString());
        return this;
    }

    public <T> MutableHttpResponse<T> body(@Nullable T body) {
        if (this.body != body) {
            Object object = this.body;
            if (object instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)object;
                buf.release();
            }
            this.setBody(body);
            this.bodyConvertor.cleanup();
        }
        return this;
    }

    public MutableHttpResponse<B> contentType(MediaType mediaType) {
        this.headers.contentType(mediaType);
        return this;
    }

    @Override
    @NonNull
    public FullHttpResponse toFullHttpResponse() {
        ByteBuf content;
        if (this.body == null) {
            content = Unpooled.EMPTY_BUFFER;
        } else {
            Object object = this.body;
            if (object instanceof ByteBuf) {
                ByteBuf buf;
                content = buf = (ByteBuf)object;
            } else {
                throw new IllegalStateException("Body needs to be converted to ByteBuf from " + this.body.getClass());
            }
        }
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(this.httpVersion, this.httpResponseStatus, content, this.nettyHeaders, this.trailingNettyHeaders);
        if (this.decoderResult != null) {
            defaultFullHttpResponse.setDecoderResult(this.decoderResult);
        }
        return defaultFullHttpResponse;
    }

    @Override
    @NonNull
    public StreamedHttpResponse toStreamHttpResponse() {
        ByteBuf content;
        if (this.body == null) {
            content = Unpooled.EMPTY_BUFFER;
        } else {
            Object object = this.body;
            if (object instanceof ByteBuf) {
                ByteBuf buf;
                content = buf = (ByteBuf)object;
            } else {
                throw new IllegalStateException("Body needs to be converted to ByteBuf from " + this.body.getClass());
            }
        }
        DefaultStreamedHttpResponse streamedHttpResponse = new DefaultStreamedHttpResponse(HttpVersion.HTTP_1_1, this.httpResponseStatus, true, (Publisher<HttpContent>)Publishers.just((Object)new DefaultLastHttpContent(content)));
        streamedHttpResponse.headers().setAll(this.nettyHeaders);
        return streamedHttpResponse;
    }

    @Override
    @NonNull
    public io.netty.handler.codec.http.HttpResponse toHttpResponse() {
        return this.toFullHttpResponse();
    }

    @Override
    public boolean isStream() {
        return false;
    }

    private void setBody(Object body) {
        this.body = body;
        this.optionalBody = Optional.ofNullable(body);
        Optional contentType = this.getContentType();
        if (!contentType.isPresent() && body != null) {
            MediaType.fromType(body.getClass()).ifPresent(this::contentType);
        }
    }

    private BodyConvertor newBodyConvertor() {
        return new BodyConvertor(){

            public Optional convert(ArgumentConversionContext conversionContext, Object value) {
                if (value == null) {
                    return Optional.empty();
                }
                if (Argument.OBJECT_ARGUMENT.equalsType(conversionContext.getArgument())) {
                    return Optional.of(value);
                }
                return this.convertFromNext(NettyMutableHttpResponse.this.conversionService, conversionContext, value);
            }
        };
    }

    private static abstract class BodyConvertor<T> {
        private BodyConvertor<T> nextConvertor;

        private BodyConvertor() {
        }

        public abstract Optional<T> convert(ArgumentConversionContext<T> var1, T var2);

        protected synchronized Optional<T> convertFromNext(final ConversionService conversionService, final ArgumentConversionContext<T> conversionContext, T value) {
            if (this.nextConvertor == null) {
                Optional conversion;
                if (value instanceof ByteBuffer) {
                    ByteBuffer buffer = (ByteBuffer)value;
                    conversion = conversionService.convert(buffer.asNativeBuffer(), conversionContext);
                } else {
                    conversion = conversionService.convert(value, conversionContext);
                }
                this.nextConvertor = new BodyConvertor<T>(){

                    @Override
                    public Optional<T> convert(ArgumentConversionContext<T> currentConversionContext, T value) {
                        if (currentConversionContext == conversionContext) {
                            return conversion;
                        }
                        if (currentConversionContext.getArgument().equalsType(conversionContext.getArgument())) {
                            conversionContext.getLastError().ifPresent(error -> error.getOriginalValue().ifPresentOrElse(originalValue -> currentConversionContext.reject(originalValue, error.getCause()), () -> currentConversionContext.reject(error.getCause())));
                            return conversion;
                        }
                        return this.convertFromNext(conversionService, currentConversionContext, value);
                    }
                };
                return conversion;
            }
            return this.nextConvertor.convert(conversionContext, value);
        }

        public void cleanup() {
            this.nextConvertor = null;
        }
    }
}

