/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.body;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.body.CharSequenceBodyWriter;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.netty.NettyHttpHeaders;
import io.micronaut.http.netty.body.NettyBodyWriter;
import io.micronaut.http.netty.body.NettyWriteContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import jakarta.inject.Singleton;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

@Singleton
@Replaces(value=CharSequenceBodyWriter.class)
@Internal
public final class NettyCharSequenceBodyWriter
implements MessageBodyWriter<CharSequence>,
NettyBodyWriter<CharSequence> {
    private final CharSequenceBodyWriter defaultHandler = new CharSequenceBodyWriter(StandardCharsets.UTF_8);

    @Override
    public void writeTo(HttpRequest<?> request, MutableHttpResponse<CharSequence> outgoingResponse, Argument<CharSequence> type, MediaType mediaType, CharSequence object, NettyWriteContext nettyContext) throws CodecException {
        MutableHttpHeaders headers = outgoingResponse.getHeaders();
        ByteBuf byteBuf = Unpooled.copiedBuffer((CharSequence)object.toString(), (Charset)MessageBodyWriter.getCharset((MediaType)mediaType, (Headers)headers));
        NettyHttpHeaders nettyHttpHeaders = (NettyHttpHeaders)headers;
        HttpHeaders nettyHeaders = nettyHttpHeaders.getNettyHeaders();
        if (!nettyHttpHeaders.contains("Content-Type")) {
            nettyHttpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)mediaType);
        }
        nettyHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byteBuf.readableBytes());
        DefaultFullHttpResponse fullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)outgoingResponse.code(), (String)outgoingResponse.reason()), byteBuf, nettyHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        nettyContext.writeFull((FullHttpResponse)fullHttpResponse);
    }

    public void writeTo(Argument<CharSequence> type, MediaType mediaType, CharSequence object, MutableHeaders outgoingHeaders, OutputStream outputStream) throws CodecException {
        this.defaultHandler.writeTo(type, mediaType, object, outgoingHeaders, outputStream);
    }
}

